/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.store.XWikiCacheStoreInterface;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Named(value="R1008010XWIKI10092")
@Singleton
public class R1008010XWIKI10092DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;

    @Override
    public String getDescription() {
        return "Add missing properties to existing objects.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(1008010);
    }

    @Override
    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        List<String> classNames = xcontext.getWiki().getClassList(xcontext);
        for (String className : classNames) {
            DocumentReference classReference = this.documentReferenceResolver.resolve((Object)className, new Object[0]);
            BaseClass xclass = xcontext.getWiki().getXClass(classReference, xcontext);
            if (xclass.getPropertyList().isEmpty()) continue;
            this.migrateObjectsOfType(className, xclass);
        }
        XWikiStoreInterface store = xcontext.getWiki().getStore();
        if (store instanceof XWikiCacheStoreInterface) {
            ((XWikiCacheStoreInterface)store).flushCache();
        }
    }

    private void migrateObjectsOfType(final String className, final BaseClass xclass) throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Void>(){

            @Override
            public Void doInHibernate(Session session) throws HibernateException, XWikiException {
                List<Long> objectIds = R1008010XWIKI10092DataMigration.this.getObjectsWithMissingProperties(className, xclass.getPropertyList(), session);
                for (Long objectId : objectIds) {
                    R1008010XWIKI10092DataMigration.this.addMissingProperties(objectId, xclass, session);
                }
                return null;
            }
        });
    }

    private List<Long> getObjectsWithMissingProperties(String className, Set<String> expectedProperties, Session session) {
        Query query = session.createQuery("select obj.id from BaseObject as obj, BaseProperty as prop where obj.id = prop.id.id and obj.className = :className and prop.id.name in :expectedProperties group by obj.id having count(prop) < :expectedPropertyCount", Long.class);
        query.setParameter("className", (Object)className);
        query.setParameterList("expectedProperties", expectedProperties);
        query.setParameter("expectedPropertyCount", (Object)expectedProperties.size());
        return query.list();
    }

    private void addMissingProperties(Long objectId, BaseClass xclass, Session session) {
        for (PropertyClass propertyClass : this.getMissingProperties(objectId, xclass, session)) {
            BaseProperty property = propertyClass.newProperty();
            if (property == null) continue;
            property.setId(objectId);
            session.save((Object)property);
        }
    }

    private List<PropertyClass> getMissingProperties(Long objectId, BaseClass xclass, Session session) {
        HashSet<String> missingProperties = new HashSet<String>(xclass.getPropertyList());
        missingProperties.removeAll(this.getCurrentProperties(objectId, session));
        return missingProperties.stream().map(propertyName -> (PropertyClass)xclass.get((String)propertyName)).collect(Collectors.toList());
    }

    private List<String> getCurrentProperties(Long objectId, Session session) {
        Query query = session.createQuery("select prop.id.name from BaseObject as obj, BaseProperty as prop where obj.id = prop.id.id and obj.id = :objectId", String.class);
        query.setParameter("objectId", (Object)objectId);
        return query.list();
    }
}

