/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.LongProperty;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="Legacy")
@Singleton
public class LegacyDataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "Convert very old legacy databases";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(1);
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){
            private static final String UPDATE = "update ";
            private static final String DELETE_FROM = "delete from ";

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                String docClass = XWikiDocument.class.getName();
                try {
                    session.createQuery(UPDATE + docClass + " doc set doc.translation = 0 where doc.translation is null").executeUpdate();
                    session.createQuery(UPDATE + docClass + " doc set doc.language = '' where doc.language is null").executeUpdate();
                    session.createQuery(UPDATE + docClass + " doc set doc.defaultLanguage = '' where doc.defaultLanguage is null").executeUpdate();
                    session.createQuery(UPDATE + docClass + " doc set doc.fullName = concat(doc.space,'.',doc.name) where doc.fullName is null").executeUpdate();
                    session.createQuery(UPDATE + docClass + " doc set doc.elements = 3 where doc.elements is null").executeUpdate();
                    try {
                        session.createQuery(DELETE_FROM + BaseProperty.class.getName() + " prop where prop.name like 'editbox_%' and prop.classType = 'com.xpn.xwiki.objects.LongProperty'").executeUpdate();
                        session.createQuery(DELETE_FROM + LongProperty.class.getName() + " prop where prop.name like 'editbox_%'").executeUpdate();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    throw new XWikiException(3, 3005, LegacyDataMigration.this.getName() + " migration failed", e);
                }
                return null;
            }
        });
    }
}

