/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.hibernate.query;

import com.xpn.xwiki.criteria.impl.Range;
import com.xpn.xwiki.criteria.impl.RevisionCriteria;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import java.util.ArrayList;
import java.util.Date;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.stability.Unstable;

@Unstable
public final class VersioningStoreQueryFactory<T> {
    private static final String FIELD_ID = "id";
    private static final String FIELD_AUTHOR = "author";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_DIFF = "diff";
    private static final String FIELD_DOCID = "docId";
    private static final String FIELD_VERSION1 = "version1";
    private static final String FIELD_VERSION2 = "version2";
    private final Root<XWikiRCSNodeInfo> root;
    private final CriteriaBuilder builder;
    private final CriteriaQuery<T> criteriaQuery;
    private final Session session;
    private Query<T> query;

    private VersioningStoreQueryFactory(Class<T> clazz, Session session) {
        this.session = session;
        this.builder = session.getCriteriaBuilder();
        this.criteriaQuery = this.builder.createQuery(clazz);
        this.root = this.criteriaQuery.from(XWikiRCSNodeInfo.class);
    }

    private void applyCriteria(long id, RevisionCriteria criteria) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(this.builder.equal((Expression)this.root.get(FIELD_ID).get(FIELD_DOCID), (Object)id));
        predicates.add(this.builder.isNotNull((Expression)this.root.get(FIELD_DIFF)));
        if (criteria != null) {
            if (!criteria.getAuthor().isEmpty()) {
                predicates.add(this.builder.equal((Expression)this.root.get(FIELD_AUTHOR), (Object)criteria.getAuthor()));
            }
            Date minDate = criteria.getMinDate();
            Date maxDate = criteria.getMaxDate();
            if (minDate.getTime() < 0L) {
                minDate = new Date(0L);
            }
            if (maxDate.getTime() > 2147483647000L) {
                maxDate = new Date(2147483647000L);
            }
            predicates.add(this.builder.between((Expression)this.root.get(FIELD_DATE), (Comparable)minDate, (Comparable)maxDate));
            if (!criteria.getIncludeMinorVersions()) {
                Subquery subQuery = this.criteriaQuery.subquery(Integer.class);
                Root subRoot = subQuery.from(XWikiRCSNodeInfo.class);
                subQuery.select(this.builder.max((Expression)subRoot.get(FIELD_ID).get(FIELD_VERSION2)));
                subQuery.where(new Predicate[]{this.builder.equal((Expression)subRoot.get(FIELD_ID).get(FIELD_VERSION1), (Expression)this.root.get(FIELD_ID).get(FIELD_VERSION1)), this.builder.equal((Expression)subRoot.get(FIELD_ID).get(FIELD_DOCID), (Expression)this.root.get(FIELD_ID).get(FIELD_DOCID))});
                predicates.add(this.builder.equal((Expression)this.root.get(FIELD_ID).get(FIELD_VERSION2), (Expression)subQuery));
            }
        }
        this.criteriaQuery.where(predicates.toArray(new Predicate[0]));
    }

    private void applyRange(Range range) {
        int start = range.getStart();
        int size = range.getSize();
        if (start > 0 && size != 0 || start == 0 && size > 0) {
            this.criteriaQuery.orderBy(new Order[]{this.builder.asc((Expression)this.root.get(FIELD_ID).get(FIELD_VERSION1)), this.builder.asc((Expression)this.root.get(FIELD_ID).get(FIELD_VERSION2))});
        } else if (size != 0) {
            this.criteriaQuery.orderBy(new Order[]{this.builder.desc((Expression)this.root.get(FIELD_ID).get(FIELD_VERSION1)), this.builder.desc((Expression)this.root.get(FIELD_ID).get(FIELD_VERSION2))});
            start = -start;
            size = -size;
        }
        this.query = this.session.createQuery(this.criteriaQuery);
        if (size > 0) {
            this.query.setFirstResult(start);
            this.query.setMaxResults(size);
        } else if (size < 0) {
            int newStart = Math.max(0, start + size);
            this.query.setFirstResult(newStart);
            this.query.setMaxResults(start - newStart);
        }
    }

    public static Query<?> getDeleteArchiveQuery(Session session, long id) {
        return session.createQuery("delete from " + XWikiRCSNodeInfo.class.getName() + " where id.docId=:docId").setParameter(FIELD_DOCID, (Object)id);
    }

    public static Query<Long> getRCSNodeInfoCountQuery(Session session, long id, RevisionCriteria criteria) {
        VersioningStoreQueryFactory<Long> queryBuilder = new VersioningStoreQueryFactory<Long>(Long.class, session);
        queryBuilder.criteriaQuery.select((Selection)queryBuilder.builder.count(queryBuilder.root));
        queryBuilder.applyCriteria(id, criteria);
        return session.createQuery(queryBuilder.criteriaQuery);
    }

    public static Query<XWikiRCSNodeInfo> getRCSNodeInfoQuery(Session session, long id, RevisionCriteria criteria) {
        VersioningStoreQueryFactory<XWikiRCSNodeInfo> queryBuilder = new VersioningStoreQueryFactory<XWikiRCSNodeInfo>(XWikiRCSNodeInfo.class, session);
        queryBuilder.criteriaQuery.select(queryBuilder.root);
        queryBuilder.applyCriteria(id, criteria);
        if (criteria != null && criteria.getRange() != null) {
            queryBuilder.applyRange(criteria.getRange());
            return queryBuilder.query;
        }
        return session.createQuery(queryBuilder.criteriaQuery);
    }
}

