/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import java.io.Serializable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.ObjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="hibernate")
@Singleton
public class HibernateAttachmentVersioningStore
extends XWikiHibernateBaseStore
implements AttachmentVersioningStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateAttachmentVersioningStore.class);

    @Deprecated
    public HibernateAttachmentVersioningStore(XWikiContext context) {
        super(context.getWiki(), context);
    }

    public HibernateAttachmentVersioningStore() {
    }

    @Override
    public XWikiAttachmentArchive loadArchive(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        try {
            XWikiAttachmentArchive archive = new XWikiAttachmentArchive();
            archive.setAttachment(attachment);
            this.executeRead(context, session -> {
                try {
                    session.load((Object)archive, (Serializable)Long.valueOf(archive.getId()));
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
                return null;
            });
            attachment.setAttachment_archive(archive);
            return archive;
        }
        catch (Exception e) {
            Object[] args = new Object[]{attachment.getFilename(), attachment.getDoc().getDocumentReference()};
            throw new XWikiException(3, 3231, "Exception while loading attachment archive {0} of document {1}", e, args);
        }
    }

    @Override
    public void saveArchive(XWikiAttachmentArchive archive, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.executeWrite(context, session -> {
            session.saveOrUpdate((Object)archive);
            return null;
        });
    }

    @Override
    public void deleteArchive(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        block2: {
            try {
                this.executeWrite(context, session -> {
                    XWikiAttachmentArchive archive = new XWikiAttachmentArchive();
                    archive.setAttachment(attachment);
                    session.delete((Object)archive);
                    return null;
                });
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn(String.format("Error deleting attachment archive [%s] of doc [%s]", attachment.getFilename(), attachment.getDoc().getDocumentReference()), (Throwable)e);
            }
        }
    }
}

