/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.criteria.impl.RevisionCriteria;
import com.xpn.xwiki.criteria.impl.RevisionCriteriaFactory;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeContent;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiVersioningStoreInterface;
import com.xpn.xwiki.store.hibernate.query.VersioningStoreQueryFactory;
import com.xpn.xwiki.web.Utils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Named(value="hibernate")
@Singleton
public class XWikiHibernateVersioningStore
extends XWikiHibernateBaseStore
implements XWikiVersioningStoreInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiHibernateVersioningStore.class);

    @Deprecated
    public XWikiHibernateVersioningStore(XWiki xwiki, XWikiContext context) {
        super(xwiki, context);
    }

    @Deprecated
    public XWikiHibernateVersioningStore(String hibpath) {
        super(hibpath);
    }

    @Deprecated
    public XWikiHibernateVersioningStore(XWikiContext context) {
        this(context.getWiki(), context);
    }

    public XWikiHibernateVersioningStore() {
    }

    @Override
    public Version[] getXWikiDocVersions(XWikiDocument doc, XWikiContext context) throws XWikiException {
        return this.getXWikiDocVersions(doc, new RevisionCriteriaFactory().createRevisionCriteria(true), context).toArray(new Version[0]);
    }

    @Override
    public Collection<Version> getXWikiDocVersions(XWikiDocument doc, RevisionCriteria criteria, XWikiContext context) throws XWikiException {
        try {
            XWikiDocumentArchive archive = this.getXWikiDocumentArchive(doc, criteria, context);
            if (archive == null) {
                return List.of();
            }
            Collection<XWikiRCSNodeInfo> nodes = archive.getNodes();
            LinkedList<Version> versions = new LinkedList<Version>();
            for (XWikiRCSNodeInfo node : nodes) {
                versions.addFirst(node.getId().getVersion());
            }
            return versions;
        }
        catch (Exception e) {
            Object[] args = new Object[]{doc.getFullName()};
            throw new XWikiException(3, 3203, "Exception while reading document {0} revisions", e, args);
        }
    }

    @Override
    public XWikiDocumentArchive getXWikiDocumentArchive(XWikiDocument doc, XWikiContext inputxcontext) throws XWikiException {
        return this.getXWikiDocumentArchive(doc, new RevisionCriteriaFactory().createRevisionCriteria(true), inputxcontext);
    }

    private XWikiDocumentArchive getXWikiDocumentArchive(XWikiDocument doc, RevisionCriteria criteria, XWikiContext inputxcontext) throws XWikiException {
        XWikiDocumentArchive archiveDoc = doc.getDocumentArchive();
        if (archiveDoc == null) {
            archiveDoc = this.getXWikiDocumentArchiveFromDatabase(doc, criteria, inputxcontext);
        } else if (!criteria.isAllInclusive()) {
            archiveDoc = this.filterArchiveFromCriteria(doc, archiveDoc, criteria);
        }
        return archiveDoc;
    }

    private XWikiDocumentArchive filterArchiveFromCriteria(XWikiDocument doc, XWikiDocumentArchive archiveDoc, RevisionCriteria criteria) {
        XWikiDocumentArchive result = new XWikiDocumentArchive(doc.getDocumentReference().getWikiReference(), doc.getId());
        Collection<String> versionsToKeep = this.filterVersions(archiveDoc, criteria);
        result.setNodes(archiveDoc.getNodes().stream().filter(node -> versionsToKeep.contains(node.getVersion().toString())).toList());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XWikiDocumentArchive getXWikiDocumentArchiveFromDatabase(XWikiDocument doc, RevisionCriteria criteria, XWikiContext inputxcontext) throws XWikiException {
        XWikiDocumentArchive archiveDoc = null;
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        String db = context.getWikiId();
        try {
            if (doc.getDatabase() != null) {
                context.setWikiId(doc.getDatabase());
            }
            archiveDoc = new XWikiDocumentArchive(doc.getDocumentReference().getWikiReference(), doc.getId());
            this.loadXWikiDocArchive(archiveDoc, criteria, context);
            if (criteria.isAllInclusive()) {
                doc.setDocumentArchive(archiveDoc);
            }
        }
        finally {
            context.setWikiId(db);
            this.restoreExecutionXContext();
        }
        return archiveDoc;
    }

    @Override
    public void loadXWikiDocArchive(XWikiDocumentArchive archivedoc, boolean bTransaction, XWikiContext context) throws XWikiException {
        this.loadXWikiDocArchive(archivedoc, new RevisionCriteriaFactory().createRevisionCriteria(true), context);
    }

    private void loadXWikiDocArchive(XWikiDocumentArchive archivedoc, RevisionCriteria criteria, XWikiContext context) throws XWikiException {
        try {
            List<XWikiRCSNodeInfo> nodes = this.loadRCSNodeInfo(context, archivedoc.getId(), criteria);
            archivedoc.setNodes(nodes);
        }
        catch (Exception e) {
            Object[] args = new Object[]{archivedoc.getId()};
            throw new XWikiException(3, 3212, "Exception while loading archive {0}", e, args);
        }
    }

    @Override
    public void saveXWikiDocArchive(XWikiDocumentArchive archivedoc, boolean bTransaction, XWikiContext context) throws XWikiException {
        this.executeWrite(context, session -> {
            for (XWikiRCSNodeInfo ni : archivedoc.getDeletedNodeInfo()) {
                session.delete((Object)ni);
            }
            archivedoc.getDeletedNodeInfo().clear();
            for (XWikiRCSNodeInfo ni : archivedoc.getUpdatedNodeInfos()) {
                session.saveOrUpdate((Object)ni);
            }
            archivedoc.getUpdatedNodeInfos().clear();
            for (XWikiRCSNodeContent nc : archivedoc.getUpdatedNodeContents()) {
                session.update((Object)nc);
            }
            archivedoc.getUpdatedNodeContents().clear();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWikiDocument loadXWikiDoc(XWikiDocument basedoc, String sversion, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            XWikiDocumentArchive archive = this.getXWikiDocumentArchive(basedoc, context);
            Version version = new Version(sversion);
            XWikiDocument doc = archive.loadDocument(version, context);
            if (doc == null) {
                Object[] args = new Object[]{basedoc.getDocumentReferenceWithLocale(), version.toString()};
                throw new XWikiException(3, 3205, "Version {1} does not exist while reading document {0}", null, args);
            }
            doc.setDocumentReference(basedoc.getDocumentReference());
            doc.setStore(basedoc.getStore());
            for (XWikiAttachment revisionAttachment : doc.getAttachmentList()) {
                XWikiAttachment attachment = basedoc.getAttachment(revisionAttachment.getFilename());
                if (attachment == null) continue;
                revisionAttachment.setContentStore(attachment.getContentStore());
                revisionAttachment.setArchiveStore(attachment.getArchiveStore());
            }
            XWikiDocument xWikiDocument = doc;
            return xWikiDocument;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRCSArchive(XWikiDocument doc, boolean bTransaction, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            this.executeWrite(context, session -> {
                XWikiDocumentArchive archive = this.getXWikiDocumentArchive(doc, context);
                archive.resetArchive();
                archive.getDeletedNodeInfo().clear();
                doc.setMinorEdit(false);
                this.deleteArchive(doc, false, context);
                this.updateXWikiDocArchive(doc, false, context);
                return null;
            });
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Override
    public void updateXWikiDocArchive(XWikiDocument doc, boolean bTransaction, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            XWikiDocumentArchive archiveDoc = this.getXWikiDocumentArchive(doc, context);
            UserReferenceSerializer userReferenceSerializer = (UserReferenceSerializer)Utils.getComponent((Type)new DefaultParameterizedType(null, UserReferenceSerializer.class, new Type[]{String.class}));
            String author = (String)userReferenceSerializer.serialize(doc.getAuthors().getOriginalMetadataAuthor());
            archiveDoc.updateArchive(doc, author, doc.getDate(), doc.getComment(), doc.getRCSVersion(), context);
            doc.setRCSVersion(archiveDoc.getLatestVersion());
            this.saveXWikiDocArchive(archiveDoc, bTransaction, context);
        }
        catch (Exception e) {
            Object[] args = new Object[]{doc.getFullName()};
            throw new XWikiException(3, 3211, "Exception while updating archive {0}", e, args);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    protected List<XWikiRCSNodeInfo> loadAllRCSNodeInfo(XWikiContext context, long id, boolean bTransaction) throws XWikiException {
        return this.loadRCSNodeInfo(context, id, new RevisionCriteriaFactory().createRevisionCriteria(true));
    }

    private List<XWikiRCSNodeInfo> loadRCSNodeInfo(XWikiContext context, long id, RevisionCriteria criteria) throws XWikiException {
        return this.executeRead(context, session -> {
            try {
                List nodes = VersioningStoreQueryFactory.getRCSNodeInfoQuery(session, id, criteria).getResultList();
                nodes.forEach(n -> n.getId().setWikiReference(context.getWikiReference()));
                return nodes;
            }
            catch (IllegalArgumentException e) {
                throw new XWikiException(String.format("Encountered invalid history when fetching archive for document [%s]", id), e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWikiRCSNodeContent loadRCSNodeContent(XWikiRCSNodeId id, boolean bTransaction, XWikiContext context) throws XWikiException {
        WikiReference currentWiki = context.getWikiReference();
        try {
            if (id.getWikiReference() != null) {
                context.setWikiReference(id.getWikiReference());
            }
            XWikiRCSNodeContent xWikiRCSNodeContent = this.executeRead(context, session -> {
                XWikiRCSNodeContent content = new XWikiRCSNodeContent(id);
                session.load((Object)content, (Serializable)content.getId());
                return content;
            });
            return xWikiRCSNodeContent;
        }
        finally {
            context.setWikiReference(currentWiki);
        }
    }

    @Override
    public void deleteArchive(XWikiDocument doc, boolean bTransaction, XWikiContext context) throws XWikiException {
        this.executeWrite(context, session -> {
            VersioningStoreQueryFactory.getDeleteArchiveQuery(session, doc.getId()).executeUpdate();
            return null;
        });
    }

    @Override
    public long getXWikiDocVersionsCount(XWikiDocument doc, RevisionCriteria criteria, XWikiContext context) throws XWikiException {
        return this.getRCSNodeInfoCount(context, doc.getId(), criteria);
    }

    private long getRCSNodeInfoCount(XWikiContext context, long id, RevisionCriteria criteria) throws XWikiException {
        return this.executeRead(context, session -> {
            try {
                return (Long)VersioningStoreQueryFactory.getRCSNodeInfoCountQuery(session, id, criteria).getSingleResult();
            }
            catch (IllegalArgumentException e) {
                throw new XWikiException(String.format("Encountered invalid history when computing archive size for document [%s]", id), e);
            }
        });
    }
}

