/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLink;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.doc.XWikiSpace;
import com.xpn.xwiki.internal.store.hibernate.legacy.LegacySessionImplementor;
import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import com.xpn.xwiki.monitor.api.MonitorPlugin;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseElement;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.BaseStringProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.ListProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.classes.StringClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import com.xpn.xwiki.stats.impl.XWikiStats;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.XWikiAttachmentStoreInterface;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateStoreCompatibilityAspect;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.EntityType;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.PageAttachmentReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.store.UnexpectedException;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="hibernate")
@Singleton
public class XWikiHibernateStore
extends XWikiHibernateBaseStore
implements XWikiStoreInterface,
Initializable {
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    @Inject
    private DocumentReferenceResolver<String> defaultDocumentReferenceResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<PageReference> currentPageReferenceDocumentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="hibernate")
    private XWikiAttachmentStoreInterface attachmentContentStore;
    @Inject
    @Named(value="hibernate")
    private AttachmentVersioningStore attachmentArchiveStore;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    private Map<String, String[]> validTypesMap = new HashMap<String, String[]>();
    private final Map<Long, ReentrantLock> documentSavingLockMap = Collections.synchronizedMap(new ReferenceMap());
    private final Map<Long, ReentrantLock> spaceSavingLockMap = Collections.synchronizedMap(new ReferenceMap());
    private Optional<Set<EntityReference>> optimizedObjectClasses;

    @Deprecated
    public XWikiHibernateStore(XWiki xwiki, XWikiContext context) {
        super(xwiki, context);
        this.initValidColumTypes();
    }

    @Deprecated
    public XWikiHibernateStore(String hibpath) {
        super(hibpath);
        this.initValidColumTypes();
    }

    @Deprecated
    public XWikiHibernateStore(XWikiContext context) {
        this(context.getWiki(), context);
    }

    public XWikiHibernateStore() {
        this.initValidColumTypes();
    }

    public void initialize() throws InitializationException {
        this.registerLogoutListener();
        this.optimizedObjectClasses = this.hibernateConfiguration.getOptimizedXObjectClasses();
        this.logger.debug("optimizedObjectClasses: {}", this.optimizedObjectClasses);
    }

    private void initValidColumTypes() {
        String[] string_types = new String[]{"string", "text", "clob"};
        String[] number_types = new String[]{"integer", "long", "float", "double", "big_decimal", "big_integer", "yes_no", "true_false"};
        String[] date_types = new String[]{"date", "time", "timestamp"};
        String[] boolean_types = new String[]{"boolean", "yes_no", "true_false", "integer"};
        this.validTypesMap = new HashMap<String, String[]>();
        this.validTypesMap.put("com.xpn.xwiki.objects.classes.StringClass", string_types);
        this.validTypesMap.put("com.xpn.xwiki.objects.classes.TextAreaClass", string_types);
        this.validTypesMap.put("com.xpn.xwiki.objects.classes.PasswordClass", string_types);
        this.validTypesMap.put("com.xpn.xwiki.objects.classes.NumberClass", number_types);
        this.validTypesMap.put("com.xpn.xwiki.objects.classes.DateClass", date_types);
        this.validTypesMap.put("com.xpn.xwiki.objects.classes.BooleanClass", boolean_types);
    }

    @Override
    public boolean isWikiNameAvailable(String wikiName, XWikiContext inputxcontext) throws XWikiException {
        try {
            return !this.store.isWikiDatabaseExist(wikiName);
        }
        catch (Exception e) {
            Object[] args = new Object[]{wikiName};
            throw new XWikiException(3, 3403, "Exception while listing databases to search for {0}", e, args);
        }
    }

    @Override
    public void createWiki(String wikiName, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, false);
        boolean bTransaction = true;
        String database = context.getWikiId();
        AtomicReference<Object> stmt = new AtomicReference<Object>(null);
        bTransaction = this.beginTransaction(context);
        try {
            Session session = this.getSession(context);
            session.doWork(connection -> {
                stmt.set(connection.createStatement());
                Statement statement = (Statement)stmt.get();
                String schema = this.getSchemaFromWikiName(wikiName, context);
                String escapedSchema = this.escapeSchema(schema, context);
                DatabaseProduct databaseProduct = this.getDatabaseProductName();
                if (DatabaseProduct.ORACLE == databaseProduct) {
                    statement.execute(String.format("CREATE USER %s IDENTIFIED BY %s QUOTA UNLIMITED ON USERS", escapedSchema, escapedSchema));
                } else if (DatabaseProduct.DERBY == databaseProduct || DatabaseProduct.DB2 == databaseProduct || DatabaseProduct.H2 == databaseProduct) {
                    statement.execute("CREATE SCHEMA " + escapedSchema);
                } else if (DatabaseProduct.HSQLDB == databaseProduct) {
                    statement.execute("CREATE SCHEMA " + escapedSchema + " AUTHORIZATION DBA");
                } else if (DatabaseProduct.MYSQL == databaseProduct) {
                    StringBuilder statementBuilder = new StringBuilder("create database " + escapedSchema);
                    String[] charsetAndCollation = this.getCharsetAndCollation(wikiName, session, context);
                    statementBuilder.append(" CHARACTER SET ");
                    statementBuilder.append(charsetAndCollation[0]);
                    statementBuilder.append(" COLLATE ");
                    statementBuilder.append(charsetAndCollation[1]);
                    statement.execute(statementBuilder.toString());
                } else if (DatabaseProduct.POSTGRESQL == databaseProduct) {
                    if (this.isInSchemaMode()) {
                        statement.execute("CREATE SCHEMA " + escapedSchema);
                    } else {
                        this.logger.error("Creation of a new database is currently only supported in the schema mode, see https://jira.xwiki.org/browse/XWIKI-8753");
                    }
                } else {
                    statement.execute("create database " + escapedSchema);
                }
            });
            if (bTransaction) {
                this.endTransaction(context, true);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{wikiName};
            throw new XWikiException(3, 3401, "Exception while create wiki database {0}", e, args);
        }
        finally {
            context.setWikiId(database);
            try {
                Statement statement = stmt.get();
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bTransaction) {
                    this.endTransaction(context, false);
                }
            }
            catch (Exception exception) {}
        }
    }

    private String[] getCharsetAndCollation(String wikiName, Session session, XWikiContext context) {
        NativeQuery selectQuery;
        Object[] queryResult;
        String[] result = new String[2];
        String charset = "utf8mb4";
        String collation = "utf8mb4_bin";
        if (!context.isMainWiki(wikiName) && (queryResult = (Object[])(selectQuery = session.createNativeQuery("select DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME from INFORMATION_SCHEMA.SCHEMATA where SCHEMA_NAME='" + this.getSchemaFromWikiName(context.getMainXWiki(), context) + "'")).uniqueResult()) != null) {
            charset = (String)queryResult[0];
            collation = (String)queryResult[1];
        }
        result[0] = charset;
        result[1] = collation;
        return result;
    }

    @Override
    public void deleteWiki(String wikiName, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, false);
        String database = context.getWikiId();
        AtomicReference<Object> stmt = new AtomicReference<Object>(null);
        boolean bTransaction = this.beginTransaction(context);
        try {
            Session session = this.getSession(context);
            session.doWork(connection -> {
                stmt.set(connection.createStatement());
                String schema = this.getSchemaFromWikiName(wikiName, context);
                String escapedSchema = this.escapeSchema(schema, context);
                this.executeDeleteWikiStatement((Statement)stmt.get(), this.getDatabaseProductName(), escapedSchema);
            });
            if (bTransaction) {
                this.endTransaction(context, true);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{wikiName};
            throw new XWikiException(3, 3402, "Exception while delete wiki database {0}", e, args);
        }
        finally {
            context.setWikiId(database);
            try {
                Statement statement = stmt.get();
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bTransaction) {
                    this.endTransaction(context, false);
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void executeDeleteWikiStatement(Statement statement, DatabaseProduct databaseProduct, String escapedSchemaName) throws SQLException {
        if (DatabaseProduct.ORACLE == databaseProduct) {
            statement.execute("DROP USER " + escapedSchemaName + " CASCADE");
        } else if (DatabaseProduct.DERBY == databaseProduct || DatabaseProduct.MYSQL == databaseProduct || DatabaseProduct.H2 == databaseProduct) {
            statement.execute("DROP SCHEMA " + escapedSchemaName);
        } else if (DatabaseProduct.HSQLDB == databaseProduct) {
            statement.execute("DROP SCHEMA " + escapedSchemaName + " CASCADE");
        } else if (DatabaseProduct.DB2 == databaseProduct) {
            statement.execute("DROP SCHEMA " + escapedSchemaName + " RESTRICT");
        } else if (DatabaseProduct.POSTGRESQL == databaseProduct) {
            if (this.isInSchemaMode()) {
                statement.execute("DROP SCHEMA " + escapedSchemaName + " CASCADE");
            } else {
                this.logger.warn("Subwiki deletion not yet supported in Database mode for PostgreSQL");
            }
        }
    }

    @Override
    public boolean exists(XWikiDocument doc, XWikiContext inputxcontext) throws XWikiException {
        try {
            if (!this.wikiDescriptorManager.exists(this.wikiDescriptorManager.getCurrentWikiId())) {
                return false;
            }
        }
        catch (WikiManagerException e) {
            Object[] args = new Object[]{this.wikiDescriptorManager.getCurrentWikiId()};
            throw new XWikiException(3, 3236, "Error while checking for existence of the [{0}] wiki", e, args);
        }
        return this.executeRead(inputxcontext, session -> {
            try {
                String fullName = doc.getFullName();
                Object sql = "select doc.fullName from XWikiDocument as doc where doc.fullName=:fullName";
                if (!doc.getLocale().equals(Locale.ROOT)) {
                    sql = (String)sql + " and doc.language=:language";
                }
                org.hibernate.query.Query query = session.createQuery((String)sql);
                query.setParameter("fullName", (Object)fullName);
                if (!doc.getLocale().equals(Locale.ROOT)) {
                    query.setParameter("language", (Object)doc.getLocale().toString());
                }
                Iterator it = query.list().iterator();
                while (it.hasNext()) {
                    if (!fullName.equals(it.next())) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                Object[] args = new Object[]{doc.getDocumentReferenceWithLocale()};
                throw new XWikiException(3, 3236, "Exception while reading document {0}", e, args);
            }
        });
    }

    private boolean isClassOptimized(DocumentReference classReference) {
        return this.optimizedObjectClasses.isEmpty() || this.optimizedObjectClasses.get().contains(classReference.getLocalDocumentReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveXWikiDoc(XWikiDocument doc, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        Lock lock = this.documentSavingLockMap.computeIfAbsent(doc.getId(), id -> new ReentrantLock(true));
        lock.lock();
        try {
            XWikiContext context = this.getExecutionXContext(inputxcontext, true);
            MonitorPlugin monitor = Util.getMonitorPlugin(context);
            try {
                if (monitor != null) {
                    monitor.startTimer("hibernate");
                }
                doc.setStore(this);
                doc.setDatabase(context.getWikiId());
                String comment = doc.getComment();
                if (comment != null && comment.length() > 1023) {
                    doc.setComment(StringUtils.abbreviate((String)comment, (int)1023));
                }
                doc.initialize();
                if (bTransaction) {
                    this.checkHibernate(context);
                    SessionFactory sfactory = this.injectCustomMappingsInSessionFactory(doc, context);
                    bTransaction = this.beginTransaction(sfactory, context);
                }
                try {
                    Session session = this.getSession(context);
                    session.setHibernateFlushMode(FlushMode.COMMIT);
                    doc.setElement(1, !doc.getAttachmentList().isEmpty());
                    doc.setElement(2, !doc.getXObjects().isEmpty());
                    BaseClass bclass = doc.getXClass();
                    if (bclass != null) {
                        if (bclass.getFieldList().isEmpty()) {
                            doc.setXClassXML("");
                        } else {
                            doc.setXClassXML(bclass.toXMLString(false));
                        }
                        bclass.setDirty(false);
                    }
                    if (!doc.getAttachmentsToRemove().isEmpty()) {
                        for (XWikiDocument.XWikiAttachmentToRemove attachmentToRemove : doc.getAttachmentsToRemove()) {
                            Object store;
                            XWikiAttachment xWikiAttachment = attachmentToRemove.getAttachment();
                            XWikiAttachment attachmentToAdd = doc.getAttachment(xWikiAttachment.getFilename());
                            if (attachmentToAdd != null && attachmentToAdd.getId() == xWikiAttachment.getId()) {
                                store = this.getAttachmentVersioningStore(xWikiAttachment);
                                store.deleteArchive(xWikiAttachment, context, bTransaction);
                                attachmentToAdd.setContentStore(xWikiAttachment.getContentStore());
                                continue;
                            }
                            store = this.getXWikiAttachmentStoreInterface(xWikiAttachment);
                            store.deleteXWikiAttachment(xWikiAttachment, false, context, false);
                        }
                    }
                    if (doc.hasElement(1)) {
                        this.saveAttachmentList(doc, context);
                    }
                    doc.clearAttachmentsToRemove();
                    if (doc.isContentDirty() || doc.isMetaDataDirty()) {
                        Date ndate = new Date();
                        doc.setDate(ndate);
                        if (doc.isContentDirty()) {
                            doc.setContentUpdateDate(ndate);
                            DocumentAuthors authors = doc.getAuthors();
                            authors.setContentAuthor(authors.getEffectiveMetadataAuthor());
                        }
                        doc.incrementVersion();
                        if (context.getWiki().hasVersioning(context)) {
                            context.getWiki().getVersioningStore().updateXWikiDocArchive(doc, false, context);
                        }
                        doc.setContentDirty(false);
                        doc.setMetaDataDirty(false);
                    } else if (doc.getDocumentArchive() != null) {
                        if (context.getWiki().hasVersioning(context)) {
                            context.getWiki().getVersioningStore().saveXWikiDocArchive(doc.getDocumentArchive(), false, context);
                            if (!this.containsVersion(doc, doc.getRCSVersion(), context)) {
                                context.getWiki().getVersioningStore().updateXWikiDocArchive(doc, false, context);
                            }
                        }
                    } else {
                        try {
                            if (context.getWiki().hasVersioning(context)) {
                                doc.getDocumentArchive(context);
                                if (!this.containsVersion(doc, doc.getRCSVersion(), context)) {
                                    context.getWiki().getVersioningStore().updateXWikiDocArchive(doc, false, context);
                                }
                            }
                        }
                        catch (XWikiException ndate) {
                            // empty catch block
                        }
                    }
                    org.hibernate.query.Query query = session.createQuery("select xwikidoc.id from XWikiDocument as xwikidoc where xwikidoc.id = :id");
                    query.setParameter("id", (Object)doc.getId());
                    if (query.uniqueResult() == null) {
                        doc.setNew(true);
                    }
                    if (doc.isNew()) {
                        if (doc.isContentDirty() || doc.isMetaDataDirty()) {
                            doc.setCreationDate(new Date());
                        }
                        session.save((Object)doc);
                    } else {
                        session.update((Object)doc);
                    }
                    if (!doc.getXObjectsToRemove().isEmpty()) {
                        for (BaseObject baseObject : doc.getXObjectsToRemove()) {
                            this.deleteXWikiCollection(baseObject, context, false, false);
                        }
                        doc.setXObjectsToRemove(new ArrayList<BaseObject>());
                    }
                    if (bclass != null) {
                        bclass.setDocumentReference(doc.getDocumentReference());
                        context.addBaseClass(bclass);
                    }
                    if (doc.hasElement(2)) {
                        for (Map.Entry entry : doc.getXObjects().entrySet()) {
                            List objects = (List)entry.getValue();
                            if (objects.isEmpty()) continue;
                            boolean optimizedObjects = !doc.isNew() && doc.isChangeTracked() && this.isClassOptimized((DocumentReference)entry.getKey());
                            int count = 0;
                            for (BaseObject obj : objects) {
                                if (obj == null || optimizedObjects && !obj.isDirty()) continue;
                                ++count;
                                obj.setDocumentReference(doc.getDocumentReference());
                                if (StringUtils.isEmpty((CharSequence)obj.getGuid())) {
                                    obj.setGuid(null);
                                }
                                this.saveXWikiCollection(obj, context, false);
                            }
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug("saveXWikiDoc:");
                            this.logger.debug("    - document: [{}]", (Object)doc.getDocumentReferenceWithLocale());
                            this.logger.debug("    - optimizedObjects: {} (doc.isNew: {} doc.isChangeTracked: {}, isClassOptimized: {})", new Object[]{optimizedObjects, doc.isNew(), doc.isChangeTracked(), this.isClassOptimized((DocumentReference)entry.getKey())});
                            this.logger.debug("    - saved xobjects: [{}]", (Object)count);
                        }
                    }
                    this.updateXWikiSpaceTable(doc, session);
                    if (bTransaction) {
                        this.endTransaction(context, true);
                    }
                    doc.setNew(false);
                    doc.setRestricted(false);
                    doc.setChangeTracked(true);
                    doc.setOriginalDocument(doc.clone());
                }
                finally {
                    if (bTransaction) {
                        try {
                            this.endTransaction(context, false);
                        }
                        catch (Exception session) {}
                    }
                }
            }
            catch (Exception e) {
                Object[] args = new Object[]{this.defaultEntityReferenceSerializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0])};
                throw new XWikiException(3, 3201, "Exception while saving document {0}", e, args);
            }
            finally {
                if (monitor != null) {
                    monitor.endTimer("hibernate");
                }
            }
        }
        finally {
            lock.unlock();
            this.restoreExecutionXContext();
        }
    }

    private void updateXWikiSpaceTable(XWikiDocument document, Session session) {
        if (document.getLocale().equals(Locale.ROOT)) {
            this.maybeCreateSpace(document.getDocumentReference().getLastSpaceReference(), document.isHidden(), session);
            if (!document.isNew() && document.isHidden() != document.getOriginalDocument().isHidden()) {
                if (document.isHidden().booleanValue()) {
                    this.maybeMakeSpaceHidden(document.getDocumentReference().getLastSpaceReference(), document.getFullName(), session);
                } else {
                    this.makeSpaceVisible(document.getDocumentReference().getLastSpaceReference(), session);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertXWikiSpace(XWikiSpace space, Session session) {
        Lock lock = this.spaceSavingLockMap.computeIfAbsent(space.getId(), id -> new ReentrantLock(true));
        lock.lock();
        try {
            session.save((Object)space);
            if (space.getSpaceReference().getParent() instanceof SpaceReference) {
                this.maybeCreateSpace((SpaceReference)space.getSpaceReference().getParent(), space.isHidden(), session);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void makeSpaceVisible(SpaceReference spaceReference, Session session) {
        XWikiSpace space = this.loadXWikiSpace(spaceReference, session);
        this.makeSpaceVisible(space, session);
    }

    private void makeSpaceVisible(XWikiSpace space, Session session) {
        if (space.isHidden()) {
            space.setHidden(false);
            session.update((Object)space);
            if (space.getSpaceReference().getParent() instanceof SpaceReference) {
                this.makeSpaceVisible((SpaceReference)space.getSpaceReference().getParent(), session);
            }
        }
    }

    private void maybeMakeSpaceHidden(SpaceReference spaceReference, String modifiedDocument, Session session) {
        XWikiSpace space = this.loadXWikiSpace(spaceReference, session);
        if (space == null) {
            this.logger.warn("Space [{}] does not exist. Usually means the spaces table is not in sync with the documents table.", (Object)spaceReference);
            return;
        }
        if (space.isHidden()) {
            return;
        }
        if (this.calculateHiddenStatus(spaceReference, modifiedDocument, session)) {
            space.setHidden(true);
            session.update((Object)space);
            if (spaceReference.getParent() instanceof SpaceReference) {
                this.maybeMakeSpaceHidden((SpaceReference)spaceReference.getParent(), modifiedDocument, session);
            }
        }
    }

    private void maybeCreateSpace(SpaceReference spaceReference, boolean hidden, Session session) {
        XWikiSpace space = this.loadXWikiSpace(spaceReference, session);
        if (space != null) {
            if (space.isHidden() && !hidden) {
                this.makeSpaceVisible(space, session);
            }
        } else {
            this.insertXWikiSpace(new XWikiSpace(spaceReference, hidden), session);
        }
    }

    private boolean hasDocuments(SpaceReference spaceReference, Session session, String extraWhere, Map<String, ?> parameters) {
        StringBuilder builder = new StringBuilder("select distinct xwikidoc.space from XWikiDocument as xwikidoc where (space = :space OR space LIKE :like)");
        if (StringUtils.isNotEmpty((CharSequence)extraWhere)) {
            builder.append(" AND ");
            builder.append('(');
            builder.append(extraWhere);
            builder.append(')');
        }
        org.hibernate.query.Query query = session.createQuery(builder.toString(), String.class);
        String localSpaceReference = (String)this.localEntityReferenceSerializer.serialize((EntityReference)spaceReference, new Object[0]);
        String localSpaceReferencePrefix = localSpaceReference + ".";
        query.setParameter("space", (Object)localSpaceReference);
        query.setParameter("like", (Object)(localSpaceReferencePrefix + "%"));
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((org.hibernate.query.Query)query).setParameter(arg_0, arg_1));
        }
        for (String result : query.getResultList()) {
            if (!result.equals(localSpaceReference) && !result.startsWith(localSpaceReferencePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean calculateHiddenStatus(SpaceReference spaceReference, String documentToIngore, Session session) {
        Map<String, String> parameters;
        StringBuilder builder = new StringBuilder("(hidden = false OR hidden IS NULL)");
        if (documentToIngore != null) {
            builder.append(" AND fullName <> :documentToIngore");
            parameters = Collections.singletonMap("documentToIngore", documentToIngore);
        } else {
            parameters = null;
        }
        return !this.hasDocuments(spaceReference, session, builder.toString(), parameters);
    }

    private boolean containsVersion(XWikiDocument doc, Version targetversion, XWikiContext context) throws XWikiException {
        for (Version version : doc.getRevisions(context)) {
            if (!version.equals((Object)targetversion)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveXWikiDoc(XWikiDocument doc, XWikiContext context) throws XWikiException {
        this.saveXWikiDoc(doc, context, true);
    }

    @Override
    public void renameXWikiDoc(XWikiDocument doc, DocumentReference newReference, XWikiContext inputxcontext) throws XWikiException {
        WikiReference sourceWikiReference = doc.getDocumentReference().getWikiReference();
        WikiReference targetWikiReference = newReference.getWikiReference();
        boolean sameSession = sourceWikiReference.equals((Object)targetWikiReference);
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        XWikiDocument newDocument = doc.cloneRename(newReference, context);
        newDocument.setNew(true);
        newDocument.setStore(this);
        newDocument.setComment("Renamed from " + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0]));
        boolean copyPerformed = false;
        try {
            if (sameSession) {
                this.executeWrite(context, session -> {
                    this.saveXWikiDoc(newDocument, context, false);
                    session.flush();
                    this.deleteXWikiDoc(doc, context, false);
                    return true;
                });
            } else {
                context.setWikiReference(targetWikiReference);
                this.executeWrite(context, session -> {
                    this.saveXWikiDoc(newDocument, context, false);
                    return true;
                });
                copyPerformed = true;
                context.setWikiReference(sourceWikiReference);
                this.executeWrite(context, session -> {
                    this.deleteXWikiDoc(doc, context, false);
                    return true;
                });
            }
        }
        catch (Exception e) {
            if (!sameSession && copyPerformed) {
                this.executeWrite(context, session -> {
                    this.deleteXWikiDoc(newDocument, context, false);
                    return true;
                });
            }
            Object[] args = new Object[]{doc.getDocumentReference(), newReference};
            throw new XWikiException(3, 3206, "Exception while renaming document [{0}] to [{1}]", e, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWikiDocument loadXWikiDoc(XWikiDocument defaultDocument, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        XWikiDocument doc = defaultDocument;
        try {
            boolean bTransaction = true;
            MonitorPlugin monitor = Util.getMonitorPlugin(context);
            try {
                if (monitor != null) {
                    monitor.startTimer("hibernate");
                }
                this.checkHibernate(context);
                SessionFactory sfactory = this.injectCustomMappingsInSessionFactory(defaultDocument, context);
                bTransaction = bTransaction && this.beginTransaction(sfactory, context);
                try {
                    Session session = this.getSession(context);
                    session.setHibernateFlushMode(FlushMode.MANUAL);
                    doc = (XWikiDocument)session.get(XWikiDocument.class, (Serializable)Long.valueOf(doc.getId()));
                    if (doc == null) {
                        defaultDocument.setNew(true);
                        defaultDocument.setOriginalDocument(new XWikiDocument(defaultDocument.getDocumentReference(), defaultDocument.getLocale()));
                        XWikiDocument xWikiDocument = defaultDocument;
                        return xWikiDocument;
                    }
                    doc.setStore(this);
                    doc.setNew(false);
                    doc.setMostRecent(true);
                    doc.setDate(new Date(doc.getDate().getTime()));
                    doc.setCreationDate(new Date(doc.getCreationDate().getTime()));
                    doc.setContentUpdateDate(new Date(doc.getContentUpdateDate().getTime()));
                    if (doc.hasElement(1)) {
                        this.loadAttachmentList(doc, context, false);
                    }
                    BaseClass bclass = new BaseClass();
                    String cxml = doc.getXClassXML();
                    if (cxml != null) {
                        bclass.fromXML(cxml);
                        doc.setXClass(bclass);
                        bclass.setDirty(false);
                    }
                    context.addBaseClass(bclass);
                    if (doc.hasElement(2)) {
                        org.hibernate.query.Query query = session.createQuery("from BaseObject as bobject where bobject.name = :name order by bobject.number", BaseObject.class);
                        query.setParameter("name", (Object)doc.getFullName());
                        Iterator it = query.list().iterator();
                        EntityReference localGroupEntityReference = new EntityReference("XWikiGroups", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
                        DocumentReference groupsDocumentReference = new DocumentReference(context.getWikiId(), localGroupEntityReference.getParent().getName(), localGroupEntityReference.getName());
                        boolean hasGroups = false;
                        while (it.hasNext()) {
                            BaseObject object = (BaseObject)it.next();
                            DocumentReference classReference = object.getXClassReference();
                            if (classReference == null || !object.getDocumentReference().equals((Object)doc.getDocumentReference())) continue;
                            BaseObject newobject = classReference.equals((Object)doc.getDocumentReference()) ? bclass.newCustomClassInstance(true) : BaseClass.newCustomClassInstance(classReference, true, context);
                            if (newobject != null) {
                                newobject.setId(object.getId());
                                newobject.setXClassReference(object.getRelativeXClassReference());
                                newobject.setDocumentReference(object.getDocumentReference());
                                newobject.setNumber(object.getNumber());
                                newobject.setGuid(object.getGuid());
                                object = newobject;
                            }
                            if (classReference.equals((Object)groupsDocumentReference)) {
                                hasGroups = true;
                            } else {
                                this.loadXWikiCollectionInternal(object, doc, context, false, true);
                            }
                            doc.setXObject(object.getNumber(), object);
                            object.setDirty(false);
                        }
                        if (hasGroups) {
                            org.hibernate.query.Query query2 = session.createQuery("select bobject.number, prop.value from StringProperty as prop,BaseObject as bobject where bobject.name = :name and bobject.className='XWiki.XWikiGroups' and bobject.id=prop.id.id and prop.id.name='member' order by bobject.number", Object[].class);
                            query2.setParameter("name", (Object)doc.getFullName());
                            for (Object[] result : query2.list()) {
                                Integer number = (Integer)result[0];
                                String member = (String)result[1];
                                BaseObject obj = BaseClass.newCustomClassInstance(groupsDocumentReference, true, context);
                                obj.setDocumentReference(doc.getDocumentReference());
                                obj.setXClassReference(localGroupEntityReference);
                                obj.setNumber(number);
                                obj.setStringValue("member", member);
                                ((BaseProperty)obj.getField("member")).setDirty(false);
                                doc.setXObject(obj.getNumber(), obj);
                                obj.setDirty(false);
                            }
                        }
                    }
                    doc.setContentDirty(false);
                    doc.setMetaDataDirty(false);
                    doc.setChangeTracked(true);
                    doc.setOriginalDocument(doc.clone());
                    if (bTransaction) {
                        this.endTransaction(context, false);
                    }
                }
                finally {
                    if (bTransaction) {
                        try {
                            this.endTransaction(context, false);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                Object[] args = new Object[]{defaultDocument.getDocumentReferenceWithLocale()};
                throw new XWikiException(3, 3202, "Exception while reading document [{0}]", e, args);
            }
            finally {
                if (monitor != null) {
                    monitor.endTimer("hibernate");
                }
            }
            this.logger.debug("Loaded XWikiDocument: [{}]", (Object)doc.getDocumentReferenceWithLocale());
            XWikiDocument xWikiDocument = doc;
            return xWikiDocument;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Override
    public void deleteXWikiDoc(XWikiDocument doc, XWikiContext inputxcontext) throws XWikiException {
        this.deleteXWikiDoc(doc, inputxcontext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteXWikiDoc(XWikiDocument doc, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            MonitorPlugin monitor = Util.getMonitorPlugin(context);
            try {
                if (monitor != null) {
                    monitor.startTimer("hibernate");
                }
                this.checkHibernate(context);
                SessionFactory sfactory = this.injectCustomMappingsInSessionFactory(doc, context);
                if (bTransaction) {
                    bTransaction = this.beginTransaction(sfactory, context);
                }
                try {
                    Session session = this.getSession(context);
                    session.setHibernateFlushMode(FlushMode.COMMIT);
                    if (doc.getStore() == null) {
                        Object[] args = new Object[]{doc.getDocumentReference()};
                        throw new XWikiException(3, 3204, "Impossible to delete document {0} if it is not loaded", null, args);
                    }
                    for (XWikiAttachment xWikiAttachment : doc.getAttachmentList()) {
                        XWikiAttachmentStoreInterface store = this.getXWikiAttachmentStoreInterface(xWikiAttachment);
                        store.deleteXWikiAttachment(xWikiAttachment, false, context, false);
                    }
                    if (context.getWiki().hasBacklinks(context)) {
                        this.deleteLinks(doc.getId(), context, true);
                    }
                    if (!doc.getXObjectsToRemove().isEmpty()) {
                        for (BaseObject baseObject : doc.getXObjectsToRemove()) {
                            if (baseObject == null) continue;
                            this.deleteXWikiCollection(baseObject, context, false, false);
                        }
                        doc.setXObjectsToRemove(new ArrayList<BaseObject>());
                    }
                    for (List list : doc.getXObjects().values()) {
                        for (BaseObject obj : list) {
                            if (obj == null) continue;
                            this.deleteXWikiCollection(obj, context, false, false);
                        }
                    }
                    context.getWiki().getVersioningStore().deleteArchive(doc, false, context);
                    session.delete((Object)doc);
                    doc.setOriginalDocument(doc.clone());
                    this.maybeDeleteXWikiSpace(doc, session);
                    if (bTransaction) {
                        this.endTransaction(context, true);
                    }
                }
                finally {
                    if (bTransaction) {
                        try {
                            this.endTransaction(context, false);
                        }
                        catch (Exception session) {}
                    }
                }
            }
            catch (Exception e) {
                Object[] args = new Object[]{doc.getDocumentReference()};
                throw new XWikiException(3, 3203, "Exception while deleting document {0}", e, args);
            }
            finally {
                if (monitor != null) {
                    monitor.endTimer("hibernate");
                }
            }
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    private void maybeDeleteXWikiSpace(XWikiDocument deletedDocument, Session session) {
        if (deletedDocument.getLocale().equals(Locale.ROOT)) {
            DocumentReference documentReference = deletedDocument.getDocumentReference();
            this.maybeDeleteXWikiSpace(documentReference.getLastSpaceReference(), (String)this.localEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]), session);
        }
    }

    private void maybeDeleteXWikiSpace(SpaceReference spaceReference, String deletedDocument, Session session) {
        if (!this.hasDocuments(spaceReference, session, "fullName <> :deletedDocument AND (language IS NULL OR language = '')", Collections.singletonMap("deletedDocument", deletedDocument))) {
            XWikiSpace space = new XWikiSpace(spaceReference, this);
            session.delete((Object)space);
            if (spaceReference.getParent() instanceof SpaceReference) {
                this.maybeDeleteXWikiSpace((SpaceReference)spaceReference.getParent(), deletedDocument, session);
            }
        } else {
            this.maybeMakeSpaceHidden(spaceReference, deletedDocument, session);
        }
    }

    private XWikiSpace loadXWikiSpace(SpaceReference spaceReference, Session session) {
        XWikiSpace space = (XWikiSpace)session.get(XWikiSpace.class, (Serializable)Long.valueOf(XWikiSpace.getId(spaceReference)));
        if (space != null) {
            space.setStore(this);
        }
        return space;
    }

    private void checkObjectClassIsLocal(BaseCollection object, XWikiContext context) throws XWikiException {
        DocumentReference xclass = object.getXClassReference();
        WikiReference wikiReference = xclass.getWikiReference();
        String db = context.getWikiId();
        if (!wikiReference.getName().equals(db)) {
            throw new XWikiException(3, 3211, "XObject [{0}] is an instance of an external XClass and cannot be persisted in this wiki [{1}].", null, new Object[]{this.localEntityReferenceSerializer.serialize(object.getReference(), new Object[0]), db});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void saveXWikiCollection(BaseCollection object, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            if (object == null) {
                return;
            }
            boolean stats = object instanceof XWikiStats;
            if (!stats) {
                this.checkObjectClassIsLocal(object, context);
            }
            if (bTransaction) {
                this.checkHibernate(context);
                bTransaction = this.beginTransaction(context);
            }
            try {
                Session session = this.getSession(context);
                org.hibernate.query.Query query = stats ? session.createQuery("select obj.id from " + object.getClass().getName() + " as obj where obj.id = :id", Long.class) : session.createQuery("select obj.id from BaseObject as obj where obj.id = :id", Long.class);
                query.setParameter("id", (Object)object.getId());
                if (query.uniqueResult() == null) {
                    if (stats) {
                        session.save((Object)object);
                    } else {
                        session.save("com.xpn.xwiki.objects.BaseObject", (Object)object);
                    }
                } else if (stats) {
                    session.update((Object)object);
                } else {
                    session.update("com.xpn.xwiki.objects.BaseObject", (Object)object);
                }
                BaseClass bclass = object.getXClass(context);
                List<Object> handledProps = new ArrayList();
                if (bclass != null && bclass.hasCustomMapping() && context.getWiki().hasCustomMappings()) {
                    Map<String, Object> objmap = object.getCustomMappingMap();
                    handledProps = bclass.getCustomMappingPropertyList(context);
                    query = session.createQuery("select obj.id from " + bclass.getName() + " as obj where obj.id = :id", Long.class);
                    query.setParameter("id", (Object)object.getId());
                    if (query.uniqueResult() == null) {
                        session.save(bclass.getName(), objmap);
                    } else {
                        session.update(bclass.getName(), objmap);
                    }
                }
                if (object.getXClassReference() != null) {
                    BaseClass xclass;
                    if (!object.getFieldsToRemove().isEmpty()) {
                        for (int i = 0; i < object.getFieldsToRemove().size(); ++i) {
                            BaseProperty prop = (BaseProperty)object.getFieldsToRemove().get(i);
                            if (handledProps.contains(prop.getName())) continue;
                            session.delete((Object)prop);
                        }
                        object.setFieldsToRemove(new ArrayList());
                    }
                    if ((xclass = object.getXClass(context)) != null) {
                        for (String key : xclass.getPropertyList()) {
                            PropertyClass classProperty;
                            BaseProperty property;
                            if (object.safeget(key) != null || (property = (classProperty = (PropertyClass)xclass.getField(key)).newProperty()) == null) continue;
                            object.safeput(key, property);
                        }
                    }
                    for (String key : object.getPropertyList()) {
                        BaseProperty prop = (BaseProperty)object.getField(key);
                        if (!prop.getName().equals(key)) {
                            Object[] args = new Object[]{key, object.getName()};
                            throw new XWikiException(7, 7002, "Field {0} in object {1} has an invalid name", null, args);
                        }
                        String pname = prop.getName();
                        if (pname == null || pname.trim().equals("") || handledProps.contains(pname)) continue;
                        this.saveXWikiPropertyInternal(prop, context, false);
                    }
                }
                object.setDirty(false);
                if (bTransaction) {
                    this.endTransaction(context, true);
                }
            }
            finally {
                if (bTransaction) {
                    try {
                        this.endTransaction(context, true);
                    }
                    catch (Exception session) {}
                }
            }
        }
        catch (XWikiException xe) {
            throw xe;
        }
        catch (Exception e) {
            Object[] args = new Object[]{object.getName()};
            throw new XWikiException(3, 3211, "Exception while saving object {0}", e, args);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Deprecated
    public void loadXWikiCollection(BaseCollection object, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.loadXWikiCollectionInternal(object, context, bTransaction, false);
    }

    private void loadXWikiCollectionInternal(BaseCollection object, XWikiContext context, boolean bTransaction, boolean alreadyLoaded) throws XWikiException {
        this.loadXWikiCollectionInternal(object, null, context, bTransaction, alreadyLoaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXWikiCollectionInternal(BaseCollection object1, XWikiDocument doc, XWikiContext inputxcontext, boolean bTransaction, boolean alreadyLoaded) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        BaseCollection object = object1;
        try {
            if (bTransaction) {
                this.checkHibernate(context);
                bTransaction = this.beginTransaction(context);
            }
            try {
                DocumentReference classReference;
                Session session = this.getSession(context);
                if (!alreadyLoaded) {
                    try {
                        session.load((Object)object, (Serializable)Long.valueOf(object1.getId()));
                    }
                    catch (ObjectNotFoundException e) {
                        object = null;
                        if (bTransaction) {
                            try {
                                this.endTransaction(context, false);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.restoreExecutionXContext();
                        return;
                    }
                }
                if ((classReference = object.getXClassReference()) != null) {
                    BaseClass bclass = null;
                    if (!classReference.equals((Object)object.getDocumentReference())) {
                        bclass = object.getXClass(context);
                    } else if (doc != null) {
                        bclass = doc.getXClass();
                    }
                    ArrayList<String> handledProps = new ArrayList<String>();
                    try {
                        if (bclass != null && bclass.hasCustomMapping() && context.getWiki().hasCustomMappings()) {
                            String className = (String)this.localEntityReferenceSerializer.serialize((EntityReference)bclass.getDocumentReference(), new Object[0]);
                            Map map = (Map)session.load(className, (Serializable)Long.valueOf(object.getId()));
                            bclass.fromValueMap(map, object);
                            for (String prop : bclass.getCustomMappingPropertyList(context)) {
                                if (map.get(prop) == null) continue;
                                handledProps.add(prop);
                            }
                        }
                    }
                    catch (HibernateException e) {
                        this.logger.error("Failed loading custom mapping for doc [{}], class [{}], nb [{}]", new Object[]{object.getDocumentReference(), object.getXClassReference(), object.getNumber(), e});
                    }
                    org.hibernate.query.Query query = session.createQuery("select prop.name, prop.classType from BaseProperty as prop where prop.id.id = :id", Object[].class);
                    query.setParameter("id", (Object)object.getId());
                    for (Object[] result : query.list()) {
                        String name = (String)result[0];
                        if (handledProps.contains(name)) continue;
                        String classType = (String)result[1];
                        BaseProperty property = null;
                        try {
                            property = (BaseProperty)Class.forName(classType).newInstance();
                            property.setObject(object);
                            property.setName(name);
                            this.loadXWikiProperty(property, context, false);
                        }
                        catch (Exception e) {
                            try {
                                BaseStringProperty property2;
                                if (property instanceof StringProperty) {
                                    property2 = new LargeStringProperty();
                                    property2.setObject(object);
                                    property2.setName(name);
                                    this.loadXWikiProperty(property2, context, false);
                                    property.setValue(property2.getValue());
                                    if (bclass != null && bclass.get(name) instanceof TextAreaClass) {
                                        property = property2;
                                    }
                                }
                                if (property instanceof LargeStringProperty) {
                                    property2 = new StringProperty();
                                    property2.setObject(object);
                                    property2.setName(name);
                                    this.loadXWikiProperty(property2, context, false);
                                    property.setValue(property2.getValue());
                                    if (bclass != null && bclass.get(name) instanceof StringClass) {
                                        property = property2;
                                    }
                                }
                                throw e;
                            }
                            catch (Throwable e2) {
                                Object[] args = new Object[]{object.getName(), object.getClass(), Integer.valueOf("" + object.getNumber()), name};
                                throw new XWikiException(3, 3212, "Exception while loading object [{0}] of class [{1}], number [{2}] and property [{3}]", e, args);
                            }
                        }
                        object.addField(name, property);
                        property.setDirty(false);
                    }
                }
                if (bTransaction) {
                    this.endTransaction(context, false);
                }
            }
            finally {
                if (bTransaction) {
                    try {
                        this.endTransaction(context, false);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{object.getName(), object.getClass(), object.getNumber()};
            throw new XWikiException(3, 3212, "Exception while loading object [{0}] of class [{1}] and number [{2}]", e, args);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void deleteXWikiCollection(BaseCollection object, XWikiContext inputxcontext, boolean bTransaction, boolean evict) throws XWikiException {
        if (object == null) {
            return;
        }
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            if (bTransaction) {
                this.checkHibernate(context);
                bTransaction = this.beginTransaction(context);
            }
            try {
                Session session = this.getSession(context);
                BaseClass bclass = object.getXClass(context);
                List<Object> handledProps = new ArrayList();
                if (bclass != null && bclass.hasCustomMapping() && context.getWiki().hasCustomMappings()) {
                    handledProps = bclass.getCustomMappingPropertyList(context);
                    Object map = session.get(bclass.getName(), (Serializable)Long.valueOf(object.getId()));
                    if (map != null) {
                        if (evict) {
                            session.evict(map);
                        }
                        session.delete(map);
                    }
                }
                if (object.getXClassReference() != null) {
                    for (BaseElement property : object.getFieldList()) {
                        if (handledProps.contains(property.getName())) continue;
                        if (evict) {
                            session.evict((Object)property);
                        }
                        session.delete((Object)property);
                    }
                }
                if (!"".equals(bclass.getCustomClass())) {
                    BaseObject cobject = new BaseObject();
                    cobject.setDocumentReference(object.getDocumentReference());
                    cobject.setClassName(object.getClassName());
                    cobject.setNumber(object.getNumber());
                    if (object instanceof BaseObject) {
                        cobject.setGuid(((BaseObject)object).getGuid());
                    }
                    cobject.setId(object.getId());
                    if (evict) {
                        session.evict((Object)cobject);
                    }
                    session.delete((Object)cobject);
                } else {
                    if (evict) {
                        session.evict((Object)object);
                    }
                    session.delete((Object)object);
                }
                if (bTransaction) {
                    this.endTransaction(context, true);
                }
            }
            finally {
                if (bTransaction) {
                    try {
                        this.endTransaction(context, false);
                    }
                    catch (Exception session) {}
                }
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{object.getName()};
            throw new XWikiException(3, 3213, "Exception while deleting object {0}", e, args);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    private void loadXWikiProperty(PropertyInterface property, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.executeRead(context, session -> {
            try {
                try {
                    BaseStringProperty stringProperty;
                    session.load((Object)property, (Serializable)((Object)property));
                    if (property instanceof BaseStringProperty && (stringProperty = (BaseStringProperty)property).getValue() == null) {
                        stringProperty.setValue("");
                    }
                    ((BaseProperty)property).setDirty(false);
                }
                catch (ObjectNotFoundException e) {
                    this.logger.error("No data for property [{}] of object id [{}]", (Object)property.getName(), (Object)property.getId());
                }
                if (property instanceof ListProperty) {
                    ((ListProperty)property).getList();
                }
            }
            catch (Exception e) {
                BaseCollection obj = property.getObject();
                Object[] args = new Object[]{obj != null ? obj.getName() : "unknown", property.getName()};
                throw new XWikiException(3, 3212, "Exception while loading property {1} of object {0}", e, args);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveXWikiPropertyInternal(PropertyInterface property, XWikiContext context, boolean runInOwnTransaction) throws XWikiException {
        boolean bTransaction = runInOwnTransaction;
        try {
            if (bTransaction) {
                this.checkHibernate(context);
                bTransaction = this.beginTransaction(context);
            }
            try {
                Session session = this.getSession(context);
                org.hibernate.query.Query query = session.createQuery("select prop.classType from BaseProperty as prop where prop.id.id = :id and prop.id.name= :name", String.class);
                query.setParameter("id", (Object)property.getId());
                query.setParameter("name", (Object)property.getName());
                String oldClassType = (String)query.uniqueResult();
                String newClassType = ((BaseProperty)property).getClassType();
                if (oldClassType == null) {
                    session.save((Object)property);
                } else if (oldClassType.equals(newClassType)) {
                    session.update((Object)property);
                } else {
                    org.hibernate.query.Query propQuery = session.createQuery("select prop from " + oldClassType + " as prop where prop.id.id = :id and prop.id.name= :name");
                    propQuery.setParameter("id", (Object)property.getId());
                    propQuery.setParameter("name", (Object)property.getName());
                    session.delete(propQuery.uniqueResult());
                    session.save((Object)property);
                }
                ((BaseProperty)property).setDirty(false);
                if (bTransaction) {
                    this.endTransaction(context, true);
                }
            }
            finally {
                if (bTransaction) {
                    try {
                        this.endTransaction(context, false);
                    }
                    catch (Exception session) {}
                }
            }
        }
        catch (Exception e) {
            BaseCollection obj = property.getObject();
            Object[] args = new Object[]{obj != null ? obj.getName() : "unknown", property.getName()};
            throw new XWikiException(3, 3212, "Exception while saving property {1} of object {0}", e, args);
        }
    }

    private void loadAttachmentList(XWikiDocument doc, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.executeRead(context, session -> {
            try {
                org.hibernate.query.Query query = session.createQuery("from XWikiAttachment as attach where attach.docId=:docid", XWikiAttachment.class);
                query.setParameter("docid", (Object)doc.getId());
                List list = query.list();
                for (XWikiAttachment attachment : list) {
                    doc.setAttachment(attachment);
                }
                return null;
            }
            catch (Exception e) {
                this.logger.error("Failed to load attachments of document [{}]", (Object)doc.getDocumentReference(), (Object)e);
                Object[] args = new Object[]{doc.getDocumentReference()};
                throw new XWikiException(3, 3235, "Exception while searching attachments for documents {0}", e, args);
            }
        });
    }

    private boolean isDeleted(XWikiAttachment attachment, XWikiDocument doc) {
        for (XWikiDocument.XWikiAttachmentToRemove attachmentToRemove : doc.getAttachmentsToRemove()) {
            if (!attachmentToRemove.getAttachment().getFilename().equals(attachment.getFilename())) continue;
            return true;
        }
        return false;
    }

    private void saveAttachmentList(XWikiDocument doc, XWikiContext context) throws XWikiException {
        try {
            List<XWikiAttachment> list = doc.getAttachmentList();
            for (XWikiAttachment attachment : list) {
                this.saveAttachment(attachment, this.isDeleted(attachment, doc), context);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{doc.getDocumentReference()};
            throw new XWikiException(3, 3234, "Exception while saving attachments attachment list of document {0}", e, args);
        }
    }

    private void saveAttachment(XWikiAttachment attachment, boolean deleted, XWikiContext context) throws XWikiException {
        try {
            boolean saveContent;
            boolean exist;
            String comment = attachment.getComment();
            if (comment != null && comment.length() > 1023) {
                attachment.setComment(StringUtils.abbreviate((String)comment, (int)1023));
            }
            Session session = this.getSession(context);
            org.hibernate.query.Query query = session.createQuery("select attach.contentStore, attach.archiveStore from XWikiAttachment as attach where attach.id = :id", Object[].class);
            query.setParameter("id", (Object)attachment.getId());
            Object[] existingAttachment = (Object[])query.uniqueResult();
            boolean bl = exist = existingAttachment != null;
            if (exist) {
                attachment.setContentStore((String)existingAttachment[0]);
                attachment.setArchiveStore((String)existingAttachment[1]);
                if (!deleted && attachment.isContentDirty() && attachment.getDoc().isMetaDataDirty()) {
                    attachment.updateContentArchive(context);
                }
                session.update((Object)attachment);
                saveContent = attachment.isContentDirty();
            } else {
                if (attachment.getContentStore() == null) {
                    attachment.setContentStore(this.getDefaultAttachmentContentStore(context));
                }
                if (attachment.getArchiveStore() == null) {
                    attachment.setArchiveStore(this.getDefaultAttachmentArchiveStore(context));
                }
                session.save((Object)attachment);
                saveContent = true;
            }
            if (saveContent) {
                XWikiAttachmentStoreInterface store = this.getXWikiAttachmentStoreInterface(attachment);
                store.saveAttachmentContent(attachment, false, context, false);
            }
            attachment.setMetaDataDirty(false);
            if (attachment.isContentDirty()) {
                attachment.getAttachment_content().setContentDirty(false);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{attachment.getReference()};
            throw new XWikiException(3, 3232, "Exception while saving attachment [{0}]", e, args);
        }
    }

    @Override
    public XWikiLock loadLock(long docId, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        return this.executeRead(inputxcontext, session -> {
            try {
                XWikiLock lock = null;
                org.hibernate.query.Query query = session.createQuery("select lock.docId from XWikiLock as lock where lock.docId = :docId", Long.class);
                query.setParameter("docId", (Object)docId);
                if (query.uniqueResult() != null) {
                    lock = new XWikiLock();
                    session.load((Object)lock, (Serializable)Long.valueOf(docId));
                }
                return lock;
            }
            catch (Exception e) {
                throw new XWikiException(3, 13007, "Exception while loading lock", e);
            }
        });
    }

    @Override
    public void saveLock(XWikiLock lock, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        this.executeWrite(inputxcontext, session -> {
            try {
                org.hibernate.query.Query query = session.createQuery("select lock.docId from XWikiLock as lock where lock.docId = :docId", Long.class);
                query.setParameter("docId", (Object)lock.getDocId());
                if (query.uniqueResult() == null) {
                    session.save((Object)lock);
                } else {
                    session.update((Object)lock);
                }
            }
            catch (Exception e) {
                throw new XWikiException(3, 13006, String.format("Exception while locking document for lock [%s]", lock.toString()), e);
            }
            return null;
        });
    }

    @Override
    public void deleteLock(XWikiLock lock, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        this.executeWrite(inputxcontext, session -> {
            try {
                session.delete((Object)lock);
            }
            catch (Exception e) {
                throw new XWikiException(3, 13008, "Exception while deleting lock", e);
            }
            return null;
        });
    }

    private void registerLogoutListener() {
        this.observationManager.addListener(new EventListener(){
            private final Event ev = new ActionExecutingEvent();

            public String getName() {
                return "deleteLocksOnLogoutListener";
            }

            public List<Event> getEvents() {
                return Collections.singletonList(this.ev);
            }

            public void onEvent(Event event, Object source, Object data) {
                XWikiContext ctx;
                if ("logout".equals(((ActionExecutingEvent)event).getActionName()) && (ctx = (XWikiContext)data).getUserReference() != null) {
                    XWikiHibernateStore.this.releaseAllLocksForCurrentUser(ctx);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllLocksForCurrentUser(XWikiContext ctx) {
        try {
            this.executeWrite(ctx, session -> {
                org.hibernate.query.Query query = session.createQuery("delete from XWikiLock as lock where lock.userName=:userName");
                query.setParameter("userName", (Object)ctx.getUser());
                query.executeUpdate();
                return null;
            });
        }
        catch (Exception e) {
            Object msg = "Error while deleting active locks held by user.";
            try {
                this.endTransaction(ctx, false);
            }
            catch (Exception utoh) {
                msg = (String)msg + " Failed to commit OR rollback [" + utoh.getMessage() + "]";
            }
            throw new UnexpectedException((String)msg, (Throwable)e);
        }
        if (!ctx.isMainWiki() && ctx.isMainWiki(ctx.getUserReference().getWikiReference().getName())) {
            String cdb = ctx.getWikiId();
            try {
                ctx.setWikiId(ctx.getMainXWiki());
                this.releaseAllLocksForCurrentUser(ctx);
            }
            finally {
                ctx.setWikiId(cdb);
            }
        }
    }

    @Override
    @Deprecated(since="14.8RC1")
    public List<XWikiLink> loadLinks(long docId, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        return this.executeRead(inputxcontext, session -> {
            try {
                org.hibernate.query.Query query = session.createQuery(" from XWikiLink as link where link.id.docId = :docId", XWikiLink.class);
                query.setParameter("docId", (Object)docId);
                return query.list();
            }
            catch (Exception e) {
                throw new XWikiException(3, 13011, "Exception while loading links", e);
            }
        });
    }

    @Override
    @Deprecated(since="14.8RC1")
    public List<DocumentReference> loadBacklinks(DocumentReference documentReference, boolean bTransaction, XWikiContext inputxcontext) throws XWikiException {
        return this.innerLoadBacklinks(inputxcontext, session -> {
            org.hibernate.query.Query query = session.createQuery("select distinct backlink.fullName from XWikiLink as backlink where backlink.id.link = :backlink", String.class);
            query.setParameter("backlink", this.compactWikiEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]));
            return query;
        });
    }

    @Override
    @Deprecated(since="14.8RC1")
    public List<DocumentReference> loadBacklinks(AttachmentReference attachmentReference, boolean bTransaction, XWikiContext inputxcontext) throws XWikiException {
        return this.innerLoadBacklinks(inputxcontext, session -> {
            org.hibernate.query.Query query = session.createQuery("select distinct backlink.fullName from XWikiLink as backlink where backlink.id.link = :backlink and backlink.id.type = :type and backlink.attachmentName = :attachmentName", String.class);
            query.setParameter("backlink", this.compactWikiEntityReferenceSerializer.serialize((EntityReference)attachmentReference.getDocumentReference(), new Object[0]));
            query.setParameter("type", (Object)attachmentReference.getType().getLowerCase());
            query.setParameter("attachmentName", (Object)attachmentReference.getName());
            return query;
        });
    }

    private List<DocumentReference> innerLoadBacklinks(XWikiContext inputxcontext, Function<Session, org.hibernate.query.Query<String>> queryBuilder) throws XWikiException {
        return this.executeRead(inputxcontext, session -> {
            try {
                HashSet<DocumentReference> backlinkReferences = new HashSet<DocumentReference>();
                org.hibernate.query.Query apply = (org.hibernate.query.Query)queryBuilder.apply(session);
                List backlinkNames = apply.list();
                for (String backlinkName : backlinkNames) {
                    DocumentReference backlinkreference = this.currentMixedDocumentReferenceResolver.resolve((Object)backlinkName, new Object[0]);
                    backlinkReferences.add(backlinkreference);
                }
                return new ArrayList(backlinkReferences);
            }
            catch (Exception e) {
                throw new XWikiException(3, 13014, "Exception while loading backlinks", e);
            }
        });
    }

    @Override
    @Deprecated
    public List<String> loadBacklinks(String fullName, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        ArrayList<String> backlinkNames = new ArrayList<String>();
        List<DocumentReference> backlinkReferences = this.loadBacklinks(this.currentMixedDocumentReferenceResolver.resolve((Object)fullName, new Object[0]), bTransaction, inputxcontext);
        for (DocumentReference backlinkReference : backlinkReferences) {
            backlinkNames.add((String)this.localEntityReferenceSerializer.serialize((EntityReference)backlinkReference, new Object[0]));
        }
        return backlinkNames;
    }

    private Set<XWikiLink> extractLinks(XWikiDocument doc, XWikiContext context) {
        LinkedHashSet<XWikiLink> links = new LinkedHashSet<XWikiLink>();
        String fullName = (String)this.localEntityReferenceSerializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0]);
        for (EntityReference entityReference : doc.getUniqueLinkedEntities(context)) {
            XWikiLink wikiLink = new XWikiLink();
            wikiLink.setDocId(doc.getId());
            wikiLink.setFullName(fullName);
            EntityReference documentReferenceToSerialize = this.convertToDocumentReference(entityReference);
            wikiLink.setLink((String)this.compactWikiEntityReferenceSerializer.serialize(documentReferenceToSerialize, new Object[0]));
            boolean isAttachmentReference = false;
            if (Objects.equals(entityReference.getType(), EntityType.ATTACHMENT) || Objects.equals(entityReference.getType(), EntityType.PAGE_ATTACHMENT)) {
                wikiLink.setAttachmentName(entityReference.getName());
                isAttachmentReference = true;
            }
            wikiLink.setType(isAttachmentReference ? EntityType.ATTACHMENT.getLowerCase() : EntityType.DOCUMENT.getLowerCase());
            links.add(wikiLink);
        }
        List<String> includedPages = doc.getIncludedPages(context);
        for (String includedPage : includedPages) {
            XWikiLink wikiLink = new XWikiLink();
            wikiLink.setDocId(doc.getId());
            wikiLink.setFullName(fullName);
            wikiLink.setLink(includedPage);
            wikiLink.setType(EntityType.DOCUMENT.getLowerCase());
            links.add(wikiLink);
        }
        return links;
    }

    @Override
    @Deprecated(since="14.8RC1")
    public void saveLinks(XWikiDocument doc, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        Set<XWikiLink> links = this.extractLinks(doc, context);
        this.executeWrite(context, session -> {
            if (this.countLinks(doc.getId(), context, false) > 0L) {
                this.deleteLinks(doc.getId(), context, false);
            }
            context.remove("links");
            if (!links.isEmpty()) {
                int linkMaxSize = this.getLimitSize(context, XWikiLink.class, "link");
                for (XWikiLink wikiLink : links) {
                    if (wikiLink.getLink().length() <= linkMaxSize) {
                        session.save((Object)wikiLink);
                        continue;
                    }
                    this.logger.warn("Could not store backlink [{}] because the link reference [{}] is too big", (Object)wikiLink, (Object)wikiLink.getLink());
                }
            }
            return null;
        });
    }

    private EntityReference convertToDocumentReference(EntityReference entityReference) {
        Object documentReference = entityReference;
        if (documentReference instanceof PageAttachmentReference) {
            documentReference = documentReference.extractReference(EntityType.PAGE);
        }
        documentReference = documentReference instanceof PageReference ? this.currentPageReferenceDocumentReferenceResolver.resolve((Object)((PageReference)documentReference), new Object[0]) : documentReference.extractReference(EntityType.DOCUMENT);
        return documentReference;
    }

    @Override
    @Deprecated(since="14.8RC1")
    public void deleteLinks(long docId, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        this.executeWrite(inputxcontext, session -> {
            try {
                org.hibernate.query.Query query = session.createQuery("delete from XWikiLink as link where link.id.docId = :docId");
                query.setParameter("docId", (Object)docId);
                query.executeUpdate();
            }
            catch (Exception e) {
                throw new XWikiException(3, 13013, "Exception while deleting links", e);
            }
            return null;
        });
    }

    public void getContent(XWikiDocument doc, StringBuffer buf) {
        buf.append(doc.getContent());
    }

    @Override
    public List<String> getClassList(XWikiContext inputxcontext) throws XWikiException {
        return this.executeRead(inputxcontext, session -> {
            try {
                org.hibernate.query.Query query = session.createQuery("select doc.fullName from XWikiDocument as doc where (doc.xWikiClassXML is not null and doc.xWikiClassXML like '<%')", String.class);
                ArrayList list = new ArrayList();
                list.addAll(query.list());
                return list;
            }
            catch (Exception e) {
                throw new XWikiException(3, 3223, "Exception while searching class list", e);
            }
        });
    }

    private <T> org.hibernate.query.Query<T> createQuery(Session session, String statement, Collection<?> parameterValues) {
        org.hibernate.query.Query query = session.createQuery(statement);
        this.injectParameterListToQuery(LegacySessionImplementor.containsLegacyOrdinalStatement(statement) ? 0 : 1, query, parameterValues);
        return query;
    }

    private int injectParameterListToQuery(int parameterId, org.hibernate.query.Query<?> query, Collection<?> parameterValues) {
        int index = parameterId;
        if (parameterValues != null) {
            Iterator<?> valueIt = parameterValues.iterator();
            while (valueIt.hasNext()) {
                this.injectParameterToQuery(index, query, valueIt.next());
                ++index;
            }
        }
        return index;
    }

    private void injectParameterToQuery(int parameterId, org.hibernate.query.Query<?> query, Object parameterValue) {
        query.setParameter(parameterId, parameterValue);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String parametrizedSqlClause, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.searchDocumentReferences(parametrizedSqlClause, 0, 0, parameterValues, context);
    }

    @Override
    public List<String> searchDocumentsNames(String parametrizedSqlClause, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.searchDocumentsNames(parametrizedSqlClause, 0, 0, parameterValues, context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String parametrizedSqlClause, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        String sql = this.createSQLQuery("select distinct doc.fullName", parametrizedSqlClause);
        return this.searchDocumentReferencesInternal(sql, nb, start, parameterValues, context);
    }

    @Override
    public List<String> searchDocumentsNames(String parametrizedSqlClause, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        String sql = this.createSQLQuery("select distinct doc.fullName", parametrizedSqlClause);
        return this.searchDocumentsNamesInternal(sql, nb, start, parameterValues, context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String wheresql, XWikiContext context) throws XWikiException {
        return this.searchDocumentReferences(wheresql, 0, 0, "", context);
    }

    @Override
    public List<String> searchDocumentsNames(String wheresql, XWikiContext context) throws XWikiException {
        return this.searchDocumentsNames(wheresql, 0, 0, "", context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String wheresql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.searchDocumentReferences(wheresql, nb, start, "", context);
    }

    @Override
    public List<String> searchDocumentsNames(String wheresql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.searchDocumentsNames(wheresql, nb, start, "", context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String wheresql, int nb, int start, String selectColumns, XWikiContext context) throws XWikiException {
        String sql = this.createSQLQuery("select distinct doc.fullName", wheresql);
        return this.searchDocumentReferencesInternal(sql, nb, start, Collections.EMPTY_LIST, context);
    }

    @Override
    public List<String> searchDocumentsNames(String wheresql, int nb, int start, String selectColumns, XWikiContext context) throws XWikiException {
        String sql = this.createSQLQuery("select distinct doc.fullName", wheresql);
        return this.searchDocumentsNamesInternal(sql, nb, start, Collections.EMPTY_LIST, context);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.search(sql, nb, start, (List)null, context);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.search(sql, nb, start, null, parameterValues, context);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, Object[][] whereParams, XWikiContext context) throws XWikiException {
        return this.search(sql, nb, start, whereParams, null, context);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, Object[][] whereParams, List<?> parameterValues, XWikiContext inputxcontext) throws XWikiException {
        if (sql == null) {
            return null;
        }
        return this.executeRead(inputxcontext, session -> {
            try {
                boolean legacyOrdinal = LegacySessionImplementor.containsLegacyOrdinalStatement(sql);
                Object statement = sql;
                if (whereParams != null) {
                    statement = (String)statement + this.generateWhereStatement(whereParams, legacyOrdinal ? -1 : CollectionUtils.size((Object)parameterValues));
                }
                statement = this.filterSQL((String)statement);
                org.hibernate.query.Query query = session.createQuery((String)statement);
                this.injectParameterListToQuery(legacyOrdinal ? 0 : 1, query, parameterValues);
                if (whereParams != null) {
                    int parameterIndex = CollectionUtils.size((Object)parameterValues);
                    if (!legacyOrdinal) {
                        ++parameterIndex;
                    }
                    for (Object[] whereParam : whereParams) {
                        query.setParameter(parameterIndex++, whereParam[1]);
                    }
                }
                if (start > 0) {
                    query.setFirstResult(start);
                }
                if (nb > 0) {
                    query.setMaxResults(nb);
                }
                ArrayList list = new ArrayList();
                list.addAll(query.list());
                return list;
            }
            catch (Exception e) {
                Object[] args = new Object[]{sql};
                throw new XWikiException(3, 3223, "Exception while searching documents with sql {0}", e, args);
            }
        });
    }

    private String generateWhereStatement(Object[][] whereParams, int previousIndex) {
        StringBuilder str = new StringBuilder();
        int index = previousIndex;
        str.append(" where ");
        for (int i = 0; i < whereParams.length; ++i) {
            if (i > 0) {
                if (whereParams[i - 1].length >= 4 && whereParams[i - 1][3] != "" && whereParams[i - 1][3] != null) {
                    str.append(" ");
                    str.append(whereParams[i - 1][3]);
                    str.append(" ");
                } else {
                    str.append(" and ");
                }
            }
            str.append(whereParams[i][0]);
            if (whereParams[i].length >= 3 && whereParams[i][2] != "" && whereParams[i][2] != null) {
                str.append(" ");
                str.append(whereParams[i][2]);
                str.append(" ");
            } else {
                str.append(" = ");
            }
            str.append(" ?");
            if (index <= -1) continue;
            str.append(++index);
        }
        return str.toString();
    }

    public List search(org.hibernate.query.Query query, int nb, int start, XWikiContext inputxcontext) throws XWikiException {
        if (query == null) {
            return null;
        }
        return this.executeRead(inputxcontext, session -> {
            try {
                if (start > 0) {
                    query.setFirstResult(start);
                }
                if (nb > 0) {
                    query.setMaxResults(nb);
                }
                Iterator it = query.list().iterator();
                ArrayList list = new ArrayList();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                return list;
            }
            catch (Exception e) {
                Object[] args = new Object[]{query.toString()};
                throw new XWikiException(3, 3223, "Exception while searching documents with sql {0}", e, args);
            }
        });
    }

    @Override
    public int countDocuments(String wheresql, XWikiContext context) throws XWikiException {
        String sql = this.createSQLQuery("select count(distinct doc.fullName)", wheresql);
        List l = this.search(sql, 0, 0, context);
        return ((Number)l.get(0)).intValue();
    }

    @Override
    public int countDocuments(String parametrizedSqlClause, List<?> parameterValues, XWikiContext context) throws XWikiException {
        String sql = this.createSQLQuery("select count(distinct doc.fullName)", parametrizedSqlClause);
        List l = this.search(sql, 0, 0, parameterValues, context);
        return ((Number)l.get(0)).intValue();
    }

    @Deprecated
    private List<String> searchDocumentsNamesInternal(String sql, int nb, int start, List parameterValues, XWikiContext context) throws XWikiException {
        ArrayList<String> documentNames = new ArrayList<String>();
        for (DocumentReference reference : this.searchDocumentReferencesInternal(sql, nb, start, parameterValues, context)) {
            documentNames.add((String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)reference, new Object[0]));
        }
        return documentNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DocumentReference> searchDocumentReferencesInternal(String sql, int nb, int start, List<?> parameterValues, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
            WikiReference wikiReference = new WikiReference(context.getWikiId());
            for (Object result : this.searchGenericInternal(sql, nb, start, parameterValues, context)) {
                String referenceString = result instanceof String ? (String)result : (String)((Object[])result)[0];
                DocumentReference reference = this.defaultDocumentReferenceResolver.resolve((Object)referenceString, new Object[]{wikiReference});
                documentReferences.add(reference);
            }
            ArrayList<DocumentReference> arrayList = documentReferences;
            return arrayList;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    private <T> List<T> searchGenericInternal(String sql, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.executeRead(context, session -> {
            try {
                org.hibernate.query.Query query = this.createQuery(session, this.filterSQL(sql), parameterValues);
                if (start > 0) {
                    query.setFirstResult(start);
                }
                if (nb > 0) {
                    query.setMaxResults(nb);
                }
                Iterator it = query.list().iterator();
                ArrayList list = new ArrayList();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                return list;
            }
            catch (Exception e) {
                throw new XWikiException(3, 3223, "Exception while searching documents with SQL [{0}]", e, new Object[]{sql});
            }
        });
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, boolean customMapping, boolean checkRight, int nb, int start, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, distinctbylanguage, customMapping, checkRight, nb, start, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, boolean customMapping, boolean checkRight, int nb, int start, List<?> parameterValues, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        ArrayList documentDatas = new ArrayList();
        boolean bTransaction = true;
        MonitorPlugin monitor = Util.getMonitorPlugin(context);
        try {
            String sql = distinctbylanguage ? this.createSQLQuery("select distinct doc.fullName, doc.language", wheresql) : this.createSQLQuery("select distinct doc.fullName", wheresql);
            if (monitor != null) {
                monitor.startTimer("hibernate", sql);
            }
            this.checkHibernate(context);
            if (bTransaction) {
                SessionFactory sfactory = customMapping ? this.injectCustomMappingsInSessionFactory(context) : this.getSessionFactory();
                bTransaction = this.beginTransaction(sfactory, context);
            }
            try {
                Session session = this.getSession(context);
                org.hibernate.query.Query query = this.createQuery(session, this.filterSQL(sql), parameterValues);
                if (start > 0) {
                    query.setFirstResult(start);
                }
                if (nb > 0) {
                    query.setMaxResults(nb);
                }
                documentDatas.addAll(query.list());
                if (bTransaction) {
                    this.endTransaction(context, false);
                }
            }
            finally {
                if (bTransaction) {
                    try {
                        this.endTransaction(context, false);
                    }
                    catch (Exception session) {}
                }
            }
        }
        catch (Exception e) {
            throw new XWikiException(3, 3223, "Exception while searching documents with SQL [{0}]", e, new Object[]{wheresql});
        }
        finally {
            this.restoreExecutionXContext();
            if (monitor != null) {
                monitor.endTimer("hibernate");
            }
        }
        ArrayList<XWikiDocument> documents = new ArrayList<XWikiDocument>();
        WikiReference currentWikiReference = new WikiReference(context.getWikiId());
        for (Object result : documentDatas) {
            String fullName;
            String locale = null;
            if (result instanceof String) {
                fullName = (String)result;
            } else {
                fullName = (String)((Object[])result)[0];
                if (distinctbylanguage) {
                    locale = (String)((Object[])result)[1];
                }
            }
            XWikiDocument doc = new XWikiDocument(this.defaultDocumentReferenceResolver.resolve((Object)fullName, new Object[]{currentWikiReference}));
            if (checkRight && !context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), doc.getFullName(), context)) continue;
            DocumentReference documentReference = doc.getDocumentReference();
            if (distinctbylanguage) {
                XWikiDocument document = context.getWiki().getDocument(documentReference, context);
                if (StringUtils.isEmpty((CharSequence)locale)) {
                    documents.add(document);
                    continue;
                }
                documents.add(document.getTranslatedDocument(locale, context));
                continue;
            }
            documents.add(context.getWiki().getDocument(documentReference, context));
        }
        return documents;
    }

    protected String createSQLQuery(String queryPrefix, String whereSQL) {
        return HqlQueryUtils.createLegacySQLQuery(queryPrefix, whereSQL);
    }

    protected String getColumnsForSelectStatement(String whereSQL) {
        return HqlQueryUtils.getColumnsForSelectStatement(whereSQL);
    }

    @Override
    @Deprecated
    public boolean isCustomMappingValid(BaseClass bclass, String custommapping1, XWikiContext context) {
        return this.isCustomMappingValid(bclass, custommapping1);
    }

    @Override
    public boolean isCustomMappingValid(BaseClass bclass, String custommapping1) {
        try {
            Metadata metadata = this.store.getMetadata(bclass.getName(), custommapping1, null);
            return this.isValidCustomMapping(bclass, metadata);
        }
        catch (Exception e) {
            return false;
        }
    }

    private SessionFactory injectCustomMappingsInSessionFactory(XWikiDocument doc, XWikiContext context) throws XWikiException {
        if (!context.getWiki().hasDynamicCustomMappings()) {
            return this.getSessionFactory();
        }
        boolean result = this.injectCustomMappings(doc, context);
        if (!result) {
            return this.getSessionFactory();
        }
        return this.getConfiguration().buildSessionFactory();
    }

    @Override
    public void injectCustomMappings(XWikiContext context) throws XWikiException {
        this.injectCustomMappingsInSessionFactory(context);
    }

    @Override
    public void injectUpdatedCustomMappings(XWikiContext context) throws XWikiException {
        Configuration config = this.getConfiguration();
        this.injectInSessionFactory(config);
    }

    public SessionFactory injectCustomMappingsInSessionFactory(BaseClass bclass, XWikiContext context) throws XWikiException {
        boolean result = this.injectCustomMapping(bclass, context);
        if (!result) {
            return this.getSessionFactory();
        }
        Configuration config = this.getConfiguration();
        return this.injectInSessionFactory(config);
    }

    private SessionFactory injectInSessionFactory(Configuration config) {
        return config.buildSessionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory injectCustomMappingsInSessionFactory(XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            if (!context.getWiki().hasDynamicCustomMappings()) {
                SessionFactory sessionFactory = this.getSessionFactory();
                return sessionFactory;
            }
            List<XWikiDocument> list = this.searchDocuments(" where (doc.xWikiClassXML is not null and doc.xWikiClassXML like '<%')", true, false, false, 0, 0, context);
            boolean result = false;
            for (XWikiDocument doc : list) {
                if (doc.getXClass().getFieldList().isEmpty()) continue;
                result |= this.injectCustomMapping(doc.getXClass(), context);
            }
            if (!result) {
                SessionFactory sessionFactory = this.getSessionFactory();
                return sessionFactory;
            }
            Configuration config = this.getConfiguration();
            SessionFactory sessionFactory = this.injectInSessionFactory(config);
            return sessionFactory;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean injectCustomMappings(XWikiDocument doc, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            if (!context.getWiki().hasDynamicCustomMappings()) {
                boolean bl = false;
                return bl;
            }
            boolean result = false;
            block4: for (List<BaseObject> objectsOfType : doc.getXObjects().values()) {
                for (BaseObject object : objectsOfType) {
                    if (object == null) continue;
                    result |= this.injectCustomMapping(object.getXClass(context), context);
                    continue block4;
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    public boolean injectCustomMapping(String className, String customMapping, XWikiContext inputxcontext) throws XWikiException {
        if (!this.hibernateConfiguration.hasDynamicCustomMappings()) {
            return false;
        }
        if (this.store.getConfigurationMetadata() != null && this.store.getConfigurationMetadata().getEntityBinding(className) != null) {
            return false;
        }
        this.store.getConfiguration().addInputStream((InputStream)new ByteArrayInputStream(this.makeMapping(className, customMapping).getBytes(StandardCharsets.UTF_8)));
        this.store.build();
        return true;
    }

    @Override
    public boolean injectCustomMapping(BaseClass doc1class, XWikiContext inputxcontext) throws XWikiException {
        return this.injectCustomMapping(doc1class);
    }

    @Override
    public boolean injectCustomMapping(BaseClass doc1class) throws XWikiException {
        if (!doc1class.hasExternalCustomMapping()) {
            return false;
        }
        if (!this.isCustomMappingValid(doc1class, doc1class.getCustomMapping())) {
            throw new XWikiException(3, 13009, "Invalid Custom Mapping");
        }
        return this.injectCustomMapping(doc1class.getName(), doc1class.getCustomMapping(), null);
    }

    private boolean isValidCustomMapping(BaseClass bclass, Metadata metadata) {
        PersistentClass mapping = metadata.getEntityBinding(bclass.getName());
        if (mapping == null) {
            return true;
        }
        Iterator it = mapping.getPropertyIterator();
        while (it.hasNext()) {
            Property hibprop = (Property)it.next();
            String propname = hibprop.getName();
            PropertyClass propclass = (PropertyClass)bclass.getField(propname);
            if (propclass == null) {
                this.logger.warn("Mapping contains invalid field name [{}]", (Object)propname);
                return false;
            }
            boolean result = this.isValidColumnType(hibprop.getValue().getType().getName(), propclass.getClassName());
            if (result) continue;
            this.logger.warn("Mapping contains invalid type in field [{}]", (Object)propname);
            return false;
        }
        return true;
    }

    @Override
    public List<String> getCustomMappingPropertyList(BaseClass bclass) {
        ArrayList<String> list = new ArrayList<String>();
        Metadata metadata = bclass.hasExternalCustomMapping() ? this.store.getMetadata(bclass.getName(), bclass.getCustomMapping(), null) : this.store.getConfigurationMetadata();
        PersistentClass mapping = metadata.getEntityBinding(bclass.getName());
        if (mapping == null) {
            return null;
        }
        Iterator it = mapping.getPropertyIterator();
        while (it.hasNext()) {
            Property hibprop = (Property)it.next();
            String propname = hibprop.getName();
            list.add(propname);
        }
        return list;
    }

    private boolean isValidColumnType(String name, String className) {
        Object[] validtypes = this.validTypesMap.get(className);
        if (validtypes == null) {
            return true;
        }
        return ArrayUtils.contains((Object[])validtypes, (Object)name);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, null, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, 0, 0, parameterValues, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, distinctbylanguage, 0, 0, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, boolean customMapping, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, distinctbylanguage, customMapping, 0, 0, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, nb, start, null, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, true, nb, start, parameterValues, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, distinctbylanguage, false, nb, start, parameterValues, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, int nb, int start, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, distinctbylanguage, nb, start, null, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, boolean customMapping, int nb, int start, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, distinctbylanguage, customMapping, nb, start, null, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, boolean customMapping, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.searchDocuments(wheresql, distinctbylanguage, customMapping, true, nb, start, parameterValues, context);
    }

    @Override
    public List<String> getTranslationList(XWikiDocument doc, XWikiContext context) throws XWikiException {
        try {
            return this.getTranslationList(doc.getDocumentReference());
        }
        catch (QueryException e) {
            throw new XWikiException(3, 3223, "Failed to retrieve the list of translations for [{0}]", e, new Object[]{doc.getDocumentReference()});
        }
    }

    private List<String> getTranslationList(DocumentReference documentReference) throws QueryException {
        String hql = "select doc.language from XWikiDocument as doc where doc.space = :space and doc.name = :name and (doc.language <> '' or (doc.language is not null and '' is null))";
        Query query = this.getQueryManager().createQuery(hql, "hql");
        query.setWiki(documentReference.getWikiReference().getName());
        query.bindValue("space", this.localEntityReferenceSerializer.serialize(documentReference.getParent(), new Object[0]));
        query.bindValue("name", (Object)documentReference.getName());
        return query.execute();
    }

    @Override
    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    private String filterSQL(String sql) {
        return StringUtils.replace((String)sql, (String)"\\", (String)"\\\\");
    }

    private String getDefaultAttachmentContentStore(XWikiContext xcontext) {
        XWikiAttachmentStoreInterface store = xcontext.getWiki().getDefaultAttachmentContentStore();
        if (store != null && store != this.attachmentContentStore) {
            return store.getHint();
        }
        return null;
    }

    private String getDefaultAttachmentArchiveStore(XWikiContext xcontext) {
        AttachmentVersioningStore store = xcontext.getWiki().getDefaultAttachmentArchiveStore();
        if (store != null && store != this.attachmentArchiveStore) {
            return store.getHint();
        }
        return null;
    }

    private XWikiAttachmentStoreInterface getXWikiAttachmentStoreInterface(XWikiAttachment attachment) throws ComponentLookupException {
        String storeHint = attachment.getContentStore();
        if (storeHint != null && !storeHint.equals("hibernate")) {
            return (XWikiAttachmentStoreInterface)this.componentManager.getInstance(XWikiAttachmentStoreInterface.class, storeHint);
        }
        return this.attachmentContentStore;
    }

    private AttachmentVersioningStore getAttachmentVersioningStore(XWikiAttachment attachment) throws ComponentLookupException {
        String storeHint = attachment.getArchiveStore();
        if (storeHint != null && !storeHint.equals("hibernate")) {
            return (AttachmentVersioningStore)this.componentManager.getInstance(AttachmentVersioningStore.class, storeHint);
        }
        return this.attachmentArchiveStore;
    }

    @Override
    public int getLimitSize(XWikiContext context, Class<?> entityType, String propertyName) {
        return this.store.getLimitSize(entityType, propertyName);
    }

    private long countLinks(long docId, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        return this.executeRead(inputxcontext, session -> {
            try {
                org.hibernate.query.Query query = session.createQuery("select count(*) from XWikiLink as link where link.id.docId = :docId").setParameter("docId", (Object)docId);
                return (Long)query.getSingleResult();
            }
            catch (Exception e) {
                throw new XWikiException(3, 13014, "Exception while count backlinks", e);
            }
        });
    }

    public /* synthetic */ void ajc$privMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$saveXWikiPropertyInternal(PropertyInterface propertyInterface, XWikiContext xWikiContext, boolean bl) throws XWikiException {
        this.saveXWikiPropertyInternal(propertyInterface, xWikiContext, bl);
    }

    public /* synthetic */ void ajc$privMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$loadXWikiCollectionInternal(BaseCollection baseCollection, XWikiDocument xWikiDocument, XWikiContext xWikiContext, boolean bl, boolean bl2) throws XWikiException {
        this.loadXWikiCollectionInternal(baseCollection, xWikiDocument, xWikiContext, bl, bl2);
    }

    @Deprecated
    public void deleteXWikiCollection(BaseCollection baseCollection, XWikiContext xWikiContext, boolean bl) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$deleteXWikiCollection(this, baseCollection, xWikiContext, bl);
    }

    @Deprecated
    public void deleteXWikiObject(BaseObject baseObject, XWikiContext xWikiContext, boolean bl) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$deleteXWikiObject(this, baseObject, xWikiContext, bl);
    }

    @Deprecated
    public void deleteXWikiObject(BaseObject baseObject, XWikiContext xWikiContext, boolean bl, boolean bl2) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$deleteXWikiObject(this, baseObject, xWikiContext, bl, bl2);
    }

    @Deprecated
    public void loadXWikiCollection(BaseCollection baseCollection, XWikiContext xWikiContext, boolean bl, boolean bl2) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$loadXWikiCollection(this, baseCollection, xWikiContext, bl, bl2);
    }

    @Deprecated
    public void loadXWikiCollection(BaseCollection baseCollection, XWikiDocument xWikiDocument, XWikiContext xWikiContext, boolean bl, boolean bl2) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$loadXWikiCollection(this, baseCollection, xWikiDocument, xWikiContext, bl, bl2);
    }

    @Deprecated
    public void loadXWikiObject(BaseObject baseObject, XWikiContext xWikiContext, boolean bl) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$loadXWikiObject(this, baseObject, xWikiContext, bl);
    }

    @Deprecated
    public void saveXWikiObject(BaseObject baseObject, XWikiContext xWikiContext, boolean bl) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$saveXWikiObject(this, baseObject, xWikiContext, bl);
    }

    @Deprecated
    public void saveXWikiProperty(PropertyInterface propertyInterface, XWikiContext xWikiContext, boolean bl) throws XWikiException {
        XWikiHibernateStoreCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_store_XWikiHibernateStoreCompatibilityAspect$com_xpn_xwiki_store_XWikiHibernateStore$saveXWikiProperty(this, propertyInterface, xWikiContext, bl);
    }
}

