/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDeletedDocumentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.store.StoreConfiguration;
import com.xpn.xwiki.internal.store.hibernate.XWikiHibernateDeletedDocumentContent;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiRecycleBinContentStoreInterface;
import com.xpn.xwiki.store.XWikiRecycleBinStoreInterface;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Named(value="hibernate")
@Singleton
public class XWikiHibernateRecycleBinStore
extends XWikiHibernateBaseStore
implements XWikiRecycleBinStoreInterface {
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceSerializer;
    private static final String FULL_NAME_FIELD = "fullName";
    private static final String LANGUAGE_PROPERTY_NAME = "language";
    @Inject
    private StoreConfiguration storeConfiguration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    @Deprecated
    public XWikiHibernateRecycleBinStore(XWikiContext context) {
        super(context.getWiki(), context);
    }

    public XWikiHibernateRecycleBinStore() {
    }

    private XWikiRecycleBinContentStoreInterface getDefaultXWikiRecycleBinContentStore() throws XWikiException {
        try {
            return this.storeConfiguration.getXWikiRecycleBinContentStore();
        }
        catch (ComponentLookupException e) {
            throw new XWikiException(3, 0, "Failed to lookup recycle bin content store", e);
        }
    }

    private XWikiRecycleBinContentStoreInterface getXWikiRecycleBinContentStore(String storeType) {
        if (storeType != null && !storeType.equals("hibernate")) {
            try {
                return (XWikiRecycleBinContentStoreInterface)this.componentManager.getInstance(XWikiRecycleBinContentStoreInterface.class, storeType);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Can't find recycle bin content store for type [{}]", (Object)storeType, (Object)e);
            }
        }
        return null;
    }

    private XWikiDeletedDocument resolveDeletedDocumentContent(XWikiDeletedDocument deletedDocument, boolean bTransaction) throws XWikiException {
        XWikiRecycleBinContentStoreInterface contentStore = this.getXWikiRecycleBinContentStore(deletedDocument.getXmlStore());
        if (contentStore != null) {
            XWikiDeletedDocumentContent content = contentStore.get(deletedDocument.getDocumentReference(), deletedDocument.getId(), bTransaction);
            try {
                FieldUtils.writeDeclaredField((Object)deletedDocument, (String)"content", (Object)content, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new XWikiException(3, 0, "Failed to set deleted document content", e);
            }
        }
        return deletedDocument;
    }

    private XWikiDeletedDocument createXWikiDeletedDocument(XWikiDocument doc, String deleter, Date date, XWikiRecycleBinContentStoreInterface contentStore, String batchId) throws XWikiException {
        String storeType = null;
        XWikiHibernateDeletedDocumentContent deletedDocumentContent = null;
        if (contentStore != null) {
            storeType = contentStore.getHint();
        } else {
            deletedDocumentContent = new XWikiHibernateDeletedDocumentContent(doc);
        }
        XWikiDeletedDocument trashdoc = new XWikiDeletedDocument(doc.getFullName(), doc.getLocale(), storeType, deleter, date, deletedDocumentContent, batchId);
        return trashdoc;
    }

    private void deleteDeletedDocumentContent(XWikiDeletedDocument deletedDocument, boolean bTransaction) throws XWikiException {
        XWikiRecycleBinContentStoreInterface contentStore = this.getXWikiRecycleBinContentStore(deletedDocument.getXmlStore());
        if (contentStore != null) {
            contentStore.delete(deletedDocument.getDocumentReference(), deletedDocument.getId(), bTransaction);
        }
    }

    @Override
    public void saveToRecycleBin(XWikiDocument doc, String deleter, Date date, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        this.saveToRecycleBin(doc, deleter, date, null, inputxcontext, bTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToRecycleBin(XWikiDocument doc, String deleter, Date date, String batchId, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            this.executeWrite(context, session -> {
                XWikiRecycleBinContentStoreInterface contentStore = this.getDefaultXWikiRecycleBinContentStore();
                XWikiDeletedDocument trashdoc = this.createXWikiDeletedDocument(doc, deleter, date, contentStore, batchId);
                long index = ((Number)session.save((Object)trashdoc)).longValue();
                if (contentStore != null) {
                    contentStore.save(doc, index, bTransaction);
                }
                return null;
            });
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Override
    public XWikiDocument restoreFromRecycleBin(XWikiDocument doc, long index, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        return this.restoreFromRecycleBin(index, inputxcontext, bTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWikiDocument restoreFromRecycleBin(long index, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            XWikiDeletedDocument deletedDocument = this.getDeletedDocument(index, context, bTransaction);
            XWikiDocument xWikiDocument = deletedDocument.restoreDocument(context);
            return xWikiDocument;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Override
    public XWikiDeletedDocument getDeletedDocument(XWikiDocument doc, long index, XWikiContext context, boolean bTransaction) throws XWikiException {
        return this.getDeletedDocument(index, context, bTransaction);
    }

    @Override
    public XWikiDeletedDocument getDeletedDocument(long index, XWikiContext context, boolean bTransaction) throws XWikiException {
        return this.getDeletedDocument(index, context, true, bTransaction);
    }

    private XWikiDeletedDocument getDeletedDocument(long index, XWikiContext context, boolean resolve, boolean bTransaction) throws XWikiException {
        return this.executeRead(context, session -> {
            XWikiDeletedDocument deletedDocument = (XWikiDeletedDocument)session.get(XWikiDeletedDocument.class, (Serializable)Long.valueOf(index));
            if (deletedDocument != null && resolve) {
                deletedDocument = this.resolveDeletedDocumentContent(deletedDocument, false);
            }
            return deletedDocument;
        });
    }

    @Override
    public XWikiDeletedDocument[] getAllDeletedDocuments(XWikiDocument doc, XWikiContext context, boolean bTransaction) throws XWikiException {
        XWikiDeletedDocument[] deletedDocuments = this.executeRead(context, new DeletedDocumentsHibernateCallback(doc));
        for (int i = 0; i < deletedDocuments.length; ++i) {
            deletedDocuments[i] = this.resolveDeletedDocumentContent(deletedDocuments[i], bTransaction);
        }
        return deletedDocuments;
    }

    @Override
    public Long[] getAllDeletedDocumentsIds(XWikiContext context, int limit) throws XWikiException {
        return this.executeRead(context, session -> {
            Query query = session.createQuery("SELECT id FROM XWikiDeletedDocument ORDER BY date DESC", Long.class);
            if (limit > 0) {
                query.setMaxResults(limit);
            }
            List deletedDocIds = query.list();
            Long[] result = new Long[deletedDocIds.size()];
            return deletedDocIds.toArray(result);
        });
    }

    @Override
    public Long getNumberOfDeletedDocuments(XWikiContext context) throws XWikiException {
        return this.executeRead(context, session -> {
            Query query = session.createQuery("SELECT count(id) FROM XWikiDeletedDocument", Long.class);
            return (Long)query.uniqueResult();
        });
    }

    @Override
    public XWikiDeletedDocument[] getAllDeletedDocuments(String batchId, XWikiContext context, boolean bTransaction) throws XWikiException {
        return this.getAllDeletedDocuments(batchId, true, context, bTransaction);
    }

    @Override
    public XWikiDeletedDocument[] getAllDeletedDocuments(String batchId, boolean withContent, XWikiContext context, boolean bTransaction) throws XWikiException {
        XWikiDeletedDocument[] deletedDocuments = this.executeRead(context, new DeletedDocumentsBatchHibernateCallback(batchId));
        if (withContent) {
            for (int i = 0; i < deletedDocuments.length; ++i) {
                XWikiDeletedDocument deletedDocument = deletedDocuments[i];
                deletedDocuments[i] = this.resolveDeletedDocumentContent(deletedDocument, bTransaction);
            }
        }
        return deletedDocuments;
    }

    @Override
    public void deleteFromRecycleBin(XWikiDocument doc, long index, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.deleteFromRecycleBin(index, context, bTransaction);
    }

    @Override
    public void deleteFromRecycleBin(long index, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.executeWrite(context, session -> {
            XWikiDeletedDocument deletedDocument = this.getDeletedDocument(index, context, false, bTransaction);
            session.delete((Object)deletedDocument);
            this.deleteDeletedDocumentContent(deletedDocument, bTransaction);
            return null;
        });
    }

    @Override
    public void checkAccess(Right right, UserReference userReference, XWikiDeletedDocument deletedDocument) throws AuthorizationException {
        if (!this.hasAccess(right, userReference, deletedDocument)) {
            throw new AuthorizationException(String.format("[%s] cannot access deleted document [%s] for right [%s]: only admin or deleter of the document are authorized", userReference, deletedDocument, right));
        }
    }

    @Override
    public boolean hasAccess(Right right, UserReference userReference, XWikiDeletedDocument deletedDocument) {
        DocumentReference documentReference = deletedDocument.getDocumentReference();
        DocumentReference userDocReference = (DocumentReference)this.userReferenceSerializer.serialize(userReference);
        boolean result = false;
        if (this.authorizationManager.hasAccess(Right.ADMIN, userDocReference, (EntityReference)documentReference) || Objects.equals(deletedDocument.getDeleterReference(), userDocReference) && this.authorizationManager.hasAccess(right, userDocReference, (EntityReference)documentReference)) {
            result = true;
        }
        return result;
    }

    private static class DeletedDocumentsHibernateCallback
    implements XWikiHibernateBaseStore.HibernateCallback<XWikiDeletedDocument[]> {
        private XWikiDocument document;

        DeletedDocumentsHibernateCallback(XWikiDocument document) {
            this.document = document;
        }

        @Override
        public XWikiDeletedDocument[] doInHibernate(Session session) throws HibernateException, XWikiException {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(XWikiDeletedDocument.class);
            Root root = query.from(XWikiDeletedDocument.class);
            query.select((Selection)root);
            Predicate[] predicates = new Predicate[2];
            predicates[0] = builder.equal((Expression)root.get(XWikiHibernateRecycleBinStore.FULL_NAME_FIELD), (Object)this.document.getFullName());
            Locale locale = this.document.getLocale();
            Path languageProperty = root.get(XWikiHibernateRecycleBinStore.LANGUAGE_PROPERTY_NAME);
            predicates[1] = locale.equals(Locale.ROOT) ? builder.or((Expression)builder.equal((Expression)languageProperty, (Object)""), (Expression)builder.isNull((Expression)languageProperty)) : builder.equal((Expression)languageProperty, (Object)locale.toString());
            query.where(predicates);
            query.orderBy(new Order[]{builder.desc((Expression)root.get("date"))});
            List deletedVersions = session.createQuery(query).getResultList();
            return deletedVersions.toArray(new XWikiDeletedDocument[deletedVersions.size()]);
        }
    }

    private static class DeletedDocumentsBatchHibernateCallback
    implements XWikiHibernateBaseStore.HibernateCallback<XWikiDeletedDocument[]> {
        private String batchId;

        DeletedDocumentsBatchHibernateCallback(String batchId) {
            this.batchId = batchId;
        }

        @Override
        public XWikiDeletedDocument[] doInHibernate(Session session) throws HibernateException, XWikiException {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(XWikiDeletedDocument.class);
            Root root = query.from(XWikiDeletedDocument.class);
            query.select((Selection)root);
            query.where((Expression)builder.equal((Expression)root.get("batchId"), (Object)this.batchId));
            query.orderBy(new Order[]{builder.asc((Expression)root.get(XWikiHibernateRecycleBinStore.FULL_NAME_FIELD))});
            List deletedVersions = session.createQuery(query).getResultList();
            return deletedVersions.toArray(new XWikiDeletedDocument[deletedVersions.size()]);
        }
    }
}

