/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.store.AbstractXWikiStore;
import com.xpn.xwiki.internal.store.hibernate.HibernateConfiguration;
import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.monitor.api.MonitorPlugin;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.migration.DataMigrationManager;
import com.xpn.xwiki.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.DatabaseMetaData;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.Execution;
import org.xwiki.logging.LoggerManager;
import org.xwiki.stability.Unstable;
import org.xwiki.store.hibernate.HibernateAdapter;
import org.xwiki.store.hibernate.HibernateStoreException;

public class XWikiHibernateBaseStore
extends AbstractXWikiStore {
    public static final String HINT = "hibernate";
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiHibernateBaseStore.class);
    @Inject
    protected LoggerManager loggerManager;
    @Inject
    protected HibernateStore store;
    @Inject
    protected HibernateConfiguration hibernateConfiguration;
    @Inject
    @Named(value="hibernate")
    private DataMigrationManager dataMigrationManager;
    @Inject
    private Execution execution;

    @Deprecated
    public XWikiHibernateBaseStore(XWiki xwiki, XWikiContext context) {
        String path = xwiki.Param("xwiki.store.hibernate.path", "/WEB-INF/hibernate.cfg.xml");
        LOGGER.debug("Hibernate configuration file: [{}]", (Object)path);
        this.hibernateConfiguration = new HibernateConfiguration();
        this.setPath(path);
    }

    @Deprecated
    public XWikiHibernateBaseStore(String hibpath) {
        this.hibernateConfiguration = new HibernateConfiguration();
        this.setPath(hibpath);
    }

    public XWikiHibernateBaseStore() {
    }

    public String getHint() {
        return HINT;
    }

    @Unstable
    public HibernateAdapter getHibernateAdapater() {
        return this.store.getAdapter();
    }

    public String getPath() {
        return this.hibernateConfiguration.getPath();
    }

    public void setPath(String hibpath) {
        this.hibernateConfiguration.setPath(hibpath);
    }

    public DatabaseMetaData getDatabaseMetaData() {
        return this.store.getDatabaseMetaData();
    }

    public DatabaseProduct getDatabaseProductName() {
        return this.store.getDatabaseProductName();
    }

    @Deprecated
    public DatabaseProduct getDatabaseProductName(XWikiContext context) {
        return this.getDatabaseProductName();
    }

    public Session getSession(XWikiContext inputxcontext) {
        return this.store.getCurrentSession();
    }

    public void setSession(Session session, XWikiContext inputxcontext) {
        this.store.setCurrentSession(session);
    }

    public Transaction getTransaction(XWikiContext inputxcontext) {
        return this.store.getCurrentTransaction();
    }

    public void setTransaction(Transaction transaction, XWikiContext inputxcontext) {
        this.store.setCurrentTransaction(transaction);
    }

    @Deprecated
    public void shutdownHibernate(XWikiContext inputxcontext) throws HibernateException {
        this.store.shutdownHibernate();
    }

    public void updateSchema(XWikiContext inputxcontext) throws HibernateException {
        this.updateSchema(inputxcontext, false);
    }

    public void updateSchema(XWikiContext inputxcontext, boolean force) throws HibernateException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            this.store.updateDatabase(context.getWikiId(), force);
        }
        catch (HibernateStoreException e) {
            throw new HibernateException((Throwable)((Object)e));
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Deprecated(since="17.1.0RC1")
    protected String getSchemaFromWikiName(String wikiName, DatabaseProduct databaseProduct, XWikiContext inputxcontext) {
        return this.store.getAdapter().getDatabaseFromWikiName(wikiName);
    }

    @Deprecated(since="17.1.0RC1")
    protected String getSchemaFromWikiName(String wikiId, XWikiContext inputxcontext) {
        return this.store.getAdapter().getDatabaseFromWikiName(wikiId);
    }

    @Deprecated(since="17.1.0RC1")
    public String getSchemaFromWikiName(XWikiContext context) {
        return this.store.getAdapter().getDatabaseFromWikiName();
    }

    @Deprecated
    public String[] getSchemaUpdateScript(Configuration config, XWikiContext inputxcontext) throws HibernateException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void createHibernateSequenceIfRequired(String[] schemaSQL, String schemaName, Session session) {
        Dialect dialect;
        if (this.isInSchemaMode() && (dialect = this.store.getDialect()).getNativeIdentifierGeneratorStrategy().equals("sequence")) {
            boolean hasSequence = false;
            String sequenceSQL = String.format("create sequence %s.hibernate_sequence", schemaName);
            for (String sql : schemaSQL) {
                if (!sequenceSQL.equals(sql)) continue;
                hasSequence = true;
                break;
            }
            if (!hasSequence) {
                try {
                    this.loggerManager.pushLogListener(null);
                    session.createSQLQuery(sequenceSQL).executeUpdate();
                }
                catch (HibernateException hibernateException) {
                }
                finally {
                    this.loggerManager.popLogListener();
                }
            }
        }
    }

    @Deprecated
    public void updateSchema(String[] createSQL, XWikiContext inputxcontext) throws HibernateException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        boolean bTransaction = true;
        MonitorPlugin monitor = Util.getMonitorPlugin(context);
        String sql = "";
        try {
            bTransaction = this.beginTransaction(context);
            Session session = this.getSession(context);
            this.setDatabase(session, context);
            if (monitor != null) {
                monitor.startTimer("sqlupgrade");
            }
            String[] stringArray = createSQL;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element;
                sql = element = stringArray[i];
                LOGGER.debug("Update Schema sql: [{}]", (Object)sql);
                session.createSQLQuery(sql).executeUpdate();
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            throw new HibernateException("Failed updating schema while executing query [" + sql + "]", (Throwable)e);
        }
        finally {
            try {
                if (bTransaction) {
                    this.endTransaction(context, true);
                }
            }
            catch (Exception exception) {}
            this.restoreExecutionXContext();
            if (monitor != null) {
                monitor.endTimer("sqlupgrade");
            }
        }
    }

    public void updateSchema(BaseClass bclass, XWikiContext inputxcontext) throws XWikiException, HibernateException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            String custommapping = bclass.getCustomMapping();
            if (!bclass.hasExternalCustomMapping()) {
                return;
            }
            Metadata metadata = this.store.getMetadata(bclass.getName(), custommapping, context.getWikiId());
            this.store.getAdapter().updateDatabase(metadata);
        }
        catch (Exception e) {
            throw new XWikiException("Failed to update the schema for class [" + bclass.getName() + "]", e);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    public void checkHibernate(XWikiContext context) throws HibernateException {
        if (this.getSessionFactory() == null) {
            this.checkHibernateSynchronized();
        }
    }

    private synchronized void checkHibernateSynchronized() throws HibernateException {
        if (this.getSessionFactory() == null) {
            this.store.initHibernate();
        }
    }

    @Deprecated
    protected boolean isVirtual(XWikiContext context) {
        return true;
    }

    public void setDatabase(Session session, XWikiContext inputxcontext) throws XWikiException {
        this.store.setWiki(session);
    }

    @Deprecated(since="17.1.0RC1")
    protected String escapeSchema(String schema, XWikiContext context) {
        return this.store.getAdapter().escapeDatabaseName(schema);
    }

    public boolean beginTransaction(XWikiContext context) throws XWikiException {
        return this.store.beginTransaction();
    }

    @Deprecated
    public boolean beginTransaction(boolean withTransaction, XWikiContext context) throws XWikiException {
        return this.store.beginTransaction();
    }

    @Deprecated
    public boolean beginTransaction(SessionFactory sfactory, boolean withTransaction, XWikiContext context) throws XWikiException {
        return this.beginTransaction(sfactory, context);
    }

    public boolean beginTransaction(SessionFactory sfactory, XWikiContext inputxcontext) throws XWikiException {
        return this.store.beginTransaction(sfactory);
    }

    @Deprecated
    public void endTransaction(XWikiContext context, boolean commit, boolean withTransaction) throws HibernateException {
        this.store.endTransaction(commit);
    }

    public void endTransaction(XWikiContext inputxcontext, boolean commit) {
        this.store.endTransaction(commit);
    }

    public void cleanUp(XWikiContext inputxcontext) {
        try {
            Session session = this.store.getCurrentSession();
            if (session != null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Cleanup of session was needed: {}", (Object)session.toString());
                }
                this.store.endTransaction(false);
            }
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
    }

    public SessionFactory getSessionFactory() {
        return this.store.getSessionFactory();
    }

    @Deprecated
    public void setSessionFactory(SessionFactory sessionFactory) {
    }

    public Configuration getConfiguration() {
        return this.store.getConfiguration();
    }

    public Metadata getMetadata() {
        return this.store.getConfigurationMetadata();
    }

    @Deprecated
    public Map<String, String> getConnections() {
        return Collections.emptyMap();
    }

    @Deprecated
    public int getNbConnections() {
        return -1;
    }

    @Deprecated
    public void setNbConnections(int nbConnections) {
    }

    public String dynamicMappingTableName(String className) {
        return this.store.toDynamicMappingTableName(className);
    }

    @Deprecated
    protected Configuration getMapping(String className, String customMapping) {
        Configuration hibconfig = new Configuration();
        hibconfig.addInputStream((InputStream)new ByteArrayInputStream(this.makeMapping(className, customMapping).getBytes(StandardCharsets.UTF_8)));
        return hibconfig;
    }

    protected String makeMapping(String className, String customMapping) {
        return this.store.makeMapping(className, customMapping);
    }

    @Deprecated
    public <T> T execute(XWikiContext context, boolean bTransaction, boolean doCommit, HibernateCallback<T> cb) throws XWikiException {
        return this.execute(context, doCommit, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T> T failSafeExecute(XWikiContext inputxcontext, boolean doCommit, HibernateCallback<T> cb) {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            T t;
            Session originalSession = this.store.getCurrentSession();
            Transaction originalTransaction = this.getTransaction(context);
            this.store.setCurrentSession(null);
            this.store.setCurrentTransaction(null);
            this.loggerManager.pushLogListener(null);
            try {
                t = this.execute(context, doCommit, cb);
            }
            catch (Exception ignored) {
                T t2 = null;
                this.loggerManager.popLogListener();
                this.store.setCurrentSession(originalSession);
                this.store.setCurrentTransaction(originalTransaction);
                this.restoreExecutionXContext();
                return t2;
                {
                    catch (Throwable throwable) {
                        this.loggerManager.popLogListener();
                        this.store.setCurrentSession(originalSession);
                        this.store.setCurrentTransaction(originalTransaction);
                        throw throwable;
                    }
                }
            }
            this.loggerManager.popLogListener();
            this.store.setCurrentSession(originalSession);
            this.store.setCurrentTransaction(originalTransaction);
            return t;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T execute(XWikiContext inputxcontext, boolean doCommit, HibernateCallback<T> cb) throws XWikiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public <T> T executeRead(XWikiContext context, boolean bTransaction, HibernateCallback<T> cb) throws XWikiException {
        return this.execute(context, false, cb);
    }

    public <T> T failSafeExecuteRead(XWikiContext context, HibernateCallback<T> cb) {
        return this.failSafeExecute(context, false, cb);
    }

    public <T> T executeRead(XWikiContext context, HibernateCallback<T> cb) throws XWikiException {
        return this.execute(context, false, cb);
    }

    @Deprecated
    public <T> T executeWrite(XWikiContext context, boolean bTransaction, HibernateCallback<T> cb) throws XWikiException {
        return this.execute(context, true, cb);
    }

    public <T> T failSafeExecuteWrite(XWikiContext context, HibernateCallback<T> cb) {
        return this.failSafeExecute(context, true, cb);
    }

    public <T> T executeWrite(XWikiContext context, HibernateCallback<T> cb) throws XWikiException {
        return this.execute(context, true, cb);
    }

    @Deprecated(since="17.1.0RC1")
    protected boolean isInSchemaMode() {
        return this.store.getAdapter().isConfiguredInSchemaMode();
    }

    protected Execution getExecution() {
        return this.execution;
    }

    public Dialect getDialect() {
        return this.store.getDialect();
    }

    @FunctionalInterface
    public static interface HibernateCallback<T> {
        public T doInHibernate(Session var1) throws HibernateException, XWikiException;
    }
}

