/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import com.xpn.xwiki.store.XWikiAttachmentStoreInterface;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

@Component
@Named(value="hibernate")
@Singleton
public class XWikiHibernateAttachmentStore
extends XWikiHibernateBaseStore
implements XWikiAttachmentStoreInterface {
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="hibernate")
    private AttachmentVersioningStore attachmentVersioningStore;

    @Deprecated
    public XWikiHibernateAttachmentStore(XWiki xwiki, XWikiContext context) {
        super(xwiki, context);
    }

    @Deprecated
    public XWikiHibernateAttachmentStore(XWikiContext context) {
        this(context.getWiki(), context);
    }

    @Deprecated
    public XWikiHibernateAttachmentStore(String hibpath) {
        super(hibpath);
    }

    public XWikiHibernateAttachmentStore() {
    }

    @Override
    public void saveAttachmentContent(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.saveAttachmentContent(attachment, true, context, bTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveAttachmentContent(XWikiAttachment attachment, boolean parentUpdate, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiAttachmentContent content = attachment.getAttachment_content();
        if (content != null) {
            XWikiContext context = this.getExecutionXContext(inputxcontext, true);
            String currentWiki = context.getWikiId();
            try {
                String attachmentWiki;
                String string = attachmentWiki = attachment.getReference() == null ? null : attachment.getReference().getDocumentReference().getWikiReference().getName();
                if (attachmentWiki != null) {
                    context.setWikiId(attachmentWiki);
                }
                if (bTransaction) {
                    this.checkHibernate(context);
                    bTransaction = this.beginTransaction(context);
                }
                try {
                    Session session = this.getSession(context);
                    boolean exist = this.exists(content, session);
                    AttachmentVersioningStore store = this.resolveAttachmentVersioningStore(attachment, context);
                    if (exist) {
                        session.update((Object)content);
                    } else {
                        session.save((Object)content);
                    }
                    if (attachment.getAttachment_archive() == null) {
                        attachment.loadArchive(context);
                    }
                    store.saveArchive(attachment.getAttachment_archive(), context, false);
                    if (parentUpdate) {
                        context.getWiki().getStore().saveXWikiDoc(attachment.getDoc(), context, true);
                    }
                    if (!bTransaction) return;
                    this.endTransaction(context, true);
                    return;
                }
                finally {
                    if (bTransaction) {
                        try {
                            this.endTransaction(context, false);
                        }
                        catch (Exception session) {}
                    }
                }
            }
            catch (Exception e) {
                Object[] args = new Object[]{attachment.getReference()};
                throw new XWikiException(3, 3232, "Exception while saving attachment {0}", e, args);
            }
            finally {
                context.setWikiId(currentWiki);
                this.restoreExecutionXContext();
            }
        }
        this.logger.warn("Failed to save the Attachment content for [{}] at [{}] since no content could be found!", (Object)attachment.getFilename(), (Object)attachment.getDoc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAttachmentsContent(List<XWikiAttachment> attachments, XWikiDocument doc, boolean bParentUpdate, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        if (attachments == null) {
            return;
        }
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            if (bTransaction) {
                this.checkHibernate(context);
                bTransaction = this.beginTransaction(context);
            }
            try {
                for (XWikiAttachment att : attachments) {
                    this.saveAttachmentContent(att, false, context, false);
                }
                if (bParentUpdate) {
                    context.getWiki().getStore().saveXWikiDoc(doc, context, false);
                }
            }
            finally {
                if (bTransaction) {
                    try {
                        this.endTransaction(context, false);
                    }
                    catch (Exception it) {}
                }
            }
        }
        catch (Exception e) {
            throw new XWikiException(3, 3232, "Exception while saving attachments", e);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAttachmentContent(XWikiAttachment attachment, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        String attachmentWiki;
        String currentWiki = inputxcontext.getWikiId();
        String string = attachmentWiki = attachment.getReference() == null ? null : attachment.getReference().getDocumentReference().getWikiReference().getName();
        if (attachmentWiki != null) {
            inputxcontext.setWikiId(attachmentWiki);
        }
        try {
            this.executeRead(inputxcontext, session -> {
                try {
                    XWikiAttachmentContent content = new XWikiAttachmentContent();
                    session.load((Object)content, (Serializable)Long.valueOf(attachment.getId()));
                    content.setContentDirty(false);
                    attachment.setAttachment_content(content);
                    attachment.setContentStore(null);
                    return null;
                }
                catch (Exception e) {
                    Object[] args = new Object[]{attachment.getReference()};
                    throw new XWikiException(3, 3231, "Exception while loading attachment {0}", e, args);
                }
            });
        }
        finally {
            inputxcontext.setWikiId(currentWiki);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean attachmentContentExists(XWikiAttachment attachment, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        String attachmentWiki;
        String currentWiki = inputxcontext.getWikiId();
        String string = attachmentWiki = attachment.getReference() == null ? null : attachment.getReference().getDocumentReference().getWikiReference().getName();
        if (attachmentWiki != null) {
            inputxcontext.setWikiId(attachmentWiki);
        }
        try {
            boolean bl = this.executeRead(inputxcontext, session -> {
                try {
                    XWikiAttachmentContent content = new XWikiAttachmentContent(attachment);
                    return this.exists(content, session);
                }
                catch (Exception e) {
                    Object[] args = new Object[]{attachment.getReference()};
                    throw new XWikiException(3, 3231, "Exception while loading attachment {0}", e, args);
                }
            });
            return bl;
        }
        finally {
            inputxcontext.setWikiId(currentWiki);
        }
    }

    private boolean exists(XWikiAttachmentContent content, Session session) {
        Query query = session.createQuery("select attach.id from XWikiAttachmentContent as attach where attach.id = :id", Long.class);
        query.setParameter("id", (Object)content.getId());
        return query.uniqueResult() != null;
    }

    @Override
    public void deleteXWikiAttachment(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.deleteXWikiAttachment(attachment, true, context, bTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteXWikiAttachment(XWikiAttachment attachment, boolean parentUpdate, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        String currentWiki = context.getWikiId();
        try {
            String attachmentWiki;
            String string = attachmentWiki = attachment.getReference() == null ? null : attachment.getReference().getDocumentReference().getWikiReference().getName();
            if (attachmentWiki != null) {
                context.setWikiId(attachmentWiki);
            }
            if (bTransaction) {
                this.checkHibernate(context);
                bTransaction = this.beginTransaction(context);
            }
            try {
                Session session = this.getSession(context);
                try {
                    session.delete((Object)new XWikiAttachmentContent(attachment));
                }
                catch (Exception e) {
                    this.logger.warn("Error deleting attachment content [{}] of document [{}]", (Object)attachment.getFilename(), (Object)attachment.getDoc().getDocumentReference());
                }
                AttachmentVersioningStore store = this.resolveAttachmentVersioningStore(attachment, context);
                store.deleteArchive(attachment, context, false);
                try {
                    session.delete((Object)attachment);
                }
                catch (Exception e) {
                    this.logger.warn("Error deleting attachment meta data [{}] of document [{}]", (Object)attachment.getFilename(), (Object)attachment.getDoc().getDocumentReference());
                }
                try {
                    if (parentUpdate) {
                        List<XWikiAttachment> list = attachment.getDoc().getAttachmentList();
                        for (int i = 0; i < list.size(); ++i) {
                            XWikiAttachment attach = list.get(i);
                            if (!attachment.getFilename().equals(attach.getFilename())) continue;
                            list.remove(i);
                            break;
                        }
                        context.getWiki().getStore().saveXWikiDoc(attachment.getDoc(), context, false);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Error updating document when deleting attachment [{}] of document [{}]", (Object)attachment.getFilename(), (Object)attachment.getDoc().getDocumentReference());
                }
                if (bTransaction) {
                    this.endTransaction(context, true);
                }
            }
            finally {
                if (bTransaction) {
                    try {
                        this.endTransaction(context, false);
                    }
                    catch (Exception session) {}
                }
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{attachment.getReference()};
            throw new XWikiException(3, 3233, "Exception while deleting attachment {0}", e, args);
        }
        finally {
            context.setWikiId(currentWiki);
            this.restoreExecutionXContext();
        }
    }

    private AttachmentVersioningStore resolveAttachmentVersioningStore(XWikiAttachment attachment, XWikiContext xcontext) {
        if (!attachment.isArchiveStoreSet()) {
            return xcontext.getWiki().getDefaultAttachmentArchiveStore();
        }
        AttachmentVersioningStore store = this.getAttachmentVersioningStore(attachment.getArchiveStore());
        return store != null ? store : this.attachmentVersioningStore;
    }

    private AttachmentVersioningStore getAttachmentVersioningStore(String storeType) {
        if (storeType != null && !storeType.equals("hibernate")) {
            try {
                return (AttachmentVersioningStore)this.componentManager.getInstance(AttachmentVersioningStore.class, storeType);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Can't find attachment versionning store for type [{}]", (Object)storeType, (Object)e);
            }
        }
        return null;
    }
}

