/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLink;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.internal.store.AbstractXWikiStore;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.store.XWikiCacheStoreInterface;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.web.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.cache.internal.CacheLoader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;
import org.xwiki.query.QueryManager;

@Component(roles={XWikiStoreInterface.class})
@Named(value="cache")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiCacheStore
extends AbstractXWikiStore
implements XWikiCacheStoreInterface,
EventListener,
Initializable,
CacheEntryListener<XWikiDocument> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiCacheStore.class);
    @Inject
    private RemoteObservationManagerContext remoteObservationManagerContext;
    @Inject
    @Named(value="uid")
    private EntityReferenceSerializer<String> uidStringEntityReferenceSerializer;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private CacheManager cacheManager;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configuration;
    private XWikiStoreInterface store;
    private Cache<XWikiDocument> cache;
    private Cache<Boolean> pageExistCache;
    private Cache<Integer> limitSizePropertyCache;
    private CacheLoader<XWikiDocument, XWikiException> cacheLoader = new CacheLoader();

    public XWikiCacheStore() {
    }

    public XWikiCacheStore(XWikiStoreInterface store, XWikiContext context) throws XWikiException {
        this.setStore(store);
        this.remoteObservationManagerContext = Utils.getComponent(RemoteObservationManagerContext.class);
        this.observationManager = Utils.getComponent(ObservationManager.class);
        this.uidStringEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "uid");
        this.cacheManager = Utils.getComponent(CacheManager.class);
        this.configuration = Utils.getComponent(ConfigurationSource.class, "xwikicfg");
        this.initCache(context);
        this.initListener();
    }

    public void cacheEntryAdded(CacheEntryEvent<XWikiDocument> event) {
        ((XWikiDocument)event.getEntry().getValue()).setCached(true);
    }

    public void cacheEntryModified(CacheEntryEvent<XWikiDocument> event) {
    }

    public void cacheEntryRemoved(CacheEntryEvent<XWikiDocument> event) {
    }

    public void initialize() throws InitializationException {
        try {
            this.initCache();
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to initialize cache", (Throwable)e);
        }
        this.initListener();
    }

    public String getName() {
        return "XWikiCacheStore";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new WikiDeletedEvent());
    }

    private void initListener() {
        this.observationManager.addListener((EventListener)this, 100);
    }

    private void initCache() throws CacheException {
        int pageCacheCapacity = (Integer)this.configuration.getProperty("xwiki.store.cache.capacity", (Object)500);
        this.cache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("xwiki.store.pagecache", pageCacheCapacity));
        this.cache.addCacheEntryListener((CacheEntryListener)this);
        int pageExistCacheCapacity = (Integer)this.configuration.getProperty("xwiki.store.cache.pageexistcapacity", (Object)10000);
        this.pageExistCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("xwiki.store.pageexistcache", pageExistCacheCapacity));
        int limitSizePropertyCacheCapacity = 10;
        this.limitSizePropertyCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("xwiki.store.limitsizepropertycache", limitSizePropertyCacheCapacity));
    }

    @Deprecated
    public void initCache(XWikiContext context) throws XWikiException {
        try {
            this.initCache();
        }
        catch (CacheException e) {
            throw new XWikiException(16, 16001, "Failed to initialize cache", e);
        }
    }

    @Override
    @Deprecated
    public void initCache(int capacity, int pageExistCacheCapacity, XWikiContext context) throws XWikiException {
    }

    @Override
    public XWikiStoreInterface getStore() {
        return this.store;
    }

    @Override
    public void setStore(XWikiStoreInterface store) {
        this.store = store;
    }

    @Override
    public void saveXWikiDoc(XWikiDocument doc, XWikiContext context) throws XWikiException {
        this.saveXWikiDoc(doc, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameXWikiDoc(XWikiDocument doc, DocumentReference newReference, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            this.store.renameXWikiDoc(doc, newReference, context);
        }
        finally {
            String key = this.getKey(doc, context);
            this.invalidateCache(key);
            WikiReference originalWikiReference = doc.getDocumentReference().getWikiReference();
            if (!newReference.getWikiReference().equals((Object)originalWikiReference)) {
                context.setWikiReference(newReference.getWikiReference());
            }
            XWikiDocument newDoc = new XWikiDocument(newReference, newReference.getLocale());
            key = this.getKey(newDoc, context);
            this.invalidateCache(key);
            context.setWikiReference(originalWikiReference);
            this.restoreExecutionXContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveXWikiDoc(XWikiDocument doc, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            this.store.saveXWikiDoc(doc, context, bTransaction);
            doc.setStore(this.store);
        }
        finally {
            String key = this.getKey(doc, context);
            this.invalidateCache(key);
            this.restoreExecutionXContext();
        }
    }

    private void invalidateCache(String key) {
        this.cacheLoader.invalidate(key, k -> {
            Cache<Boolean> existCache;
            Cache<XWikiDocument> documentCache = this.getCache();
            if (documentCache != null) {
                documentCache.remove(k);
            }
            if ((existCache = this.getPageExistCache()) != null) {
                existCache.remove(k);
            }
        });
    }

    @Override
    public void flushCache() {
        this.cacheLoader.invalidateAll(() -> {
            this.getCache().removeAll();
            this.getPageExistCache().removeAll();
        });
        this.getLimitSizePropertyCache().removeAll();
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.remoteObservationManagerContext.isRemoteState() && event instanceof WikiDeletedEvent) {
            this.flushCache();
        }
    }

    public void invalidate(XWikiDocument document) {
        String key = document.getKey();
        this.invalidateCache(key);
    }

    @Deprecated
    public String getKey(XWikiDocument doc) {
        return doc.getKey();
    }

    public String getKey(XWikiDocument doc, XWikiContext context) {
        DocumentReference reference = doc.getDocumentReferenceWithLocale();
        if (!reference.getWikiReference().equals((Object)context.getWikiReference())) {
            reference = reference.setWikiReference(context.getWikiReference());
        }
        return (String)this.uidStringEntityReferenceSerializer.serialize((EntityReference)reference, new Object[]{reference});
    }

    @Deprecated
    public String getKey(String fullName, String language, XWikiContext context) {
        XWikiDocument doc = new XWikiDocument(null, fullName);
        doc.setLanguage(language);
        return this.getKey(doc, context);
    }

    @Deprecated
    public String getKey(String wiki, String fullName, String language) {
        XWikiDocument doc = new XWikiDocument(wiki, null, fullName);
        doc.setLanguage(language);
        return this.getKey(doc);
    }

    @Override
    public XWikiDocument loadXWikiDoc(XWikiDocument doc, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            XWikiDocument cachedoc;
            String key = this.getKey(doc, context);
            LOGGER.debug("Starting checking for Document [{}] in cache", (Object)key);
            try {
                cachedoc = (XWikiDocument)this.getCache().get(key);
            }
            catch (Exception e) {
                LOGGER.error("Failed to get document [{}] from cache", (Object)key, (Object)e);
                cachedoc = null;
            }
            if (cachedoc != null && !cachedoc.isMetaDataDirty()) {
                cachedoc.setFromCache(true);
                LOGGER.debug("Document [{}] was retrieved from cache", (Object)key);
            } else {
                Boolean result = (Boolean)this.getPageExistCache().get(key);
                if (result == Boolean.FALSE) {
                    LOGGER.debug("Document [{}] doesn't exist in cache, returning an empty one", (Object)key);
                    cachedoc = doc;
                    cachedoc.setNew(true);
                    cachedoc.setOriginalDocument(new XWikiDocument(cachedoc.getDocumentReference(), cachedoc.getLocale()));
                } else {
                    cachedoc = (XWikiDocument)this.cacheLoader.loadAndStoreInCache(key, k -> {
                        LOGGER.debug("Trying to get Document [{}] from persistent storage", (Object)key);
                        XWikiDocument databaseDocument = this.store.loadXWikiDoc(doc, context);
                        LOGGER.debug("Document [{}] was retrieved from persistent storage", (Object)key);
                        return databaseDocument;
                    }, this::storeInCache);
                }
            }
            cachedoc.setStore(this);
            LOGGER.debug("Ending checking for Document [{}] in cache", (Object)key);
            XWikiDocument xWikiDocument = cachedoc;
            return xWikiDocument;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof XWikiException) {
                XWikiException xwikiException = (XWikiException)throwable;
                throw xwikiException;
            }
            throw new XWikiException("Error loading document [%s]".formatted(this.getKey(doc, context)), e);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    private void storeInCache(String key, XWikiDocument document) {
        if (document.isNew()) {
            this.getPageExistCache().set(key, (Object)Boolean.FALSE);
        } else {
            this.getCache().set(key, (Object)document);
            this.getPageExistCache().set(key, (Object)Boolean.TRUE);
        }
        LOGGER.debug("Document [{}] was put in cache", (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteXWikiDoc(XWikiDocument doc, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            String key = this.getKey(doc, context);
            this.store.deleteXWikiDoc(doc, context);
            this.invalidateCache(key);
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Override
    public List<String> getClassList(XWikiContext context) throws XWikiException {
        return this.store.getClassList(context);
    }

    @Override
    public int countDocuments(String wheresql, XWikiContext context) throws XWikiException {
        return this.store.countDocuments(wheresql, context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String wheresql, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentReferences(wheresql, context);
    }

    @Override
    public List<String> searchDocumentsNames(String wheresql, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentsNames(wheresql, context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String wheresql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentReferences(wheresql, nb, start, context);
    }

    @Override
    public List<String> searchDocumentsNames(String wheresql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentsNames(wheresql, nb, start, context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String wheresql, int nb, int start, String selectColumns, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentReferences(wheresql, nb, start, selectColumns, context);
    }

    @Override
    public List<String> searchDocumentsNames(String wheresql, int nb, int start, String selectColumns, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentsNames(wheresql, nb, start, selectColumns, context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String parametrizedSqlClause, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentReferences(parametrizedSqlClause, nb, start, parameterValues, context);
    }

    @Override
    public List<String> searchDocumentsNames(String parametrizedSqlClause, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentsNames(parametrizedSqlClause, nb, start, parameterValues, context);
    }

    @Override
    public List<DocumentReference> searchDocumentReferences(String parametrizedSqlClause, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentReferences(parametrizedSqlClause, parameterValues, context);
    }

    @Override
    public List<String> searchDocumentsNames(String parametrizedSqlClause, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocumentsNames(parametrizedSqlClause, parameterValues, context);
    }

    @Override
    public boolean isCustomMappingValid(BaseClass bclass, String custommapping1, XWikiContext context) throws XWikiException {
        return this.store.isCustomMappingValid(bclass, custommapping1, context);
    }

    @Override
    public boolean injectCustomMapping(BaseClass doc1class, XWikiContext context) throws XWikiException {
        return this.store.injectCustomMapping(doc1class, context);
    }

    @Override
    public boolean injectCustomMappings(XWikiDocument doc, XWikiContext context) throws XWikiException {
        return this.store.injectCustomMappings(doc, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbyname, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbyname, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbyname, boolean customMapping, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbyname, customMapping, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbyname, int nb, int start, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbyname, nb, start, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbyname, boolean customMapping, int nb, int start, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbyname, customMapping, nb, start, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, nb, start, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbyname, boolean customMapping, boolean checkRight, int nb, int start, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbyname, customMapping, checkRight, nb, start, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbylanguage, nb, start, parameterValues, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, parameterValues, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, boolean customMapping, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbylanguage, customMapping, nb, start, parameterValues, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, nb, start, parameterValues, context);
    }

    @Override
    public List<XWikiDocument> searchDocuments(String wheresql, boolean distinctbylanguage, boolean customMapping, boolean checkRight, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.searchDocuments(wheresql, distinctbylanguage, customMapping, checkRight, nb, start, parameterValues, context);
    }

    @Override
    public int countDocuments(String parametrizedSqlClause, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.countDocuments(parametrizedSqlClause, parameterValues, context);
    }

    @Override
    public XWikiLock loadLock(long docId, XWikiContext context, boolean bTransaction) throws XWikiException {
        return this.store.loadLock(docId, context, bTransaction);
    }

    @Override
    public void saveLock(XWikiLock lock, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.store.saveLock(lock, context, bTransaction);
    }

    @Override
    public void deleteLock(XWikiLock lock, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.store.deleteLock(lock, context, bTransaction);
    }

    @Override
    @Deprecated(since="14.8RC1")
    public List<XWikiLink> loadLinks(long docId, XWikiContext context, boolean bTransaction) throws XWikiException {
        return this.store.loadLinks(docId, context, bTransaction);
    }

    @Override
    @Deprecated(since="14.8RC1")
    public List<DocumentReference> loadBacklinks(DocumentReference documentReference, boolean bTransaction, XWikiContext context) throws XWikiException {
        return this.store.loadBacklinks(documentReference, bTransaction, context);
    }

    @Override
    @Deprecated(since="14.8RC1")
    public List<DocumentReference> loadBacklinks(AttachmentReference attachmentReference, boolean bTransaction, XWikiContext context) throws XWikiException {
        return this.store.loadBacklinks(attachmentReference, bTransaction, context);
    }

    @Override
    @Deprecated(since="2.2M2")
    public List<String> loadBacklinks(String fullName, XWikiContext context, boolean bTransaction) throws XWikiException {
        return this.store.loadBacklinks(fullName, context, bTransaction);
    }

    @Override
    @Deprecated(since="14.8RC1")
    public void saveLinks(XWikiDocument doc, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.store.saveLinks(doc, context, bTransaction);
    }

    @Override
    @Deprecated(since="14.8RC1")
    public void deleteLinks(long docId, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.store.deleteLinks(docId, context, bTransaction);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, XWikiContext context) throws XWikiException {
        return this.store.search(sql, nb, start, context);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, Object[][] whereParams, XWikiContext context) throws XWikiException {
        return this.store.search(sql, nb, start, whereParams, context);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.search(sql, nb, start, parameterValues, context);
    }

    @Override
    public <T> List<T> search(String sql, int nb, int start, Object[][] whereParams, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return this.store.search(sql, nb, start, whereParams, parameterValues, context);
    }

    @Override
    public synchronized void cleanUp(XWikiContext context) {
        this.store.cleanUp(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWikiNameAvailable(String wikiName, XWikiContext context) throws XWikiException {
        String string = wikiName;
        synchronized (string) {
            return this.store.isWikiNameAvailable(wikiName, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createWiki(String wikiName, XWikiContext context) throws XWikiException {
        String string = wikiName;
        synchronized (string) {
            this.store.createWiki(wikiName, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWiki(String wikiName, XWikiContext context) throws XWikiException {
        String string = wikiName;
        synchronized (string) {
            this.store.deleteWiki(wikiName, context);
            this.flushCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(XWikiDocument doc, XWikiContext inputxcontext) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            String key = this.getKey(doc, context);
            try {
                Boolean result = (Boolean)this.getPageExistCache().get(key);
                if (result != null) {
                    boolean bl = result;
                    return bl;
                }
            }
            catch (Exception result) {
                // empty catch block
            }
            boolean result = this.store.exists(doc, context);
            this.getPageExistCache().set(key, (Object)result);
            boolean bl = result;
            return bl;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    public Cache<XWikiDocument> getCache() {
        return this.cache;
    }

    public void setCache(Cache<XWikiDocument> cache) {
        this.cache = cache;
    }

    public Cache<Boolean> getPageExistCache() {
        return this.pageExistCache;
    }

    public void setPageExistCache(Cache<Boolean> pageExistCache) {
        this.pageExistCache = pageExistCache;
    }

    public Cache<Integer> getLimitSizePropertyCache() {
        return this.limitSizePropertyCache;
    }

    @Override
    public List<String> getCustomMappingPropertyList(BaseClass bclass) {
        return this.store.getCustomMappingPropertyList(bclass);
    }

    @Override
    public synchronized void injectCustomMappings(XWikiContext context) throws XWikiException {
        this.store.injectCustomMappings(context);
    }

    @Override
    public void injectUpdatedCustomMappings(XWikiContext context) throws XWikiException {
        this.store.injectUpdatedCustomMappings(context);
    }

    @Override
    public List<String> getTranslationList(XWikiDocument doc, XWikiContext context) throws XWikiException {
        return this.store.getTranslationList(doc, context);
    }

    @Override
    public QueryManager getQueryManager() {
        return this.getStore().getQueryManager();
    }

    @Override
    public int getLimitSize(XWikiContext context, Class<?> entityType, String propertyName) {
        String cacheKey = String.format("%s.%s.%s", context.getWikiId(), entityType.getName(), propertyName);
        Integer limitSize = (Integer)this.getLimitSizePropertyCache().get(cacheKey);
        if (limitSize == null) {
            limitSize = this.store.getLimitSize(context, entityType, propertyName);
            this.getLimitSizePropertyCache().set(cacheKey, (Object)limitSize);
        }
        return limitSize;
    }
}

