/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    private static final Logger LOGGER = LoggerFactory.getLogger(DBCPConnectionProvider.class);
    private static final String PREFIX = "hibernate.dbcp.";
    private BasicDataSource ds;
    private static final String COMPATIBILITY_PS_MAXACTIVE = "ps.maxActive";
    private static final String COMPATIBILITY_MAXACTIVE = "maxActive";
    private static final String COMPATIBILITY_MAXWAIT = "maxWait";
    private static final String AUTOCOMMIT = "hibernate.connection.autocommit";

    public void configure(Map props) throws HibernateException {
        try {
            String key;
            Properties driverProps;
            String autocommit;
            String isolationLevel;
            String password;
            String jdbcUrl;
            LOGGER.debug("Configure DBCPConnectionProvider");
            Properties dbcpProperties = new Properties();
            String jdbcDriverClass = (String)props.get("hibernate.connection.driver_class");
            if (jdbcDriverClass != null) {
                dbcpProperties.put("driverClassName", jdbcDriverClass);
            }
            if ((jdbcUrl = System.getProperty("hibernate.connection.url")) == null) {
                jdbcUrl = (String)props.get("hibernate.connection.url");
            }
            dbcpProperties.put("url", jdbcUrl);
            String username = (String)props.get("hibernate.connection.username");
            if (username != null) {
                dbcpProperties.put("username", username);
            }
            if ((password = (String)props.get("hibernate.connection.password")) != null) {
                dbcpProperties.put("password", password);
            }
            if ((isolationLevel = (String)props.get("hibernate.connection.isolation")) != null && isolationLevel.trim().length() > 0) {
                dbcpProperties.put("defaultTransactionIsolation", isolationLevel);
            }
            if ((autocommit = (String)props.get(AUTOCOMMIT)) != null && autocommit.trim().length() > 0) {
                dbcpProperties.put("defaultAutoCommit", autocommit);
            } else {
                dbcpProperties.put("defaultAutoCommit", String.valueOf(Boolean.FALSE));
            }
            String poolSize = (String)props.get("hibernate.connection.pool_size");
            if (poolSize != null && poolSize.trim().length() > 0 && Integer.parseInt(poolSize) > 0) {
                dbcpProperties.put("maxTotal", poolSize);
            }
            if ((driverProps = ConnectionProviderInitiator.getConnectionProperties((Map)props)).size() > 0) {
                StringBuilder connectionProperties = new StringBuilder();
                Iterator<Object> iter = driverProps.keySet().iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    String value = driverProps.getProperty(key);
                    connectionProperties.append(key).append('=').append(value);
                    if (!iter.hasNext()) continue;
                    connectionProperties.append(';');
                }
                dbcpProperties.put("connectionProperties", connectionProperties.toString());
            }
            block15: for (Object element : props.keySet()) {
                key = String.valueOf(element);
                if (!key.startsWith(PREFIX)) continue;
                String property = key.substring(PREFIX.length());
                String value = (String)props.get(key);
                switch (property) {
                    case "ps.maxActive": {
                        dbcpProperties.put("poolPreparedStatements", String.valueOf(Boolean.TRUE));
                        dbcpProperties.put("maxOpenPreparedStatements", value);
                        continue block15;
                    }
                    case "maxActive": {
                        dbcpProperties.put("maxTotal", value);
                        continue block15;
                    }
                    case "maxWait": {
                        dbcpProperties.put("maxWaitMillis", value);
                        continue block15;
                    }
                }
                dbcpProperties.put(property, value);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating a DBCP BasicDataSource with the following DBCP factory properties:");
                StringWriter sw = new StringWriter();
                dbcpProperties.list(new PrintWriter((Writer)sw, true));
                LOGGER.debug(sw.toString());
            }
            this.ds = BasicDataSourceFactory.createDataSource((Properties)dbcpProperties);
            Connection conn = this.ds.getConnection();
            conn.close();
            this.logStatistics();
        }
        catch (Exception e) {
            String message = "Could not create a DBCP pool. There is an error in the Hibernate configuration file, please review it.";
            LOGGER.error(message, (Throwable)e);
            if (this.ds != null) {
                try {
                    this.ds.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ds = null;
            }
            throw new HibernateException(message, (Throwable)e);
        }
        LOGGER.debug("Configure DBCPConnectionProvider complete");
    }

    public Connection getConnection() throws SQLException {
        if (this.ds == null) {
            throw new SQLException("Database Connection Pool has not been started or is already stopped!");
        }
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
        }
        finally {
            this.logStatistics();
        }
        return conn;
    }

    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.close();
        }
        finally {
            this.logStatistics();
        }
    }

    public void close() throws HibernateException {
        SHUTDOWN_LOGGER.debug("Stopping Database Connection Pool...");
        this.logStatistics();
        try {
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            } else {
                LOGGER.warn("Cannot close Database Connection Pool (not initialized)");
            }
        }
        catch (Exception e) {
            throw new HibernateException("Could not close DBCP pool", (Throwable)e);
        }
        SHUTDOWN_LOGGER.debug("Database Connection Pool has been stopped");
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    protected void logStatistics() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("active: [{}] (max: [{}]), idle: [{}] (max: [{}])", new Object[]{this.ds.getNumActive(), this.ds.getMaxTotal(), this.ds.getNumIdle(), this.ds.getMaxIdle()});
        }
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || DBCPConnectionProvider.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DBCPConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.ds;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        this.close();
    }
}

