/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.stats.impl.VisitStats;
import com.xpn.xwiki.stats.impl.xwiki.AbstractStatsStoreItem;
import com.xpn.xwiki.stats.impl.xwiki.XWikiStatsStoreItem;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisitStatsStoreItem
extends AbstractStatsStoreItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisitStatsStoreItem.class);
    private VisitStats visitStats;

    public VisitStatsStoreItem(VisitStats visitStats, XWikiContext context) {
        super(visitStats.getName(), new Date(), StatsUtil.PeriodType.MONTH, context);
        this.period = visitStats.getPeriod();
        this.visitStats = (VisitStats)visitStats.clone();
    }

    @Override
    public String getId() {
        return String.format("%s %s %s %s", this.getClass(), this.visitStats.getName(), this.visitStats.getUniqueID(), this.visitStats.getCookie());
    }

    @Override
    public void storeInternal(List<XWikiStatsStoreItem> stats) {
        VisitStatsStoreItem firstItem = (VisitStatsStoreItem)stats.get(0);
        VisitStats oldVisitStats = firstItem.visitStats.getOldObject();
        VisitStatsStoreItem lastItem = (VisitStatsStoreItem)stats.get(stats.size() - 1);
        VisitStats newVisitStats = lastItem.visitStats;
        XWikiHibernateStore store = this.context.getWiki().getHibernateStore();
        if (store == null) {
            return;
        }
        try {
            block6: {
                if (oldVisitStats != null) {
                    try {
                        store.deleteXWikiCollection(oldVisitStats, this.context, true, true);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled()) break block6;
                        LOGGER.error("Failed to delete old visit statistics object from database [{}]", (Object)this.getId(), (Object)e);
                    }
                }
            }
            store.saveXWikiCollection(newVisitStats, this.context, true);
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to save visit statistics object [{}]", (Object)this.getId(), (Object)e);
        }
    }
}

