/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.stats.impl.RefererStats;
import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.stats.impl.xwiki.AbstractStatsStoreItem;
import com.xpn.xwiki.stats.impl.xwiki.XWikiStatsStoreItem;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefererStatsStoreItem
extends AbstractStatsStoreItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefererStatsStoreItem.class);
    private String referer;

    public RefererStatsStoreItem(String name, Date periodDate, StatsUtil.PeriodType periodType, String referer, XWikiContext context) {
        super(name, periodDate, periodType, context);
        this.referer = referer;
    }

    @Override
    public String getId() {
        return String.format("%s %s %s %s", this.getClass(), this.name, this.referer, this.period);
    }

    @Override
    public void storeInternal(List<XWikiStatsStoreItem> stats) {
        RefererStats refererStat;
        XWikiHibernateStore store;
        block5: {
            RefererStatsStoreItem lastItem = (RefererStatsStoreItem)stats.get(stats.size() - 1);
            store = this.context.getWiki().getHibernateStore();
            if (store == null) {
                return;
            }
            refererStat = new RefererStats(lastItem.name, lastItem.referer, lastItem.periodDate, lastItem.periodType);
            try {
                store.loadXWikiCollection(refererStat, this.context, true);
            }
            catch (XWikiException e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Failed to load referer statictics object [" + this.getId() + "]");
            }
        }
        refererStat.setIntValue("pageViews", refererStat.getPageViews() + stats.size());
        try {
            store.saveXWikiCollection(refererStat, this.context, true);
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to save referer statictics object [" + this.getId() + "]");
        }
    }
}

