/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.web.Utils;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

public class XWikiStats
extends BaseCollection {
    private static final long serialVersionUID = 1L;
    private static final String XMLNODE_OBJECT = "object";
    private static final String XMLNODE_NAME = "name";
    private static final String XMLNODE_NUMBER = "number";
    private static final String XMLNODE_CLASSNAME = "className";
    private static final String XMLNODE_PROPERTY = "property";
    private final EntityReferenceResolver<String> resolver = (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING);

    public XWikiStats() {
    }

    public XWikiStats(Date periodDate, StatsUtil.PeriodType periodtype) {
        this.setPeriod(StatsUtil.getPeriodAsInt(periodDate, periodtype));
    }

    public int getPeriod() {
        return this.getIntValue(Property.period.toString());
    }

    public void setPeriod(int period) {
        this.setIntValue(Property.period.toString(), period);
    }

    public int getPageViews() {
        return this.getIntValue(Property.pageViews.toString());
    }

    public void setPageViews(int pageViews) {
        this.setIntValue(Property.pageViews.toString(), pageViews);
    }

    public void incPageViews() {
        this.setIntValue(Property.pageViews.toString(), this.getPageViews() + 1);
    }

    @Override
    protected String getLocalKey() {
        StringBuilder sb = new StringBuilder(64);
        String name = this.getName();
        int nb = this.getNumber();
        if (!StringUtils.isEmpty((CharSequence)name)) {
            EntityReference ref = this.resolver.resolve((Object)name, EntityType.DOCUMENT, new Object[0]);
            if (ref.getName().equals(name)) {
                ref = new EntityReference(name, EntityType.SPACE);
            }
            sb.append(this.getLocalUidStringEntityReferenceSerializer().serialize(ref, new Object[0]));
        }
        if (nb != 0) {
            String str = Integer.toString(nb);
            sb.append(str.length()).append(':').append(str);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getNumber() == ((BaseCollection)obj).getNumber();
    }

    @Override
    public Element toXML(BaseClass bclass) {
        DOMElement oel = new DOMElement(XMLNODE_OBJECT);
        if (bclass != null && bclass.getFieldList().size() > 0) {
            oel.add(bclass.toXML());
        }
        DOMElement el = new DOMElement(XMLNODE_NAME);
        el.addText(this.getName());
        oel.add((Element)el);
        el = new DOMElement(XMLNODE_NUMBER);
        el.addText("" + this.getNumber());
        oel.add((Element)el);
        el = new DOMElement(XMLNODE_CLASSNAME);
        el.addText(this.getClassName());
        oel.add((Element)el);
        Iterator it = this.getFieldList().iterator();
        while (it.hasNext()) {
            DOMElement pel = new DOMElement(XMLNODE_PROPERTY);
            PropertyInterface bprop = (PropertyInterface)it.next();
            pel.add(bprop.toXML());
            oel.add((Element)pel);
        }
        return oel;
    }

    @Override
    public void fromXML(Element oel) throws XWikiException {
        Element cel = oel.element("class");
        BaseClass bclass = new BaseClass();
        if (cel != null) {
            bclass.fromXML(cel);
            this.setClassName(bclass.getName());
        }
        this.setName(oel.element(XMLNODE_NAME).getText());
        List list = oel.elements(XMLNODE_PROPERTY);
        for (int i = 0; i < list.size(); ++i) {
            Element pcel = (Element)((Element)list.get(i)).elements().get(0);
            String name = pcel.getName();
            PropertyClass pclass = (PropertyClass)bclass.get(name);
            if (pclass == null) continue;
            BaseProperty property = pclass.newPropertyfromXML(pcel);
            property.setName(name);
            property.setObject(this);
            this.safeput(name, property);
        }
    }

    public static enum Property {
        period,
        pageViews;

    }
}

