/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl;

import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.stats.impl.XWikiStats;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class VisitStats
extends XWikiStats {
    private static final long serialVersionUID = 1L;
    protected VisitStats oldObject;

    public VisitStats() {
    }

    public VisitStats(String user, String uniqueID, String cookie, String ip, String userAgent, Date startDate, StatsUtil.PeriodType periodType) {
        super(startDate, periodType);
        this.setName(user);
        this.setStartDate(startDate);
        this.setUniqueID(uniqueID);
        this.setCookie(cookie);
        this.setIP(ip);
        this.setUserAgent(userAgent);
    }

    public void rememberOldObject(VisitStats vobject) {
        if (this.oldObject == null) {
            this.oldObject = vobject;
        }
    }

    public void unrememberOldObject() {
        this.oldObject = null;
    }

    public VisitStats getOldObject() {
        return this.oldObject;
    }

    public int getPageSaves() {
        return this.getIntValue(Property.pageSaves.toString());
    }

    public void setPageSaves(int pageSaves) {
        this.setIntValue(Property.pageSaves.toString(), pageSaves);
    }

    public void incPageSaves() {
        this.setIntValue(Property.pageSaves.toString(), this.getPageSaves() + 1);
    }

    public int getDownloads() {
        return this.getIntValue(Property.downloads.toString());
    }

    public void setDownloads(int downloads) {
        this.setIntValue(Property.downloads.toString(), downloads);
    }

    public void incDownloads() {
        this.setIntValue(Property.downloads.toString(), this.getDownloads() + 1);
    }

    public Date getStartDate() {
        return this.getDateValue(Property.startDate.toString());
    }

    public void setStartDate(Date startDate) {
        this.setDateValue(Property.startDate.toString(), startDate);
    }

    public Date getEndDate() {
        return this.getDateValue(Property.endDate.toString());
    }

    public void setEndDate(Date endDate) {
        this.setDateValue(Property.endDate.toString(), endDate);
    }

    public String getUniqueID() {
        return this.getStringValue(Property.uniqueID.toString());
    }

    public void setUniqueID(String uniqueID) {
        if (this.getStartDate() != null) {
            String nb = uniqueID + this.getStartDate().getTime();
            this.setNumber(nb.hashCode());
        }
        this.setStringValue(Property.uniqueID.toString(), uniqueID);
    }

    public String getCookie() {
        return this.getStringValue(Property.cookie.toString());
    }

    public void setCookie(String cookie) {
        this.setStringValue(Property.cookie.toString(), StringUtils.defaultString((String)cookie));
    }

    public String getIP() {
        return this.getStringValue(Property.ip.toString());
    }

    public void setIP(String ip) {
        this.setStringValue(Property.ip.toString(), ip);
    }

    public String getUserAgent() {
        return this.getStringValue(Property.userAgent.toString());
    }

    public void setUserAgent(String userAgent) {
        this.setStringValue(Property.userAgent.toString(), StringUtils.defaultString((String)userAgent));
    }

    public String getUser() {
        return this.getName();
    }

    public void setUser(String user) {
        this.setName(user);
    }

    public static enum Property {
        pageSaves,
        downloads,
        startDate,
        endDate,
        uniqueID,
        cookie,
        ip,
        userAgent;

    }
}

