/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import com.xpn.xwiki.stats.impl.StatsUtilCompatibilityAspect;
import com.xpn.xwiki.stats.impl.VisitStats;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.XWikiRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.QueryManager;

public final class StatsUtil {
    private static final Logger LOGGER;
    private static final String LIST_SEPARATOR = ",";
    private static final String ESCAPED_LIST_SEPARATOR = "\\,";
    private static final String CFGPROP_COOKIEDOMAINS = "xwiki.authentication.cookiedomains";
    private static final char CFGPROP_COOKIEDOMAINS_SEP = ',';
    private static final String CFGPROP_STATS = "xwiki.stats";
    private static final String CFGPROP_STATS_DEFAULT = "xwiki.stats.default";
    @Deprecated
    private static final String DEPRECATED_CFGPROP_STATS_EXCLUDEDUSERSANDGROUPS = "xwiki.stats.excludedUsersAndGroups";
    private static final String CFGPROP_STATS_EXCLUDEDUSERSANDGROUPS_REQUEST = "xwiki.stats.request.excludedUsersAndGroups";
    private static final String CFGPROP_STATS_EXCLUDEDUSERSANDGROUPS_STORAGE = "xwiki.stats.storage.excludedUsersAndGroups";
    private static final String SESSPROP_RECENT_PREFFIX = "recent_";
    private static final String SESSPROP_VISITOBJECT = "visitObject";
    private static final String PREFPROP_RECENT_VISITS_SIZE = "recent_visits_size";
    private static final String PREFPROP_STATISTICS = "statistics";
    @Deprecated
    private static final String DEPRECATED_PREFPROP_EXCLUDEDUSERSANDGROUPS = "statistics_excludedUsersAndGroups";
    private static final String PREFPROP_EXCLUDEDUSERSANDGROUPS_REQUEST = "statistics_request_excludedUsersAndGroups";
    private static final String PREFPROP_EXCLUDEDUSERSANDGROUPS_STORAGE = "statistics_storage_excludedUsersAndGroups";
    private static final String REQPROP_REFERER = "referer";
    private static final String REQPROP_USERAGENT = "User-Agent";
    private static final String CONTPROP_STATS_COOKIE = "stats_cookie";
    private static final String CONTPROP_STATS_NEWCOOKIE = "stats_newcookie";
    private static final String COOKPROP_VISITID = "visitid";
    private static String[] cookieDomains;
    private static Date cookieExpirationDate;
    @Deprecated
    public static int PERIOD_MONTH;
    @Deprecated
    public static int PERIOD_DAY;

    private StatsUtil() {
    }

    public static int getPeriodAsInt(Date date, PeriodType type) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        int period = type == PeriodType.MONTH ? cal.get(1) * 100 + (cal.get(2) + 1) : cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5);
        return period;
    }

    public static String[] getCookieDomains(XWikiContext context) {
        if (cookieDomains == null) {
            cookieDomains = StringUtils.split((String)context.getWiki().Param(CFGPROP_COOKIEDOMAINS), (char)',');
        }
        return cookieDomains;
    }

    public static Date getCookieExpirationDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(2030, 0, 0);
        cookieExpirationDate = cal.getTime();
        return cookieExpirationDate;
    }

    public static Collection<?> getRecentActionFromSessions(XWikiContext context, String action) {
        return (Collection)context.getRequest().getSession().getAttribute(SESSPROP_RECENT_PREFFIX + action);
    }

    public static void setRecentActionsFromSession(XWikiContext context, String action, Collection<?> actions) {
        context.getRequest().getSession().setAttribute(SESSPROP_RECENT_PREFFIX + action, actions);
    }

    public static int getRecentVisitSize(XWikiContext context) {
        return context.getWiki().getXWikiPreferenceAsInt(PREFPROP_RECENT_VISITS_SIZE, 20, context);
    }

    public static VisitStats getVisitFromSession(HttpSession session) {
        return (VisitStats)session.getAttribute(SESSPROP_VISITOBJECT);
    }

    public static void setVisitInSession(HttpSession session, VisitStats visitStat) {
        session.setAttribute(SESSPROP_VISITOBJECT, (Object)visitStat);
    }

    public static boolean isStatsEnabled(XWikiContext context) {
        return "1".equals(context.getWiki().Param(CFGPROP_STATS, "1"));
    }

    public static boolean isWikiStatsEnabled(XWikiContext context) {
        String statsdefault = context.getWiki().Param(CFGPROP_STATS_DEFAULT);
        String statsactive = context.getWiki().getXWikiPreference(PREFPROP_STATISTICS, "", context);
        return "1".equals(statsactive) || "".equals(statsactive) && "1".equals(statsdefault);
    }

    public static VisitStats findVisit(XWikiContext context) {
        XWikiRequest request = context.getRequest();
        HttpSession session = request.getSession(true);
        VisitStats visitObject = StatsUtil.getVisitFromSession(session);
        Cookie cookie = (Cookie)context.get(CONTPROP_STATS_COOKIE);
        boolean newcookie = (Boolean)context.get(CONTPROP_STATS_NEWCOOKIE);
        if (visitObject == null) {
            visitObject = StatsUtil.findVisitByCookieOrIPUA(context);
        }
        if (visitObject == null || !StatsUtil.isVisitObjectValid(visitObject, context)) {
            visitObject = StatsUtil.createNewVisit(context);
        } else {
            String oldcookie;
            String uniqueID;
            if (!newcookie && !(uniqueID = visitObject.getUniqueID()).equals(oldcookie = visitObject.getCookie())) {
                VisitStats newVisitObject = (VisitStats)visitObject.clone();
                newVisitObject.rememberOldObject(visitObject);
                newVisitObject.setUniqueID(cookie.getValue());
                visitObject = newVisitObject;
            }
            if (!context.getUser().equals("XWiki.XWikiGuest") && visitObject.getUser().equals("XWiki.XWikiGuest")) {
                VisitStats newVisitObject = visitObject;
                newVisitObject.rememberOldObject(visitObject);
                newVisitObject.setName(context.getUser());
                visitObject = newVisitObject;
            }
        }
        StatsUtil.setVisitInSession(session, visitObject);
        return visitObject;
    }

    private static VisitStats findVisitByCookieOrIPUA(XWikiContext context) {
        VisitStats visitStats = null;
        XWikiRequest request = context.getRequest();
        Cookie cookie = (Cookie)context.get(CONTPROP_STATS_COOKIE);
        boolean newcookie = (Boolean)context.get(CONTPROP_STATS_NEWCOOKIE);
        if (!newcookie) {
            try {
                visitStats = StatsUtil.findVisitByCookie(cookie.getValue(), context);
            }
            catch (XWikiException e) {
                LOGGER.error("Failed to find visit by cookie", (Throwable)e);
            }
        } else {
            try {
                String ip = request.getRemoteAddr();
                String ua = request.getHeader(REQPROP_USERAGENT);
                visitStats = StatsUtil.findVisitByIPUA(StatsUtil.computeUniqueID(ip, ua), context);
            }
            catch (XWikiException e) {
                LOGGER.error("Failed to find visit by unique id", (Throwable)e);
            }
        }
        return visitStats;
    }

    private static boolean isVisitObjectValid(VisitStats visitObject, XWikiContext context) {
        boolean valid = true;
        XWikiRequest request = context.getRequest();
        HttpSession session = request.getSession(true);
        Cookie cookie = (Cookie)context.get(CONTPROP_STATS_COOKIE);
        Date nowDate = new Date();
        if (visitObject != null) {
            if (!visitObject.getCookie().equals(cookie.getValue())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found visit with cookie " + visitObject.getCookie() + " in session " + session.getId() + " for request with cookie " + cookie.getValue());
                }
                valid = false;
            } else if (nowDate.getTime() - visitObject.getEndDate().getTime() > 1800000L) {
                valid = false;
            } else if (!context.getUser().equals(visitObject.getName())) {
                valid = false;
            }
        }
        return valid;
    }

    private static VisitStats createNewVisit(XWikiContext context) {
        VisitStats visitStats = null;
        XWikiRequest request = context.getRequest();
        Date nowDate = new Date();
        Cookie cookie = (Cookie)context.get(CONTPROP_STATS_COOKIE);
        boolean newcookie = (Boolean)context.get(CONTPROP_STATS_NEWCOOKIE);
        String ip = request.getRemoteAddr();
        String ua = request.getHeader(REQPROP_USERAGENT);
        if (ua == null) {
            ua = "";
        }
        String uniqueID = newcookie ? StatsUtil.computeUniqueID(ip, ua) : cookie.getValue();
        visitStats = new VisitStats(context.getUser(), uniqueID, cookie.getValue(), ip, ua, nowDate, PeriodType.MONTH);
        visitStats.setEndDate(nowDate);
        return visitStats;
    }

    private static String computeUniqueID(String ip, String ua) {
        return StringUtils.substring((String)(ip + ua), (int)0, (int)255);
    }

    protected static VisitStats findVisitByField(String fieldName, String fieldValue, XWikiContext context) throws XWikiException {
        VisitStats visitStats = null;
        Date currentDate = new Date(new Date().getTime() - 1800000L);
        QueryManager qm = context.getWiki().getStore().getQueryManager();
        List solist = null;
        String sfieldValue = "fieldValue";
        String sdate = "date";
        if (qm.hasLanguage("xpath")) {
            try {
                solist = qm.createQuery("//element(*, xwiki:object)[@:{fieldName}=:{fieldValue} and @endDate>:{date}]  order by @endDate descending", "xpath").bindValue("fieldName", (Object)fieldName).bindValue("fieldValue", (Object)fieldValue).bindValue("date", (Object)currentDate).execute();
            }
            catch (Exception e) {
                LOGGER.error("Failed to search visit object in the jcr store from cookie name", (Throwable)e);
            }
        } else if (qm.hasLanguage("hql")) {
            try {
                solist = qm.createQuery("from VisitStats as obj where obj." + fieldName + "=:fieldValue and obj.endDate > :date order by obj.endDate desc", "hql").bindValue("fieldValue", (Object)fieldValue).bindValue("date", (Object)currentDate).execute();
            }
            catch (Exception e) {
                LOGGER.error("Failed to search visit object in the database from " + fieldName, (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("The current storage engine does not support querying statistics");
        }
        if (solist != null && solist.size() > 0) {
            visitStats = (VisitStats)solist.get(0);
        }
        return visitStats;
    }

    protected static VisitStats findVisitByCookie(String cookie, XWikiContext context) throws XWikiException {
        return StatsUtil.findVisitByField("cookie", cookie, context);
    }

    protected static VisitStats findVisitByIPUA(String uniqueID, XWikiContext context) throws XWikiException {
        return StatsUtil.findVisitByField("uniqueID", uniqueID, context);
    }

    protected static Cookie addCookie(XWikiContext context) {
        Cookie cookie = new Cookie(COOKPROP_VISITID, RandomStringUtils.secure().nextAlphanumeric(32).toUpperCase());
        cookie.setPath("/");
        int time = (int)(StatsUtil.getCookieExpirationDate().getTime() - new Date().getTime()) / 1000;
        cookie.setMaxAge(time);
        String cookieDomain = null;
        StatsUtil.getCookieDomains(context);
        if (cookieDomains != null) {
            String servername = context.getRequest().getServerName();
            for (String cookieDomain2 : cookieDomains) {
                if (servername.indexOf(cookieDomain2) == -1) continue;
                cookieDomain = cookieDomain2;
                break;
            }
        }
        if (cookieDomain != null) {
            cookie.setDomain(cookieDomain);
        }
        if (!context.getResponse().isCommitted()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting cookie " + cookie.getValue() + " for name " + cookie.getName() + " with domain " + cookie.getDomain() + " and path " + cookie.getPath() + " and maxage " + cookie.getMaxAge());
            }
            context.getResponse().addCookie(cookie);
        }
        return cookie;
    }

    public static boolean findCookie(XWikiContext context) {
        if (context.get(CONTPROP_STATS_COOKIE) != null) {
            return false;
        }
        Cookie cookie = Util.getCookie(COOKPROP_VISITID, context);
        boolean newcookie = false;
        if (cookie == null) {
            cookie = StatsUtil.addCookie(context);
            newcookie = true;
        }
        context.put(CONTPROP_STATS_COOKIE, cookie);
        context.put(CONTPROP_STATS_NEWCOOKIE, (Object)newcookie);
        return true;
    }

    public static String getReferer(XWikiContext context) {
        String referer = context.getRequest().getHeader(REQPROP_REFERER);
        try {
            URL url = new URL(referer);
            URL baseurl = context.getURL();
            if (baseurl.getHost().equals(url.getHost())) {
                referer = null;
            }
        }
        catch (MalformedURLException e) {
            referer = null;
        }
        return referer;
    }

    private static Collection<DocumentReference> getFilteredUsers(String pref, String cfg, XWikiContext context) throws XWikiException {
        List<String> userList;
        String users = context.getWiki().getXWikiPreference(pref, "", context);
        if (StringUtils.isEmpty((CharSequence)users)) {
            users = context.getWiki().Param(cfg);
        }
        if (!StringUtils.isBlank((CharSequence)users)) {
            userList = new ArrayList();
            int begin = 0;
            boolean escaped = false;
            for (int i = 0; i < users.length(); ++i) {
                char c = users.charAt(i);
                if (!escaped) {
                    if (c == '\\') {
                        escaped = true;
                        continue;
                    }
                    if (c != ',') continue;
                    userList.add(users.substring(begin, i).replace(ESCAPED_LIST_SEPARATOR, LIST_SEPARATOR));
                    begin = i + 1;
                    continue;
                }
                escaped = false;
            }
            if (begin < users.length()) {
                userList.add(users.substring(begin).replace(ESCAPED_LIST_SEPARATOR, LIST_SEPARATOR));
            }
        } else {
            userList = Collections.emptyList();
        }
        return RightsManager.getInstance().resolveUsers(userList, context);
    }

    public static Collection<DocumentReference> getStorageFilteredUsers(XWikiContext context) throws XWikiException {
        return StatsUtil.getFilteredUsers(PREFPROP_EXCLUDEDUSERSANDGROUPS_STORAGE, CFGPROP_STATS_EXCLUDEDUSERSANDGROUPS_STORAGE, context);
    }

    public static Collection<DocumentReference> getRequestFilteredUsers(XWikiContext context) throws XWikiException {
        Collection<DocumentReference> users = StatsUtil.getFilteredUsers(PREFPROP_EXCLUDEDUSERSANDGROUPS_REQUEST, CFGPROP_STATS_EXCLUDEDUSERSANDGROUPS_REQUEST, context);
        return users != null ? users : StatsUtil.getFilteredUsers(DEPRECATED_PREFPROP_EXCLUDEDUSERSANDGROUPS, DEPRECATED_CFGPROP_STATS_EXCLUDEDUSERSANDGROUPS, context);
    }

    static {
        StatsUtilCompatibilityAspect.ajc$interFieldInit$com_xpn_xwiki_stats_impl_StatsUtilCompatibilityAspect$com_xpn_xwiki_stats_impl_StatsUtil$PERIOD_MONTH();
        StatsUtilCompatibilityAspect.ajc$interFieldInit$com_xpn_xwiki_stats_impl_StatsUtilCompatibilityAspect$com_xpn_xwiki_stats_impl_StatsUtil$PERIOD_DAY();
        LOGGER = LoggerFactory.getLogger(StatsUtil.class);
    }

    @Deprecated
    public static int getPeriodAsInt(Date date, int n) {
        return StatsUtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_stats_impl_StatsUtilCompatibilityAspect$com_xpn_xwiki_stats_impl_StatsUtil$getPeriodAsInt(date, n);
    }

    public static enum PeriodType {
        MONTH,
        DAY;

    }
}

