/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.script.parentchild;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.parentchild.ParentChildConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="parentchild")
@Singleton
public class ParentChildScriptService
implements ScriptService {
    @Inject
    private ParentChildConfiguration configuration;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public boolean isParentChildMechanismEnabled() {
        return this.configuration.isParentChildMechanismEnabled();
    }

    public List<DocumentReference> getParents(DocumentReference docRef) {
        if (this.isParentChildMechanismEnabled()) {
            return this.getParentsBasedOnParentChildRelationship(docRef);
        }
        return this.getParentsBasedOnReference(docRef);
    }

    public List<DocumentReference> getParentsBasedOnReference(DocumentReference docRef) {
        ArrayList<DocumentReference> parents = new ArrayList<DocumentReference>();
        for (SpaceReference spaceReference : docRef.getSpaceReferences()) {
            parents.add(this.documentReferenceResolver.resolve((Object)spaceReference, new Object[0]));
        }
        return parents;
    }

    public List<DocumentReference> getParentsBasedOnParentChildRelationship(DocumentReference docRef) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki xwiki = context.getWiki();
        ArrayList<DocumentReference> parents = new ArrayList<DocumentReference>();
        try {
            XWikiDocument document = xwiki.getDocument(docRef, context);
            while (document.getParentReference() != null) {
                DocumentReference parentReference = document.getParentReference();
                if (parents.contains(parentReference)) {
                    throw new Exception("Cyclic references of parent documents");
                }
                parents.add(document.getParentReference());
                document = xwiki.getDocument(document.getParentReference(), context);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get the parents of [{}].", (Object)docRef, (Object)e);
        }
        Collections.reverse(parents);
        return parents;
    }
}

