/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.render.groovy;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWikiPageClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiPageClassLoader.class);

    public XWikiPageClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public XWikiPageClassLoader(URL[] urls) {
        super(urls);
    }

    public XWikiPageClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public XWikiPageClassLoader(String jarWikiPage, XWikiContext context) throws XWikiException {
        this(jarWikiPage, Thread.currentThread().getContextClassLoader(), context);
    }

    public XWikiPageClassLoader(String jarWikiPage, ClassLoader parent, XWikiContext context) throws XWikiException {
        super(new URL[0], parent);
        XWikiDocument doc = context.getWiki().getDocument(jarWikiPage, context);
        if (!doc.isNew()) {
            List<XWikiAttachment> attachList = doc.getAttachmentList();
            for (int i = 0; i < attachList.size(); ++i) {
                XWikiAttachment attach = attachList.get(i);
                String filename = attach.getFilename();
                if (!filename.endsWith(".jar")) continue;
                String downloadURL = doc.getExternalAttachmentURL(filename, "download", context);
                try {
                    this.addURL(new URL(downloadURL));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Adding [" + downloadURL + "] JAR from page [" + jarWikiPage + "] to Groovy classloader");
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to add [" + downloadURL + "] JAR from page [" + jarWikiPage + "], ignoring it.");
                }
            }
        }
    }
}

