/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.render;

import com.xpn.xwiki.render.ScriptHttpSession;
import com.xpn.xwiki.web.WrappingXWikiRequest;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiServletRequest;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class ScriptXWikiServletRequest
extends WrappingXWikiRequest {
    private static final Set<String> READ_ONLY_ATTRIBUTES = Set.of(XWikiServletRequest.ATTRIBUTE_EFFECTIVE_AUTHOR);
    private final ContextualAuthorizationManager authorization;

    public ScriptXWikiServletRequest(XWikiRequest request, ContextualAuthorizationManager authorization) {
        super(request);
        this.authorization = authorization;
    }

    public ServletContext getServletContext() {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            return super.getServletContext();
        }
        return null;
    }

    public ServletRequest getRequest() {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            return super.getRequest();
        }
        return null;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            return super.getHttpServletRequest();
        }
        return this;
    }

    public HttpSession getSession() {
        return new ScriptHttpSession(super.getSession(), this.authorization);
    }

    public HttpSession getSession(boolean create) {
        return new ScriptHttpSession(super.getSession(create), this.authorization);
    }

    public void setAttribute(String name, Object value) {
        if (!READ_ONLY_ATTRIBUTES.contains(name) || this.authorization.hasAccess(Right.PROGRAM)) {
            super.setAttribute(name, value);
        }
    }
}

