/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.rightsmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightsManagerRightsApi
extends Api {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Logger LOGGER = LoggerFactory.getLogger(RightsManagerRightsApi.class);

    public RightsManagerRightsApi(XWikiContext context) {
        super(context);
    }

    private void logError(String comment, XWikiException e) {
        LOGGER.error(comment, (Throwable)e);
        this.context.put(CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put(CONTEXT_LASTEXCEPTION, e);
    }

    public Document getParentPreference(String spaceOrPage) throws XWikiException {
        Document parent = null;
        try {
            XWikiDocument xdoc = RightsManager.getInstance().getParentPreference(spaceOrPage, this.context);
            parent = this.convert(xdoc);
        }
        catch (RightsManagerException e) {
            this.logError(MessageFormat.format("Try to get parent rights preference for [{0}]", spaceOrPage), e);
        }
        return parent;
    }
}

