/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.rightsmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.plugin.rightsmanager.ReferenceUserIterator;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.plugin.rightsmanager.utils.AllowDeny;
import com.xpn.xwiki.plugin.rightsmanager.utils.LevelTree;
import com.xpn.xwiki.plugin.rightsmanager.utils.RequestLimit;
import com.xpn.xwiki.plugin.rightsmanager.utils.UsersGroups;
import com.xpn.xwiki.user.impl.xwiki.XWikiRightServiceImpl;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public final class RightsManager {
    public static final String DEFAULT_USERORGROUP_SPACE = "XWiki";
    private static final String WIKIFULLNAME_SEP = ":";
    private static final String SPACEPAGENAME_SEP = ".";
    private static final String WIKI_PREFERENCES = "XWiki.XWikiPreferences";
    private static final String SPACE_PREFERENCES = "WebPreferences";
    private static final String RIGHTSFIELD_LEVELS = "levels";
    private static final String RIGHTSFIELD_USERS = "users";
    private static final String RIGHTSFIELD_GROUPS = "groups";
    private static final String RIGHTSFIELD_ALLOW = "allow";
    private static final String RIGHTSLISTFIELD_SEP = ",|";
    private static final String USERGROUPLISTFIELD_SEP = ",";
    private static final String HQLLIKE_ALL_SYMBOL = "%";
    private static final String ALL_RIGHTS_QUERY = ", BaseObject as obj, %s as prop where doc.fullName=obj.name and (obj.className=?1 or obj.className=?2) and obj.id=prop.id.id and prop.name=?3 and prop.value like ?4";
    private static RightsManager instance;
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "explicit");
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki");
    private EntityReferenceSerializer<String> localEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");

    private RightsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RightsManager getInstance() {
        Class<RightsManager> clazz = RightsManager.class;
        synchronized (RightsManager.class) {
            if (instance == null) {
                instance = new RightsManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int countAllUsersOrGroups(boolean user, Object[][] matchFields, XWikiContext context) throws XWikiException {
        if (context.isMainWiki()) {
            return this.countAllLocalUsersOrGroups(user, matchFields, context);
        }
        return this.countAllGlobalUsersOrGroups(user, matchFields, context) + this.countAllLocalUsersOrGroups(user, matchFields, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countAllWikiUsersOrGroups(boolean user, String wikiName, Object[][] matchFields, XWikiContext context) throws XWikiException {
        if (context.isMainWiki()) {
            return this.countAllLocalUsersOrGroups(user, matchFields, context);
        }
        String database = context.getWikiId();
        try {
            context.setWikiId(wikiName);
            int n = this.countAllLocalUsersOrGroups(user, matchFields, context);
            return n;
        }
        finally {
            context.setWikiId(database);
        }
    }

    public int countAllGlobalUsersOrGroups(boolean user, Object[][] matchFields, XWikiContext context) throws XWikiException {
        if (context.isMainWiki()) {
            return this.countAllLocalUsersOrGroups(user, matchFields, context);
        }
        return this.countAllWikiUsersOrGroups(user, context.getMainXWiki(), matchFields, context);
    }

    public int countAllLocalUsersOrGroups(boolean user, Object[][] matchFields, XWikiContext context) throws XWikiException {
        if (user) {
            return context.getWiki().getGroupService(context).countAllMatchedUsers(matchFields, context);
        }
        return context.getWiki().getGroupService(context).countAllMatchedGroups(matchFields, context);
    }

    public List<?> getAllMatchedUsersOrGroups(boolean user, Object[][] matchFields, boolean withdetails, RequestLimit limit, Object[][] order, XWikiContext context) throws XWikiException {
        if (context.isMainWiki()) {
            return this.getAllMatchedLocalUsersOrGroups(user, matchFields, withdetails, limit, order, context);
        }
        ArrayList userOrGroupList = new ArrayList();
        int nbGlobalUsersOrGroups = this.countAllGlobalUsersOrGroups(user, null, context);
        int newstart = limit.getStart();
        if (newstart < nbGlobalUsersOrGroups) {
            userOrGroupList.addAll(this.getAllMatchedGlobalUsersOrGroups(user, matchFields, withdetails, new RequestLimit(limit.getNb(), newstart), order, context));
            newstart = 0;
        } else {
            newstart -= nbGlobalUsersOrGroups;
        }
        if (limit.getNb() > userOrGroupList.size()) {
            userOrGroupList.addAll(this.getAllMatchedLocalUsersOrGroups(user, matchFields, withdetails, new RequestLimit(limit.getNb() - userOrGroupList.size(), newstart), order, context));
        } else if (limit.getNb() <= 0) {
            userOrGroupList.addAll(this.getAllMatchedLocalUsersOrGroups(user, matchFields, withdetails, new RequestLimit(0, newstart), order, context));
        }
        return userOrGroupList;
    }

    public List<?> getAllMatchedGlobalUsersOrGroups(boolean user, Object[][] matchFields, boolean withdetails, RequestLimit limit, Object[][] order, XWikiContext context) throws XWikiException {
        if (context.isMainWiki()) {
            return this.getAllMatchedLocalUsersOrGroups(user, matchFields, withdetails, limit, order, context);
        }
        return this.getAllMatchedWikiUsersOrGroups(user, context.getMainXWiki(), matchFields, withdetails, limit, order, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getAllMatchedWikiUsersOrGroups(boolean user, String wikiName, Object[][] matchFields, boolean withdetails, RequestLimit limit, Object[][] order, XWikiContext context) throws XWikiException {
        if (context.isMainWiki()) {
            return this.getAllMatchedLocalUsersOrGroups(user, matchFields, withdetails, limit, order, context);
        }
        String database = context.getWikiId();
        try {
            context.setWikiId(wikiName);
            List<?> localGroupList = this.getAllMatchedLocalUsersOrGroups(user, matchFields, withdetails, limit, order, context);
            if (localGroupList != null && !withdetails) {
                ArrayList wikiGroupList = new ArrayList(localGroupList.size());
                for (Object groupName : localGroupList) {
                    wikiGroupList.add(wikiName + WIKIFULLNAME_SEP + String.valueOf(groupName));
                }
                localGroupList = wikiGroupList;
            }
            List<?> list = localGroupList;
            return list;
        }
        finally {
            context.setWikiId(database);
        }
    }

    public List<?> getAllMatchedLocalUsersOrGroups(boolean user, Object[][] matchFields, boolean withdetails, RequestLimit limit, Object[][] order, XWikiContext context) throws XWikiException {
        if (user) {
            return context.getWiki().getGroupService(context).getAllMatchedUsers(matchFields, withdetails, limit.getNb(), limit.getStart(), order, context);
        }
        return context.getWiki().getGroupService(context).getAllMatchedGroups(matchFields, withdetails, limit.getNb(), limit.getStart(), order, context);
    }

    @Deprecated
    public Collection<String> getAllGroupsNamesForMember(String member, int nb, int start, XWikiContext context) throws XWikiException {
        return context.getWiki().getGroupService(context).getAllGroupsNamesForMember(member, nb, start, context);
    }

    @Deprecated
    public Collection<String> getAllMembersNamesForGroup(String group, int nb, int start, XWikiContext context) throws XWikiException {
        return context.getWiki().getGroupService(context).getAllMembersNamesForGroup(group, nb, start, context);
    }

    public Collection<String> getAllMatchedMembersNamesForGroup(String group, String matchField, int nb, int start, Boolean orderAsc, XWikiContext context) throws XWikiException {
        return context.getWiki().getGroupService(context).getAllMatchedMembersNamesForGroup(group, matchField, nb, start, orderAsc, context);
    }

    public int countAllMatchedMembersNamesForGroup(String group, String filter, XWikiContext xcontext) throws XWikiException {
        return xcontext.getWiki().getGroupService(xcontext).countAllMatchedMembersNamesForGroup(group, filter, xcontext);
    }

    @Deprecated
    public int countAllGroupsNamesForMember(String member, XWikiContext context) throws XWikiException {
        return context.getWiki().getGroupService(context).countAllGroupsNamesForMember(member, context);
    }

    @Deprecated
    public int countAllMembersNamesForGroup(String group, XWikiContext context) throws XWikiException {
        return context.getWiki().getGroupService(context).countAllMembersNamesForGroup(group, context);
    }

    private Map<String, LevelTree> getLevelTreeMap(XWikiDocument preferences, List<String> levelsToMatch, boolean global, XWikiContext context) throws XWikiException {
        HashMap<String, LevelTree> rightsMap = new HashMap<String, LevelTree>();
        this.fillLevelTreeMap(rightsMap, preferences, levelsToMatch, global, true, context);
        return rightsMap;
    }

    public Map<String, LevelTree> getLevelTreeMap(String spaceOrPage, List<String> levelsToMatch, XWikiContext context) throws XWikiException {
        XWikiDocument preferences = this.getXWikiPreferencesDoc(spaceOrPage, context);
        return this.getLevelTreeMap(preferences, levelsToMatch, this.isGlobal(preferences, spaceOrPage), context);
    }

    private void fillLevelTreeMap(Map<String, LevelTree> rightsMap, List<String> levelInherited, BaseObject bobj, List<String> levelsToMatch, boolean direct, XWikiContext context) {
        List<String> users = ListClass.getListFromString(bobj.getStringValue(RIGHTSFIELD_USERS), RIGHTSLISTFIELD_SEP, false);
        List<String> groups = ListClass.getListFromString(bobj.getStringValue(RIGHTSFIELD_GROUPS), RIGHTSLISTFIELD_SEP, false);
        List<String> levels = ListClass.getListFromString(bobj.getStringValue(RIGHTSFIELD_LEVELS), RIGHTSLISTFIELD_SEP, false);
        boolean allow = bobj.getIntValue(RIGHTSFIELD_ALLOW) == 1;
        for (String levelName : levels) {
            AllowDeny allowdeny;
            LevelTree level;
            if (levelsToMatch != null && !levelsToMatch.contains(levelName)) continue;
            if (!rightsMap.containsKey(levelName)) {
                level = new LevelTree();
                rightsMap.put(levelName, level);
            } else {
                level = rightsMap.get(levelName);
            }
            if (direct) {
                if (levelInherited != null) {
                    levelInherited.add(levelName);
                }
                if (level.direct == null) {
                    level.direct = new AllowDeny();
                }
                allowdeny = level.direct;
            } else {
                if (level.inherited == null) {
                    level.inherited = new AllowDeny();
                }
                allowdeny = level.inherited;
            }
            UsersGroups usersgroups = allow ? allowdeny.allow : allowdeny.deny;
            usersgroups.users.addAll(users);
            usersgroups.groups.addAll(groups);
        }
    }

    private void fillLevelTreeMapInherited(Map<String, LevelTree> rightsMap, List<String> levelInheritedIn, XWikiDocument preferences, List<String> levelsToMatch, boolean global, XWikiContext context) throws XWikiException {
        List<String> levelInherited = levelInheritedIn;
        XWikiDocument parentPreferences = this.getParentPreference(preferences, global, context);
        if (parentPreferences != null) {
            if (levelInherited == null) {
                levelInherited = new ArrayList<String>();
            }
            for (String levelName : levelsToMatch) {
                if (rightsMap.containsKey(levelName) && rightsMap.get((Object)levelName).inherited != null) continue;
                levelInherited.add(levelName);
            }
            if (!levelInherited.isEmpty()) {
                this.fillLevelTreeMap(rightsMap, parentPreferences, levelInherited, true, false, context);
            }
        }
    }

    private void fillLevelTreeMap(Map<String, LevelTree> rightsMap, XWikiDocument preferences, List<String> levelsToMatch, boolean global, boolean direct, XWikiContext context) throws XWikiException {
        EntityReference rightClassReference;
        List<BaseObject> rightObjects;
        ArrayList<String> levelInherited = null;
        if (levelsToMatch == null) {
            levelInherited = new ArrayList<String>();
        }
        if (!preferences.isNew() && (rightObjects = preferences.getXObjects(rightClassReference = global ? XWikiRightServiceImpl.GLOBALRIGHTCLASS_REFERENCE : XWikiRightServiceImpl.RIGHTCLASS_REFERENCE)) != null) {
            for (BaseObject bobj : rightObjects) {
                this.fillLevelTreeMap(rightsMap, levelInherited, bobj, levelsToMatch, direct, context);
            }
        }
        this.fillLevelTreeMapInherited(rightsMap, levelInherited, preferences, levelsToMatch, global, context);
    }

    public XWikiDocument getParentPreference(XWikiDocument currentPreference, boolean currentGlobal, XWikiContext context) throws XWikiException {
        XWikiDocument parentPreferences = null;
        if (currentGlobal) {
            String parentspace;
            if (currentPreference.getFullName().equals(WIKI_PREFERENCES)) {
                if (!context.isMainWiki()) {
                    parentPreferences = context.getWiki().getDocument(context.getMainXWiki() + ":XWiki.XWikiPreferences", context);
                }
            } else if (currentPreference.getName().equals(SPACE_PREFERENCES) && (parentPreferences = (parentspace = currentPreference.getStringValue(WIKI_PREFERENCES, "parent")).trim().length() > 0 ? context.getWiki().getDocument(parentspace + ".WebPreferences", context) : context.getWiki().getDocument(WIKI_PREFERENCES, context)) == currentPreference) {
                parentPreferences = null;
            }
        } else {
            parentPreferences = context.getWiki().getDocument(currentPreference.getSpace() + ".WebPreferences", context);
        }
        return parentPreferences;
    }

    public XWikiDocument getParentPreference(String spaceOrPage, XWikiContext context) throws XWikiException {
        XWikiDocument preferences = this.getXWikiPreferencesDoc(spaceOrPage, context);
        boolean global = this.isGlobal(preferences, spaceOrPage);
        return this.getParentPreference(preferences, global, context);
    }

    private LevelTree getLevel(XWikiDocument doc, String levelName, boolean global, XWikiContext context) throws XWikiException {
        if (doc.isNew()) {
            return null;
        }
        ArrayList<String> rights = new ArrayList<String>();
        rights.add(levelName);
        Map<String, LevelTree> rightsMap = this.getLevelTreeMap(doc, rights, global, context);
        return rightsMap.get(levelName);
    }

    private XWikiDocument getXWikiPreferencesDoc(String spaceOrPage, XWikiContext context) throws XWikiException {
        XWikiDocument xwikidoc = null;
        if (spaceOrPage != null) {
            xwikidoc = context.getWiki().getDocument(spaceOrPage, context);
            if (xwikidoc.isNew()) {
                xwikidoc = context.getWiki().getDocument(spaceOrPage + ".WebPreferences", context);
            }
        } else {
            xwikidoc = context.getWiki().getDocument(WIKI_PREFERENCES, context);
        }
        return xwikidoc;
    }

    private boolean isGlobal(XWikiDocument preferences, String spaceOrPage) {
        return !preferences.getFullName().equals(spaceOrPage);
    }

    public LevelTree getTreeLevel(String spaceOrPage, String levelName, XWikiContext context) throws XWikiException {
        XWikiDocument preferences = this.getXWikiPreferencesDoc(spaceOrPage, context);
        return this.getLevel(preferences, levelName, this.isGlobal(preferences, spaceOrPage), context);
    }

    public void removeUserOrGroupFromLevel(String spaceOrPage, String userOrGroup, boolean user, String levelName, boolean allow, String comment, XWikiContext context) throws XWikiException {
        XWikiDocument preferences = this.getXWikiPreferencesDoc(spaceOrPage, context);
        boolean global = this.isGlobal(preferences, spaceOrPage);
        EntityReference rightClassReference = global ? XWikiRightServiceImpl.GLOBALRIGHTCLASS_REFERENCE : XWikiRightServiceImpl.RIGHTCLASS_REFERENCE;
        boolean needUpdate = false;
        List<BaseObject> rightObjects = preferences.getXObjects(rightClassReference);
        if (rightObjects != null) {
            for (BaseObject bobj : rightObjects) {
                List<String> levels = ListClass.getListFromString(bobj.getStringValue(RIGHTSFIELD_LEVELS), RIGHTSLISTFIELD_SEP, false);
                if (!levels.contains(levelName)) continue;
                needUpdate |= this.removeUserOrGroupFromRight(bobj, null, null, userOrGroup, user, context);
            }
            if (needUpdate) {
                context.getWiki().saveDocument(preferences, comment, context);
            }
        }
    }

    public boolean removeUserOrGroupFromRight(BaseObject right, String userOrGroupWiki, String userOrGroupSpace, String userOrGroupName, boolean user, XWikiContext context) {
        boolean needUpdate = false;
        String userOrGroupField = this.getUserOrGroupField(user);
        List<String> usersOrGroups = ListClass.getListFromString(right.getLargeStringValue(userOrGroupField), USERGROUPLISTFIELD_SEP, false);
        if (userOrGroupWiki != null) {
            needUpdate |= usersOrGroups.remove(userOrGroupWiki + WIKIFULLNAME_SEP + userOrGroupName);
        }
        if (context.getWikiId() == null || context.getWikiId().equalsIgnoreCase(userOrGroupWiki)) {
            needUpdate |= usersOrGroups.remove(userOrGroupName);
            if (userOrGroupSpace == null || userOrGroupSpace.equals(DEFAULT_USERORGROUP_SPACE)) {
                needUpdate |= usersOrGroups.remove(userOrGroupSpace + SPACEPAGENAME_SEP + userOrGroupName);
            }
        }
        if (needUpdate) {
            right.setLargeStringValue(userOrGroupField, ListClass.getStringFromList(usersOrGroups, USERGROUPLISTFIELD_SEP));
        }
        return needUpdate;
    }

    private String getUserOrGroupField(boolean user) {
        return user ? RIGHTSFIELD_USERS : RIGHTSFIELD_GROUPS;
    }

    public boolean removeUserOrGroupFromRights(XWikiDocument rightsDocument, String userOrGroupWiki, String userOrGroupSpace, String userOrGroupName, boolean user, boolean global, XWikiContext context) {
        boolean needUpdate = false;
        EntityReference rightClassReference = global ? XWikiRightServiceImpl.GLOBALRIGHTCLASS_REFERENCE : XWikiRightServiceImpl.RIGHTCLASS_REFERENCE;
        List<BaseObject> rightObjects = rightsDocument.getXObjects(rightClassReference);
        if (rightObjects != null) {
            for (BaseObject bobj : rightObjects) {
                if (bobj == null || !(needUpdate |= this.removeUserOrGroupFromRight(bobj, userOrGroupWiki, userOrGroupSpace, userOrGroupName, user, context)) || bobj.getLargeStringValue(RIGHTSFIELD_USERS).trim().length() != 0 || bobj.getLargeStringValue(RIGHTSFIELD_GROUPS).trim().length() != 0) continue;
                rightsDocument.removeXObject(bobj);
            }
        }
        return needUpdate;
    }

    public boolean removeUserOrGroupFromAllRights(XWikiDocument rightsDocument, String userOrGroupWiki, String userOrGroupSpace, String userOrGroupName, boolean user, XWikiContext context) {
        return this.removeUserOrGroupFromRights(rightsDocument, userOrGroupWiki, userOrGroupSpace, userOrGroupName, user, true, context) || this.removeUserOrGroupFromRights(rightsDocument, userOrGroupWiki, userOrGroupSpace, userOrGroupName, user, false, context);
    }

    public void removeUserOrGroupFromAllRights(String userOrGroupWiki, String userOrGroupSpace, String userOrGroupName, boolean user, XWikiContext context) throws XWikiException {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String fieldName = user ? RIGHTSFIELD_USERS : RIGHTSFIELD_GROUPS;
        BaseClass rightClass = context.getWiki().getRightsClass(context);
        BaseClass globalRightClass = context.getWiki().getGlobalRightsClass(context);
        String fieldTypeName = ((PropertyClass)rightClass.get(fieldName)).newProperty().getClass().getSimpleName();
        String where = String.format(ALL_RIGHTS_QUERY, fieldTypeName);
        parameterValues.add(rightClass.getName());
        parameterValues.add(globalRightClass.getName());
        parameterValues.add(fieldName);
        if (context.getWikiId() == null || context.getWikiId().equalsIgnoreCase(userOrGroupWiki)) {
            if (userOrGroupSpace == null || userOrGroupSpace.equals(DEFAULT_USERORGROUP_SPACE)) {
                parameterValues.add(HQLLIKE_ALL_SYMBOL + userOrGroupName + HQLLIKE_ALL_SYMBOL);
            } else {
                parameterValues.add(HQLLIKE_ALL_SYMBOL + userOrGroupSpace + SPACEPAGENAME_SEP + userOrGroupName + HQLLIKE_ALL_SYMBOL);
            }
        } else {
            parameterValues.add(HQLLIKE_ALL_SYMBOL + userOrGroupWiki + WIKIFULLNAME_SEP + userOrGroupName + HQLLIKE_ALL_SYMBOL);
        }
        List<XWikiDocument> documentList = context.getWiki().getStore().searchDocuments(where, parameterValues, context);
        for (XWikiDocument groupDocument : documentList) {
            XWikiDocument clonedDocument = groupDocument.clone();
            if (!this.removeUserOrGroupFromAllRights(clonedDocument, userOrGroupWiki, userOrGroupSpace, userOrGroupName, user, context)) continue;
            context.getWiki().saveDocument(clonedDocument, context);
        }
    }

    private boolean replaceUserOrGroupFromRight(BaseObject right, DocumentReference userOrGroupSourceReference, DocumentReference userOrGroupTargetReference, boolean user) {
        boolean needUpdate = false;
        String userOrGroupField = this.getUserOrGroupField(user);
        List<String> usersOrGroups = ListClass.getListFromString(right.getLargeStringValue(userOrGroupField), USERGROUPLISTFIELD_SEP, false);
        String userOrGroupSource = (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)userOrGroupSourceReference, new Object[0]);
        String userOrGroupTarget = (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)userOrGroupTargetReference, new Object[0]);
        if (usersOrGroups.remove(userOrGroupSource)) {
            usersOrGroups.add(userOrGroupTarget);
            needUpdate = true;
        }
        if (needUpdate) {
            right.setLargeStringValue(userOrGroupField, ListClass.getStringFromList(usersOrGroups, USERGROUPLISTFIELD_SEP));
        }
        return needUpdate;
    }

    private boolean replaceUserOrGroupFromRights(XWikiDocument rightsDocument, DocumentReference userOrGroupSourceReference, DocumentReference userOrGroupTargetReference, boolean user, boolean global) {
        boolean needUpdate = false;
        EntityReference rightClassReference = global ? XWikiRightServiceImpl.GLOBALRIGHTCLASS_REFERENCE : XWikiRightServiceImpl.RIGHTCLASS_REFERENCE;
        List<BaseObject> rightObjects = rightsDocument.getXObjects(rightClassReference);
        if (rightObjects != null) {
            for (BaseObject bobj : rightObjects) {
                if (bobj == null) continue;
                needUpdate |= this.replaceUserOrGroupFromRight(bobj, userOrGroupSourceReference, userOrGroupTargetReference, user);
            }
        }
        return needUpdate;
    }

    private boolean replaceUserOrGroupFromAllRights(XWikiDocument rightsDocument, DocumentReference userOrGroupSourceReference, DocumentReference userOrGroupTargetReference, boolean user) {
        return this.replaceUserOrGroupFromRights(rightsDocument, userOrGroupSourceReference, userOrGroupTargetReference, user, true) || this.replaceUserOrGroupFromRights(rightsDocument, userOrGroupSourceReference, userOrGroupTargetReference, user, false);
    }

    public void replaceUserOrGroupFromAllRights(DocumentReference userOrGroupSourceReference, DocumentReference userOrGroupTargetReference, boolean user, XWikiContext context) throws XWikiException {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String fieldName = user ? RIGHTSFIELD_USERS : RIGHTSFIELD_GROUPS;
        BaseClass rightClass = context.getWiki().getRightsClass(context);
        BaseClass globalRightClass = context.getWiki().getGlobalRightsClass(context);
        String fieldTypeName = ((PropertyClass)rightClass.get(fieldName)).newProperty().getClass().getSimpleName();
        String where = String.format(ALL_RIGHTS_QUERY, fieldTypeName);
        parameterValues.add((String)this.localEntityReferenceSerializer.serialize((EntityReference)rightClass.getReference(), new Object[0]));
        parameterValues.add((String)this.localEntityReferenceSerializer.serialize((EntityReference)globalRightClass.getReference(), new Object[0]));
        parameterValues.add(fieldName);
        parameterValues.add(HQLLIKE_ALL_SYMBOL + (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)userOrGroupSourceReference, new Object[0]) + HQLLIKE_ALL_SYMBOL);
        List<XWikiDocument> documentList = context.getWiki().getStore().searchDocuments(where, parameterValues, context);
        for (XWikiDocument groupDocument : documentList) {
            XWikiDocument clonedDocument = groupDocument.clone();
            if (!this.replaceUserOrGroupFromAllRights(clonedDocument, userOrGroupSourceReference, userOrGroupTargetReference, user)) continue;
            context.getWiki().saveDocument(clonedDocument, context);
        }
    }

    public void removeDirectRights(String spaceOrPage, List<String> levelNames, String comment, XWikiContext context) throws XWikiException {
        XWikiDocument preferences;
        boolean global = this.isGlobal(preferences = this.getXWikiPreferencesDoc(spaceOrPage, context), spaceOrPage);
        EntityReference rightClassReference = global ? XWikiRightServiceImpl.GLOBALRIGHTCLASS_REFERENCE : XWikiRightServiceImpl.RIGHTCLASS_REFERENCE;
        List<BaseObject> rightObjects = preferences.getXObjects(rightClassReference);
        if (rightObjects != null && !rightObjects.isEmpty()) {
            preferences = preferences.clone();
            preferences.removeXObjects(rightClassReference);
            context.getWiki().saveDocument(preferences, comment, context);
        }
    }

    public boolean groupContainsMember(String groupName, String memberName, Map<String, Collection<String>> groupCacheIn, XWikiContext context) throws XWikiException {
        Collection<String> memberList;
        boolean found = false;
        Map<String, Collection<String>> groupCache = groupCacheIn;
        if (groupCache == null) {
            groupCache = new HashMap<String, Collection<String>>();
        }
        if ((memberList = groupCache.get(groupName)) == null) {
            memberList = context.getWiki().getGroupService(context).getAllMembersNamesForGroup(groupName, 0, 0, context);
            groupCache.put(groupName, memberList);
        }
        if (memberList.contains(memberName) || memberList.contains(context.getWikiId() + WIKIFULLNAME_SEP + memberName)) {
            found = true;
        } else {
            for (String groupMemberName : memberList) {
                if (!this.groupContainsMember(groupMemberName, memberName, groupCache, context)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public Collection<DocumentReference> resolveUsers(DocumentReference userOrGroup, XWikiContext context) throws XWikiException {
        LinkedHashSet<DocumentReference> userReferences = new LinkedHashSet<DocumentReference>();
        ReferenceUserIterator iterator = new ReferenceUserIterator(userOrGroup, this.explicitDocumentReferenceResolver, context);
        while (iterator.hasNext()) {
            userReferences.add((DocumentReference)iterator.next());
        }
        return userReferences;
    }

    public Collection<DocumentReference> resolveUsers(String userOrGroup, XWikiContext context) throws XWikiException {
        return this.resolveUsers(this.currentDocumentReferenceResolver.resolve((Object)userOrGroup, new Object[0]), context);
    }

    public Collection<DocumentReference> resolveUsers(List<String> referenceList, XWikiContext context) throws XWikiException {
        LinkedHashSet<DocumentReference> users = new LinkedHashSet<DocumentReference>();
        for (String reference : referenceList) {
            users.addAll(this.resolveUsers(reference, context));
        }
        return users;
    }
}

