/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.packaging;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import com.xpn.xwiki.internal.event.XARImportingEvent;
import com.xpn.xwiki.internal.xml.XMLWriter;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.packaging.DocumentFilter;
import com.xpn.xwiki.plugin.packaging.DocumentInfo;
import com.xpn.xwiki.plugin.packaging.ExcludeDocumentException;
import com.xpn.xwiki.plugin.packaging.PackageException;
import com.xpn.xwiki.web.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.json.JSONObject;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.QueryException;

@Deprecated
public class Package {
    public static final int OK = 0;
    public static final int Right = 1;
    public static final String DEFAULT_FILEEXT = "xml";
    public static final String XAR_FILENAME_ENCODING = "UTF-8";
    public static final String DefaultPackageFileName = "package.xml";
    public static final String DefaultPluginName = "package";
    private static final Logger LOGGER = LoggerFactory.getLogger(Package.class);
    private String name = "My package";
    private String description = "";
    private boolean installExtension = true;
    private String extensionId;
    private String version = "1.0.0";
    private String licence = "LGPL";
    private String authorName = "XWiki";
    private List<DocumentInfo> files = null;
    private List<DocumentInfo> customMappingFiles = null;
    private List<DocumentInfo> classFiles = null;
    private boolean backupPack = false;
    private boolean preserveVersion = false;
    private boolean withVersions = true;
    private List<DocumentFilter> documentFilters = new ArrayList<DocumentFilter>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.extensionId;
    }

    public void setId(String id) {
        this.extensionId = id;
    }

    @Deprecated
    public boolean isInstallExension() {
        return this.isInstallExtension();
    }

    public boolean isInstallExtension() {
        return this.installExtension;
    }

    @Deprecated
    public void setInstallExension(boolean installExension) {
        this.installExtension = installExension;
    }

    public void setInstallExtension(boolean installExtension) {
        this.installExtension = installExtension;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public void setExtensionId(String extensionId) {
        this.extensionId = extensionId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLicence() {
        return this.licence;
    }

    public void setLicence(String licence) {
        this.licence = licence;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public boolean isBackupPack() {
        return this.backupPack;
    }

    public void setBackupPack(boolean backupPack) {
        this.backupPack = backupPack;
    }

    public boolean hasBackupPackImportRights(XWikiContext context) {
        return this.isFarmAdmin(context);
    }

    public boolean isVersionPreserved() {
        return this.preserveVersion;
    }

    public void setPreserveVersion(boolean preserveVersion) {
        this.preserveVersion = preserveVersion;
    }

    public List<DocumentInfo> getFiles() {
        return this.files;
    }

    public List<DocumentInfo> getCustomMappingFiles() {
        return this.customMappingFiles;
    }

    public boolean isWithVersions() {
        return this.withVersions;
    }

    public void setWithVersions(boolean withVersions) {
        this.withVersions = withVersions;
    }

    public void addDocumentFilter(Object filter) throws PackageException {
        if (!(filter instanceof DocumentFilter)) {
            throw new PackageException(3, "Invalid Document Filter");
        }
        this.documentFilters.add((DocumentFilter)filter);
    }

    public Package() {
        this.files = new ArrayList<DocumentInfo>();
        this.customMappingFiles = new ArrayList<DocumentInfo>();
        this.classFiles = new ArrayList<DocumentInfo>();
    }

    public boolean add(XWikiDocument doc, int defaultAction, XWikiContext context) throws XWikiException {
        if (!context.getWiki().checkAccess("edit", doc, context)) {
            return false;
        }
        for (int i = 0; i < this.files.size(); ++i) {
            DocumentInfo di = this.files.get(i);
            if (!di.getFullName().equals(doc.getFullName()) || !di.getLanguage().equals(doc.getLanguage())) continue;
            if (defaultAction != -1) {
                di.setAction(defaultAction);
            }
            if (!doc.isNew()) {
                di.setDoc(doc);
            }
            return true;
        }
        doc = doc.clone();
        try {
            this.filter(doc, context);
            DocumentInfo docinfo = new DocumentInfo(doc);
            docinfo.setAction(defaultAction);
            this.files.add(docinfo);
            BaseClass bclass = doc.getXClass();
            if (bclass.getFieldList().size() > 0) {
                this.classFiles.add(docinfo);
            }
            if (bclass.getCustomMapping() != null) {
                this.customMappingFiles.add(docinfo);
            }
            return true;
        }
        catch (ExcludeDocumentException e) {
            LOGGER.info("Skip the document " + String.valueOf(doc.getDocumentReference()));
            return false;
        }
    }

    public boolean add(XWikiDocument doc, XWikiContext context) throws XWikiException {
        return this.add(doc, -1, context);
    }

    public boolean updateDoc(String docFullName, int action, XWikiContext context) throws XWikiException {
        XWikiDocument doc = new XWikiDocument();
        doc.setFullName(docFullName, context);
        return this.add(doc, action, context);
    }

    public boolean add(String docFullName, int DefaultAction, XWikiContext context) throws XWikiException {
        XWikiDocument doc = context.getWiki().getDocument(docFullName, context);
        this.add(doc, DefaultAction, context);
        List<String> languages = doc.getTranslationList(context);
        for (String language : languages) {
            if (language == null || language.equals("") || language.equals(doc.getDefaultLanguage())) continue;
            this.add(doc.getTranslatedDocument(language, context), DefaultAction, context);
        }
        return true;
    }

    public boolean add(String docFullName, String language, int DefaultAction, XWikiContext context) throws XWikiException {
        XWikiDocument doc = context.getWiki().getDocument(docFullName, context);
        if (language == null || language.equals("")) {
            this.add(doc, DefaultAction, context);
        } else {
            this.add(doc.getTranslatedDocument(language, context), DefaultAction, context);
        }
        return true;
    }

    public boolean add(String docFullName, XWikiContext context) throws XWikiException {
        return this.add(docFullName, -1, context);
    }

    public boolean add(String docFullName, String language, XWikiContext context) throws XWikiException {
        return this.add(docFullName, language, -1, context);
    }

    public void filter(XWikiDocument doc, XWikiContext context) throws ExcludeDocumentException {
        for (DocumentFilter docFilter : this.documentFilters) {
            docFilter.filter(doc, context);
        }
    }

    public String export(OutputStream os, XWikiContext context) throws IOException, XWikiException {
        if (this.files.size() == 0) {
            return "No Selected file";
        }
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(os);
        zos.setEncoding(XAR_FILENAME_ENCODING);
        zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        for (int i = 0; i < this.files.size(); ++i) {
            DocumentInfo docinfo = this.files.get(i);
            XWikiDocument doc = docinfo.getDoc();
            this.addToZip(doc, zos, this.withVersions, context);
        }
        this.addInfosToZip(zos, context);
        zos.finish();
        zos.flush();
        return "";
    }

    public String exportToDir(File dir, XWikiContext context) throws IOException, XWikiException {
        if (!dir.exists() && !dir.mkdirs()) {
            Object[] args = new Object[]{dir.toString()};
            throw new XWikiException(0, 4, "Error creating directory {0}", null, args);
        }
        for (int i = 0; i < this.files.size(); ++i) {
            DocumentInfo docinfo = this.files.get(i);
            XWikiDocument doc = docinfo.getDoc();
            this.addToDir(doc, dir, this.withVersions, context);
        }
        this.addInfosToDir(dir, context);
        return "";
    }

    public String Import(byte[] file, XWikiContext context) throws IOException, XWikiException {
        return this.Import(new ByteArrayInputStream(file), context);
    }

    public String Import(InputStream file, XWikiContext context) throws IOException, XWikiException {
        Document description = null;
        try {
            ZipArchiveEntry entry;
            ZipArchiveInputStream zis = new ZipArchiveInputStream(file, XAR_FILENAME_ENCODING, false);
            LinkedList<XWikiDocument> docsToLoad = new LinkedList<XWikiDocument>();
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || entry.getName().indexOf("META-INF") != -1) continue;
                if (entry.getName().compareTo(DefaultPackageFileName) == 0) {
                    description = this.fromXml((InputStream)new CloseShieldInputStream((InputStream)zis));
                    continue;
                }
                XWikiDocument doc = null;
                try {
                    doc = this.readFromXML((InputStream)new CloseShieldInputStream((InputStream)zis));
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to parse document [{}] from XML during import, thus it will not be installed. The error was: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
                    this.addToErrors(entry.getName().replaceAll("/", "."), context);
                    continue;
                }
                try {
                    this.filter(doc, context);
                    docsToLoad.add(doc);
                }
                catch (ExcludeDocumentException e) {
                    LOGGER.info("Skip the document '" + String.valueOf(doc.getDocumentReference()) + "'");
                }
            }
            if (description == null) {
                throw new PackageException(0, "Could not find the package definition");
            }
            for (XWikiDocument doc : docsToLoad) {
                if (this.documentExistInPackageFile(doc.getFullName(), doc.getLanguage(), description)) {
                    this.add(doc, context);
                    continue;
                }
                LOGGER.warn("document " + String.valueOf(doc.getDocumentReference()) + " does not exist in package definition. It will not be installed.");
                this.addToSkipped(doc.getFullName(), context);
            }
            this.updateFileInfos(description);
        }
        catch (DocumentException e) {
            throw new PackageException(0, "Error when reading the XML");
        }
        return "";
    }

    private boolean documentExistInPackageFile(String docName, String language, Document xml) {
        Element docFiles = xml.getRootElement();
        Element infosFiles = docFiles.element("files");
        List fileList = infosFiles.elements("file");
        for (Element el : fileList) {
            String tmpDocName = el.getStringValue();
            if (tmpDocName.compareTo(docName) != 0) continue;
            String tmpLanguage = el.attributeValue("language");
            if (tmpLanguage == null) {
                tmpLanguage = "";
            }
            if (tmpLanguage.compareTo(language) != 0) continue;
            return true;
        }
        return false;
    }

    private void updateFileInfos(Document xml) {
        Element docFiles = xml.getRootElement();
        Element infosFiles = docFiles.element("files");
        List fileList = infosFiles.elements("file");
        for (Element el : fileList) {
            String defaultAction = el.attributeValue("defaultAction");
            String language = el.attributeValue("language");
            if (language == null) {
                language = "";
            }
            String docName = el.getStringValue();
            this.setDocumentDefaultAction(docName, language, Integer.parseInt(defaultAction));
        }
    }

    private void setDocumentDefaultAction(String docName, String language, int defaultAction) {
        if (this.files == null) {
            return;
        }
        for (DocumentInfo docInfo : this.files) {
            if (!docInfo.getFullName().equals(docName) || !docInfo.getLanguage().equals(language)) continue;
            docInfo.setAction(defaultAction);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int testInstall(boolean isAdmin, XWikiContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Package test install");
        }
        int result = 0;
        try {
            if (this.files.size() == 0) {
                int n = result;
                return n;
            }
            result = this.files.get(0).testInstall(isAdmin, context);
            for (DocumentInfo docInfo : this.files) {
                int res = docInfo.testInstall(isAdmin, context);
                if (res >= result) continue;
                result = res;
            }
            int n = result;
            return n;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Package test install result " + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int install(XWikiContext context) throws XWikiException {
        boolean isAdmin = context.getWiki().getRightService().hasWikiAdminRights(context);
        if (this.testInstall(isAdmin, context) == 0) {
            this.setStatus(0, context);
            return 0;
        }
        boolean hasCustomMappings = false;
        for (DocumentInfo docinfo : this.customMappingFiles) {
            BaseClass bclass = docinfo.getDoc().getXClass();
            hasCustomMappings |= context.getWiki().getStore().injectCustomMapping(bclass, context);
        }
        if (hasCustomMappings) {
            context.getWiki().getStore().injectUpdatedCustomMappings(context);
        }
        int status = 2;
        boolean backup = this.backupPack && this.isFarmAdmin(context);
        ObservationManager om = Utils.getComponent(ObservationManager.class);
        om.notify((Event)new XARImportingEvent(), null, (Object)context);
        try {
            for (DocumentInfo classFile : this.classFiles) {
                if (this.installDocument(classFile, isAdmin, backup, context) != 4) continue;
                status = 4;
            }
            for (DocumentInfo docInfo : this.files) {
                if (this.classFiles.contains(docInfo) || this.installDocument(docInfo, isAdmin, backup, context) != 4) continue;
                status = 4;
            }
            this.setStatus(status, context);
        }
        finally {
            om.notify((Event)new XARImportedEvent(), null, (Object)context);
            this.registerExtension(context);
        }
        return status;
    }

    private void registerExtension(XWikiContext context) {
        if (this.isInstallExtension() && StringUtils.isNotEmpty((CharSequence)this.getExtensionId()) && StringUtils.isNotEmpty((CharSequence)this.getVersion())) {
            ExtensionId extensionId = new ExtensionId(this.getExtensionId(), this.getVersion());
            try {
                LocalExtensionRepository localRepository = Utils.getComponent(LocalExtensionRepository.class);
                LocalExtension localExtension = localRepository.getLocalExtension(extensionId);
                if (localExtension == null) {
                    Extension extension;
                    try {
                        extension = Utils.getComponent(ExtensionRepositoryManager.class).resolve(extensionId);
                    }
                    catch (ResolveException e) {
                        LOGGER.debug("Can't find extension [{}]", (Object)extensionId, (Object)e);
                        return;
                    }
                    localExtension = localRepository.storeExtension(extension);
                }
                InstalledExtensionRepository installedRepository = Utils.getComponent(InstalledExtensionRepository.class);
                String namespace = "wiki:" + context.getWikiId();
                if (installedRepository.getInstalledExtension(localExtension.getId().getId(), namespace) == null) {
                    for (ExtensionId feature : localExtension.getExtensionFeatures()) {
                        if (installedRepository.getInstalledExtension(feature.getId(), namespace) == null) continue;
                        return;
                    }
                } else {
                    return;
                }
                InstalledExtension installedExtension = installedRepository.installExtension(localExtension, namespace, false);
                Utils.getComponent(ObservationManager.class).notify((Event)new ExtensionInstalledEvent(installedExtension.getId(), namespace), (Object)installedExtension);
            }
            catch (Exception e) {
                LOGGER.error("Failed to register extenion [{}] from the XAR", (Object)extensionId, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFarmAdmin(XWikiContext context) {
        String wiki = context.getWikiId();
        try {
            context.setWikiId(context.getMainXWiki());
            boolean bl = context.getWiki().getRightService().hasWikiAdminRights(context);
            return bl;
        }
        finally {
            context.setWikiId(wiki);
        }
    }

    private int installDocument(DocumentInfo doc, boolean isAdmin, boolean backup, XWikiContext context) throws XWikiException {
        if (this.preserveVersion && this.withVersions) {
            this.withVersions = false;
        }
        int result = 2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Package installing document " + doc.getFullName() + " " + doc.getLanguage());
        }
        if (doc.getAction() == 1) {
            this.addToSkipped(doc.getFullName() + ":" + doc.getLanguage(), context);
            return 2;
        }
        int status = doc.testInstall(isAdmin, context);
        if (status == 0) {
            this.addToErrors(doc.getFullName() + ":" + doc.getLanguage(), context);
            return 0;
        }
        if (status == 2 || status == 1 && doc.getAction() == 0) {
            XWikiDocument previousdoc = null;
            if (status == 1) {
                block24: {
                    previousdoc = context.getWiki().getDocument(doc.getFullName(), context);
                    if (doc.getDoc().getTranslation() != 0) {
                        previousdoc = previousdoc.getTranslatedDocument(doc.getLanguage(), context);
                    }
                    if (!this.preserveVersion || this.withVersions) {
                        try {
                            context.getWiki().getStore().deleteXWikiDoc(previousdoc, context);
                        }
                        catch (Exception e) {
                            result = 4;
                            this.addToErrors(doc.getFullName() + ":" + doc.getLanguage(), context);
                            if (LOGGER.isErrorEnabled()) {
                                LOGGER.error("Failed to delete document " + String.valueOf(previousdoc.getDocumentReference()));
                            }
                            if (!LOGGER.isDebugEnabled()) break block24;
                            LOGGER.debug("Failed to delete document " + String.valueOf(previousdoc.getDocumentReference()), (Throwable)e);
                        }
                    } else if (previousdoc.hasElement(1)) {
                        List<XWikiAttachment> newDocAttachments = doc.getDoc().getAttachmentList();
                        for (XWikiAttachment att : previousdoc.getAttachmentList()) {
                            if (doc.getDoc().getAttachment(att.getFilename()) != null) continue;
                            newDocAttachments.add(att);
                            doc.getDoc().removeAttachment(att);
                        }
                    }
                }
                doc.getDoc().addXObjectsToRemoveFromVersion(previousdoc);
                doc.getDoc().setOriginalDocument(previousdoc);
            }
            try {
                boolean shouldResetToInitialVersion;
                if (!backup) {
                    doc.getDoc().setAuthorReference(context.getUserReference());
                    doc.getDoc().setContentAuthorReference(context.getUserReference());
                    Date date = new Date();
                    doc.getDoc().setDate(date);
                    doc.getDoc().setContentUpdateDate(date);
                }
                if (!this.withVersions) {
                    doc.getDoc().setVersion("1.1");
                }
                boolean isNewDocument = previousdoc == null;
                boolean conserveExistingHistory = this.preserveVersion && !isNewDocument;
                boolean packageHasHistory = this.documentContainsHistory(doc);
                boolean bl = shouldResetToInitialVersion = !isNewDocument && !conserveExistingHistory && (!this.withVersions || !packageHasHistory);
                if (conserveExistingHistory) {
                    doc.getDoc().setDocumentArchive(previousdoc.getDocumentArchive(context));
                } else if (shouldResetToInitialVersion) {
                    doc.getDoc().setContentDirty(false);
                    doc.getDoc().setMetaDataDirty(false);
                }
                String saveMessage = context.getMessageTool().get("core.importer.saveDocumentComment");
                context.getWiki().saveDocument(doc.getDoc(), saveMessage, context);
                this.addToInstalled(doc.getFullName() + ":" + doc.getLanguage(), context);
                if ((this.withVersions && packageHasHistory || conserveExistingHistory) && doc.getDoc().getDocumentArchive() != null) {
                    context.getWiki().getVersioningStore().saveXWikiDocArchive(doc.getDoc().getDocumentArchive(context), true, context);
                }
                if (shouldResetToInitialVersion) {
                    doc.getDoc().resetArchive(context);
                }
            }
            catch (XWikiException e) {
                this.addToErrors(doc.getFullName() + ":" + doc.getLanguage(), context);
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Failed to save document " + doc.getFullName(), (Throwable)e);
                }
                result = 4;
            }
        }
        return result;
    }

    private boolean documentContainsHistory(DocumentInfo doc) {
        return doc.getDoc().getDocumentArchive() != null && doc.getDoc().getDocumentArchive().getNodes() != null && doc.getDoc().getDocumentArchive().getNodes().size() != 0;
    }

    private List<String> getStringList(String name, XWikiContext context) {
        ArrayList list = (ArrayList)context.get(name);
        if (list == null) {
            list = new ArrayList();
            context.put(name, list);
        }
        return list;
    }

    private void addToErrors(String fullName, XWikiContext context) {
        if (fullName.endsWith(":")) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        this.getErrors(context).add(fullName);
    }

    private void addToSkipped(String fullName, XWikiContext context) {
        if (fullName.endsWith(":")) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        this.getSkipped(context).add(fullName);
    }

    private void addToInstalled(String fullName, XWikiContext context) {
        if (fullName.endsWith(":")) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        this.getInstalled(context).add(fullName);
    }

    private void setStatus(int status, XWikiContext context) {
        context.put("install_status", (Object)status);
    }

    public List<String> getErrors(XWikiContext context) {
        return this.getStringList("install_errors", context);
    }

    public List<String> getSkipped(XWikiContext context) {
        return this.getStringList("install_skipped", context);
    }

    public List<String> getInstalled(XWikiContext context) {
        return this.getStringList("install_installed", context);
    }

    public int getStatus(XWikiContext context) {
        Integer status = (Integer)context.get("install_status");
        if (status == null) {
            return -1;
        }
        return status;
    }

    private XWikiDocument readFromXML(InputStream is) throws XWikiException {
        XWikiDocument doc = new XWikiDocument();
        doc.fromXML(is, this.withVersions);
        return doc;
    }

    private XWikiDocument readFromXML(Document domDoc) throws XWikiException {
        XWikiDocument doc = new XWikiDocument();
        doc.fromXML(domDoc, this.withVersions);
        return doc;
    }

    public String toXml(XWikiContext context) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.toXML(baos, context);
            return baos.toString(context.getWiki().getEncoding());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void toXML(XMLWriter wr) throws IOException {
        DOMElement docel = new DOMElement(DefaultPluginName);
        wr.writeOpen((Element)docel);
        DOMElement elInfos = new DOMElement("infos");
        wr.write((Element)elInfos);
        DOMElement el = new DOMElement("name");
        el.addText(this.name);
        wr.write((Element)el);
        el = new DOMElement("description");
        el.addText(this.description);
        wr.write((Element)el);
        el = new DOMElement("licence");
        el.addText(this.licence);
        wr.write((Element)el);
        el = new DOMElement("author");
        el.addText(this.authorName);
        wr.write((Element)el);
        el = new DOMElement("version");
        el.addText(this.version);
        wr.write((Element)el);
        el = new DOMElement("backupPack");
        el.addText(new Boolean(this.backupPack).toString());
        wr.write((Element)el);
        el = new DOMElement("preserveVersion");
        el.addText(new Boolean(this.preserveVersion).toString());
        wr.write((Element)el);
        DOMElement elfiles = new DOMElement("files");
        wr.writeOpen((Element)elfiles);
        for (DocumentInfo docInfo : this.files) {
            DOMElement elfile = new DOMElement("file");
            elfile.addAttribute("defaultAction", String.valueOf(docInfo.getAction()));
            elfile.addAttribute("language", String.valueOf(docInfo.getLanguage()));
            elfile.addText(docInfo.getFullName());
            wr.write((Element)elfile);
        }
    }

    public void toXML(OutputStream out, XWikiContext context) throws IOException {
        XMLWriter wr = new XMLWriter(out, new OutputFormat("", true, context.getWiki().getEncoding()));
        DOMDocument doc = new DOMDocument();
        wr.writeDocumentStart((Document)doc);
        this.toXML(wr);
        wr.writeDocumentEnd((Document)doc);
    }

    private void addInfosToZip(ZipArchiveOutputStream zos, XWikiContext context) {
        try {
            String zipname = DefaultPackageFileName;
            ZipArchiveEntry zipentry = new ZipArchiveEntry(zipname);
            zos.putArchiveEntry(zipentry);
            this.toXML((OutputStream)zos, context);
            zos.closeArchiveEntry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPathFromDocument(XWikiDocument doc, XWikiContext context) {
        return this.getDirectoryForDocument(doc) + this.getFileNameFromDocument(doc, context);
    }

    public String getFileNameFromDocument(XWikiDocument doc, XWikiContext context) {
        StringBuilder fileName = new StringBuilder(doc.getDocumentReference().getName());
        String language = doc.getLanguage();
        if (language != null && !language.equals("")) {
            fileName.append(".");
            fileName.append(language);
        }
        fileName.append('.').append(DEFAULT_FILEEXT);
        return fileName.toString();
    }

    public String getDirectoryForDocument(XWikiDocument doc) {
        StringBuilder path = new StringBuilder();
        for (SpaceReference space : doc.getDocumentReference().getSpaceReferences()) {
            path.append(space.getName()).append('/');
        }
        return path.toString();
    }

    @Deprecated
    public void addToZip(XWikiDocument doc, ZipOutputStream zos, boolean withVersions, XWikiContext context) throws XWikiException, IOException {
        String zipname = this.getPathFromDocument(doc, context);
        ZipEntry zipentry = new ZipEntry(zipname);
        zos.putNextEntry(zipentry);
        doc.toXML(zos, true, false, true, withVersions, context);
        zos.closeEntry();
    }

    private void addToZip(XWikiDocument doc, ZipArchiveOutputStream zos, boolean withVersions, XWikiContext context) throws XWikiException, IOException {
        String zipname = this.getPathFromDocument(doc, context);
        ZipArchiveEntry zipentry = new ZipArchiveEntry(zipname);
        zos.putArchiveEntry(zipentry);
        doc.toXML((OutputStream)zos, true, false, true, withVersions, context);
        zos.closeArchiveEntry();
    }

    public void addToDir(XWikiDocument doc, File dir, boolean withVersions, XWikiContext context) throws XWikiException {
        try {
            this.filter(doc, context);
            File spacedir = new File(dir, this.getDirectoryForDocument(doc));
            if (!spacedir.exists() && !spacedir.mkdirs()) {
                Object[] args = new Object[]{dir.toString()};
                throw new XWikiException(0, 4, "Error creating directory {0}", null, args);
            }
            String filename = this.getFileNameFromDocument(doc, context);
            File file = new File(spacedir, filename);
            FileOutputStream fos = new FileOutputStream(file);
            doc.toXML(fos, true, false, true, withVersions, context);
            fos.flush();
            fos.close();
        }
        catch (ExcludeDocumentException e) {
            LOGGER.info("Skip the document " + String.valueOf(doc.getDocumentReference()));
        }
        catch (Exception e) {
            Object[] args = new Object[]{doc.getDocumentReference()};
            throw new XWikiException(2, 2001, "Error creating file {0}", e, args);
        }
    }

    private void addInfosToDir(File dir, XWikiContext context) {
        try {
            String filename = DefaultPackageFileName;
            File file = new File(dir, filename);
            FileOutputStream fos = new FileOutputStream(file);
            this.toXML(fos, context);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getElementText(Element docel, String name) {
        return this.getElementText(docel, name, "");
    }

    protected String getElementText(Element docel, String name, String def) {
        Element el = docel.element(name);
        if (el == null) {
            return def;
        }
        return el.getText();
    }

    protected Document fromXml(InputStream xml) throws DocumentException {
        SAXReader reader = this.getSAXReader();
        Document domdoc = reader.read(xml);
        Element docEl = domdoc.getRootElement();
        Element infosEl = docEl.element("infos");
        this.name = this.getElementText(infosEl, "name");
        this.description = this.getElementText(infosEl, "description");
        this.licence = this.getElementText(infosEl, "licence");
        this.authorName = this.getElementText(infosEl, "author");
        this.extensionId = this.getElementText(infosEl, "extensionId", null);
        this.version = this.getElementText(infosEl, "version");
        this.backupPack = new Boolean(this.getElementText(infosEl, "backupPack"));
        this.preserveVersion = new Boolean(this.getElementText(infosEl, "preserveVersion"));
        return domdoc;
    }

    public void addAllWikiDocuments(XWikiContext context) throws XWikiException {
        XWiki wiki = context.getWiki();
        try {
            List documentNames = wiki.getStore().getQueryManager().getNamedQuery("getAllDocuments").execute();
            for (String docName : documentNames) {
                this.add(docName, 0, context);
            }
        }
        catch (QueryException ex) {
            throw new PackageException(3223, "Cannot retrieve the list of documents to export", ex);
        }
    }

    public void deleteAllWikiDocuments(XWikiContext context) throws XWikiException {
        XWiki wiki = context.getWiki();
        List<String> spaces = wiki.getSpaces(context);
        for (int i = 0; i < spaces.size(); ++i) {
            List<String> docNameList = wiki.getSpaceDocsName(spaces.get(i), context);
            for (String docName : docNameList) {
                String docFullName = spaces.get(i) + "." + docName;
                XWikiDocument doc = wiki.getDocument(docFullName, context);
                wiki.deleteAllDocuments(doc, context);
            }
        }
    }

    public int readFromDir(File dir, XWikiContext context, Document description) throws IOException, XWikiException {
        File[] files = dir.listFiles();
        SAXReader reader = this.getSAXReader();
        int count = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                count += this.readFromDir(file, context, description);
                continue;
            }
            boolean validWikiDoc = false;
            Document domdoc = null;
            try {
                domdoc = reader.read((InputStream)new FileInputStream(file));
                validWikiDoc = XWikiDocument.containsXMLWikiDocument(domdoc);
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            if (validWikiDoc) {
                XWikiDocument doc = this.readFromXML(domdoc);
                try {
                    this.filter(doc, context);
                    if (this.documentExistInPackageFile(doc.getFullName(), doc.getLanguage(), description)) {
                        this.add(doc, context);
                        ++count;
                        continue;
                    }
                    throw new PackageException(0, "document " + String.valueOf(doc.getDocumentReference()) + " does not exist in package definition");
                }
                catch (ExcludeDocumentException e) {
                    LOGGER.info("Skip the document '" + String.valueOf(doc.getDocumentReference()) + "'");
                }
                continue;
            }
            if (file.getName().equals(DefaultPackageFileName)) continue;
            LOGGER.info(file.getAbsolutePath() + " is not a valid wiki document");
        }
        return count;
    }

    public String readFromDir(File dir, XWikiContext context) throws IOException, XWikiException {
        if (!dir.isDirectory()) {
            throw new PackageException(1, dir.getAbsolutePath() + " is not a directory");
        }
        int count = 0;
        try {
            File infofile = new File(dir, DefaultPackageFileName);
            Document description = this.fromXml(new FileInputStream(infofile));
            count = this.readFromDir(dir, context, description);
            this.updateFileInfos(description);
        }
        catch (DocumentException e) {
            throw new PackageException(1, "Error when reading the XML");
        }
        LOGGER.info("Package read " + count + " documents");
        return "";
    }

    public JSONObject toJSON(XWikiContext wikiContext) {
        HashMap json = new HashMap();
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("name", this.name);
        infos.put("description", this.description);
        infos.put("licence", this.licence);
        infos.put("author", this.authorName);
        infos.put("version", this.version);
        infos.put("backup", this.isBackupPack());
        HashMap files = new HashMap();
        for (DocumentInfo docInfo : this.files) {
            HashMap<String, String> fileInfos = new HashMap<String, String>();
            fileInfos.put("defaultAction", String.valueOf(docInfo.getAction()));
            fileInfos.put("language", String.valueOf(docInfo.getLanguage()));
            fileInfos.put("fullName", docInfo.getFullName());
            if (files.get(docInfo.getDoc().getSpace()) == null) {
                files.put(docInfo.getDoc().getSpace(), new HashMap());
            }
            if (((Map)files.get(docInfo.getDoc().getSpace())).get(docInfo.getDoc().getName()) == null) {
                ((Map)files.get(docInfo.getDoc().getSpace())).put(docInfo.getDoc().getName(), new ArrayList());
            }
            ((List)((Map)files.get(docInfo.getDoc().getSpace())).get(docInfo.getDoc().getName())).add(fileInfos);
        }
        json.put("infos", infos);
        json.put("files", files);
        JSONObject jsonObject = JSONObject.fromObject(json);
        return jsonObject;
    }

    private SAXReader getSAXReader() {
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return reader;
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to configure the XML parser to read XAR data", e);
        }
    }
}

