/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.fileupload;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.internal.fileupload.FileUploadUtils;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.fileupload.FileUploadPluginApi;
import com.xpn.xwiki.web.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.attachment.validation.AttachmentValidator;
import org.xwiki.environment.Environment;
import org.xwiki.text.StringUtils;

public class FileUploadPlugin
extends XWikiDefaultPlugin {
    public static final String PLUGIN_NAME = "fileupload";
    public static final String FILE_LIST_KEY = "fileuploadlist";
    public static final String UPLOAD_MAXSIZE_PARAMETER = "upload_maxsize";
    public static final long UPLOAD_DEFAULT_MAXSIZE = 0x2000000L;
    public static final String UPLOAD_SIZETHRESHOLD_PARAMETER = "upload_sizethreshold";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadPlugin.class);
    private static final long UPLOAD_DEFAULT_SIZETHRESHOLD = 100000L;
    private Environment environment;
    private String temporaryDirectory;
    private AttachmentValidator attachmentValidator;

    public FileUploadPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public void init(XWikiContext context) {
        super.init(context);
    }

    @Override
    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
    }

    @Override
    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new FileUploadPluginApi((FileUploadPlugin)plugin, context);
    }

    @Override
    public void endRendering(XWikiContext context) {
    }

    public void cleanFileList(XWikiContext context) {
        LOGGER.debug("Cleaning uploaded files");
        List<FileItem> fileuploadlist = this.getFileItems(context);
        if (fileuploadlist != null) {
            for (FileItem item : fileuploadlist) {
                try {
                    item.delete();
                }
                catch (Exception ex) {
                    LOGGER.warn("Exception cleaning uploaded files", (Throwable)ex);
                }
            }
            context.remove(FILE_LIST_KEY);
        }
    }

    public void loadFileList(XWikiContext context) throws XWikiException, AttachmentValidationException {
        XWiki xwiki = context.getWiki();
        this.loadFileList(xwiki.getSpacePreferenceAsLong(UPLOAD_MAXSIZE_PARAMETER, 0x2000000L, context), (int)xwiki.getSpacePreferenceAsLong(UPLOAD_SIZETHRESHOLD_PARAMETER, 100000L, context), this.getTemporaryDirectory(xwiki), context);
    }

    public void loadFileList(long uploadMaxSize, int uploadSizeThreshold, String tempdir, XWikiContext context) throws XWikiException, AttachmentValidationException {
        LOGGER.debug("Loading uploaded files");
        if (context.get(FILE_LIST_KEY) != null) {
            LOGGER.debug("Called loadFileList twice");
            return;
        }
        Collection<FileItem> fileItems = FileUploadUtils.getFileItems(uploadMaxSize, uploadSizeThreshold, tempdir, context.getRequest(), this.getAttachmentValidator());
        ArrayList<FileItem> items = fileItems instanceof List ? (ArrayList<FileItem>)fileItems : new ArrayList<FileItem>(fileItems);
        context.put(FILE_LIST_KEY, items);
    }

    public List<FileItem> getFileItems(XWikiContext context) {
        return (List)context.get(FILE_LIST_KEY);
    }

    public byte[] getFileItemData(String formfieldName, XWikiContext context) throws XWikiException {
        byte[] byArray;
        block11: {
            int size = this.getFileItemSize(formfieldName, context);
            if (size == 0) {
                return null;
            }
            InputStream fileis = this.getFileItemInputStream(formfieldName, context);
            try {
                byte[] data = new byte[size];
                if (fileis != null) {
                    IOUtils.readFully((InputStream)fileis, (byte[])data);
                }
                byArray = data;
                if (fileis == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fileis != null) {
                        try {
                            fileis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OutOfMemoryError e) {
                    throw new XWikiException(11, 11014, "Java Heap Space, Out of memory exception", e);
                }
                catch (IOException ie) {
                    throw new XWikiException(11, 11009, "Exception while reading uploaded parsed file", ie);
                }
            }
            fileis.close();
        }
        return byArray;
    }

    public InputStream getFileItemInputStream(String formfieldName, XWikiContext context) throws IOException {
        FileItem fileitem = this.getFile(formfieldName, context);
        if (fileitem == null) {
            return null;
        }
        return fileitem.getInputStream();
    }

    public int getFileItemSize(String formfieldName, XWikiContext context) {
        FileItem fileitem = this.getFile(formfieldName, context);
        if (fileitem == null) {
            return 0;
        }
        return (int)fileitem.getSize();
    }

    public String getFileItemAsString(String formfieldName, XWikiContext context) throws XWikiException {
        byte[] data = this.getFileItemData(formfieldName, context);
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    @Deprecated
    public String getFileItem(String formfieldName, XWikiContext context) throws XWikiException {
        return this.getFileItemAsString(formfieldName, context);
    }

    public List<String> getFileItemNames(XWikiContext context) {
        ArrayList<String> itemnames = new ArrayList<String>();
        List<FileItem> fileuploadlist = this.getFileItems(context);
        if (fileuploadlist == null) {
            return itemnames;
        }
        for (FileItem item : fileuploadlist) {
            itemnames.add(item.getFieldName());
        }
        return itemnames;
    }

    public String getFileName(String formfieldName, XWikiContext context) {
        FileItem fileitem = this.getFile(formfieldName, context);
        return fileitem == null ? null : FilenameUtils.getName((String)fileitem.getName());
    }

    public FileItem getFile(String formfieldName, XWikiContext context) {
        LOGGER.debug("Searching file uploaded for field " + formfieldName);
        List<FileItem> fileuploadlist = this.getFileItems(context);
        if (fileuploadlist == null) {
            return null;
        }
        FileItem fileitem = null;
        for (FileItem item : fileuploadlist) {
            if (!formfieldName.equals(item.getFieldName())) continue;
            fileitem = item;
            LOGGER.debug("Found uploaded file!");
            break;
        }
        return fileitem;
    }

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = Utils.getComponent(Environment.class);
        }
        return this.environment;
    }

    private AttachmentValidator getAttachmentValidator() {
        if (this.attachmentValidator == null) {
            this.attachmentValidator = Utils.getComponent(AttachmentValidator.class);
        }
        return this.attachmentValidator;
    }

    private String getTemporaryDirectory(XWiki xwiki) {
        if (this.temporaryDirectory == null) {
            String tmpDirectory = xwiki.Param("xwiki.upload.tempdir");
            File tmpDirectoryFile = StringUtils.isEmpty((CharSequence)tmpDirectory) ? new File(this.getEnvironment().getTemporaryDirectory(), "fileuploads") : new File(tmpDirectory);
            tmpDirectoryFile.mkdirs();
            this.temporaryDirectory = tmpDirectoryFile.getAbsolutePath();
        }
        return this.temporaryDirectory;
    }
}

