/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.pdf.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.pdf.XSLFORenderer;
import com.xpn.xwiki.pdf.api.PdfExport;
import com.xpn.xwiki.web.Utils;
import io.sf.carte.doc.dom4j.CSSStylableElement;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.nsac.InputSource;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.XMLReader;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.environment.Environment;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.xml.EntityResolver;
import org.xwiki.xml.XMLReaderFactory;
import org.xwiki.xml.XMLUtils;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;
import org.xwiki.xml.html.filter.HTMLFilter;

public class PdfExportImpl
implements PdfExport {
    private static final String DEFAULT_XHTML2FOP_XSLT = "xhtml2fo.xsl";
    private static final String DEFAULT_CLEANUP_XSLT = "fop.xsl";
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfExportImpl.class);
    private final DocumentReferenceResolver<String> referenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
    private final EntityReferenceSerializer<String> referenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
    private final DocumentAccessBridge dab = Utils.getComponent(DocumentAccessBridge.class);
    private final VelocityManager velocityManager = Utils.getComponent(VelocityManager.class);
    private final XMLReaderFactory xmlReaderFactory = Utils.getComponent(XMLReaderFactory.class);
    private final DocumentAuthorizationManager authorizationManager = Utils.getComponent(DocumentAuthorizationManager.class);
    private final AuthorExecutor authorExecutor = Utils.getComponent(AuthorExecutor.class);
    private final UserReferenceSerializer<DocumentReference> userReferenceSerializer = (UserReferenceSerializer)Utils.getComponent(UserReferenceSerializer.TYPE_DOCUMENT_REFERENCE, "document");
    private final Environment environment = (Environment)Utils.getComponent(Environment.class);
    private final XSLFORenderer xslFORenderer = Utils.getComponent(XSLFORenderer.class, "fop");

    @Override
    public void exportToPDF(XWikiDocument doc, OutputStream out, XWikiContext context) throws XWikiException {
        this.export(doc, out, PdfExport.ExportType.PDF, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(XWikiDocument doc, OutputStream out, PdfExport.ExportType type, XWikiContext context) throws XWikiException {
        File dir = this.environment.getTemporaryDirectory();
        File tempdir = new File(dir, RandomStringUtils.secure().nextAlphanumeric(8));
        try {
            FileUtils.forceMkdir((File)tempdir);
        }
        catch (IOException e) {
            throw new XWikiException(String.format("Failed to create PDF export temporary directory [%s]", tempdir), e);
        }
        try {
            boolean useLocalPlaceholders;
            context.put("pdfexportdir", tempdir);
            context.put("pdfexport-file-mapping", new HashMap());
            boolean bl = useLocalPlaceholders = !Utils.arePlaceholdersEnabled(context);
            if (useLocalPlaceholders) {
                Utils.enablePlaceholders(context);
            }
            String content = context.getWiki().parseTemplate("pdf.vm", context).trim();
            if (useLocalPlaceholders) {
                content = Utils.replacePlaceholders(content, context);
                Utils.disablePlaceholders(context);
            }
            this.exportHtml(content, out, type, context);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempdir);
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to cleanup temporary files after a PDF export", (Throwable)ex);
            }
        }
    }

    @Override
    public void exportHtml(String html, OutputStream out, PdfExport.ExportType type, XWikiContext context) throws XWikiException {
        this.exportXHTML(this.applyCSS(this.convertToStrictXHtml(html), context), out, type, context);
    }

    private String convertToStrictXHtml(String input2) {
        LOGGER.debug("Cleaning HTML:\n{}", (Object)input2);
        HTMLCleaner cleaner = Utils.getComponent(HTMLCleaner.class);
        HTMLCleanerConfiguration config = cleaner.getDefaultConfiguration();
        ArrayList<HTMLFilter> filters = new ArrayList<HTMLFilter>(config.getFilters());
        filters.add(Utils.getComponent(HTMLFilter.class, "uniqueId"));
        config.setFilters(filters);
        String result = HTMLUtils.toString((org.w3c.dom.Document)cleaner.clean((Reader)new StringReader(input2), config));
        LOGGER.debug("Cleaned XHTML:\n{}", (Object)result);
        return result;
    }

    protected void exportXHTML(String xhtml, OutputStream out, PdfExport.ExportType type, XWikiContext context) throws XWikiException {
        LOGGER.debug("Final XHTML for export:\n{}", (Object)xhtml);
        String xmlfo = this.convertXHtmlToXMLFO(xhtml, context);
        LOGGER.debug("Final XSL-FO source:\n{}", (Object)xmlfo);
        this.renderXSLFO(xmlfo, out, type, context);
    }

    private String convertXHtmlToXMLFO(String xhtml, XWikiContext context) throws XWikiException {
        String xmlfo = null;
        try (InputStream stream = this.getXhtml2FopXslt(context);){
            xmlfo = this.applyXSLT(xhtml, stream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to close the XSLT stream", (Throwable)e);
        }
        LOGGER.debug("Intermediary XSL-FO:\n{}", (Object)xmlfo);
        return this.applyXSLT(xmlfo, this.getFopCleanupXslt(context));
    }

    private void renderXSLFO(String xmlfo, OutputStream out, PdfExport.ExportType type, XWikiContext context) throws XWikiException {
        try {
            this.xslFORenderer.render(new ByteArrayInputStream(xmlfo.getBytes(StandardCharsets.UTF_8)), out, type.getMimeType());
        }
        catch (IllegalStateException e) {
            throw this.createException(e, type, 11011);
        }
        catch (Exception e) {
            throw this.createException(e, type, 12002);
        }
    }

    protected String applyXSLT(String xml, InputStream xslt) throws XWikiException {
        try {
            XMLReader xmlReader = Utils.getComponent(XMLReaderFactory.class).createXMLReader();
            xmlReader.setEntityResolver((org.xml.sax.EntityResolver)Utils.getComponent(EntityResolver.class));
            SAXSource xmlSource = new SAXSource(xmlReader, new org.xml.sax.InputSource(new StringReader(xml)));
            SAXSource xsltSource = new SAXSource(xmlReader, new org.xml.sax.InputSource(xslt));
            return XMLUtils.transform((Source)xmlSource, (Source)xsltSource);
        }
        catch (Exception e) {
            throw new XWikiException(12, 12003, "XSL Transformation Failed", e);
        }
    }

    private String applyCSS(String html, XWikiContext context) {
        Object css = context == null || context.getWiki() == null ? "" : context.getWiki().parseTemplate("pdf.css", context);
        String style = this.getPDFTemplateProperty("style", context);
        if (style != null) {
            css = (String)css + style;
        }
        return StringUtils.isBlank((CharSequence)css) ? html : this.applyCSS(html, (String)css, context);
    }

    String applyCSS(String html, String css, XWikiContext context) {
        LOGGER.debug("Applying the following CSS [{}] to HTML [{}]", (Object)css, (Object)html);
        try {
            StringReader re = new StringReader(html);
            org.xml.sax.InputSource source = new org.xml.sax.InputSource(re);
            XHTMLDocumentFactory docFactory = XHTMLDocumentFactory.getInstance();
            SAXReader reader = new SAXReader((DocumentFactory)docFactory);
            XMLReader xmlReader = this.xmlReaderFactory.createXMLReader();
            reader.setXMLReader(xmlReader);
            reader.setEntityResolver((org.xml.sax.EntityResolver)new DefaultEntityResolver());
            XHTMLDocument document = (XHTMLDocument)reader.read(source);
            document.setBaseURL(new URL(context.getDoc().getExternalURL("view", context)));
            document.addStyleSheet(new InputSource((Reader)new StringReader(css)));
            this.applyInlineStyle(document.getRootElement());
            OutputFormat outputFormat = new OutputFormat("", false);
            if (context == null || context.getWiki() == null) {
                outputFormat.setEncoding("UTF-8");
            } else {
                outputFormat.setEncoding(context.getWiki().getEncoding());
            }
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)out, outputFormat);
            writer.write((Document)document);
            String result = out.toString();
            LOGGER.debug("HTML with CSS applied [{}]", (Object)result);
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to apply CSS [{}] to HTML [{}]", new Object[]{css, html, e});
            return html;
        }
    }

    private void applyInlineStyle(Element element) {
        int nodeCount = element.nodeCount();
        for (int i = 0; i < nodeCount; ++i) {
            Node node = element.node(i);
            if (node.getNodeType() != 1) continue;
            CSSStylableElement styleElement = (CSSStylableElement)node;
            ComputedCSSStyle style = styleElement.getComputedStyle();
            if (style.getLength() != 0) {
                styleElement.addAttribute("style", style.getCssText());
            }
            this.applyInlineStyle((Element)styleElement);
        }
    }

    private InputStream getXhtml2FopXslt(XWikiContext context) {
        return this.getXslt("xhtmlxsl", DEFAULT_XHTML2FOP_XSLT, context);
    }

    private InputStream getFopCleanupXslt(XWikiContext context) {
        return this.getXslt("fopxsl", DEFAULT_CLEANUP_XSLT, context);
    }

    protected InputStream getXslt(String propertyName, String fallbackFile, XWikiContext context) {
        String xsl = this.getPDFTemplateProperty(propertyName, context);
        if (!StringUtils.isBlank((CharSequence)xsl)) {
            return IOUtils.toInputStream((String)xsl, (String)context.getWiki().getEncoding());
        }
        return this.getClass().getClassLoader().getResourceAsStream(fallbackFile);
    }

    private String getPDFTemplateProperty(String propertyName, XWikiContext context) {
        DocumentReference templateAuthorReference;
        DocumentReference classReference;
        DocumentReference templateReference;
        String pdftemplate = context.getRequest().getParameter("pdftemplate");
        if (StringUtils.isNotEmpty((CharSequence)pdftemplate)) {
            templateReference = this.referenceResolver.resolve((Object)pdftemplate, new Object[0]);
            classReference = new DocumentReference(templateReference.getWikiReference().getName(), "XWiki", "PDFClass");
        } else {
            templateReference = this.dab.getCurrentDocumentReference();
            String currentWiki = this.dab.getCurrentDocumentReference().getRoot().getName();
            classReference = new DocumentReference(currentWiki, "XWiki", "PDFClass");
        }
        String templateContent = (String)this.dab.getProperty(templateReference, classReference, propertyName);
        if (StringUtils.isBlank((CharSequence)templateContent)) {
            return "";
        }
        String templateName = (String)this.referenceSerializer.serialize((EntityReference)templateReference, new Object[0]);
        String result = templateContent;
        try {
            templateAuthorReference = (DocumentReference)this.userReferenceSerializer.serialize(this.dab.getDocumentInstance(templateReference).getAuthors().getEffectiveMetadataAuthor());
        }
        catch (Exception e) {
            LOGGER.warn("Error fetching the author of template [{}] during PDF conversion. Using the [{}] property of the document's value without applying Velocity.", (Object)templateName, (Object)propertyName);
            return result;
        }
        if (this.authorizationManager.hasAccess(Right.SCRIPT, EntityType.DOCUMENT, templateAuthorReference, templateReference)) {
            try {
                result = (String)this.authorExecutor.call(() -> {
                    StringWriter writer = new StringWriter();
                    VelocityContext vcontext = this.velocityManager.getVelocityContext();
                    this.velocityManager.getVelocityEngine().evaluate((Context)vcontext, (Writer)writer, templateName, templateContent);
                    return writer.toString();
                }, templateAuthorReference, templateReference);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to run Velocity engine in author executor. Using the [{}] property of the [{}] document's value without applying Velocity. Reason: [{}]", new Object[]{propertyName, templateName, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
        return result;
    }

    private XWikiException createException(Throwable source, PdfExport.ExportType exportType, int errorType) {
        return new XWikiException(12, errorType, "Exception while exporting " + exportType.getExtension(), source);
    }
}

