/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.pdf.impl;

import com.xpn.xwiki.XWikiContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceLoader;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.ResourceTypeResolver;
import org.xwiki.url.ExtendedURL;

@Component(roles={PDFResourceResolver.class})
@Singleton
public class PDFResourceResolver
implements ResourceResolver {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private ResourceReferenceResolver<ExtendedURL> resourceReferenceResolver;
    @Inject
    private ResourceTypeResolver<ExtendedURL> resourceTypeResolver;
    private ResourceResolver standardResolver = ResourceResolverFactory.createDefaultResourceResolver();

    public Resource getResource(URI uri) throws IOException {
        InputStream is;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        Resource result = null;
        ResourceReference resourceReference = this.buildTResourceReference(uri, xcontext);
        ResourceLoader resourceLoader = null;
        if (resourceReference != null) {
            try {
                resourceLoader = (ResourceLoader)((ComponentManager)this.componentManagerProvider.get()).getInstance((Type)new DefaultParameterizedType(null, ResourceLoader.class, new Type[]{resourceReference.getClass()}));
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
        if (resourceLoader != null && (is = resourceLoader.load(resourceReference)) != null) {
            result = new Resource(is);
        }
        if (result == null) {
            this.logger.debug("Fall-backing to the standard resolver for URI [{}]", (Object)uri);
            result = this.standardResolver.getResource(uri);
        }
        return result;
    }

    public OutputStream getOutputStream(URI uri) throws IOException {
        return this.standardResolver.getOutputStream(uri);
    }

    private ResourceReference buildTResourceReference(URI uri, XWikiContext xcontext) {
        ResourceReference result = null;
        if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
            try {
                ExtendedURL extendedURL = new ExtendedURL(uri.toURL(), xcontext.getRequest().getContextPath());
                ResourceType resourceType = this.resourceTypeResolver.resolve((Object)extendedURL, Collections.emptyMap());
                result = this.resourceReferenceResolver.resolve((Object)extendedURL, resourceType, Collections.emptyMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

