/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.EntityReference;

public class UsersClass
extends ListClass {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersClass.class);
    private static final String META_PROPERTY_USES_LIST = "usesList";
    private static final String COMMA = ",";

    public UsersClass(PropertyMetaClass metaClass) {
        super("userslist", "Users List", metaClass);
        this.setSize(20);
        this.setDisplayType("input");
        this.setPicker(true);
    }

    public UsersClass() {
        this(null);
    }

    @Override
    protected String getFirstSeparator() {
        return COMMA;
    }

    @Override
    public List<String> getList(XWikiContext context) {
        try {
            return context.getWiki().getGroupService(context).getAllMatchedUsers(null, false, 0, 0, null, context);
        }
        catch (XWikiException e) {
            LOGGER.warn("Failed to retrieve the list of users.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Map<String, ListItem> getMap(XWikiContext context) {
        Map<String, ListItem> result;
        List<String> users = this.getList(context);
        if (users != null && users.size() > 0) {
            result = new LinkedHashMap<String, ListItem>();
            for (String userName : users) {
                String prettyUserName = context.getWiki().getUserName(userName, null, false, context);
                result.put(userName, new ListItem(userName, prettyUserName));
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    @Deprecated
    public boolean isUsesList() {
        return this.getIntValue(META_PROPERTY_USES_LIST) == 1;
    }

    @Deprecated
    public void setUsesList(boolean usesList) {
        this.setIntValue(META_PROPERTY_USES_LIST, usesList ? 1 : 0);
    }

    @Override
    public BaseProperty newProperty() {
        LargeStringProperty property = new LargeStringProperty();
        property.setName(this.getName());
        return property;
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        BaseProperty prop = this.newProperty();
        prop.setValue(value);
        return prop;
    }

    @Override
    public BaseProperty fromStringArray(String[] strings) {
        List<String> list = strings.length == 1 && (this.getDisplayType().equals("input") || this.isMultiSelect()) ? UsersClass.getListFromString(strings[0], this.getSeparators(), false) : Arrays.asList(strings);
        BaseProperty prop = this.newProperty();
        this.fromList(prop, list);
        return prop;
    }

    @Override
    public void fromList(BaseProperty<?> property, List<String> list) {
        this.fromList(property, list, true);
    }

    public String getText(String value, XWikiContext context) {
        return context.getWiki().getUserName(value, null, false, context);
    }

    public static List<String> getListFromString(String value) {
        return UsersClass.getListFromString(value, COMMA, false, true);
    }

    @Override
    public BaseProperty newPropertyfromXML(Element ppcel) throws XWikiException {
        String value = ppcel.getText();
        return this.fromString(value);
    }

    @Override
    public List<String> toList(BaseProperty<?> property) {
        List<String> selectlist = property == null ? Collections.emptyList() : UsersClass.getListFromString((String)property.getValue());
        return selectlist;
    }

    @Override
    public <T extends EntityReference> void mergeProperty(BaseProperty<T> currentProperty, BaseProperty<T> previousProperty, BaseProperty<T> newProperty, MergeConfiguration configuration, XWikiContext xcontext, MergeResult mergeResult) {
        this.mergeNotOrderedListProperty(currentProperty, previousProperty, newProperty, configuration, xcontext, mergeResult);
    }
}

