/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.input;

public class StaticListClass
extends ListClass {
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "staticlist";

    public StaticListClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "Static List", wclass);
        this.setSeparators("|, ");
    }

    public StaticListClass() {
        this(null);
    }

    public String getValues() {
        return this.getStringValue("values");
    }

    public void setValues(String values) {
        this.setStringValue("values", values);
    }

    @Override
    public List<String> getList(XWikiContext context) {
        String sort = this.getSort();
        if (StringUtils.isEmpty((CharSequence)sort) || "none".equals(sort)) {
            return StaticListClass.getListFromString(this.getValues());
        }
        Map<String, ListItem> valuesMap = this.getMap(context);
        ArrayList<ListItem> values = new ArrayList<ListItem>(valuesMap.size());
        values.addAll(valuesMap.values());
        if ("id".equals(sort)) {
            Collections.sort(values, ListItem.ID_COMPARATOR);
        } else if ("value".equals(sort)) {
            Collections.sort(values, ListItem.VALUE_COMPARATOR);
        }
        ArrayList<String> result = new ArrayList<String>(values.size());
        for (ListItem value : values) {
            result.add(value.getId());
        }
        return result;
    }

    @Override
    public Map<String, ListItem> getMap(XWikiContext context) {
        String values = this.getValues();
        return StaticListClass.getMapFromString(values);
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        if (this.getDisplayType().equals("input")) {
            input input2 = new input();
            input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            BaseProperty prop = (BaseProperty)object.safeget(name);
            if (prop != null) {
                input2.setValue(this.toFormString(prop));
            }
            input2.setType("text");
            input2.setSize(this.getSize());
            input2.setName(prefix + name);
            input2.setID(prefix + name);
            input2.setDisabled(this.isDisabled());
            if (this.isPicker()) {
                input2.setClass("suggested");
                String path = "";
                XWiki xwiki = context.getWiki();
                path = xwiki.getURL("Main.WebHome", "view", context);
                String classname = this.getObject().getName();
                String fieldname = this.getName();
                String secondCol = "-";
                String firstCol = "-";
                String script = "\"" + path + "?xpage=suggest&classname=" + classname + "&fieldname=" + fieldname + "&firCol=" + firstCol + "&secCol=" + secondCol + "&\"";
                String varname = "\"input\"";
                String seps = "\"" + this.getSeparators() + "\"";
                if (this.isMultiSelect()) {
                    input2.setOnFocus("new ajaxSuggest(this, {script:" + script + ", varname:" + varname + ", seps:" + seps + "} )");
                } else {
                    input2.setOnFocus("new ajaxSuggest(this, {script:" + script + ", varname:" + varname + "} )");
                }
            }
            buffer.append(input2.toString());
        } else if (this.getDisplayType().equals("radio") || this.getDisplayType().equals("checkbox")) {
            this.displayRadioEdit(buffer, name, prefix, object, context);
        } else {
            this.displaySelectEdit(buffer, name, prefix, object, context);
            input hidden = new input("hidden", prefix + name, "");
            hidden.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            hidden.setDisabled(this.isDisabled());
            buffer.append(hidden);
        }
    }
}

