/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.StringClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordClass
extends StringClass {
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "password";
    protected static Logger LOGGER = LoggerFactory.getLogger(PasswordClass.class);
    protected static final String DEFAULT_STORAGE = "Hash";
    protected static final String DEFAULT_HASH_ALGORITHM = "SHA-512";
    protected static final String DEFAULT_CRYPT_ALGORITHM = "AES";
    protected static final String HASH_IDENTIFIER = "hash";
    protected static final String CRYPT_IDENTIFIER = "crypt";
    protected static final String SEPARATOR = ":";
    protected static final String FORM_PASSWORD_PLACEHODLER = "********";

    public PasswordClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "Password", wclass);
    }

    public PasswordClass() {
        this(null);
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        if (value.equals(FORM_PASSWORD_PLACEHODLER)) {
            return null;
        }
        BaseProperty property = this.newProperty();
        if (value.isEmpty() || value.startsWith("hash:") || value.startsWith("crypt:")) {
            property.setValue(value);
        } else {
            property.setValue(this.getProcessedPassword(value));
        }
        return property;
    }

    @Override
    public void displayHidden(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        PropertyInterface prop = object.safeget(name);
        if (prop != null) {
            buffer.append(FORM_PASSWORD_PLACEHODLER);
        }
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        input input2 = new input();
        input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop != null && !StringUtils.isEmpty((CharSequence)prop.toText())) {
            input2.setValue(FORM_PASSWORD_PLACEHODLER);
        }
        input2.setType(XCLASSNAME);
        input2.setName(prefix + name);
        input2.setID(prefix + name);
        input2.setSize(this.getSize());
        input2.setDisabled(this.isDisabled());
        buffer.append(input2.toString());
    }

    public String getStorageType() {
        String type;
        Object value;
        BaseProperty st = (BaseProperty)this.getField("storageType");
        if (st != null && (value = st.getValue()) != null && !(type = value.toString().trim()).equals("")) {
            return type;
        }
        return DEFAULT_STORAGE;
    }

    public void setStorageType(String storageType) {
        this.setStringValue("storageType", storageType);
    }

    public String getHashAlgorithm() {
        BaseProperty alg = (BaseProperty)this.getField("algorithm");
        if (alg != null && alg.getValue() != null && !alg.getValue().toString().trim().equals("")) {
            return alg.getValue().toString();
        }
        return DEFAULT_HASH_ALGORITHM;
    }

    public String getCryptAlgorithm() {
        BaseProperty alg = (BaseProperty)this.getField("algorithm");
        if (alg != null && alg.getValue() != null && !alg.getValue().toString().trim().equals("")) {
            return alg.getValue().toString();
        }
        return DEFAULT_CRYPT_ALGORITHM;
    }

    public String getAlgorithmFromPassword(String password) {
        int endIndex;
        int beginIndex = password.indexOf(SEPARATOR) + 1;
        if (beginIndex >= 0 && (endIndex = password.indexOf(SEPARATOR, beginIndex)) >= 0) {
            return password.substring(beginIndex, endIndex);
        }
        return DEFAULT_HASH_ALGORITHM;
    }

    public String getSaltFromPassword(String password) {
        String[] components = password.split(SEPARATOR);
        if (components.length == 4) {
            return components[2];
        }
        return "";
    }

    public String getEquivalentPassword(String storedPassword, String plainPassword) {
        String result = plainPassword;
        if (storedPassword != null && plainPassword != null) {
            if (storedPassword.startsWith("hash:")) {
                result = this.getPasswordHash(result, this.getAlgorithmFromPassword(storedPassword), this.getSaltFromPassword(storedPassword));
            } else if (storedPassword.startsWith("crypt:")) {
                result = this.getPasswordCrypt(result, this.getAlgorithmFromPassword(storedPassword));
            }
        }
        return result;
    }

    public String getProcessedPassword(String password) {
        String storageType = this.getStorageType();
        String result = password;
        if (storageType.equals(DEFAULT_STORAGE)) {
            result = this.getPasswordHash(result);
        } else if (storageType.equals("Encrypted")) {
            result = this.getPasswordCrypt(result);
        }
        return result;
    }

    public String getPasswordCrypt(String password) {
        return this.getPasswordCrypt(password, this.getCryptAlgorithm());
    }

    public String getPasswordCrypt(String password, String algorithmName) {
        return password;
    }

    public String getPasswordHash(String password) {
        return this.getPasswordHash(password, this.getHashAlgorithm(), null);
    }

    public String getPasswordHash(String password, String algorithmName) {
        return this.getPasswordHash(password, algorithmName, null);
    }

    public String getPasswordHash(String password, String algorithmName, String salt) {
        if (salt == null) {
            salt = PasswordClass.randomSalt();
        }
        try {
            LOGGER.debug("Hashing password");
            String saltedPassword = salt + password;
            MessageDigest hashAlgorithm = MessageDigest.getInstance(algorithmName);
            hashAlgorithm.update(saltedPassword.getBytes());
            byte[] digest = hashAlgorithm.digest();
            StringBuilder sb = new StringBuilder();
            sb.append(HASH_IDENTIFIER);
            sb.append(SEPARATOR);
            sb.append(algorithmName);
            sb.append(SEPARATOR);
            if (!salt.equals("")) {
                sb.append(salt);
                sb.append(SEPARATOR);
            }
            for (byte element : digest) {
                int b = element & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error("Wrong hash algorithm [{}] specified in property [{}] of class [{}]", new Object[]{algorithmName, this.getName(), this.getXClassReference(), ex});
        }
        catch (NullPointerException ex) {
            LOGGER.error("Error hashing password", (Throwable)ex);
        }
        return password;
    }

    public static String randomSalt() {
        StringBuilder salt = new StringBuilder();
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        for (byte temp : bytes) {
            Object s = Integer.toHexString(Byte.valueOf(temp).byteValue());
            while (((String)s).length() < 2) {
                s = "0" + (String)s;
            }
            s = ((String)s).substring(((String)s).length() - 2);
            salt.append((String)s);
        }
        return salt.toString();
    }
}

