/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.DBStringListProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.ListProperty;
import com.xpn.xwiki.objects.StringListProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.ListClassCompatibiityAspect;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.plugin.query.XWikiQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.dom4j.Element;
import org.hibernate.collection.spi.PersistentCollection;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.xml.XMLUtils;

public abstract class ListClass
extends PropertyClass {
    public static final String DISPLAYTYPE_INPUT = "input";
    public static final String DISPLAYTYPE_RADIO = "radio";
    public static final String DISPLAYTYPE_CHECKBOX = "checkbox";
    public static final String DISPLAYTYPE_SELECT = "select";
    public static final String DEFAULT_SEPARATOR = "|";
    public static final char SEPARATOR_ESCAPE = '\\';
    public static final String FREE_TEXT_DISCOURAGED = "discouraged";
    public static final String FREE_TEXT_FORBIDDEN = "forbidden";
    public static final String FREE_TEXT_ALLOWED = "allowed";
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "list";

    public ListClass(String name, String prettyname, PropertyMetaClass wclass) {
        super(name, prettyname, wclass);
        this.setRelationalStorage(false);
        this.setDisplayType(DISPLAYTYPE_SELECT);
        this.setMultiSelect(false);
        this.setSize(1);
        this.setSeparator(" ");
        this.setCache(false);
    }

    public ListClass(PropertyMetaClass wclass) {
        this(XCLASSNAME, "List", wclass);
    }

    public ListClass() {
        this(null);
    }

    public String getSeparators() {
        String separators = this.getStringValue("separators");
        if (separators == null || separators.equals("")) {
            separators = "|,";
        }
        return separators;
    }

    public void setSeparators(String separators) {
        this.setStringValue("separators", separators);
    }

    public String getDisplayType() {
        return this.getStringValue("displayType");
    }

    public void setDisplayType(String type) {
        this.setStringValue("displayType", type);
    }

    public String getSort() {
        return this.getStringValue("sort");
    }

    public void setSort(String sort) {
        this.setStringValue("sort", sort);
    }

    public int getSize() {
        return this.getIntValue("size");
    }

    public void setSize(int size) {
        this.setIntValue("size", size);
    }

    public boolean isCache() {
        return this.getIntValue("cache") == 1;
    }

    public void setCache(boolean cache) {
        this.setIntValue("cache", cache ? 1 : 0);
    }

    public boolean isMultiSelect() {
        return this.getIntValue("multiSelect") == 1;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.setIntValue("multiSelect", multiSelect ? 1 : 0);
    }

    public boolean isRelationalStorage() {
        return this.getIntValue("relationalStorage") == 1;
    }

    public void setRelationalStorage(boolean relationalStorage) {
        this.setIntValue("relationalStorage", relationalStorage ? 1 : 0);
    }

    public boolean isPicker() {
        return this.getIntValue("picker") == 1;
    }

    public void setPicker(boolean picker) {
        this.setIntValue("picker", picker ? 1 : 0);
    }

    public boolean isLargeStorage() {
        return this.getIntValue("largeStorage") == 1;
    }

    public void setLargeStorage(boolean largeStorage) {
        this.setIntValue("largeStorage", largeStorage ? 1 : 0);
    }

    public String getSeparator() {
        return this.getStringValue("separator");
    }

    public void setSeparator(String separator) {
        this.setStringValue("separator", separator);
    }

    public String getDefaultValue() {
        return this.getStringValue("defaultValue");
    }

    public void setDefaultValue(String separator) {
        this.setStringValue("defaultValue", separator);
    }

    public String getFreeText() {
        return this.getStringValue("freeText");
    }

    public void setFreeText(String type) {
        this.setStringValue("freeText", type);
    }

    public static List<String> getListFromString(String value) {
        return ListClass.getListFromString(value, null, true);
    }

    protected String getFirstSeparator() {
        String separator = !StringUtils.isEmpty((CharSequence)this.getSeparators()) ? String.valueOf(this.getSeparators().charAt(0)) : DEFAULT_SEPARATOR;
        return separator;
    }

    public static List<String> getListFromString(String value, String separators, boolean withMap) {
        return ListClass.getListFromString(value, separators, withMap, false);
    }

    protected static List<String> getListFromString(String value, String separators, boolean withMap, boolean filterEmptyValues) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return list;
        }
        if (separators == null) {
            separators = DEFAULT_SEPARATOR;
        }
        boolean inEscape = false;
        boolean inMapValue = false;
        boolean previousWasSeparator = false;
        Character previousSeparator = null;
        StringBuilder currentValue = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (currentChar == '=' && withMap && !inEscape) {
                inMapValue = true;
                continue;
            }
            if (withMap && inMapValue && !StringUtils.containsAny((CharSequence)separators, (char[])new char[]{currentChar})) continue;
            if (currentChar == '\\' && !inEscape) {
                inEscape = true;
                previousWasSeparator = false;
                continue;
            }
            if (currentChar == '\\') {
                currentValue.append('\\');
                inEscape = false;
                previousWasSeparator = false;
                continue;
            }
            if (StringUtils.containsAny((CharSequence)separators, (char[])new char[]{currentChar}) && previousWasSeparator) {
                if (!inEscape && currentChar == previousSeparator.charValue() && !StringUtils.isWhitespace((CharSequence)("" + currentChar))) {
                    if (!filterEmptyValues) {
                        list.add("");
                    }
                    previousWasSeparator = false;
                }
                previousSeparator = Character.valueOf(currentChar);
                continue;
            }
            if (StringUtils.containsAny((CharSequence)separators, (char[])new char[]{currentChar}) && !inEscape) {
                if (!filterEmptyValues || !StringUtils.isEmpty((CharSequence)currentValue.toString())) {
                    list.add(currentValue.toString());
                }
                currentValue = new StringBuilder();
                inMapValue = false;
                previousWasSeparator = true;
                previousSeparator = Character.valueOf(currentChar);
                continue;
            }
            if (StringUtils.containsAny((CharSequence)separators, (char[])new char[]{currentChar})) {
                currentValue.append(currentChar);
                inEscape = false;
                previousWasSeparator = false;
                previousSeparator = Character.valueOf(currentChar);
                continue;
            }
            if (inEscape) {
                currentValue.append('\\');
                currentValue.append(currentChar);
                inEscape = false;
                previousWasSeparator = false;
                continue;
            }
            currentValue.append(currentChar);
            previousWasSeparator = false;
        }
        if (!filterEmptyValues || !StringUtils.isEmpty((CharSequence)currentValue.toString())) {
            list.add(currentValue.toString());
        }
        return list;
    }

    public static String getStringFromList(List<String> list) {
        return ListClass.getStringFromList(list, null);
    }

    public static String getStringFromList(List<String> list, String separators) {
        if (list instanceof PersistentCollection && !((PersistentCollection)list).wasInitialized()) {
            return "";
        }
        if (separators == null) {
            separators = DEFAULT_SEPARATOR;
        }
        ArrayList<String> escapedValues = new ArrayList<String>();
        for (String valueElement : list) {
            boolean inEscape = false;
            StringBuilder newValue = new StringBuilder();
            if (valueElement == null) continue;
            for (int i = 0; i < valueElement.length(); ++i) {
                char currentChar = valueElement.charAt(i);
                if (currentChar == '\\' && !inEscape) {
                    inEscape = true;
                    newValue.append('\\');
                    continue;
                }
                if (currentChar == '\\') {
                    inEscape = false;
                    newValue.append('\\');
                    continue;
                }
                if (StringUtils.containsAny((CharSequence)separators, (char[])new char[]{currentChar})) {
                    if (inEscape) {
                        newValue.append('\\');
                    }
                    newValue.append('\\');
                    newValue.append(currentChar);
                    inEscape = false;
                    continue;
                }
                newValue.append(currentChar);
                inEscape = false;
            }
            if (inEscape) {
                newValue.append('\\');
            }
            escapedValues.add(newValue.toString());
        }
        return StringUtils.join(escapedValues, (char)separators.charAt(0));
    }

    public static Map<String, ListItem> getMapFromString(String value) {
        String[] result;
        LinkedHashMap<String, ListItem> map = new LinkedHashMap<String, ListItem>();
        if (value == null) {
            return map;
        }
        String val = StringUtils.replace((String)value, (String)"\\|", (String)"%PIPE%");
        for (String element2 : result = val.split("\\|")) {
            String element = StringUtils.replace((String)element2, (String)"%PIPE%", (String)DEFAULT_SEPARATOR);
            if (element.indexOf(61) != -1) {
                String[] data = element.split("=", 2);
                map.put(data[0], new ListItem(data[0], data[1]));
                continue;
            }
            map.put(element, new ListItem(element, element));
        }
        return map;
    }

    public String toFormString(BaseProperty property) {
        String result;
        if (property instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)property;
            result = ListClass.getStringFromList(listProperty.getList(), this.getSeparators());
        } else {
            result = property.toText();
        }
        return result;
    }

    @Override
    public BaseProperty newProperty() {
        BaseProperty lprop = this.isRelationalStorage() && this.isMultiSelect() ? new DBStringListProperty() : (this.isMultiSelect() ? new StringListProperty() : (this.isLargeStorage() ? new LargeStringProperty() : new StringProperty()));
        lprop.setName(this.getName());
        return lprop;
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        BaseProperty prop = this.newProperty();
        if (this.isMultiSelect()) {
            ((ListProperty)prop).setList(ListClass.getListFromString(value, this.getSeparators(), false));
        } else {
            prop.setValue(value);
        }
        return prop;
    }

    @Override
    public BaseProperty fromStringArray(String[] strings) throws XWikiException {
        if (!this.isMultiSelect()) {
            return this.fromString(strings[0]);
        }
        BaseProperty prop = this.newProperty();
        if (prop instanceof StringProperty) {
            return this.fromString(strings[0]);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (strings.length == 0) {
            return prop;
        }
        if (strings.length == 1 && (this.getDisplayType().equals(DISPLAYTYPE_INPUT) || this.isMultiSelect())) {
            ((ListProperty)prop).setList(ListClass.getListFromString(strings[0], this.getSeparators(), false));
            return prop;
        }
        for (String item : strings) {
            if (item.trim().equals("")) continue;
            list.add(item);
        }
        ((ListProperty)prop).setList(list);
        return prop;
    }

    @Override
    public BaseProperty newPropertyfromXML(Element ppcel) throws XWikiException {
        if (!this.isMultiSelect()) {
            return super.newPropertyfromXML(ppcel);
        }
        List elist = ppcel.elements("value");
        BaseProperty lprop = this.newProperty();
        if (lprop instanceof ListProperty) {
            List<String> llist = ((ListProperty)lprop).getList();
            for (int i = 0; i < elist.size(); ++i) {
                Element el = (Element)elist.get(i);
                llist.add(el.getText());
            }
        } else {
            for (int i = 0; i < elist.size(); ++i) {
                Element el = (Element)elist.get(i);
                ((StringProperty)lprop).setValue(el.getText());
            }
        }
        return lprop;
    }

    public String getDisplayValue(String value, String name, Map<String, ListItem> map, XWikiContext context) {
        return this.getDisplayValue(value, name, map, value, context);
    }

    private String getDisplayValue(String value, String name, Map<String, ListItem> map, String def, XWikiContext context) {
        ListItem item = map.get(value);
        String displayValue = item == null ? def : item.getValue();
        if (context == null || context.getWiki() == null) {
            return displayValue;
        }
        String msgname = this.getFieldFullName() + "_" + value;
        String newresult = this.localizePlain(msgname, new Object[0]);
        if (newresult == null && (newresult = this.localizePlain(msgname = "option_" + name + "_" + value, new Object[0])) == null && (newresult = this.localizePlain(msgname = "option_" + value, new Object[0])) == null) {
            newresult = displayValue;
        }
        return newresult;
    }

    protected String getDisplayValue(Object rawvalue, String name, Map<String, ListItem> map, XWikiContext context) {
        if (rawvalue == null) {
            return "";
        }
        if (rawvalue instanceof Object[]) {
            return ((Object[])rawvalue)[1].toString();
        }
        return this.getDisplayValue(rawvalue.toString(), name, map, context);
    }

    protected String getElementValue(Object rawvalue) {
        if (rawvalue == null) {
            return "";
        }
        if (rawvalue instanceof Object[]) {
            return ((Object[])rawvalue)[0].toString();
        }
        return rawvalue.toString();
    }

    @Override
    public void displayHidden(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        input input2 = new input();
        input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop != null) {
            input2.setValue(prop.toText());
        }
        input2.setType("hidden");
        input2.setName(prefix + name);
        input2.setID(prefix + name);
        buffer.append(input2.toString());
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop == null) {
            return;
        }
        Map<String, ListItem> map = this.getMap(context);
        if (prop instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)prop;
            String separator = this.getSeparator();
            List<String> selectlist = listProperty.getList();
            ArrayList<String> newlist = new ArrayList<String>();
            for (String value : selectlist) {
                newlist.add(XMLUtils.escapeElementText((String)this.getDisplayValue(value, name, map, context)));
            }
            buffer.append(StringUtils.join(newlist, (String)separator));
        } else {
            buffer.append(XMLUtils.escapeElementText((String)this.getDisplayValue(prop.getValue(), name, map, context)));
        }
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        if (this.getDisplayType().equals(DISPLAYTYPE_INPUT)) {
            input input2 = new input();
            input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            BaseProperty prop = (BaseProperty)object.safeget(name);
            if (prop != null) {
                input2.setValue(this.toFormString(prop));
            }
            input2.setType("text");
            input2.setSize(this.getSize());
            input2.setName(prefix + name);
            input2.setID(prefix + name);
            input2.setDisabled(this.isDisabled());
            buffer.append(input2.toString());
        } else if (this.getDisplayType().equals(DISPLAYTYPE_RADIO) || this.getDisplayType().equals(DISPLAYTYPE_CHECKBOX)) {
            this.displayRadioEdit(buffer, name, prefix, object, context);
        } else {
            this.displaySelectEdit(buffer, name, prefix, object, context);
        }
        if (!this.getDisplayType().equals(DISPLAYTYPE_INPUT)) {
            input hidden = new input("hidden", prefix + name, "");
            hidden.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            buffer.append(hidden);
        }
    }

    protected void displayRadioEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        List<String> list = this.getList(context);
        Map<String, ListItem> map = this.getMap(context);
        BaseProperty prop = (BaseProperty)object.safeget(name);
        List<String> selectlist = this.toList(prop);
        for (String string : selectlist) {
            if (StringUtils.isEmpty((CharSequence)string) || list.contains(string)) continue;
            list.add(string);
        }
        int count = 0;
        for (String string : list) {
            String value = this.getElementValue(string);
            String display = XMLUtils.escape((String)this.getDisplayValue((Object)string, name, map, context));
            input radio = new input(this.getDisplayType().equals(DISPLAYTYPE_RADIO) && !this.isMultiSelect() ? DISPLAYTYPE_RADIO : DISPLAYTYPE_CHECKBOX, prefix + name, value);
            radio.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            radio.setID("xwiki-form-" + name + "-" + object.getNumber() + "-" + count);
            radio.setDisabled(this.isDisabled());
            if (selectlist.contains(value)) {
                radio.setChecked(true);
            }
            radio.addElement(display);
            buffer.append("<label class=\"xwiki-form-listclass\" for=\"xwiki-form-" + XMLUtils.escape((String)name) + "-" + object.getNumber() + "-" + count++ + "\">");
            buffer.append(radio.toString());
            buffer.append("</label>");
        }
        input input2 = new input("hidden", prefix + name, "");
        input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        input2.setDisabled(this.isDisabled());
        buffer.append(input2);
    }

    protected void displaySelectEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        select select2 = new select(prefix + name, 1);
        select2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        select2.setMultiple(this.isMultiSelect());
        select2.setSize(this.getSize());
        select2.setName(prefix + name);
        select2.setID(prefix + name);
        select2.setDisabled(this.isDisabled());
        List<String> list = this.getList(context);
        Map<String, ListItem> map = this.getMap(context);
        String sort = this.getSort();
        if (!"none".equals(sort)) {
            if ("id".equals(sort)) {
                Collections.sort(list);
            }
            if ("value".equals(sort)) {
                Collections.sort(list, new MapComparator(map));
            }
        }
        List<String> selectlist = this.toList((BaseProperty)object.safeget(name));
        String defaultValue = this.getDefaultValue();
        for (String item : selectlist) {
            if (StringUtils.isEmpty((CharSequence)item) || defaultValue.equals(item) || list.contains(item)) continue;
            list.add(item);
        }
        if (!this.isMultiSelect() && !list.contains(defaultValue)) {
            String display = this.getDisplayValue(defaultValue, name, map, defaultValue.isEmpty() ? "---" : defaultValue, context);
            select2.addElement((org.apache.ecs.Element)this.createOption("", display, selectlist));
        }
        for (String rawvalue : list) {
            String value = this.getElementValue(rawvalue);
            String display = this.getDisplayValue(rawvalue, name, map, context);
            select2.addElement((org.apache.ecs.Element)this.createOption(value, display, selectlist));
        }
        buffer.append(select2.toString());
    }

    private option createOption(String value, String display, List<String> selectlist) {
        option option2 = new option(display, value);
        option2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        option2.addElement(XMLUtils.escape((String)display));
        if (selectlist.contains(value)) {
            option2.setSelected(true);
        }
        return option2;
    }

    public abstract List<String> getList(XWikiContext var1);

    public abstract Map<String, ListItem> getMap(XWikiContext var1);

    public List<String> toList(BaseProperty<?> property) {
        List<String> list = property == null ? Collections.emptyList() : (property instanceof ListProperty ? ((ListProperty)property).getList() : Arrays.asList(String.valueOf(property.getValue())));
        return list;
    }

    public void fromList(BaseProperty<?> property, List<String> list) {
        this.fromList(property, list, false);
    }

    protected void fromList(BaseProperty<?> property, List<String> list, boolean filterEmptyValues) {
        if (list == null && !(property instanceof ListProperty)) {
            property.setValue(null);
        } else {
            List<String> actualList = filterEmptyValues && list != null ? list.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item)).collect(Collectors.toList()) : list;
            if (property instanceof ListProperty) {
                ((ListProperty)property).setList(actualList);
            } else if (this.isMultiSelect()) {
                property.setValue(ListClass.getStringFromList(actualList, this.getFirstSeparator()));
            } else {
                property.setValue(actualList.isEmpty() ? null : actualList.get(0));
            }
        }
    }

    @Override
    public <T extends EntityReference> void mergeProperty(BaseProperty<T> currentProperty, BaseProperty<T> previousProperty, BaseProperty<T> newProperty, MergeConfiguration configuration, XWikiContext context, MergeResult mergeResult) {
        if (this.isMultiSelect() && !DISPLAYTYPE_INPUT.equals(this.getDisplayType()) && currentProperty instanceof ListProperty) {
            this.mergeNotOrderedListProperty(currentProperty, previousProperty, newProperty, configuration, context, mergeResult);
            return;
        }
        super.mergeProperty(currentProperty, previousProperty, newProperty, configuration, context, mergeResult);
    }

    protected <T extends EntityReference> void mergeNotOrderedListProperty(BaseProperty<T> currentProperty, BaseProperty<T> previousProperty, BaseProperty<T> newProperty, MergeConfiguration configuration, XWikiContext context, MergeResult mergeResult) {
        LinkedList<String> currentList = new LinkedList<String>(this.toList(currentProperty));
        List<String> previousList = this.toList(previousProperty);
        List<String> newList = this.toList(newProperty);
        if (previousList != null) {
            for (String element : previousList) {
                if (newList != null && newList.contains(element)) continue;
                currentList.remove(element);
                mergeResult.setModified(true);
            }
        }
        if (newList != null) {
            for (String element : newList) {
                if (previousList != null && previousList.contains(element) || currentList.contains(element)) continue;
                currentList.add(element);
                mergeResult.setModified(true);
            }
        }
        this.fromList(currentProperty, currentList);
    }

    public /* synthetic */ String ajc$protectedDispatch$com_xpn_xwiki_objects_classes_ListClass$getElementValue(Object object) {
        return this.getElementValue(object);
    }

    public /* synthetic */ String ajc$superDispatch$com_xpn_xwiki_objects_classes_ListClass$getFullQueryPropertyName() {
        return super.getFullQueryPropertyName();
    }

    @Deprecated
    public String displayRadioSearch(String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return ListClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_ListClassCompatibiityAspect$com_xpn_xwiki_objects_classes_ListClass$displayRadioSearch(this, string, string2, xWikiCriteria, xWikiContext);
    }

    @Override
    @Deprecated
    public String displaySearch(String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return ListClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_ListClassCompatibiityAspect$com_xpn_xwiki_objects_classes_ListClass$displaySearch(this, string, string2, xWikiCriteria, xWikiContext);
    }

    @Deprecated
    public String displaySelectSearch(String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return ListClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_ListClassCompatibiityAspect$com_xpn_xwiki_objects_classes_ListClass$displaySelectSearch(this, string, string2, xWikiCriteria, xWikiContext);
    }

    @Override
    @Deprecated
    public void fromSearchMap(XWikiQuery xWikiQuery, Map<String, String[]> map) {
        ListClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_ListClassCompatibiityAspect$com_xpn_xwiki_objects_classes_ListClass$fromSearchMap(this, xWikiQuery, map);
    }

    @Override
    @Deprecated
    public void makeQuery(Map<String, Object> map, String string, XWikiCriteria xWikiCriteria, List<String> list) {
        ListClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_ListClassCompatibiityAspect$com_xpn_xwiki_objects_classes_ListClass$makeQuery(this, map, string, xWikiCriteria, list);
    }

    protected class MapComparator
    implements Comparator<String> {
        protected Map<String, ListItem> map;

        public MapComparator(Map<String, ListItem> map) {
            this.map = map;
        }

        @Override
        public int compare(String o1, String o2) {
            ListItem s1 = this.map.get(o1);
            ListItem s2 = this.map.get(o2);
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.getValue().compareTo(s2.getValue());
        }
    }
}

