/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.web.XWikiRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.dom4j.Element;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.xml.XMLUtils;

public class LevelsClass
extends ListClass {
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "levelslist";
    private static final String COMMA = ",";

    public LevelsClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "Levels List", wclass);
        this.setSize(6);
    }

    public LevelsClass() {
        this(null);
    }

    @Override
    protected String getFirstSeparator() {
        return COMMA;
    }

    @Override
    public List<String> getList(XWikiContext context) {
        List<String> list;
        try {
            list = context.getWiki().getRightService().listAllLevels(context);
        }
        catch (XWikiException e) {
            list = new ArrayList<String>();
        }
        XWikiRequest req = context.getRequest();
        if (("editrights".equals(req.get("xpage")) || "rights".equals(req.get("editor"))) && !"1".equals(req.get("global"))) {
            list.remove("admin");
            list.remove("programming");
            list.remove("delete");
            list.remove("register");
        }
        return list;
    }

    @Override
    public Map<String, ListItem> getMap(XWikiContext context) {
        return new HashMap<String, ListItem>();
    }

    @Override
    public BaseProperty newProperty() {
        StringProperty property = new StringProperty();
        property.setName(this.getName());
        return property;
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        BaseProperty prop = this.newProperty();
        prop.setValue(value);
        return prop;
    }

    @Override
    public BaseProperty fromStringArray(String[] strings) {
        List<String> list = strings.length == 1 && (this.getDisplayType().equals("input") || this.isMultiSelect()) ? LevelsClass.getListFromString(strings[0], this.getSeparators(), false) : Arrays.asList(strings);
        BaseProperty prop = this.newProperty();
        this.fromList(prop, list, true);
        return prop;
    }

    @Override
    public void fromList(BaseProperty<?> property, List<String> list) {
        this.fromList(property, list, true);
    }

    public String getText(String value, XWikiContext context) {
        return value;
    }

    public static List<String> getListFromString(String value) {
        return LevelsClass.getListFromString(value, COMMA, false, true);
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        select select2 = new select(prefix + name, 1);
        select2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        select2.setMultiple(this.isMultiSelect());
        select2.setSize(this.getSize());
        select2.setName(prefix + name);
        select2.setID(prefix + name);
        select2.setDisabled(this.isDisabled());
        List<String> list = this.getList(context);
        BaseProperty prop = (BaseProperty)object.safeget(name);
        List<String> selectlist = this.toList(prop);
        for (String value : list) {
            String display = this.getText(value, context);
            option option2 = new option(display, value);
            option2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            option2.addElement(XMLUtils.escape((String)display));
            if (!list.contains(value)) {
                list.add(value);
            }
            if (selectlist.stream().anyMatch(value::equalsIgnoreCase)) {
                option2.setSelected(true);
            }
            select2.addElement((org.apache.ecs.Element)option2);
        }
        buffer.append(select2.toString());
        input in = new input();
        in.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        in.setType("hidden");
        in.setName(prefix + name);
        in.setDisabled(this.isDisabled());
        buffer.append(in.toString());
    }

    @Override
    public BaseProperty newPropertyfromXML(Element ppcel) throws XWikiException {
        String value = ppcel.getText();
        return this.fromString(value);
    }

    @Override
    public List<String> toList(BaseProperty<?> property) {
        List<String> selectlist = property == null ? Collections.emptyList() : LevelsClass.getListFromString((String)property.getValue());
        return selectlist;
    }

    @Override
    public <T extends EntityReference> void mergeProperty(BaseProperty<T> currentProperty, BaseProperty<T> previousProperty, BaseProperty<T> newProperty, MergeConfiguration configuration, XWikiContext xcontext, MergeResult mergeResult) {
        this.mergeNotOrderedListProperty(currentProperty, previousProperty, newProperty, configuration, xcontext, mergeResult);
    }
}

