/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.ListProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.security.SecurityConfiguration;
import org.xwiki.security.authorization.AuthorExecutor;

public class DBListClass
extends ListClass {
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "dblist";
    private static final Logger LOGGER = LoggerFactory.getLogger(DBListClass.class);
    protected static final String DEFAULT_QUERY = "select doc.name from XWikiDocument doc where 1 = 0";
    private List<ListItem> cachedDBList;

    public DBListClass(String name, String prettyname, PropertyMetaClass wclass) {
        super(name, prettyname, wclass);
    }

    public DBListClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "DB List", wclass);
    }

    public DBListClass() {
        this(null);
    }

    public List<ListItem> makeList(List<Object> list) {
        ArrayList<ListItem> result = new ArrayList<ListItem>();
        for (Object item : list) {
            if (item == null) continue;
            if (item instanceof String) {
                result.add(new ListItem((String)item));
                continue;
            }
            Object[] res = (Object[])item;
            if (res.length == 1) {
                result.add(new ListItem(this.toStringButEmptyIfNull(res[0])));
                continue;
            }
            if (res.length == 2) {
                result.add(new ListItem(this.toStringButEmptyIfNull(res[0]), this.toStringButEmptyIfNull(res[1])));
                continue;
            }
            result.add(new ListItem(this.toStringButEmptyIfNull(res[0]), this.toStringButEmptyIfNull(res[1]), this.toStringButEmptyIfNull(res[2])));
        }
        return result;
    }

    private String toStringButEmptyIfNull(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public List<ListItem> getDBList(XWikiContext context) {
        List<ListItem> list = this.getCachedDBList(context);
        if (list == null) {
            try {
                SecurityConfiguration securityConfiguration = Utils.getComponent(SecurityConfiguration.class);
                DefaultParameterizedType dbListQueryBuilderType = new DefaultParameterizedType(null, QueryBuilder.class, new Type[]{DBListClass.class});
                QueryBuilder dbListQueryBuilder = (QueryBuilder)Utils.getComponent((Type)dbListQueryBuilderType);
                AuthorExecutor authorExecutor = Utils.getComponent(AuthorExecutor.class);
                list = this.makeList((List)authorExecutor.call(() -> {
                    Query query = dbListQueryBuilder.build((Object)this);
                    int configuredLimit = securityConfiguration.getQueryItemsLimit();
                    if (configuredLimit > 0 && (query.getLimit() <= 0 || query.getLimit() > configuredLimit)) {
                        query.setLimit(configuredLimit);
                    }
                    return query.execute();
                }, this.getOwnerDocument().getAuthorReference(), this.getDocumentReference()));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to get the Database List values. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                list = new ArrayList<ListItem>();
            }
            this.setCachedDBList(list, context);
        }
        return list;
    }

    @Override
    public List<String> getList(XWikiContext context) {
        List<ListItem> dblist = this.getDBList(context);
        String sort = this.getSort();
        if ("id".equals(sort)) {
            Collections.sort(dblist, ListItem.ID_COMPARATOR);
        } else if ("value".equals(sort)) {
            Collections.sort(dblist, ListItem.VALUE_COMPARATOR);
        }
        ArrayList<String> result = new ArrayList<String>(dblist.size());
        for (ListItem value : dblist) {
            result.add(value.getId());
        }
        return result;
    }

    @Override
    public Map<String, ListItem> getMap(XWikiContext context) {
        List<ListItem> list = this.getDBList(context);
        LinkedHashMap<String, ListItem> result = new LinkedHashMap<String, ListItem>();
        if (list == null || list.size() == 0) {
            return result;
        }
        String sort = this.getSort();
        if ("id".equals(sort)) {
            Collections.sort(list, ListItem.ID_COMPARATOR);
        } else if ("value".equals(sort)) {
            Collections.sort(list, ListItem.VALUE_COMPARATOR);
        }
        for (ListItem item : list) {
            result.put(item.getId(), item);
        }
        return result;
    }

    @Deprecated
    public String getQuery(XWikiContext context) {
        Object sql = this.getSql();
        if (StringUtils.isBlank((CharSequence)sql) && context.getWiki().getHibernateStore() != null) {
            boolean usesDoc;
            boolean hasValueField;
            String classname = StringUtils.defaultString((String)this.getClassname());
            String idField = StringUtils.defaultString((String)this.getIdField());
            String valueField = StringUtils.defaultString((String)this.getValueField());
            boolean hasClassname = !StringUtils.isBlank((CharSequence)classname);
            boolean hasIdField = !StringUtils.isBlank((CharSequence)idField);
            boolean bl = hasValueField = !StringUtils.isBlank((CharSequence)valueField);
            if (!hasIdField && !hasValueField) {
                sql = hasClassname ? "select distinct doc.fullName from XWikiDocument as doc, BaseObject as obj where doc.fullName=obj.name and obj.className='" + classname + "'" : DEFAULT_QUERY;
                return sql;
            }
            if (!hasIdField && hasValueField) {
                idField = valueField;
                valueField = "";
                hasValueField = false;
            } else if (idField.equals(valueField)) {
                hasValueField = false;
            }
            boolean usesObj = hasClassname || idField.startsWith("obj.") || valueField.startsWith("obj.");
            boolean bl2 = usesDoc = idField.startsWith("doc.") || valueField.startsWith("doc.");
            if ((!idField.startsWith("obj.") || hasValueField && !valueField.startsWith("obj.")) && !hasClassname) {
                usesDoc = true;
            }
            StringBuffer select2 = new StringBuffer("select distinct ");
            ArrayList<String> fromStatements = new ArrayList<String>();
            ArrayList<Object> whereStatements = new ArrayList<Object>();
            if (usesDoc) {
                fromStatements.add("XWikiDocument as doc");
                if (usesObj) {
                    whereStatements.add("doc.fullName=obj.name");
                }
            }
            if (usesObj) {
                fromStatements.add("BaseObject as obj");
                if (hasClassname) {
                    whereStatements.add("obj.className='" + classname + "'");
                }
            }
            if (idField.startsWith("doc.") || idField.startsWith("obj.")) {
                select2.append(idField);
            } else if (!hasClassname) {
                select2.append("doc." + idField);
            } else {
                select2.append("idprop.value");
                fromStatements.add("StringProperty as idprop");
                whereStatements.add("obj.id=idprop.id.id and idprop.id.name='" + idField + "'");
            }
            if (hasValueField) {
                if (valueField.startsWith("doc.") || valueField.startsWith("obj.")) {
                    select2.append(", ").append(valueField);
                } else if (!hasClassname) {
                    select2.append(", doc." + valueField);
                } else {
                    select2.append(", valueprop.value");
                    fromStatements.add("StringProperty as valueprop");
                    whereStatements.add("obj.id=valueprop.id.id and valueprop.id.name='" + valueField + "'");
                }
            }
            select2.append(" from ");
            select2.append(StringUtils.join(fromStatements.iterator(), (String)", "));
            if (whereStatements.size() > 0) {
                select2.append(" where ");
                select2.append(StringUtils.join(whereStatements.iterator(), (String)" and "));
            }
            sql = select2.toString();
        }
        try {
            sql = context.getWiki().parseContent((String)sql, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse SQL script [{}]. Continuing with non-rendered script.", sql, (Object)e);
        }
        return sql;
    }

    public String getSql() {
        return this.getLargeStringValue("sql");
    }

    public void setSql(String sql) {
        this.setLargeStringValue("sql", sql);
    }

    public String getClassname() {
        return this.getStringValue("classname");
    }

    public void setClassname(String classname) {
        this.setStringValue("classname", classname);
    }

    public String getIdField() {
        return this.getStringValue("idField");
    }

    public void setIdField(String idField) {
        this.setStringValue("idField", idField);
    }

    public String getValueField() {
        return this.getStringValue("valueField");
    }

    public void setValueField(String valueField) {
        this.setStringValue("valueField", valueField);
    }

    public List<ListItem> getCachedDBList(XWikiContext context) {
        if (this.isCache()) {
            return this.cachedDBList;
        }
        return (List)context.get(context.getWikiId() + ":" + this.getFieldFullName());
    }

    public void setCachedDBList(List<ListItem> cachedDBList, XWikiContext context) {
        if (this.isCache()) {
            this.cachedDBList = cachedDBList;
        } else {
            context.put(context.getWikiId() + ":" + this.getFieldFullName(), cachedDBList);
        }
    }

    @Override
    public void flushCache() {
        this.cachedDBList = null;
        super.flushCache();
    }

    public String returnCol(String hqlQuery, boolean first) {
        String firstCol = "-";
        Object secondCol = "-";
        if (StringUtils.isEmpty((CharSequence)hqlQuery)) {
            return firstCol;
        }
        int fromIndx = hqlQuery.toLowerCase().indexOf("from");
        if (fromIndx > 0) {
            String beforeFrom = hqlQuery.substring(0, fromIndx).replaceAll("\\s+", " ");
            int commaIndex = beforeFrom.indexOf(",");
            if (commaIndex > 0) {
                StringTokenizer st = new StringTokenizer(beforeFrom, " ,()", true);
                ArrayList<String> words = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    words.add(st.nextToken());
                }
                int comma = words.indexOf(",") - 1;
                while (((String)words.get(comma)).compareTo(" ") == 0) {
                    --comma;
                }
                firstCol = ((String)words.get(comma)).trim();
                comma = words.indexOf(",") + 1;
                while (((String)words.get(comma)).compareTo(" ") == 0) {
                    ++comma;
                }
                if (((String)words.get(comma)).compareTo("(") == 0) {
                    int i = comma + 1;
                    while (((String)words.get(i)).compareTo(")") != 0) {
                        secondCol = (String)secondCol + (String)words.get(i);
                        ++i;
                    }
                    secondCol = (String)secondCol + ")";
                } else {
                    secondCol = ((String)words.get(comma)).trim();
                }
            } else {
                firstCol = StringUtils.substringAfterLast((String)beforeFrom.trim(), (String)" ");
            }
        }
        if (first) {
            return firstCol;
        }
        return secondCol;
    }

    public String getValue(String val, String sql, XWikiContext context) {
        String lowerCaseSQL = sql.toLowerCase();
        int orderByPos = lowerCaseSQL.lastIndexOf("order by ");
        if (orderByPos >= 0) {
            sql = sql.substring(0, orderByPos);
        }
        String firstCol = this.returnCol(sql, true);
        String secondCol = this.returnCol(sql, false);
        Object newsql = sql.substring(0, sql.indexOf(firstCol));
        newsql = (String)newsql + secondCol + " ";
        newsql = (String)newsql + sql.substring(lowerCaseSQL.indexOf("from "));
        newsql = (String)newsql + "and " + firstCol + "='" + val + "'";
        Object[] list = null;
        XWiki xwiki = context.getWiki();
        String res = "";
        try {
            list = xwiki.search((String)newsql, context).toArray();
            if (list.length > 0) {
                res = list[0].toString();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute SQL query", (Throwable)e);
        }
        return res;
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        if (this.getDisplayType().equals("input")) {
            input input2 = new input();
            input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            input2.setType("text");
            input2.setSize(this.getSize());
            boolean changeInputName = false;
            boolean setInpVal = true;
            BaseProperty prop = (BaseProperty)object.safeget(name);
            String value = "";
            String databaseValue = "";
            if (prop != null) {
                value = this.toFormString(prop);
                databaseValue = prop.toText();
            }
            if (this.isPicker()) {
                input2.setClass("suggested");
                String path = "";
                XWiki xwiki = context.getWiki();
                path = xwiki.getURL("Main.WebHome", "view", context);
                String classname = this.getObject().getName();
                String fieldname = this.getName();
                String hibquery = this.getSql();
                String secondCol = "-";
                String firstCol = "-";
                if (hibquery != null && !hibquery.equals("")) {
                    firstCol = this.returnCol(hibquery, true);
                    secondCol = this.returnCol(hibquery, false);
                    if (secondCol.compareTo("-") != 0) {
                        changeInputName = true;
                        input hidden = new input();
                        hidden.setAttributeFilter((Filter)new XMLAttributeValueFilter());
                        hidden.setID(prefix + name);
                        hidden.setName(prefix + name);
                        hidden.setType("hidden");
                        hidden.setDisabled(this.isDisabled());
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            hidden.setValue(value);
                        }
                        buffer.append(hidden.toString());
                        input2.setValue(this.getValue(databaseValue, hibquery, context));
                        setInpVal = false;
                    }
                }
                String script = "\"" + path + "?xpage=suggest&classname=" + classname + "&fieldname=" + fieldname + "&firCol=" + firstCol + "&secCol=" + secondCol + "&\"";
                String varname = "\"input\"";
                String seps = "\"" + this.getSeparators() + "\"";
                if (this.isMultiSelect()) {
                    input2.setOnFocus("new ajaxSuggest(this, {script:" + script + ", varname:" + varname + ", seps:" + seps + "} )");
                } else {
                    input2.setOnFocus("new ajaxSuggest(this, {script:" + script + ", varname:" + varname + "} )");
                }
            }
            if (changeInputName) {
                input2.setName(prefix + name + "_suggest");
                input2.setID(prefix + name + "_suggest");
            } else {
                input2.setName(prefix + name);
                input2.setID(prefix + name);
            }
            if (setInpVal) {
                input2.setValue(value);
            }
            input2.setDisabled(this.isDisabled());
            buffer.append(input2.toString());
        } else if (this.getDisplayType().equals("radio") || this.getDisplayType().equals("checkbox")) {
            this.displayRadioEdit(buffer, name, prefix, object, context);
        } else {
            this.displaySelectEdit(buffer, name, prefix, object, context);
        }
        if (!this.getDisplayType().equals("input")) {
            input hidden = new input("hidden", prefix + name, "");
            hidden.setAttributeFilter((Filter)new XMLAttributeValueFilter());
            buffer.append(hidden);
        }
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        String separator = this.getSeparator();
        BaseProperty prop = (BaseProperty)object.safeget(name);
        Map<String, ListItem> map = this.getMap(context);
        if (prop == null) {
            return;
        }
        if (prop instanceof ListProperty) {
            List<String> selectlist = ((ListProperty)prop).getList();
            ArrayList<String> newlist = new ArrayList<String>();
            for (String entry : selectlist) {
                newlist.add(this.getDisplayValue(entry, name, map, context));
            }
            buffer.append(StringUtils.join(newlist, (String)separator));
        } else {
            buffer.append(this.getDisplayValue(prop.getValue(), name, map, context));
        }
    }
}

