/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseElement;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClassCompatibiityAspect;
import com.xpn.xwiki.objects.classes.BooleanClass;
import com.xpn.xwiki.objects.classes.ClassInterface;
import com.xpn.xwiki.objects.classes.DBListClass;
import com.xpn.xwiki.objects.classes.DBTreeListClass;
import com.xpn.xwiki.objects.classes.DateClass;
import com.xpn.xwiki.objects.classes.EmailClass;
import com.xpn.xwiki.objects.classes.GroupsClass;
import com.xpn.xwiki.objects.classes.LevelsClass;
import com.xpn.xwiki.objects.classes.NumberClass;
import com.xpn.xwiki.objects.classes.PageClass;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import com.xpn.xwiki.objects.classes.StringClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import com.xpn.xwiki.objects.classes.TimezoneClass;
import com.xpn.xwiki.objects.classes.UsersClass;
import com.xpn.xwiki.objects.meta.MetaClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.plugin.query.XWikiQuery;
import com.xpn.xwiki.validation.XWikiValidationInterface;
import com.xpn.xwiki.validation.XWikiValidationStatus;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.store.merge.MergeManagerResult;

public class BaseClass
extends BaseCollection<DocumentReference>
implements ClassInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseClass.class);
    private static final long serialVersionUID = 1L;
    private String customMapping;
    private String customClass;
    private String defaultWeb;
    private String defaultViewSheet;
    private String defaultEditSheet;
    private String validationScript;
    private String nameField;
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;

    private DocumentReferenceResolver<String> getCurrentMixedDocumentReferenceResolver() {
        if (this.currentMixedDocumentReferenceResolver == null) {
            this.currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
        }
        return this.currentMixedDocumentReferenceResolver;
    }

    private DocumentReferenceResolver<String> getCurrentDocumentReferenceResolver() {
        if (this.currentDocumentReferenceResolver == null) {
            this.currentDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
        }
        return this.currentDocumentReferenceResolver;
    }

    @Override
    public DocumentReference getReference() {
        return this.getDocumentReference();
    }

    @Override
    @Deprecated
    public String getName() {
        return super.getName();
    }

    @Override
    @Deprecated
    public void setName(String name) {
        if (this instanceof MetaClass || this instanceof PropertyMetaClass) {
            super.setName(name);
        } else {
            DocumentReference reference = this.getDocumentReference();
            if (reference != null) {
                EntityReference relativeReference = this.getRelativeEntityReferenceResolver().resolve((Object)name, EntityType.DOCUMENT, new Object[0]);
                reference = new DocumentReference(relativeReference.extractReference(EntityType.DOCUMENT).getName(), new SpaceReference(relativeReference.extractReference(EntityType.SPACE).getName(), reference.getParent().getParent()));
            } else {
                reference = this.getCurrentMixedDocumentReferenceResolver().resolve((Object)name, new Object[0]);
            }
            this.setDocumentReference(reference);
        }
        this.setDirty(true);
    }

    @Override
    public void addField(String name, PropertyInterface element) {
        if (element != null) {
            Set<String> properties = this.getPropertyList();
            if (!properties.contains(name) && ((BaseCollection)((Object)element)).getNumber() == 0) {
                ((BaseCollection)((Object)element)).setNumber(properties.size() + 1);
            }
            super.addField(name, element);
            this.setDirty(true);
        } else {
            LOGGER.warn("Cannot add null field with name [{}] in [{}].", (Object)name, (Object)this);
        }
    }

    public void disableField(String name) {
        PropertyClass pclass = (PropertyClass)this.safeget(name);
        if (pclass != null) {
            pclass.setDisabled(true);
        }
        this.setDirty(true);
    }

    public void enableField(String name) {
        PropertyClass pclass = (PropertyClass)this.safeget(name);
        if (pclass != null) {
            pclass.setDisabled(false);
        }
        this.setDirty(true);
    }

    @Override
    public PropertyInterface get(String name) {
        return this.safeget(name);
    }

    @Override
    public void put(String name, PropertyInterface property) {
        this.safeput(name, property);
        this.setDirty(true);
    }

    public List<PropertyClass> getEnabledProperties() {
        Collection allProperties = this.getFieldList();
        if (allProperties == null) {
            return Collections.emptyList();
        }
        ArrayList<PropertyClass> enabledProperties = new ArrayList<PropertyClass>(allProperties.size());
        for (PropertyClass property : allProperties) {
            if (property == null || property.isDisabled()) continue;
            enabledProperties.add(property);
        }
        Collections.sort(enabledProperties);
        return Collections.unmodifiableList(enabledProperties);
    }

    public List<PropertyClass> getDisabledProperties() {
        Collection allProperties = this.getFieldList();
        if (allProperties == null) {
            return Collections.emptyList();
        }
        ArrayList<PropertyClass> disabledProperties = new ArrayList<PropertyClass>();
        for (PropertyClass property : allProperties) {
            if (property == null || !property.isDisabled()) continue;
            disabledProperties.add(property);
        }
        Collections.sort(disabledProperties);
        return Collections.unmodifiableList(disabledProperties);
    }

    public List<PropertyClass> getDisabledObjectProperties(BaseObject object) {
        List<PropertyClass> disabledProperties = this.getDisabledProperties();
        if (disabledProperties == null) {
            return Collections.emptyList();
        }
        ArrayList<PropertyClass> disabledObjectProperties = new ArrayList<PropertyClass>(disabledProperties.size());
        for (PropertyClass property : disabledProperties) {
            try {
                if (object.get(property.getName()) == null) continue;
                disabledObjectProperties.add(property);
            }
            catch (XWikiException xWikiException) {}
        }
        return Collections.unmodifiableList(disabledObjectProperties);
    }

    public List<BaseProperty> getDeprecatedObjectProperties(BaseObject object) {
        Collection objectProperties = object.getFieldList();
        if (objectProperties == null) {
            return Collections.emptyList();
        }
        ArrayList<BaseProperty> deprecatedObjectProperties = new ArrayList<BaseProperty>();
        for (BaseProperty property : objectProperties) {
            String objectPropertyClass;
            String propertyClass;
            if (this.safeget(property.getName()) == null) {
                deprecatedObjectProperties.add(property);
                continue;
            }
            BaseProperty emptyProperty = ((PropertyClass)this.safeget(property.getName())).newProperty();
            if (emptyProperty == null || (propertyClass = emptyProperty.getClassType()).equals(objectPropertyClass = property.getClassType())) continue;
            deprecatedObjectProperties.add(property);
        }
        return Collections.unmodifiableList(deprecatedObjectProperties);
    }

    public BaseProperty fromString(String value) {
        return null;
    }

    @Deprecated
    public BaseCollection newObject(XWikiContext context) throws XWikiException {
        BaseObject bobj = this.newCustomClassInstance(context);
        DocumentReference classReference = this.getDocumentReference();
        bobj.setXClassReference(classReference.removeParent((EntityReference)classReference.getWikiReference()));
        return bobj;
    }

    @Deprecated
    public BaseCollection fromMap(Map<String, ?> map, XWikiContext context) throws XWikiException {
        BaseCollection object = this.newObject(context);
        return this.fromMap(map, object);
    }

    public BaseCollection fromMap(Map<String, ?> map, BaseCollection object) throws XWikiException {
        for (PropertyClass property : this.getFieldList()) {
            BaseProperty objprop;
            String name = property.getName();
            Object formvalues = map.get(name);
            if (formvalues == null || (objprop = formvalues instanceof String[] ? property.fromStringArray((String[])formvalues) : (formvalues instanceof String ? property.fromString(formvalues.toString()) : property.fromValue(formvalues))) == null) continue;
            objprop.setObject(object);
            object.safeput(name, objprop);
        }
        return object;
    }

    public BaseCollection fromValueMap(Map<String, ?> map, BaseCollection object) {
        for (PropertyClass property : this.getFieldList()) {
            BaseProperty objprop;
            String name = property.getName();
            Object formvalue = map.get(name);
            if (formvalue == null || (objprop = property.fromValue(formvalue)) == null) continue;
            objprop.setObject(object);
            object.safeput(name, objprop);
        }
        return object;
    }

    @Override
    public BaseClass clone() {
        return (BaseClass)super.clone();
    }

    public BaseClass clone(boolean detach) {
        return (BaseClass)super.clone(detach);
    }

    @Override
    protected void cloneContent(BaseElement<DocumentReference> element) {
        super.cloneContent(element);
        BaseClass bclass = (BaseClass)element;
        bclass.setCustomClass(this.getCustomClass());
        bclass.setCustomMapping(this.getCustomMapping());
        bclass.setDefaultWeb(this.getDefaultWeb());
        bclass.setDefaultViewSheet(this.getDefaultViewSheet());
        bclass.setDefaultEditSheet(this.getDefaultEditSheet());
        bclass.setValidationScript(this.getValidationScript());
        bclass.setNameField(this.getNameField());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BaseClass bclass = (BaseClass)obj;
        if (!this.getCustomClass().equals(bclass.getCustomClass())) {
            return false;
        }
        if (!Objects.equals(this.customMapping, bclass.customMapping) && !this.getCustomMapping().equals(bclass.getCustomMapping())) {
            return false;
        }
        if (!this.getDefaultViewSheet().equals(bclass.getDefaultViewSheet())) {
            return false;
        }
        if (!this.getDefaultEditSheet().equals(bclass.getDefaultEditSheet())) {
            return false;
        }
        if (!this.getDefaultWeb().equals(bclass.getDefaultWeb())) {
            return false;
        }
        if (!this.getValidationScript().equals(bclass.getValidationScript())) {
            return false;
        }
        return this.getNameField().equals(bclass.getNameField());
    }

    public void merge(BaseClass bclass) {
    }

    @Override
    public void fromXML(Element element) throws XWikiException {
        super.fromXML(element);
    }

    @Override
    public void fromXML(String xml) throws XWikiException {
        super.fromXML(xml);
    }

    public boolean addTextField(String fieldName, String fieldPrettyName, int size) {
        if (this.get(fieldName) == null) {
            StringClass text_class = new StringClass();
            text_class.setName(fieldName);
            text_class.setPrettyName(fieldPrettyName);
            text_class.setSize(size);
            text_class.setObject(this);
            this.put(fieldName, text_class);
            return true;
        }
        return false;
    }

    public boolean addPasswordField(String fieldName, String fieldPrettyName, int size) {
        return this.addPasswordField(fieldName, fieldPrettyName, size, null);
    }

    public boolean addPasswordField(String fieldName, String fieldPrettyName, int size, String storageType) {
        if (this.get(fieldName) == null) {
            PasswordClass passwordClass = new PasswordClass();
            passwordClass.setName(fieldName);
            passwordClass.setPrettyName(fieldPrettyName);
            passwordClass.setSize(size);
            if (storageType != null) {
                passwordClass.setStorageType(storageType);
            }
            passwordClass.setObject(this);
            this.put(fieldName, passwordClass);
            return true;
        }
        return false;
    }

    public boolean addEmailField(String fieldName, String fieldPrettyName, int size) {
        if (this.get(fieldName) == null) {
            EmailClass emailClass = new EmailClass();
            emailClass.setName(fieldName);
            emailClass.setPrettyName(fieldPrettyName);
            emailClass.setSize(size);
            emailClass.setObject(this);
            this.put(fieldName, emailClass);
            return true;
        }
        return false;
    }

    public boolean addTimezoneField(String fieldName, String fieldPrettyName, int size) {
        if (this.get(fieldName) == null) {
            TimezoneClass timezoneClass = new TimezoneClass();
            timezoneClass.setName(fieldName);
            timezoneClass.setPrettyName(fieldPrettyName);
            timezoneClass.setSize(size);
            timezoneClass.setObject(this);
            this.put(fieldName, timezoneClass);
            return true;
        }
        return false;
    }

    public boolean addBooleanField(String fieldName, String fieldPrettyName) {
        return this.addBooleanField(fieldName, fieldPrettyName, null);
    }

    public boolean addBooleanField(String fieldName, String fieldPrettyName, String displayType) {
        return this.addBooleanField(fieldName, fieldPrettyName, displayType, null);
    }

    public boolean addBooleanField(String fieldName, String fieldPrettyName, String displayType, Boolean def) {
        return this.addBooleanField(fieldName, fieldPrettyName, null, displayType, def);
    }

    public boolean addBooleanField(String fieldName, String fieldPrettyName, String formType, String displayType, Boolean def) {
        if (this.get(fieldName) == null) {
            BooleanClass booleanClass = new BooleanClass();
            booleanClass.setName(fieldName);
            booleanClass.setPrettyName(fieldPrettyName);
            if (formType != null) {
                booleanClass.setDisplayFormType(formType);
            }
            booleanClass.setDisplayType(displayType);
            booleanClass.setObject(this);
            if (def != null) {
                booleanClass.setDefaultValue(def != false ? 1 : 0);
            }
            this.put(fieldName, booleanClass);
            return true;
        }
        return false;
    }

    public boolean addUsersField(String fieldName, String fieldPrettyName) {
        return this.addUsersField(fieldName, fieldPrettyName, true);
    }

    public boolean addUsersField(String fieldName, String fieldPrettyName, boolean multiSelect) {
        return this.addUsersField(fieldName, fieldPrettyName, 5, multiSelect);
    }

    public boolean addUsersField(String fieldName, String fieldPrettyName, int size) {
        return this.addUsersField(fieldName, fieldPrettyName, size, true);
    }

    public boolean addUsersField(String fieldName, String fieldPrettyName, int size, boolean multiSelect) {
        if (this.get(fieldName) == null) {
            UsersClass users_class = new UsersClass();
            users_class.setName(fieldName);
            users_class.setPrettyName(fieldPrettyName);
            users_class.setSize(size);
            users_class.setMultiSelect(multiSelect);
            users_class.setObject(this);
            this.put(fieldName, users_class);
            return true;
        }
        return false;
    }

    public boolean addLevelsField(String fieldName, String fieldPrettyName) {
        return this.addLevelsField(fieldName, fieldPrettyName, 3);
    }

    public boolean addLevelsField(String fieldName, String fieldPrettyName, int size) {
        if (this.get(fieldName) == null) {
            LevelsClass levels_class = new LevelsClass();
            levels_class.setName(fieldName);
            levels_class.setPrettyName(fieldPrettyName);
            levels_class.setSize(size);
            levels_class.setMultiSelect(true);
            levels_class.setObject(this);
            this.put(fieldName, levels_class);
            return true;
        }
        return false;
    }

    public boolean addGroupsField(String fieldName, String fieldPrettyName) {
        return this.addGroupsField(fieldName, fieldPrettyName, 5);
    }

    public boolean addGroupsField(String fieldName, String fieldPrettyName, int size) {
        if (this.get(fieldName) == null) {
            GroupsClass groups_class = new GroupsClass();
            groups_class.setName(fieldName);
            groups_class.setPrettyName(fieldPrettyName);
            groups_class.setSize(size);
            groups_class.setMultiSelect(true);
            groups_class.setObject(this);
            this.put(fieldName, groups_class);
            return true;
        }
        return false;
    }

    public boolean addTemplateField(String fieldName, String fieldPrettyName) {
        return this.addTextAreaField(fieldName, fieldPrettyName, 80, 15, TextAreaClass.EditorType.PURE_TEXT);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, false);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, boolean restricted) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, (String)null, restricted);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, TextAreaClass.EditorType editorType) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, editorType, TextAreaClass.getContentType(editorType, null));
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, String editor) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, editor, false);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, String editor, boolean restricted) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, editor, null, restricted);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, TextAreaClass.ContentType contentType) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, TextAreaClass.getEditorType(contentType, null), contentType);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, TextAreaClass.EditorType editorType, TextAreaClass.ContentType contentType) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, editorType != null ? editorType.toString() : null, contentType != null ? contentType.toString() : null);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, String editor, String contenttype) {
        return this.addTextAreaField(fieldName, fieldPrettyName, cols, rows, editor, contenttype, false);
    }

    public boolean addTextAreaField(String fieldName, String fieldPrettyName, int cols, int rows, String editor, String contenttype, boolean restricted) {
        TextAreaClass textAreaClass;
        boolean result = false;
        PropertyInterface field = this.get(fieldName);
        if (field instanceof TextAreaClass) {
            textAreaClass = (TextAreaClass)field;
        } else {
            if (field != null) {
                this.removeField(fieldName);
            }
            textAreaClass = new TextAreaClass();
            textAreaClass.setName(fieldName);
            textAreaClass.setObject(this);
            this.put(fieldName, textAreaClass);
            result = true;
        }
        if (!textAreaClass.getPrettyName().equals(fieldPrettyName)) {
            textAreaClass.setPrettyName(fieldPrettyName);
            result = true;
        }
        if (editor == null && !textAreaClass.getEditor().isEmpty() || editor != null && !textAreaClass.getEditor().equals(editor.toLowerCase())) {
            textAreaClass.setEditor(editor);
            result = true;
        }
        if (contenttype == null && !textAreaClass.getContentType().equalsIgnoreCase(TextAreaClass.ContentType.WIKI_TEXT.toString()) || contenttype != null && !textAreaClass.getContentType().equalsIgnoreCase(contenttype)) {
            textAreaClass.setContentType(contenttype);
            result = true;
        }
        if (textAreaClass.getSize() != cols) {
            textAreaClass.setSize(cols);
            result = true;
        }
        if (textAreaClass.getRows() != rows) {
            textAreaClass.setRows(rows);
            result = true;
        }
        textAreaClass.setRestricted(restricted);
        return result;
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, String values) {
        return this.addStaticListField(fieldName, fieldPrettyName, 1, false, values);
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, String values, String defaultValue) {
        return this.addStaticListField(fieldName, fieldPrettyName, 1, false, false, values, null, null, defaultValue);
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, String values) {
        return this.addStaticListField(fieldName, fieldPrettyName, size, multiSelect, values, null);
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, String values, String displayType) {
        return this.addStaticListField(fieldName, fieldPrettyName, size, multiSelect, values, displayType, null);
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, String values, String displayType, String separators) {
        return this.addStaticListField(fieldName, fieldPrettyName, size, multiSelect, false, values, displayType, separators);
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, boolean relationalStorage, String values, String displayType, String separators) {
        return this.addStaticListField(fieldName, fieldPrettyName, size, multiSelect, relationalStorage, values, displayType, separators, null);
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, boolean relationalStorage, String values, String displayType, String separators, String defaultValue) {
        return this.addStaticListField(fieldName, fieldPrettyName, size, multiSelect, relationalStorage, values, displayType, separators, defaultValue, "forbidden", false);
    }

    public boolean addStaticListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, boolean relationalStorage, String values, String displayType, String separators, String defaultValue, String freeText, boolean largeStorage) {
        if (this.get(fieldName) == null) {
            StaticListClass list_class = new StaticListClass();
            list_class.setName(fieldName);
            list_class.setPrettyName(fieldPrettyName);
            list_class.setSize(size);
            list_class.setMultiSelect(multiSelect);
            list_class.setRelationalStorage(relationalStorage);
            list_class.setValues(values);
            if (displayType != null) {
                list_class.setDisplayType(displayType);
            }
            if (separators != null) {
                list_class.setSeparators(separators);
                list_class.setSeparator(separators.substring(0, 1));
            }
            if (defaultValue != null) {
                list_class.setDefaultValue(defaultValue);
            }
            list_class.setFreeText(freeText);
            if (!"forbidden".equals(freeText)) {
                list_class.setPicker(true);
            }
            list_class.setLargeStorage(largeStorage);
            list_class.setObject(this);
            this.put(fieldName, list_class);
            return true;
        }
        return false;
    }

    public StaticListClass addStaticListField(String fieldName) {
        StaticListClass result = (StaticListClass)this.get(fieldName);
        if (result == null) {
            result = new StaticListClass();
            result.setName(fieldName);
            result.setSize(1);
            result.setMultiSelect(false);
            result.setRelationalStorage(false);
            result.setFreeText("forbidden");
            result.setLargeStorage(false);
            result.setObject(this);
            this.put(fieldName, result);
        }
        return result;
    }

    public boolean addNumberField(String fieldName, String fieldPrettyName, int size, String type) {
        if (this.get(fieldName) == null) {
            NumberClass number_class = new NumberClass();
            number_class.setName(fieldName);
            number_class.setPrettyName(fieldPrettyName);
            number_class.setSize(size);
            number_class.setNumberType(type);
            number_class.setObject(this);
            this.put(fieldName, number_class);
            return true;
        }
        return false;
    }

    public boolean addDateField(String fieldName, String fieldPrettyName) {
        return this.addDateField(fieldName, fieldPrettyName, null, 1);
    }

    public boolean addDateField(String fieldName, String fieldPrettyName, String dformat) {
        return this.addDateField(fieldName, fieldPrettyName, dformat, 1);
    }

    public boolean addDateField(String fieldName, String fieldPrettyName, String dformat, int emptyIsToday) {
        if (this.get(fieldName) == null) {
            DateClass date_class = new DateClass();
            date_class.setName(fieldName);
            date_class.setPrettyName(fieldPrettyName);
            if (dformat != null) {
                date_class.setDateFormat(dformat);
            }
            date_class.setObject(this);
            date_class.setEmptyIsToday(emptyIsToday);
            this.put(fieldName, date_class);
            return true;
        }
        return false;
    }

    public boolean addDBListField(String fieldName, String fieldPrettyName, String sql) {
        return this.addDBListField(fieldName, fieldPrettyName, 1, false, sql);
    }

    public boolean addDBListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, String sql) {
        return this.addDBListField(fieldName, fieldPrettyName, size, multiSelect, multiSelect, sql);
    }

    public boolean addDBListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, boolean relationalStorage, String sql) {
        if (this.get(fieldName) == null) {
            DBListClass list_class = new DBListClass();
            list_class.setName(fieldName);
            list_class.setPrettyName(fieldPrettyName);
            list_class.setSize(size);
            list_class.setMultiSelect(multiSelect);
            list_class.setRelationalStorage(relationalStorage);
            list_class.setSql(sql);
            list_class.setObject(this);
            this.put(fieldName, list_class);
            return true;
        }
        return false;
    }

    public boolean addDBTreeListField(String fieldName, String fieldPrettyName, String sql) {
        return this.addDBTreeListField(fieldName, fieldPrettyName, 1, false, sql);
    }

    public boolean addDBTreeListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, String sql) {
        return this.addDBTreeListField(fieldName, fieldPrettyName, size, multiSelect, multiSelect, sql);
    }

    public boolean addDBTreeListField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, boolean relationalStorage, String sql) {
        if (this.get(fieldName) == null) {
            DBTreeListClass list_class = new DBTreeListClass();
            list_class.setName(fieldName);
            list_class.setPrettyName(fieldPrettyName);
            list_class.setSize(size);
            list_class.setMultiSelect(multiSelect);
            list_class.setRelationalStorage(relationalStorage);
            list_class.setSql(sql);
            list_class.setObject(this);
            this.put(fieldName, list_class);
            return true;
        }
        return false;
    }

    public boolean addPageField(String fieldName, String fieldPrettyName, int size) {
        return this.addPageField(fieldName, fieldPrettyName, size, false);
    }

    public boolean addPageField(String fieldName, String fieldPrettyName, int size, boolean multiSelect) {
        return this.addPageField(fieldName, fieldPrettyName, size, multiSelect, multiSelect, "");
    }

    public boolean addPageField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, boolean relationalStorage, String hqlQuery) {
        return this.addPageField(fieldName, fieldPrettyName, size, multiSelect, relationalStorage, hqlQuery, "", "input", true, "discouraged");
    }

    public boolean addPageField(String fieldName, String fieldPrettyName, int size, boolean multiSelect, boolean relationalStorage, String hqlQuery, String className, String displayType, boolean hasPicker, String freeText) {
        if (this.getField(fieldName) == null) {
            PageClass pageClass = new PageClass();
            pageClass.setName(fieldName);
            pageClass.setPrettyName(fieldPrettyName);
            pageClass.setSize(size);
            pageClass.setMultiSelect(multiSelect);
            pageClass.setSql(hqlQuery);
            pageClass.setRelationalStorage(relationalStorage);
            pageClass.setDisplayType(displayType);
            pageClass.setPicker(hasPicker);
            pageClass.setObject(this);
            pageClass.setClassname(className);
            pageClass.setFreeText(freeText);
            this.put(fieldName, pageClass);
            return true;
        }
        return false;
    }

    public void setCustomMapping(String customMapping) {
        this.customMapping = customMapping;
    }

    public String getCustomMapping() {
        if ("XWiki.XWikiPreferences".equals(this.getName())) {
            return "internal";
        }
        if (this.customMapping == null) {
            return "";
        }
        return this.customMapping;
    }

    public boolean hasCustomMapping() {
        String cMapping = this.getCustomMapping();
        return cMapping != null && !"".equals(cMapping);
    }

    public boolean hasExternalCustomMapping() {
        String cMapping = this.getCustomMapping();
        return cMapping != null && !"".equals(cMapping) && !"internal".equals(cMapping);
    }

    public boolean hasInternalCustomMapping() {
        return "internal".equals(this.customMapping);
    }

    public boolean isCustomMappingValid(XWikiContext context) throws XWikiException {
        return this.isCustomMappingValid(this.getCustomMapping(), context);
    }

    public boolean isCustomMappingValid(String custommapping, XWikiContext context) throws XWikiException {
        if (custommapping != null && custommapping.trim().length() > 0) {
            return context.getWiki().getStore().isCustomMappingValid(this, custommapping, context);
        }
        return true;
    }

    public List<String> getCustomMappingPropertyList(XWikiContext context) {
        String custommapping1 = this.getCustomMapping();
        if (custommapping1 != null && custommapping1.trim().length() > 0) {
            return context.getWiki().getStore().getCustomMappingPropertyList(this);
        }
        return new ArrayList<String>();
    }

    public void setCustomClass(String customClass) {
        this.customClass = customClass;
    }

    public String getCustomClass() {
        if (this.customClass == null) {
            return "";
        }
        return this.customClass;
    }

    public BaseObject newCustomClassInstance(XWikiContext context) throws XWikiException {
        return this.newCustomClassInstance(false);
    }

    public BaseObject newCustomClassInstance(boolean fallback) throws XWikiException {
        String customClass = this.getCustomClass();
        try {
            if (StringUtils.isEmpty((CharSequence)customClass)) {
                return new BaseObject();
            }
            return (BaseObject)Class.forName(customClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            if (fallback) {
                LOGGER.warn("Failed to create a new custom class instance ([{}]). Fallbacking on BaseObject.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                return new BaseObject();
            }
            Object[] args = new Object[]{customClass};
            throw new XWikiException(7, 7004, "Cannot instanciate custom class {0}", e, args);
        }
    }

    public static BaseObject newCustomClassInstance(DocumentReference classReference, XWikiContext context) throws XWikiException {
        return BaseClass.newCustomClassInstance(classReference, false, context);
    }

    public static BaseObject newCustomClassInstance(DocumentReference classReference, boolean fallback, XWikiContext context) throws XWikiException {
        BaseClass bclass = context.getWiki().getXClass(classReference, context);
        BaseObject object = bclass == null ? new BaseObject() : bclass.newCustomClassInstance(fallback);
        object.setXClassReference((EntityReference)classReference);
        return object;
    }

    @Deprecated
    public static BaseObject newCustomClassInstance(String className, XWikiContext context) throws XWikiException {
        BaseClass bclass = context.getWiki().getClass(className, context);
        BaseObject object = bclass == null ? new BaseObject() : bclass.newCustomClassInstance(context);
        return object;
    }

    public String getDefaultWeb() {
        if (this.defaultWeb == null) {
            return "";
        }
        return this.defaultWeb;
    }

    public void setDefaultWeb(String defaultWeb) {
        this.defaultWeb = defaultWeb;
    }

    public String getDefaultViewSheet() {
        if (this.defaultViewSheet == null) {
            return "";
        }
        return this.defaultViewSheet;
    }

    public void setDefaultViewSheet(String defaultViewSheet) {
        this.defaultViewSheet = defaultViewSheet;
    }

    public String getDefaultEditSheet() {
        if (this.defaultEditSheet == null) {
            return "";
        }
        return this.defaultEditSheet;
    }

    public void setDefaultEditSheet(String defaultEditSheet) {
        this.defaultEditSheet = defaultEditSheet;
    }

    public String getNameField() {
        if (this.nameField == null) {
            return "";
        }
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public void setValidationScript(String validationScript) {
        this.validationScript = validationScript;
    }

    public String getValidationScript() {
        if (this.validationScript == null) {
            return "";
        }
        return this.validationScript;
    }

    public boolean validateObject(BaseObject obj, XWikiContext context) throws XWikiException {
        String[] props;
        boolean isValid = true;
        String[] stringArray = props = this.getPropertyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String prop;
            String propname = prop = stringArray[i];
            BaseProperty property = (BaseProperty)obj.get(propname);
            PropertyClass propclass = (PropertyClass)this.get(propname);
            isValid &= propclass.validateProperty(property, context);
        }
        String validSript = this.getValidationScript();
        if (validSript != null && !validSript.trim().equals("")) {
            isValid &= this.executeValidationScript(obj, validSript, context);
        }
        return isValid;
    }

    private boolean executeValidationScript(BaseObject obj, String validationScript, XWikiContext context) {
        try {
            ContextualAuthorizationManager authorization = Utils.getComponent(ContextualAuthorizationManager.class);
            DocumentReference validationScriptReference = this.getCurrentDocumentReferenceResolver().resolve((Object)validationScript, new Object[]{this.getDocumentReference()});
            authorization.checkAccess(Right.PROGRAM, (EntityReference)validationScriptReference);
            XWikiValidationInterface validObject = (XWikiValidationInterface)context.getWiki().parseGroovyFromPage(validationScript, context);
            return validObject.validateObject(obj, context);
        }
        catch (Throwable e) {
            XWikiValidationStatus.addExceptionToContext(this.getName(), "", e, context);
            return false;
        }
    }

    public void flushCache() {
        String[] props;
        for (String prop : props = this.getPropertyNames()) {
            String propname = prop;
            PropertyClass propclass = (PropertyClass)this.get(propname);
            if (propclass == null) continue;
            propclass.flushCache();
        }
    }

    @Override
    public List<ObjectDiff> getDiff(Object oldObject, XWikiContext context) {
        String propertyType;
        String propertyName;
        ArrayList<ObjectDiff> difflist = new ArrayList<ObjectDiff>();
        BaseClass oldClass = (BaseClass)oldObject;
        for (PropertyClass newProperty : this.getFieldList()) {
            propertyName = newProperty.getName();
            PropertyClass oldProperty = (PropertyClass)oldClass.get(propertyName);
            propertyType = newProperty.getClassType();
            if (oldProperty == null) {
                difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), "", "added", propertyName, propertyType, (Object)"", (Object)""));
                continue;
            }
            if (oldProperty.equals(newProperty)) continue;
            difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), "", "changed", propertyName, propertyType, (Object)"", (Object)""));
        }
        for (PropertyClass oldProperty : oldClass.getFieldList()) {
            propertyName = oldProperty.getName();
            PropertyClass newProperty = (PropertyClass)this.get(propertyName);
            propertyType = oldProperty.getClassType();
            if (newProperty != null) continue;
            difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), "", "removed", propertyName, propertyType, (Object)"", (Object)""));
        }
        return difflist;
    }

    @Override
    public MergeManagerResult<ElementInterface, Object> merge(ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context) {
        MergeManagerResult<ElementInterface, Object> mergeResult = super.merge(previousElement, newElement, configuration, context);
        BaseClass previousClass = (BaseClass)previousElement;
        BaseClass newClass = (BaseClass)newElement;
        BaseClass modifiableResult = (BaseClass)mergeResult.getMergeResult();
        MergeManagerResult customClassMergeResult = this.getMergeManager().mergeObject((Object)previousClass.getCustomClass(), (Object)newClass.getCustomClass(), (Object)this.getCustomClass(), configuration);
        mergeResult.getLog().addAll((Collection)customClassMergeResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || customClassMergeResult.isModified());
        modifiableResult.setCustomClass((String)customClassMergeResult.getMergeResult());
        MergeManagerResult customMappingMergeResult = this.getMergeManager().mergeObject((Object)previousClass.getCustomMapping(), (Object)newClass.getCustomMapping(), (Object)this.getCustomMapping(), configuration);
        mergeResult.getLog().addAll((Collection)customMappingMergeResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || customMappingMergeResult.isModified());
        modifiableResult.setCustomMapping((String)customMappingMergeResult.getMergeResult());
        MergeManagerResult defaultWebMergeResult = this.getMergeManager().mergeObject((Object)previousClass.getDefaultWeb(), (Object)newClass.getDefaultWeb(), (Object)this.getDefaultWeb(), configuration);
        mergeResult.getLog().addAll((Collection)defaultWebMergeResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || defaultWebMergeResult.isModified());
        modifiableResult.setDefaultWeb((String)defaultWebMergeResult.getMergeResult());
        MergeManagerResult defaultViewSheetMergeResult = this.getMergeManager().mergeObject((Object)previousClass.getDefaultViewSheet(), (Object)newClass.getDefaultViewSheet(), (Object)this.getDefaultViewSheet(), configuration);
        mergeResult.getLog().addAll((Collection)defaultViewSheetMergeResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || defaultViewSheetMergeResult.isModified());
        modifiableResult.setDefaultViewSheet((String)defaultViewSheetMergeResult.getMergeResult());
        MergeManagerResult defaultEditSheetMergeResult = this.getMergeManager().mergeObject((Object)previousClass.getDefaultEditSheet(), (Object)newClass.getDefaultEditSheet(), (Object)this.getDefaultEditSheet(), configuration);
        mergeResult.getLog().addAll((Collection)defaultEditSheetMergeResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || defaultEditSheetMergeResult.isModified());
        modifiableResult.setDefaultEditSheet((String)defaultEditSheetMergeResult.getMergeResult());
        MergeManagerResult validationScriptMergeResult = this.getMergeManager().mergeObject((Object)previousClass.getValidationScript(), (Object)newClass.getValidationScript(), (Object)this.getValidationScript(), configuration);
        mergeResult.getLog().addAll((Collection)validationScriptMergeResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || validationScriptMergeResult.isModified());
        modifiableResult.setValidationScript((String)validationScriptMergeResult.getMergeResult());
        MergeManagerResult nameFieldMergeResult = this.getMergeManager().mergeObject((Object)previousClass.getNameField(), (Object)newClass.getNameField(), (Object)this.getNameField(), configuration);
        mergeResult.getLog().addAll((Collection)nameFieldMergeResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || nameFieldMergeResult.isModified());
        modifiableResult.setNameField((String)nameFieldMergeResult.getMergeResult());
        return mergeResult;
    }

    @Override
    public boolean apply(ElementInterface newElement, boolean clean) {
        boolean modified = super.apply(newElement, clean);
        BaseClass newBaseClass = (BaseClass)newElement;
        if (!Strings.CS.equals(this.getCustomClass(), newBaseClass.getCustomClass())) {
            this.setCustomClass(newBaseClass.getCustomClass());
            modified = true;
        }
        if (!Strings.CS.equals(this.getCustomMapping(), newBaseClass.getCustomMapping())) {
            this.setCustomMapping(newBaseClass.getCustomMapping());
            modified = true;
        }
        if (!Strings.CS.equals(this.getDefaultWeb(), newBaseClass.getDefaultWeb())) {
            this.setDefaultWeb(newBaseClass.getDefaultWeb());
            modified = true;
        }
        if (!Strings.CS.equals(this.getDefaultViewSheet(), newBaseClass.getDefaultViewSheet())) {
            this.setDefaultViewSheet(newBaseClass.getDefaultViewSheet());
            modified = true;
        }
        if (!Strings.CS.equals(this.getDefaultEditSheet(), newBaseClass.getDefaultEditSheet())) {
            this.setDefaultEditSheet(newBaseClass.getDefaultEditSheet());
            modified = true;
        }
        if (!Strings.CS.equals(this.getValidationScript(), newBaseClass.getValidationScript())) {
            this.setValidationScript(newBaseClass.getValidationScript());
            modified = true;
        }
        if (!Strings.CS.equals(this.getNameField(), newBaseClass.getNameField())) {
            this.setNameField(newBaseClass.getNameField());
            modified = true;
        }
        return modified;
    }

    @Override
    public void setOwnerDocument(XWikiDocument ownerDocument) {
        if (this.ownerDocument != ownerDocument) {
            super.setOwnerDocument(ownerDocument);
            if (this.ownerDocument != null) {
                this.setDocumentReference(this.ownerDocument.getDocumentReference());
            }
        }
    }

    @Deprecated
    public String displaySearchColumns(String string, XWikiQuery xWikiQuery, XWikiContext xWikiContext) {
        return BaseClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BaseClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BaseClass$displaySearchColumns(this, string, xWikiQuery, xWikiContext);
    }

    @Deprecated
    public String displaySearchOrder(String string, XWikiQuery xWikiQuery, XWikiContext xWikiContext) {
        return BaseClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BaseClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BaseClass$displaySearchOrder(this, string, xWikiQuery, xWikiContext);
    }

    @Deprecated
    public String makeQuery(XWikiCriteria xWikiCriteria) {
        return BaseClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BaseClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BaseClass$makeQuery(this, xWikiCriteria);
    }
}

