/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.internal.AbstractNotifyOnUpdateList;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.collection.spi.PersistentCollection;
import org.xwiki.store.merge.MergeManagerResult;

public class ListProperty
extends BaseProperty
implements Cloneable {
    private static final long serialVersionUID = 1L;
    protected transient List<String> list;
    @Deprecated
    private String formStringSeparator = "|";
    private List<String> actualList = new ArrayList<String>();

    public ListProperty() {
        this.list = new NotifyList(this.actualList, this);
    }

    @Deprecated
    public String getFormStringSeparator() {
        return this.formStringSeparator;
    }

    @Deprecated
    public void setFormStringSeparator(String formStringSeparator) {
        this.formStringSeparator = formStringSeparator;
    }

    @Override
    public Object getValue() {
        return this.getList();
    }

    @Override
    public void setValue(Object value) {
        this.setList((List)value);
    }

    public String getTextValue() {
        return this.toText();
    }

    @Override
    public String toText() {
        return ListClass.getStringFromList(this.getList(), "|");
    }

    @Deprecated
    public String toSingleFormString() {
        return super.toFormString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        List<String> list1 = this.getList();
        List list2 = (List)((BaseProperty)obj).getValue();
        if (list1 instanceof PersistentCollection && !((PersistentCollection)list1).wasInitialized()) {
            return true;
        }
        if (list2 instanceof PersistentCollection && !((PersistentCollection)list2).wasInitialized()) {
            return true;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Object obj2;
            String obj1 = list1.get(i);
            if (obj1.equals(obj2 = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ListProperty clone() {
        return (ListProperty)super.clone();
    }

    @Override
    public ListProperty clone(boolean detach) {
        return (ListProperty)super.clone(detach);
    }

    @Override
    protected void cloneInternal(BaseProperty clone) {
        ListProperty property = (ListProperty)clone;
        property.actualList = new ArrayList<String>();
        for (String entry : this.getList()) {
            property.actualList.add(entry);
        }
        property.list = new NotifyList(property.actualList, property);
    }

    public List<String> getList() {
        if (!(this.list instanceof NotifyList)) {
            return new NotifyList(this.list, this);
        }
        return this.list;
    }

    public void setList(List<String> list) {
        if (list == this.list || list == this.actualList) {
            return;
        }
        if (list == null) {
            if (!this.actualList.isEmpty()) {
                this.actualList.clear();
                this.setDirty(true);
            }
        } else if (!this.list.equals(list)) {
            this.actualList.clear();
            list.stream().map(e -> e == null ? "" : e).forEach(this.actualList::add);
            this.setDirty(true);
        }
    }

    @Override
    public String toString() {
        if (this.getList() instanceof PersistentCollection && !((PersistentCollection)this.getList()).wasInitialized()) {
            return "";
        }
        return super.toString();
    }

    @Override
    protected MergeManagerResult<Object, Object> mergeValue(Object previousValue, Object newValue, MergeConfiguration configuration) {
        MergeManagerResult listStringMergeManagerResult = this.getMergeManager().mergeList((List)previousValue, (List)newValue, this.list, configuration);
        MergeManagerResult result = new MergeManagerResult();
        result.setLog(listStringMergeManagerResult.getLog());
        result.setMergeResult(listStringMergeManagerResult.getMergeResult());
        result.setModified(listStringMergeManagerResult.isModified());
        return result;
    }

    public static class NotifyList
    extends AbstractNotifyOnUpdateList<String> {
        private ListProperty owner;
        private boolean dirty;
        private final List<String> actualList;

        public NotifyList(List<String> list) {
            super(list);
            this.actualList = list;
        }

        private NotifyList(List<String> list, ListProperty owner) {
            this(list);
            this.owner = owner;
        }

        @Override
        public void onUpdate() {
            this.setDirty();
        }

        public void setOwner(ListProperty owner) {
            if (this.owner != owner) {
                if (this.dirty) {
                    owner.setDirty(true);
                }
                this.owner = owner;
                owner.actualList = this.actualList;
            }
        }

        public boolean isWrapper(Object collection) {
            return this.actualList == collection;
        }

        private void setDirty() {
            if (this.owner != null) {
                this.owner.setValueDirty(true);
            }
            this.dirty = true;
        }
    }
}

