/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.web.Utils;
import java.util.Objects;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.properties.ConverterManager;

public class BaseStringProperty
extends BaseProperty {
    private static final long serialVersionUID = 1L;
    private String value;

    @Override
    public String getValue() {
        return this.value != null ? this.value : "";
    }

    @Override
    public void setValue(Object value) {
        String stringValue = value instanceof String ? (String)value : (String)BaseStringProperty.getConverterManager().convert(String.class, value);
        if (!this.isValueDirty() && !Strings.CS.equals(stringValue, this.getValue())) {
            this.setValueDirty(true);
        }
        this.value = stringValue;
    }

    @Override
    public String toText() {
        return this.getValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BaseStringProperty)) {
            return false;
        }
        return Objects.equals(this.getValue(), ((BaseStringProperty)obj).getValue());
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.getValue());
        return builder.toHashCode();
    }

    @Override
    public BaseStringProperty clone() {
        return (BaseStringProperty)super.clone();
    }

    @Override
    public BaseStringProperty clone(boolean detach) {
        return (BaseStringProperty)super.clone(detach);
    }

    @Override
    protected void cloneInternal(BaseProperty clone) {
        BaseStringProperty property = (BaseStringProperty)clone;
        property.setValue(this.getValue());
    }

    private static ConverterManager getConverterManager() {
        return Utils.getComponent(ConverterManager.class);
    }
}

