/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseElement;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.dom4j.Element;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.store.merge.MergeManagerResult;
import org.xwiki.xml.XMLUtils;

public class BaseProperty<R extends EntityReference>
extends BaseElement<R>
implements PropertyInterface,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final String MERGE_CONFLICT_LOG = "Collision found on property [{}] between from value [{}] and to [{}]";
    private BaseCollection object;
    private long id;

    @Override
    protected R createReference() {
        Object reference = this.object.getReference() instanceof ObjectReference ? new ObjectPropertyReference(this.getName(), (ObjectReference)this.object.getReference()) : super.createReference();
        return reference;
    }

    @Override
    public BaseCollection getObject() {
        return this.object;
    }

    @Override
    public void setObject(BaseCollection object) {
        if (this.object != object) {
            this.object = object;
            if (this.object != null) {
                this.setOwnerDocument(object.getOwnerDocument());
                if (this.isDirty()) {
                    this.object.setDirty(true);
                }
            }
        }
    }

    @Override
    public boolean equals(Object el) {
        if (this == el) {
            return true;
        }
        if (el == null) {
            return false;
        }
        if (this.object == null || ((BaseProperty)el).getObject() == null) {
            return this.hashCode() == el.hashCode();
        }
        if (!super.equals(el)) {
            return false;
        }
        return this.getId() == ((BaseProperty)el).getId();
    }

    @Override
    public long getId() {
        if (this.object == null) {
            return this.id;
        }
        return this.getObject().getId();
    }

    @Override
    public void setId(long id) {
        if (id != this.id) {
            this.id = id;
            this.setDirty(true);
        }
    }

    @Override
    public int hashCode() {
        return (this.getId() + this.getName()).hashCode();
    }

    public String getClassType() {
        return this.getClass().getName();
    }

    public void setClassType(String type) {
    }

    @Override
    protected void detachOwner() {
        super.detachOwner();
        this.setObject(null);
    }

    @Override
    protected void cloneOwner() {
        super.cloneOwner();
        if (this.getOwnerDocument() != null && this.getObject() != null) {
            this.setObject(this.ownerDocument.getXObject((EntityReference)this.object.getReference()));
        }
    }

    @Override
    public BaseProperty<R> clone() {
        return (BaseProperty)super.clone();
    }

    @Override
    public BaseProperty<R> clone(boolean detach) {
        return (BaseProperty)super.clone(detach);
    }

    protected void cloneInternal(BaseProperty clone) {
    }

    @Override
    protected void cloneContent(BaseElement<R> element) {
        super.cloneContent(element);
        this.cloneInternal((BaseProperty)element);
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    @Override
    public Element toXML() {
        return super.toXML();
    }

    @Override
    public String toFormString() {
        return XMLUtils.escape((String)this.toText());
    }

    public String toText() {
        Object value = this.getValue();
        return value == null ? "" : value.toString();
    }

    public String toXMLString() {
        return super.toXMLString(true);
    }

    public Object getCustomMappingValue() {
        return this.getValue();
    }

    @Override
    public void merge(ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context, MergeResult mergeResult) {
        MergeManagerResult<ElementInterface, Object> mergeManagerResult = this.merge(previousElement, newElement, configuration, context);
        mergeResult.setModified(mergeResult.isModified() || mergeManagerResult.isModified());
        mergeResult.getLog().addAll((Collection)mergeManagerResult.getLog());
        this.setValue(((BaseProperty)mergeManagerResult.getMergeResult()).getValue());
    }

    @Override
    public MergeManagerResult<ElementInterface, Object> merge(ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context) {
        MergeManagerResult<ElementInterface, Object> mergeResult = super.merge(previousElement, newElement, configuration, context);
        BaseProperty modifiableResult = (BaseProperty)mergeResult.getMergeResult();
        Object previousValue = ((BaseProperty)previousElement).getValue();
        Object newValue = ((BaseProperty)newElement).getValue();
        if (previousValue == null) {
            if (newValue != null) {
                if (this.getValue() == null) {
                    modifiableResult.setValue(newValue);
                    mergeResult.setModified(true);
                } else {
                    if (configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.NEXT) {
                        modifiableResult.setValue(newValue);
                        mergeResult.setModified(true);
                    }
                    mergeResult.getLog().error(MERGE_CONFLICT_LOG, new Object[]{this.getName(), this.getValue(), newValue});
                }
            }
        } else if (newValue == null) {
            if (Objects.equals(previousValue, this.getValue())) {
                modifiableResult.setValue(null);
                mergeResult.setModified(true);
            } else {
                mergeResult.getLog().error(MERGE_CONFLICT_LOG, new Object[]{this.getName(), this.getValue(), newValue});
            }
        } else if (Objects.equals(previousValue, this.getValue())) {
            modifiableResult.setValue(newValue);
            mergeResult.setModified(true);
        } else if (previousValue.getClass() != newValue.getClass()) {
            mergeResult.getLog().error(MERGE_CONFLICT_LOG, new Object[]{this.getName(), this.getValue(), newValue});
        } else if (!Objects.equals(newValue, this.getValue())) {
            MergeManagerResult<Object, Object> mergeValueResult = this.mergeValue(previousValue, newValue, configuration);
            mergeResult.getLog().addAll((Collection)mergeValueResult.getLog());
            if (mergeValueResult.isModified()) {
                modifiableResult.setValue(mergeValueResult.getMergeResult());
                mergeResult.setModified(true);
                mergeResult.addConflicts(mergeValueResult.getConflicts());
            }
        }
        return mergeResult;
    }

    @Deprecated(since="14.10.7,15.2RC1")
    protected void mergeValue(Object previousValue, Object newValue, MergeResult mergeResult) {
        MergeManagerResult<Object, Object> result = this.mergeValue(previousValue, newValue, new MergeConfiguration());
        mergeResult.setModified(mergeResult.isModified() || result.isModified());
        mergeResult.getLog().addAll((Collection)result.getLog());
        if (result.isModified()) {
            this.setValue(result.getMergeResult());
        }
    }

    protected MergeManagerResult<Object, Object> mergeValue(Object previousValue, Object newValue, MergeConfiguration mergeConfiguration) {
        MergeManagerResult result = new MergeManagerResult();
        result.setMergeResult(this.getValue());
        result.getLog().error(MERGE_CONFLICT_LOG, new Object[]{this.getName(), this.getValue(), newValue});
        return result;
    }

    @Override
    public boolean apply(ElementInterface newProperty, boolean clean) {
        boolean modified = super.apply(newProperty, clean);
        BaseProperty newBaseProperty = (BaseProperty)newProperty;
        if (ObjectUtils.notEqual((Object)newBaseProperty.getValue(), (Object)this.getValue())) {
            this.setValue(newBaseProperty.getValue());
            modified = true;
        }
        return modified;
    }

    @Deprecated(since="17.1.0RC1")
    public boolean isValueDirty() {
        return this.isDirty();
    }

    protected void setValueDirty(Object newValue) {
        if (!this.isDirty() && !Objects.equals(newValue, this.getValue())) {
            this.setValueDirty(true);
        }
    }

    @Deprecated(since="17.1.0RC1")
    public void setValueDirty(boolean valueDirty) {
        this.setDirty(valueDirty);
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty && this.object != null) {
            this.object.setDirty(true);
        }
    }

    public PropertyClass getPropertyClass(XWikiContext xcontext) {
        BaseObject xobject;
        XWikiDocument document;
        if (this.getObject() instanceof BaseObject && (document = this.getOwnerDocument()) != null && (xobject = document.getXObject(this.getReference().getParent())) != null) {
            BaseClass xclass = xobject.getXClass(xcontext);
            return (PropertyClass)xclass.get(this.getName());
        }
        return null;
    }
}

