/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilterUtils;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Provider;
import javax.xml.transform.Result;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.StringInputSource;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.filter.xml.output.DefaultResultOutputTarget;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.stability.Unstable;
import org.xwiki.store.merge.MergeManager;
import org.xwiki.store.merge.MergeManagerResult;

public abstract class BaseElement<R extends EntityReference>
implements ElementInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseElement.class);
    protected R referenceCache;
    protected DocumentReference documentReference;
    protected transient XWikiDocument ownerDocument;
    private String name;
    private String prettyName;
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    private EntityReferenceSerializer<String> localUidStringEntityReferenceSerializer;
    private ContextualLocalizationManager localization;
    private transient boolean dirty = true;

    @Unstable
    public boolean isDirty() {
        return this.dirty;
    }

    @Unstable
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty && this.ownerDocument != null) {
            this.ownerDocument.setMetaDataDirty(true);
        }
    }

    protected MergeManager getMergeManager() {
        return Utils.getComponent(MergeManager.class);
    }

    public R getReference() {
        if (this.referenceCache == null) {
            this.referenceCache = this.createReference();
        }
        return this.referenceCache;
    }

    protected R createReference() {
        return null;
    }

    @Override
    public DocumentReference getDocumentReference() {
        if (this.documentReference == null && this.name != null) {
            throw new IllegalStateException("BaseElement#getDocumentReference could not be called when a non-reference Name has been set.");
        }
        return this.documentReference;
    }

    @Override
    public String getName() {
        if (this.name == null && this.documentReference != null) {
            this.name = (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)this.documentReference, new Object[0]);
        }
        return this.name;
    }

    @Override
    public void setDocumentReference(DocumentReference documentReference) {
        if (!Objects.equals(documentReference, this.documentReference)) {
            this.documentReference = documentReference;
            this.name = null;
            this.referenceCache = null;
            if (this.isDirty()) {
                this.setDirty(true);
            }
        }
    }

    @Override
    public void setName(String name) {
        if (this.documentReference != null) {
            throw new IllegalStateException("BaseElement#setName could not be called when a reference has been set.");
        }
        if (!Strings.CS.equals(name, this.name)) {
            this.name = name;
            this.referenceCache = null;
            this.setDirty(true);
        }
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setPrettyName(String name) {
        this.prettyName = name;
    }

    protected EntityReferenceSerializer<String> getLocalUidStringEntityReferenceSerializer() {
        if (this.localUidStringEntityReferenceSerializer == null) {
            this.localUidStringEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local/uid");
        }
        return this.localUidStringEntityReferenceSerializer;
    }

    protected EntityReferenceSerializer<String> getLocalEntityReferenceSerializer() {
        if (this.localEntityReferenceSerializer == null) {
            this.localEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
        }
        return this.localEntityReferenceSerializer;
    }

    protected ContextualLocalizationManager getLocalization() {
        if (this.localization == null) {
            this.localization = Utils.getComponent(ContextualLocalizationManager.class);
        }
        return this.localization;
    }

    protected String localizePlain(String key, Object ... parameters) {
        return this.getLocalization().getTranslationPlain(key, parameters);
    }

    protected String localizePlainOrKey(String key, Object ... parameters) {
        return StringUtils.defaultString((String)this.getLocalization().getTranslationPlain(key, parameters), (String)key);
    }

    protected String getLocalKey() {
        return (String)this.getLocalUidStringEntityReferenceSerializer().serialize(this.getReference(), new Object[0]);
    }

    public long getId() {
        String key = this.getLocalKey();
        if (key != null) {
            return Util.getHash(key);
        }
        return 0L;
    }

    public void setId(long id) {
    }

    public int hashCode() {
        return (int)Util.getHash(this.getLocalKey());
    }

    public boolean equals(Object el) {
        if (this == el) {
            return true;
        }
        if (el == null || !el.getClass().equals(this.getClass())) {
            return false;
        }
        BaseElement element = (BaseElement)el;
        if (element.documentReference != null) {
            if (!element.documentReference.equals((Object)this.documentReference)) {
                return false;
            }
        } else {
            if (this.documentReference != null) {
                return false;
            }
            if (element.name == null ? this.name != null : !element.name.equals(this.name)) {
                return false;
            }
        }
        return !(element.getPrettyName() == null ? this.getPrettyName() != null : !element.getPrettyName().equals(this.getPrettyName()));
    }

    @Unstable
    protected void detachOwner() {
        this.ownerDocument = null;
        this.documentReference = null;
        this.referenceCache = null;
    }

    @Unstable
    protected void cloneOwner() {
        if (this.ownerDocument != null) {
            this.ownerDocument = this.ownerDocument.clone();
        }
    }

    public BaseElement<R> clone() {
        return this.clone(false);
    }

    @Unstable
    public BaseElement<R> clone(boolean detach) {
        BaseElement element;
        try {
            element = (BaseElement)super.clone();
            if (detach) {
                element.detachOwner();
            } else {
                element.cloneOwner();
            }
            this.cloneContent(element);
            element.setDirty(this.isDirty());
        }
        catch (CloneNotSupportedException e) {
            element = null;
        }
        return element;
    }

    @Unstable
    protected void cloneContent(BaseElement<R> element) {
        element.setPrettyName(this.getPrettyName());
    }

    @Override
    public void merge(ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context, MergeResult mergeResult) {
        MergeManagerResult<ElementInterface, Object> mergeManagerResult = this.merge(previousElement, newElement, configuration, context);
        mergeResult.getLog().addAll((Collection)mergeManagerResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || mergeManagerResult.isModified());
    }

    @Override
    public MergeManagerResult<ElementInterface, Object> merge(ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context) {
        MergeManagerResult mergeManagerResult = new MergeManagerResult();
        if (configuration.isProvidedVersionsModifiables()) {
            mergeManagerResult.setMergeResult((Object)this);
        } else {
            mergeManagerResult.setMergeResult(this.clone());
        }
        MergeManagerResult mergePrettyNameResult = this.getMergeManager().mergeCharacters(((BaseElement)previousElement).getPrettyName(), ((BaseElement)newElement).getPrettyName(), this.getPrettyName(), configuration);
        mergeManagerResult.setLog(mergePrettyNameResult.getLog());
        if (mergePrettyNameResult.isModified()) {
            mergeManagerResult.setModified(true);
            ((BaseElement)mergeManagerResult.getMergeResult()).setPrettyName((String)mergePrettyNameResult.getMergeResult());
        }
        return mergeManagerResult;
    }

    @Override
    public boolean apply(ElementInterface newElement, boolean clean) {
        boolean modified = false;
        BaseElement newBaseElement = (BaseElement)newElement;
        if (!Strings.CS.equals(newBaseElement.getPrettyName(), this.getPrettyName())) {
            this.setPrettyName(newBaseElement.getPrettyName());
            modified = true;
        }
        return modified;
    }

    public void setOwnerDocument(XWikiDocument ownerDocument) {
        if (this.ownerDocument != ownerDocument) {
            this.ownerDocument = ownerDocument;
            if (this.ownerDocument != null && this.isDirty()) {
                this.ownerDocument.setMetaDataDirty(true);
            }
        }
    }

    public XWikiDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    protected XWikiContext getXWikiContext() {
        Provider xcontextProvider = (Provider)Utils.getComponent(XWikiContext.TYPE_PROVIDER);
        if (xcontextProvider != null) {
            return (XWikiContext)xcontextProvider.get();
        }
        return null;
    }

    protected void fromXML(Element oel) throws XWikiException {
        StringWriter writer = new StringWriter();
        try {
            XMLWriter domWriter = new XMLWriter((Writer)writer);
            domWriter.write(oel);
            domWriter.flush();
        }
        catch (IOException e) {
            throw new XWikiException(2, 2002, "Error parsing xml", e, null);
        }
        this.fromXML(writer.toString());
    }

    public void fromXML(String source) throws XWikiException {
        if (!source.isEmpty()) {
            try {
                Utils.getComponent(XWikiDocumentFilterUtils.class).importEntity(this, (InputSource)new StringInputSource(source));
            }
            catch (Exception e) {
                throw new XWikiException(2, 2002, "Error parsing xml", e, null);
            }
        }
    }

    protected Element toXML() {
        DocumentResult domResult = new DocumentResult();
        try {
            Utils.getComponent(XWikiDocumentFilterUtils.class).exportEntity((Object)this, (OutputTarget)new DefaultResultOutputTarget((Result)domResult));
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize element to XML", (Throwable)e);
            return null;
        }
        return domResult.getDocument().getRootElement();
    }

    public String toXMLString(boolean format) {
        XAROutputProperties xarProperties = new XAROutputProperties();
        xarProperties.setFormat(format);
        try {
            return Utils.getComponent(XWikiDocumentFilterUtils.class).exportEntity((Object)this, xarProperties);
        }
        catch (Exception e) {
            LOGGER.error("Failed to serialize collection to XML", (Throwable)e);
            return "";
        }
    }

    @Override
    public String toString() {
        return this.toXMLString(true);
    }

    public static /* synthetic */ String ajc$get$name(BaseElement baseElement) {
        return baseElement.name;
    }

    public static /* synthetic */ void ajc$set$name(BaseElement baseElement, String string) {
        baseElement.name = string;
    }
}

