/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.objects.BaseCollectionCompatibiityAspect;
import com.xpn.xwiki.objects.BaseElement;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.BaseStringProperty;
import com.xpn.xwiki.objects.DBStringListProperty;
import com.xpn.xwiki.objects.DateProperty;
import com.xpn.xwiki.objects.DoubleProperty;
import com.xpn.xwiki.objects.ElementComparator;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.FloatProperty;
import com.xpn.xwiki.objects.IntegerProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.ListProperty;
import com.xpn.xwiki.objects.LongProperty;
import com.xpn.xwiki.objects.NumberProperty;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.ObjectInterface;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.StringListProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.stability.Unstable;
import org.xwiki.store.merge.MergeManagerResult;

public abstract class BaseCollection<R extends EntityReference>
extends BaseElement<R>
implements ObjectInterface,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCollection.class);
    private EntityReference xClassReference;
    private DocumentReference xClassReferenceCache;
    protected Map<String, Object> fields = new LinkedHashMap<String, Object>();
    protected List<Object> fieldsToRemove = new ArrayList<Object>();
    protected int number;
    protected EntityReferenceResolver<String> relativeEntityReferenceResolver;
    protected DocumentReferenceResolver<EntityReference> currentReferenceDocumentReferenceResolver;

    protected EntityReferenceResolver<String> getRelativeEntityReferenceResolver() {
        if (this.relativeEntityReferenceResolver == null) {
            this.relativeEntityReferenceResolver = (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "relative");
        }
        return this.relativeEntityReferenceResolver;
    }

    protected DocumentReferenceResolver<EntityReference> getCurrentReferenceDocumentReferenceResolver() {
        if (this.currentReferenceDocumentReferenceResolver == null) {
            this.currentReferenceDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE, "current");
        }
        return this.currentReferenceDocumentReferenceResolver;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void addPropertyForRemoval(PropertyInterface field) {
        this.getFieldsToRemove().add(field);
    }

    public DocumentReference getXClassReference() {
        if (this.xClassReferenceCache == null && this.getRelativeXClassReference() != null) {
            this.xClassReferenceCache = this.getCurrentReferenceDocumentReferenceResolver().resolve((Object)this.getRelativeXClassReference(), new Object[]{this.getDocumentReference()});
        }
        return this.xClassReferenceCache;
    }

    public EntityReference getRelativeXClassReference() {
        return this.xClassReference;
    }

    @Deprecated
    public String getClassName() {
        String xClassAsString = this.getXClassReference() != null ? (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)this.getXClassReference(), new Object[0]) : "";
        return xClassAsString;
    }

    public void setXClassReference(EntityReference xClassReference) {
        EntityReference wiki;
        EntityReference ref = xClassReference;
        if (ref != null && (wiki = xClassReference.extractReference(EntityType.WIKI)) != null) {
            ref = xClassReference.removeParent(wiki);
        }
        if (!Objects.equals(this.xClassReference, ref)) {
            this.xClassReference = ref;
            this.xClassReferenceCache = null;
            this.setDirty(true);
        }
    }

    @Deprecated
    public void setClassName(String name) {
        EntityReference xClassReference = null;
        if (!StringUtils.isEmpty((CharSequence)name) && !"internal".equals(name)) {
            xClassReference = this.getRelativeEntityReferenceResolver().resolve((Object)name, EntityType.DOCUMENT, new Object[0]);
        }
        this.setXClassReference(xClassReference);
    }

    @Override
    public PropertyInterface safeget(String name) {
        return (PropertyInterface)this.getFields().get(name);
    }

    @Override
    public PropertyInterface get(String name) throws XWikiException {
        return this.safeget(name);
    }

    @Override
    public void safeput(String name, PropertyInterface property) {
        this.addField(name, property);
        if (property instanceof BaseProperty) {
            ((BaseProperty)property).setName(name);
        }
    }

    @Override
    public void put(String name, PropertyInterface property) throws XWikiException {
        this.safeput(name, property);
    }

    @Override
    public BaseClass getXClass(XWikiContext context) {
        BaseClass baseClass = null;
        if (context == null || context.getWiki() == null) {
            return baseClass;
        }
        DocumentReference classReference = this.getXClassReference();
        if (classReference != null) {
            try {
                baseClass = context.getWiki().getXClass(classReference, context);
            }
            catch (Exception e) {
                LOGGER.error("Failed to get class [" + String.valueOf(classReference) + "]", (Throwable)e);
            }
        }
        return baseClass;
    }

    public String getStringValue(String name) {
        BaseProperty prop = (BaseProperty)this.safeget(name);
        if (prop == null || prop.getValue() == null) {
            return "";
        }
        return prop.getValue().toString();
    }

    public String getLargeStringValue(String name) {
        return this.getStringValue(name);
    }

    public void setStringValue(String name, String value) {
        BaseStringProperty property = (BaseStringProperty)this.safeget(name);
        if (!(property instanceof StringProperty)) {
            if (property != null) {
                this.removeField(name);
            }
            property = new StringProperty();
        }
        property.setName(name);
        property.setValue(value);
        this.safeput(name, property);
    }

    public void setLargeStringValue(String name, String value) {
        BaseStringProperty property = (BaseStringProperty)this.safeget(name);
        if (!(property instanceof LargeStringProperty)) {
            if (property != null) {
                this.removeField(name);
            }
            property = new LargeStringProperty();
        }
        property.setName(name);
        property.setValue(value);
        this.safeput(name, property);
    }

    public int getIntValue(String name) {
        return this.getIntValue(name, 0);
    }

    public int getIntValue(String name, int default_value) {
        try {
            NumberProperty prop = (NumberProperty)this.safeget(name);
            if (prop == null) {
                return default_value;
            }
            return ((Number)prop.getValue()).intValue();
        }
        catch (Exception e) {
            return default_value;
        }
    }

    public void setIntValue(String name, int value) {
        IntegerProperty property = new IntegerProperty();
        property.setName(name);
        property.setValue(value);
        this.safeput(name, property);
    }

    public long getLongValue(String name) {
        try {
            NumberProperty prop = (NumberProperty)this.safeget(name);
            if (prop == null) {
                return 0L;
            }
            return ((Number)prop.getValue()).longValue();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void setLongValue(String name, long value) {
        LongProperty property = new LongProperty();
        property.setName(name);
        property.setValue(value);
        this.safeput(name, property);
    }

    public float getFloatValue(String name) {
        try {
            NumberProperty prop = (NumberProperty)this.safeget(name);
            if (prop == null) {
                return 0.0f;
            }
            return ((Number)prop.getValue()).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setFloatValue(String name, float value) {
        FloatProperty property = new FloatProperty();
        property.setName(name);
        property.setValue(Float.valueOf(value));
        this.safeput(name, property);
    }

    public double getDoubleValue(String name) {
        try {
            NumberProperty prop = (NumberProperty)this.safeget(name);
            if (prop == null) {
                return 0.0;
            }
            return ((Number)prop.getValue()).doubleValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void setDoubleValue(String name, double value) {
        DoubleProperty property = new DoubleProperty();
        property.setName(name);
        property.setValue(value);
        this.safeput(name, property);
    }

    public Date getDateValue(String name) {
        try {
            DateProperty prop = (DateProperty)this.safeget(name);
            if (prop == null) {
                return null;
            }
            return (Date)prop.getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDateValue(String name, Date value) {
        DateProperty property = new DateProperty();
        property.setName(name);
        property.setValue(value);
        this.safeput(name, property);
    }

    public Set<?> getSetValue(String name) {
        ListProperty prop = (ListProperty)this.safeget(name);
        if (prop == null) {
            return new HashSet();
        }
        return new HashSet((Collection)prop.getValue());
    }

    public void setSetValue(String name, Set<?> value) {
        ListProperty property = new ListProperty();
        property.setValue(value);
        this.safeput(name, property);
    }

    public List getListValue(String name) {
        ListProperty prop = (ListProperty)this.safeget(name);
        if (prop == null) {
            return new ArrayList();
        }
        return (List)prop.getValue();
    }

    public void setStringListValue(String name, List value) {
        ListProperty property = (ListProperty)this.safeget(name);
        if (property == null) {
            property = new StringListProperty();
        }
        property.setValue(value);
        this.safeput(name, property);
    }

    public void setDBStringListValue(String name, List value) {
        ListProperty property = (ListProperty)this.safeget(name);
        if (property == null) {
            property = new DBStringListProperty();
        }
        property.setValue(value);
        this.safeput(name, property);
    }

    private Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map fields) {
        this.fields = fields;
    }

    public PropertyInterface getField(String name) {
        return (PropertyInterface)this.fields.get(name);
    }

    public void addField(String name, PropertyInterface element) {
        this.fields.put(name, element);
        if (element instanceof BaseElement) {
            BaseElement baseElement = (BaseElement)((Object)element);
            baseElement.setOwnerDocument(this.getOwnerDocument());
            if (element instanceof BaseProperty) {
                BaseProperty baseProperty = (BaseProperty)element;
                baseProperty.setObject(this);
            }
        }
        this.setDirty(true);
    }

    public void removeField(String name) {
        PropertyInterface field = this.safeget(name);
        if (field != null) {
            this.fields.remove(name);
            this.fieldsToRemove.add(field);
            this.setDirty(true);
        }
    }

    public Collection getFieldList() {
        return this.fields.values();
    }

    public Set<String> getPropertyList() {
        return this.fields.keySet();
    }

    public Object[] getProperties() {
        return this.getFields().values().toArray();
    }

    public String[] getPropertyNames() {
        return this.getFields().keySet().toArray(new String[0]);
    }

    public Iterator getSortedIterator() {
        Iterator<Object> it = null;
        try {
            List<Object> propList = Arrays.asList(this.getProperties());
            Collections.sort(propList, new ElementComparator());
            it = propList.iterator();
        }
        catch (ClassCastException ccex) {
            it = this.getFieldList().iterator();
        }
        return it;
    }

    @Override
    public boolean equals(Object coll) {
        if (this == coll) {
            return true;
        }
        if (!super.equals(coll)) {
            return false;
        }
        BaseCollection collection = (BaseCollection)coll;
        if (collection.getXClassReference() == null ? this.getXClassReference() != null : !collection.getXClassReference().equals((Object)this.getXClassReference())) {
            return false;
        }
        if (this.getFields().size() != collection.getFields().size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.getFields().entrySet()) {
            Object prop2;
            Object prop = entry.getValue();
            if (prop.equals(prop2 = collection.getFields().get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BaseCollection<R> clone() {
        return (BaseCollection)super.clone();
    }

    @Override
    protected void cloneContent(BaseElement<R> element) {
        super.cloneContent(element);
        BaseCollection collection = (BaseCollection)element;
        collection.setXClassReference(this.getRelativeXClassReference());
        collection.setNumber(this.getNumber());
        Map<String, Object> fields = this.getFields();
        HashMap<String, PropertyInterface> cfields = new HashMap<String, PropertyInterface>();
        Iterator<Map.Entry<String, Object>> iterator = fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> objEntry;
            Map.Entry<String, Object> entry = objEntry = iterator.next();
            PropertyInterface prop = (PropertyInterface)((Object)((BaseElement)entry.getValue()).clone(true));
            prop.setObject(collection);
            cfields.put(entry.getKey(), prop);
        }
        collection.setFields(cfields);
    }

    public void merge(BaseObject object) {
        for (String name : object.getPropertyList()) {
            if (this.safeget(name) != null) continue;
            this.safeput(name, (PropertyInterface)((Object)((BaseElement)((Object)object.safeget(name))).clone(true)));
        }
    }

    public List<ObjectDiff> getDiff(Object oldObject, XWikiContext context) {
        String propertyType;
        PropertyClass pclass;
        BaseClass bclass;
        BaseProperty oldProperty;
        BaseProperty newProperty;
        String propertyName;
        String key;
        ArrayList<ObjectDiff> difflist = new ArrayList<ObjectDiff>();
        BaseCollection oldCollection = (BaseCollection)oldObject;
        Iterator<String> iterator = this.getFields().keySet().iterator();
        while (iterator.hasNext()) {
            String newPropertyValue;
            propertyName = key = iterator.next();
            newProperty = (BaseProperty)this.getFields().get(propertyName);
            oldProperty = (BaseProperty)oldCollection.getFields().get(propertyName);
            bclass = this.getXClass(context);
            pclass = (PropertyClass)(bclass == null ? null : bclass.getField(propertyName));
            String string = propertyType = pclass == null ? "" : pclass.getClassType();
            if (oldProperty == null) {
                if (newProperty == null || newProperty.toText().equals("") || pclass == null) continue;
                newPropertyValue = newProperty.getValue() instanceof String ? newProperty.toText() : pclass.displayView(propertyName, this, context);
                difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), "", "added", propertyName, propertyType, (Object)"", (Object)newPropertyValue));
                continue;
            }
            if (oldProperty.toText().equals(newProperty == null ? "" : newProperty.toText())) continue;
            if (pclass != null) {
                newPropertyValue = newProperty.getValue() instanceof String ? newProperty.toText() : pclass.displayView(propertyName, this, context);
                String oldPropertyValue = oldProperty.getValue() instanceof String ? oldProperty.toText() : pclass.displayView(propertyName, oldCollection, context);
                difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), "", "changed", propertyName, propertyType, (Object)oldPropertyValue, (Object)newPropertyValue));
                continue;
            }
            difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), "", "changed", propertyName, propertyType, (Object)oldProperty.toText(), (Object)newProperty.toText()));
        }
        iterator = oldCollection.getFields().keySet().iterator();
        while (iterator.hasNext()) {
            propertyName = key = iterator.next();
            newProperty = (BaseProperty)this.getFields().get(propertyName);
            oldProperty = (BaseProperty)oldCollection.getFields().get(propertyName);
            bclass = this.getXClass(context);
            pclass = (PropertyClass)(bclass == null ? null : bclass.getField(propertyName));
            String string = propertyType = pclass == null ? "" : pclass.getClassType();
            if (newProperty != null || oldProperty == null || oldProperty.toText().equals("")) continue;
            if (pclass != null) {
                String oldPropertyValue = oldProperty.getValue() instanceof String ? oldProperty.toText() : pclass.displayView(propertyName, oldCollection, context);
                difflist.add(new ObjectDiff(oldCollection.getXClassReference(), oldCollection.getNumber(), "", "removed", propertyName, propertyType, (Object)oldPropertyValue, (Object)""));
                continue;
            }
            difflist.add(new ObjectDiff(oldCollection.getXClassReference(), oldCollection.getNumber(), "", "removed", propertyName, propertyType, (Object)oldProperty.toText(), (Object)""));
        }
        return difflist;
    }

    public List getFieldsToRemove() {
        return this.fieldsToRemove;
    }

    public void setFieldsToRemove(List fieldsToRemove) {
        this.fieldsToRemove = fieldsToRemove;
    }

    @Override
    public Element toXML() {
        return super.toXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Element toXML(BaseClass bclass) {
        BaseClass currentBaseClass;
        DocumentReference classReference;
        XWikiContext xcontext = this.getXWikiContext();
        if (bclass != null && xcontext != null) {
            classReference = bclass.getDocumentReference();
            currentBaseClass = xcontext.getBaseClass(bclass.getDocumentReference());
            xcontext.addBaseClass(bclass);
        } else {
            classReference = null;
            currentBaseClass = null;
        }
        try {
            Element element = super.toXML();
            return element;
        }
        finally {
            if (classReference != null) {
                if (currentBaseClass != null) {
                    xcontext.addBaseClass(currentBaseClass);
                } else {
                    xcontext.removeBaseClass(classReference);
                }
            }
        }
    }

    public String toXMLString() {
        return this.toXMLString(true);
    }

    public Map<String, Object> getCustomMappingMap() throws XWikiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String name : this.fields.keySet()) {
            BaseProperty property = (BaseProperty)this.get(name);
            map.put(name, property.getCustomMappingValue());
        }
        map.put("id", this.getId());
        return map;
    }

    @Override
    public void setDocumentReference(DocumentReference reference) {
        super.setDocumentReference(reference);
        this.xClassReferenceCache = null;
    }

    @Override
    public MergeManagerResult<ElementInterface, Object> merge(ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context) {
        MergeManagerResult<ElementInterface, Object> mergeResult = super.merge(previousElement, newElement, configuration, context);
        BaseCollection previousCollection = (BaseCollection)previousElement;
        BaseCollection newCollection = (BaseCollection)newElement;
        BaseCollection modifiableResult = (BaseCollection)mergeResult.getMergeResult();
        List<ObjectDiff> classDiff = newCollection.getDiff(previousCollection, context);
        for (ObjectDiff diff : classDiff) {
            PropertyInterface propertyResult = this.getField(diff.getPropName());
            PropertyInterface previousProperty = previousCollection.getField(diff.getPropName());
            PropertyInterface newProperty = newCollection.getField(diff.getPropName());
            if ("added".equals(diff.getAction())) {
                if (propertyResult == null) {
                    modifiableResult.safeput(diff.getPropName(), configuration.isProvidedVersionsModifiables() ? newProperty : newProperty.clone());
                    mergeResult.setModified(true);
                    continue;
                }
                if (propertyResult.equals(newProperty)) continue;
                if (configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.NEXT) {
                    modifiableResult.safeput(diff.getPropName(), configuration.isProvidedVersionsModifiables() ? newProperty : newProperty.clone());
                    mergeResult.setModified(true);
                }
                mergeResult.getLog().error("Collision found on property [{}]", (Object)newProperty.getReference());
                continue;
            }
            if ("removed".equals(diff.getAction())) {
                if (propertyResult != null) {
                    if (propertyResult.equals(previousProperty)) {
                        modifiableResult.removeField(diff.getPropName());
                        mergeResult.setModified(true);
                        continue;
                    }
                    mergeResult.getLog().error("Collision found on property [{}]", (Object)previousProperty.getReference());
                    continue;
                }
                mergeResult.getLog().warn("Property [{}] already removed", (Object)previousProperty.getReference());
                continue;
            }
            if (!"changed".equals(diff.getAction())) continue;
            if (propertyResult != null) {
                if (propertyResult.equals(previousProperty)) {
                    modifiableResult.safeput(diff.getPropName(), configuration.isProvidedVersionsModifiables() ? newProperty : newProperty.clone());
                    mergeResult.setModified(true);
                    continue;
                }
                if (propertyResult.equals(newProperty)) continue;
                MergeResult propertyMergeResult = new MergeResult();
                MergeConfiguration propertyMergeConfiguration = new MergeConfiguration();
                propertyMergeConfiguration.setConcernedDocument(configuration.getConcernedDocument());
                propertyMergeConfiguration.setUserReference(configuration.getUserReference());
                propertyMergeConfiguration.setProvidedVersionsModifiables(true);
                propertyMergeConfiguration.setConflictFallbackVersion(configuration.getConflictFallbackVersion());
                this.mergeField(propertyResult, previousProperty, newProperty, propertyMergeConfiguration, context, propertyMergeResult);
                mergeResult.getLog().addAll((Collection)propertyMergeResult.getLog());
                if (!propertyMergeResult.isModified()) continue;
                mergeResult.setModified(true);
                continue;
            }
            mergeResult.getLog().warn("Collision found on property [{}]", (Object)newProperty.getReference());
            modifiableResult.safeput(diff.getPropName(), configuration.isProvidedVersionsModifiables() ? newProperty : newProperty.clone());
            mergeResult.setModified(true);
        }
        return mergeResult;
    }

    protected void mergeField(PropertyInterface currentElement, ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context, MergeResult mergeResult) {
        currentElement.merge(previousElement, newElement, configuration, context, mergeResult);
    }

    @Override
    public boolean apply(ElementInterface newElement, boolean clean) {
        boolean modified = false;
        BaseCollection newCollection = (BaseCollection)newElement;
        if (clean) {
            ArrayList<String> fieldsToDelete = new ArrayList<String>(this.fields.size());
            for (String key : this.fields.keySet()) {
                if (newCollection.safeget(key) != null) continue;
                fieldsToDelete.add(key);
            }
            for (String key : fieldsToDelete) {
                this.removeField(key);
                modified = true;
            }
        }
        for (Map.Entry<String, Object> entry : newCollection.fields.entrySet()) {
            PropertyInterface field = (PropertyInterface)this.fields.get(entry.getKey());
            PropertyInterface newField = (PropertyInterface)entry.getValue();
            if (field == null) {
                this.safeput(entry.getKey(), newField);
                modified = true;
                continue;
            }
            if (field.getClass() != newField.getClass()) {
                this.removeField(entry.getKey());
                this.safeput(entry.getKey(), newField);
                modified = true;
                continue;
            }
            modified |= field.apply(newField, clean);
        }
        return modified;
    }

    @Override
    public void setOwnerDocument(XWikiDocument ownerDocument) {
        if (this.ownerDocument != ownerDocument) {
            super.setOwnerDocument(ownerDocument);
            for (String propertyName : this.getPropertyList()) {
                PropertyInterface property = this.getField(propertyName);
                if (!(property instanceof BaseElement)) continue;
                ((BaseElement)((Object)property)).setOwnerDocument(ownerDocument);
            }
        }
    }

    @Unstable
    public void setDirty(boolean dirty, boolean deep) {
        this.setDirty(dirty);
        this.fields.values().forEach(field -> {
            if (field instanceof BaseCollection) {
                BaseCollection baseCollection = (BaseCollection)field;
                baseCollection.setDirty(dirty, deep);
            } else if (field instanceof BaseElement) {
                BaseElement baseElement = (BaseElement)field;
                baseElement.setDirty(dirty);
            }
        });
    }

    @Override
    @Deprecated
    public BaseClass getxWikiClass(XWikiContext xWikiContext) {
        return BaseCollectionCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_BaseCollectionCompatibiityAspect$com_xpn_xwiki_objects_BaseCollection$getxWikiClass(this, xWikiContext);
    }

    @Deprecated
    public void setListValue(String string, List list) {
        BaseCollectionCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_BaseCollectionCompatibiityAspect$com_xpn_xwiki_objects_BaseCollection$setListValue(this, string, list);
    }
}

