/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.monitor.api;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.monitor.api.MonitorData;
import com.xpn.xwiki.monitor.api.MonitorTimerSummary;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorPlugin
extends XWikiDefaultPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorPlugin.class);
    private boolean bActive;
    private long duration = 0L;
    private long nbrequests = 0L;
    private Map<String, MonitorTimerSummary> timerSummaries = new HashMap<String, MonitorTimerSummary>();
    private CircularFifoQueue<MonitorData> lastTimerDataList = new CircularFifoQueue();
    private CircularFifoQueue<MonitorData> lastUnfinishedTimerDataList = new CircularFifoQueue();
    private Map<Thread, MonitorData> activeTimerDataList = new HashMap<Thread, MonitorData>();

    public MonitorPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    @Override
    public void init(XWikiContext context) {
        super.init(context);
        this.reset(context);
        long iActive = context.getWiki().ParamAsLong("xwiki.monitor", 0L);
        this.setActive(iActive > 0L);
    }

    public void reset(XWikiContext context) {
        this.timerSummaries = new HashMap<String, MonitorTimerSummary>();
        this.activeTimerDataList = new HashMap<Thread, MonitorData>();
        this.duration = 0L;
        this.nbrequests = 0L;
        long size = context.getWiki().ParamAsLong("xwiki.monitor.lastlistsize", 20L);
        this.lastTimerDataList = new CircularFifoQueue((int)size);
        this.lastUnfinishedTimerDataList = new CircularFifoQueue((int)size);
    }

    @Override
    public String getName() {
        return "monitor";
    }

    public void startRequest(String page, String action, URL url) {
        block5: {
            if (!this.isActive()) {
                return;
            }
            try {
                Thread cthread = Thread.currentThread();
                MonitorData mdata = this.activeTimerDataList.get(cthread);
                if (mdata != null) {
                    this.removeFromActiveTimerDataList(cthread);
                    this.addToLastUnfinishedTimerDataList(mdata);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("MONITOR: Thread " + cthread.getName() + " for page " + mdata.getWikiPage() + " did not call endRequest");
                    }
                    mdata.endRequest(false);
                }
                mdata = new MonitorData(page, action, url, cthread.getName());
                this.activeTimerDataList.put(cthread, mdata);
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("MONITOR: endRequest failed with exception " + String.valueOf(e));
                e.printStackTrace();
            }
        }
    }

    private void addToLastUnfinishedTimerDataList(MonitorData mdata) {
        this.lastUnfinishedTimerDataList.add((Object)mdata);
    }

    public void endRequest() {
        block5: {
            if (!this.isActive()) {
                return;
            }
            try {
                Thread cthread = Thread.currentThread();
                MonitorData mdata = this.activeTimerDataList.get(cthread);
                if (mdata == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("MONITOR: Thread " + cthread.getName() + " did not call startRequest");
                    }
                    return;
                }
                mdata.endRequest(true);
                this.addDuration(mdata.getDuration());
                this.addTimerDuration(mdata);
                this.removeFromActiveTimerDataList(cthread);
                this.addToTimerDataList(mdata);
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("MONITOR: endRequest failed with exception " + String.valueOf(e));
                e.printStackTrace();
            }
        }
    }

    private void removeFromActiveTimerDataList(Thread cthread) {
        if (this.activeTimerDataList.containsKey(cthread)) {
            this.activeTimerDataList.remove(cthread);
        }
    }

    private void addToTimerDataList(MonitorData mdata) {
        this.lastTimerDataList.add((Object)mdata);
    }

    public void setWikiPage(String page) {
        if (!this.isActive()) {
            return;
        }
        try {
            Thread cthread = Thread.currentThread();
            MonitorData mdata = this.activeTimerDataList.get(cthread);
            if (mdata != null) {
                mdata.setWikiPage(page);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addTimerDuration(MonitorData mdata) {
        Map<String, MonitorTimerSummary> map = mdata.getTimerSummaries();
        Map<String, MonitorTimerSummary> gmap = this.getTimerSummaries();
        for (MonitorTimerSummary stimer : map.values()) {
            MonitorTimerSummary gtimer = gmap.get(stimer.getName());
            if (gtimer == null) {
                gtimer = new MonitorTimerSummary(stimer.getName());
                gmap.put(stimer.getName(), gtimer);
            }
            gtimer.add(stimer);
        }
    }

    private void addDuration(long duration) {
        this.duration += duration;
        ++this.nbrequests;
    }

    public CircularFifoQueue<MonitorData> getLastTimerData() {
        return this.lastTimerDataList;
    }

    public CircularFifoQueue<MonitorData> getLastUnfinishedTimerData() {
        return this.lastUnfinishedTimerDataList;
    }

    public void startTimer(String timername) {
        this.startTimer(timername, null);
    }

    public void startTimer(String timername, String desc) {
        block4: {
            if (!this.isActive()) {
                return;
            }
            try {
                Thread cthread = Thread.currentThread();
                MonitorData mdata = this.activeTimerDataList.get(cthread);
                if (mdata != null) {
                    mdata.startTimer(timername, desc);
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("MONITOR: startRequest for timer " + timername + " failed with exception " + String.valueOf(e));
                e.printStackTrace();
            }
        }
    }

    public void setTimerDesc(String timername, String desc) {
        block4: {
            if (!this.isActive()) {
                return;
            }
            try {
                Thread cthread = Thread.currentThread();
                MonitorData mdata = this.activeTimerDataList.get(cthread);
                if (mdata != null) {
                    mdata.setTimerDetails(timername, desc);
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("MONITOR: setTimerDesc for timer " + timername + " failed with exception " + String.valueOf(e));
                e.printStackTrace();
            }
        }
    }

    public void endTimer(String timername) {
        block4: {
            if (!this.isActive()) {
                return;
            }
            try {
                Thread cthread = Thread.currentThread();
                MonitorData mdata = this.activeTimerDataList.get(cthread);
                if (mdata != null) {
                    mdata.endTimer(timername);
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("MONITOR: endRequest for timer " + timername + " failed with exception " + String.valueOf(e));
                e.printStackTrace();
            }
        }
    }

    public Map<Thread, MonitorData> getActiveTimerData() {
        return this.activeTimerDataList;
    }

    public Map<String, MonitorTimerSummary> getTimerSummaries() {
        return this.timerSummaries;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getRequests() {
        return this.nbrequests;
    }

    public long getDuration(String timer) {
        MonitorTimerSummary tsummary = this.getTimerSummaries().get(timer);
        if (tsummary == null) {
            return 0L;
        }
        return tsummary.getDuration();
    }

    public long getNbCalls(String timer) {
        MonitorTimerSummary tsummary = this.getTimerSummaries().get(timer);
        if (tsummary == null) {
            return 0L;
        }
        return tsummary.getNbCalls();
    }

    public long getRequests(String timer) {
        MonitorTimerSummary tsummary = this.getTimerSummaries().get(timer);
        if (tsummary == null) {
            return 0L;
        }
        return tsummary.getRequests();
    }

    public boolean isActive() {
        return this.bActive;
    }

    public void setActive(boolean bActive) {
        this.bActive = bActive;
    }
}

