/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.monitor.api;

import com.xpn.xwiki.monitor.api.MonitorTimer;
import com.xpn.xwiki.monitor.api.MonitorTimerSummary;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorData.class);
    private URL url;
    private String wikiPage;
    private String action;
    private String threadName;
    private Date startTime;
    private Date endTime;
    private Map<String, MonitorTimer> timers = new HashMap<String, MonitorTimer>();
    private Map<String, MonitorTimerSummary> timerSummaries = new HashMap<String, MonitorTimerSummary>();
    private List<MonitorTimer> timerList = new ArrayList<MonitorTimer>();

    public MonitorData(String wikiPage, String action, URL url, String threadName) {
        this.setWikiPage(wikiPage);
        this.setURL(url);
        this.setThreadName(threadName);
        this.setStartTime(new Date());
        this.setAction(action);
    }

    public void startRequest(String page, URL url) {
        this.setWikiPage(page);
        this.setURL(url);
        this.setStartTime(new Date());
    }

    public void endRequest() {
        this.endRequest(true);
    }

    public void endRequest(boolean normal) {
        this.setEndTime(new Date());
        this.log();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public String getWikiPage() {
        return this.wikiPage;
    }

    public void setWikiPage(String page) {
        this.wikiPage = page;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getDuration() {
        return this.endTime.getTime() - this.startTime.getTime();
    }

    public long getDuration(String timer) {
        MonitorTimerSummary tsummary = this.timerSummaries.get(timer);
        if (tsummary == null) {
            return 0L;
        }
        return tsummary.getDuration();
    }

    public void startTimer(String timername, String details) {
        if (this.startTime == null) {
            return;
        }
        MonitorTimer timer = this.timers.get(timername);
        if (timer != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MONITOR: error recursive timers for " + timername);
            }
        } else {
            timer = new MonitorTimer(timername, details);
            timer.setStartDate();
            this.timers.put(timername, timer);
        }
    }

    public void startTimer(String timername) {
        this.startTimer(timername, "");
    }

    public void setTimerDetails(String timername, String details) {
        MonitorTimer timer = this.timers.get(timername);
        if (timer == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MONITOR: could not find timer for " + timername);
            }
        } else {
            timer.setDetails(details);
        }
    }

    public void endTimer(String timername) {
        if (this.startTime == null) {
            return;
        }
        MonitorTimer timer = this.timers.get(timername);
        if (timer == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MONITOR: could not find timer for " + timername);
            }
        } else {
            timer.setEndDate();
            if (timer.getDetails() != null) {
                this.timerList.add(timer);
            }
            this.timers.remove(timername);
            MonitorTimerSummary tsummary = this.timerSummaries.get(timername);
            if (tsummary == null) {
                tsummary = new MonitorTimerSummary(timername);
                this.timerSummaries.put(timername, tsummary);
            }
            tsummary.addTimer(timer.getDuration());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MONITOR " + this.wikiPage + " " + this.action + " " + timer.getName() + ": " + timer.getDuration() + "ms " + timer.getDetails());
            }
        }
    }

    public List<MonitorTimer> getTimerList() {
        return this.timerList;
    }

    public Map<String, MonitorTimerSummary> getTimerSummaries() {
        return this.timerSummaries;
    }

    public void log() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MONITOR " + this.wikiPage + ": " + this.getDuration() + "ms");
            for (MonitorTimerSummary tsummary : this.timerSummaries.values()) {
                LOGGER.debug("MONITOR " + this.wikiPage + " " + this.action + " " + tsummary.getName() + ": " + tsummary.getDuration() + "ms " + tsummary.getNbCalls());
            }
        }
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getNbCalls(String timer) {
        MonitorTimerSummary tsummary = this.timerSummaries.get(timer);
        if (tsummary == null) {
            return 0L;
        }
        return tsummary.getNbCalls();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("WikiPage: ");
        str.append(this.wikiPage);
        str.append(" Action: ");
        str.append(this.action);
        str.append(" URL: ");
        str.append(this.url.toString());
        str.append(" Thread: ");
        str.append(this.threadName);
        str.append(" StartTime: " + String.valueOf(this.startTime));
        str.append(" EndTime: " + String.valueOf(this.endTime));
        str.append(this.getTimerSummaries());
        str.append(this.getTimerList());
        return str.toString();
    }
}

