/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.velocity;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.velocity.VelocityEvaluator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.velocity.VelocityManager;

@Component
@Singleton
public class DefaultVelocityEvaluator
implements VelocityEvaluator {
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;

    @Override
    public String evaluateVelocity(String content, String namespace, VelocityContext vcontext) throws XWikiException {
        StringWriter writer = new StringWriter();
        boolean renderingContextPushed = false;
        try {
            String currentNamespace = this.renderingContext.getTransformationId();
            if (namespace != null && !Strings.CS.equals(namespace, currentNamespace) && this.renderingContext instanceof MutableRenderingContext) {
                ((MutableRenderingContext)this.renderingContext).push(this.renderingContext.getTransformation(), this.renderingContext.getXDOM(), this.renderingContext.getDefaultSyntax(), namespace, this.renderingContext.isRestricted(), this.renderingContext.getTargetSyntax());
                renderingContextPushed = true;
            }
            this.velocityManager.getVelocityEngine().evaluate((Context)vcontext, (Writer)writer, namespace, content);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            Object[] args = new Object[]{namespace};
            throw new XWikiException(4, 4001, "Error while parsing velocity page {0}", e, args);
        }
        finally {
            if (renderingContextPushed) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
        }
    }

    @Override
    public String evaluateVelocityNoException(String content, DocumentReference namespaceDocument) {
        String namespace = namespaceDocument != null ? (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)namespaceDocument, new Object[0]) : this.renderingContext.getTransformationId();
        try {
            return this.evaluateVelocity(content, namespace, this.velocityManager.getVelocityContext());
        }
        catch (XWikiException e) {
            return this.renderError(e);
        }
    }

    private String renderError(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        this.beginDiv(builder, "xwikirenderingerror");
        builder.append("Failed to execute textarea");
        this.beginDiv(builder, "xwikirenderingerrordescription hidden");
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        builder.append(writer.toString().replace("\n", "<br/>"));
        this.endDiv(builder);
        this.endDiv(builder);
        return builder.toString();
    }

    private void beginDiv(StringBuilder builder, String cssClass) {
        builder.append("<div class=\"" + cssClass + "\">");
    }

    private void endDiv(StringBuilder builder) {
        builder.append("</div>");
    }
}

