/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.user;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authentication.UserAuthenticatedEvent;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component(roles={UserAuthenticatedEventNotifier.class})
@Singleton
public class UserAuthenticatedEventNotifier {
    @Inject
    private Logger logger;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;

    public void notify(String stringUserReference) {
        UserReference userReference = this.userReferenceResolver.resolve((Object)stringUserReference, new Object[0]);
        this.notify(new UserAuthenticatedEvent(userReference));
    }

    private void notify(UserAuthenticatedEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("User authenticated for [{}]", (Object)event.getUserReference());
        }
        this.observationManager.notify((Event)event, null);
    }
}

