/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.template;

import com.xpn.xwiki.internal.template.InternalTemplateManager;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.EntityType;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateContent;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.VelocityTemplate;
import org.xwiki.velocity.XWikiVelocityException;

@Component(roles={VelocityTemplateEvaluator.class})
@Singleton
public class VelocityTemplateEvaluator {
    @Inject
    private DocumentAuthorizationManager authorization;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private JobProgressManager progress;
    @Inject
    private VelocityManager velocityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateContent(Template template, TemplateContent content, Writer writer) throws Exception {
        if (content.isAuthorProvided()) {
            this.authorization.checkAccess(Right.SCRIPT, EntityType.DOCUMENT, content.getAuthorReference(), content.getDocumentReference());
        }
        String namespace = this.renderingContext.getTransformationId();
        boolean renderingContextPushed = false;
        if (namespace == null) {
            String string = namespace = template.getId() != null ? template.getId() : "unknown namespace";
            if (this.renderingContext instanceof MutableRenderingContext) {
                ((MutableRenderingContext)this.renderingContext).push(this.renderingContext.getTransformation(), this.renderingContext.getXDOM(), this.renderingContext.getDefaultSyntax(), namespace, this.renderingContext.isRestricted(), this.renderingContext.getTargetSyntax());
                renderingContextPushed = true;
            }
        }
        this.progress.startStep((Object)template, "template.evaluateContent.message", "Evaluate content of template with id [{}]", new Object[]{template.getId()});
        try {
            VelocityTemplate velocityTemplate = this.getVelocityTemplate(template, content);
            VelocityEngine velocityEngine = this.velocityManager.getVelocityEngine();
            if (velocityTemplate != null) {
                velocityEngine.evaluate((Context)this.velocityManager.getVelocityContext(), writer, namespace, velocityTemplate);
            } else {
                velocityEngine.evaluate((Context)this.velocityManager.getVelocityContext(), writer, namespace, (Reader)new StringReader(content.getContent()));
            }
        }
        finally {
            if (renderingContextPushed) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
            this.progress.endStep((Object)template);
        }
    }

    private VelocityTemplate getVelocityTemplate(Template template, TemplateContent content) throws XWikiVelocityException {
        if (content instanceof InternalTemplateManager.DefaultTemplateContent) {
            InternalTemplateManager.DefaultTemplateContent templateContent = (InternalTemplateManager.DefaultTemplateContent)content;
            if (!(templateContent.compiledContent instanceof VelocityTemplate)) {
                String templateId = Objects.toString(template.getId(), "unknown template");
                templateContent.compiledContent = this.velocityManager.compile(templateId, (Reader)new StringReader(content.getContent()));
            }
            return (VelocityTemplate)templateContent.compiledContent;
        }
        return null;
    }
}

