/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDeletedDocumentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.file.TemporaryDeferredFileRepository;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.xwiki.filter.input.DefaultReaderInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.output.DefaultWriterOutputTarget;
import org.xwiki.filter.output.OutputTarget;

public class XWikiHibernateDeletedDocumentContent
implements XWikiDeletedDocumentContent {
    private final TemporaryDeferredFileRepository.TemporaryDeferredStringFile content = this.createTemporaryDeferredFile();

    public XWikiHibernateDeletedDocumentContent(XWikiDocument document) throws XWikiException {
        try {
            document.toXML((OutputTarget)new DefaultWriterOutputTarget(this.content.getWriter(), true), true, false, true, true, false, StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new XWikiException(2, 2002, "Error serializing document to xml", e, null);
        }
    }

    public XWikiHibernateDeletedDocumentContent(String xml) throws IOException {
        this.content.setString(xml);
    }

    private TemporaryDeferredFileRepository.TemporaryDeferredStringFile createTemporaryDeferredFile() {
        return Utils.getComponent(TemporaryDeferredFileRepository.class).createTemporaryDeferredStringFile("deleted-documents-xml", StandardCharsets.UTF_8);
    }

    @Override
    public String getContentAsString() throws IOException {
        return this.content.getString();
    }

    @Override
    public XWikiDocument getXWikiDocument(XWikiDocument document) throws XWikiException, IOException {
        XWikiDocument result = document;
        if (result == null) {
            result = new XWikiDocument();
        }
        try (Reader reader = this.content.getReader();){
            result.fromXML((InputSource)new DefaultReaderInputSource(reader), true);
        }
        return result;
    }
}

