/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store.hibernate;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

@Component(roles={HibernateConfiguration.class})
@Singleton
public class HibernateConfiguration {
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikiConfiguration;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> resolver;
    private String path;

    public boolean hasCustomMappings() {
        return "1".equals(this.xwikiConfiguration.getProperty("xwiki.store.hibernate.custommapping", (Object)"1"));
    }

    public boolean hasDynamicCustomMappings() {
        return "1".equals(this.xwikiConfiguration.getProperty("xwiki.store.hibernate.custommapping.dynamic", (Object)"0"));
    }

    public String getPath() {
        if (this.path == null) {
            this.path = (String)this.xwikiConfiguration.getProperty("xwiki.store.hibernate.path", (Object)"/WEB-INF/hibernate.cfg.xml");
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDB() {
        return (String)this.xwikiConfiguration.getProperty("xwiki.db");
    }

    public String getDBPrefix() {
        return (String)this.xwikiConfiguration.getProperty("xwiki.db.prefix", (Object)"");
    }

    @Deprecated
    public boolean isUpdateSchema() {
        return (Integer)this.xwikiConfiguration.getProperty("xwiki.store.hibernate.updateschema", (Object)1) != 0;
    }

    public boolean isMigrationEnabled() {
        return (Integer)this.xwikiConfiguration.getProperty("xwiki.store.migration", (Object)0) == 1 && this.isUpdateSchema();
    }

    public boolean isExitAfterMigration() {
        return (Integer)this.xwikiConfiguration.getProperty("xwiki.store.migration.exitAfterEnd", (Object)0) == 1;
    }

    private List<String> getList(String key) {
        return Arrays.asList(StringUtils.split((String)((String)this.xwikiConfiguration.getProperty(key, (Object)"")), (String)" ,"));
    }

    public List<String> getMigrationDatabases() {
        return this.getList("xwiki.store.migration.databases");
    }

    public String getMigrationVersion() {
        return (String)this.xwikiConfiguration.getProperty("xwiki.store.migration.version");
    }

    public List<String> getForcedMigrations() {
        return this.getList("xwiki.store.migration.force");
    }

    public List<String> getIgnoredMigrations() {
        return this.getList("xwiki.store.migration.ignored");
    }

    public Optional<Set<EntityReference>> getOptimizedXObjectClasses() {
        List references = (List)this.xwikiConfiguration.getProperty("xwiki.store.hibernate.optimizedObjectSave.classes", List.class);
        return references != null ? Optional.of(references.stream().map(r -> this.resolver.resolve(r, EntityType.DOCUMENT, new Object[0])).collect(Collectors.toSet())) : Optional.empty();
    }
}

