/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.NumberClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component(roles={PropertyConverter.class})
@Singleton
public class PropertyConverter {
    @Inject
    private Logger logger;

    public BaseProperty<?> convertProperty(BaseProperty<?> storedProperty, PropertyClass modifiedPropertyClass) {
        Object newValue = this.convertPropertyValue(storedProperty.getValue(), modifiedPropertyClass);
        BaseProperty newProperty = null;
        if (newValue != null && (newProperty = modifiedPropertyClass.newProperty()) != null) {
            String errorLog = "Incompatible data migration when changing field [{}] of class [{}]";
            try {
                newProperty.setValue(newValue);
            }
            catch (Exception e) {
                try {
                    newProperty = modifiedPropertyClass.fromString(storedProperty.toText());
                }
                catch (XWikiException ex) {
                    this.logger.warn(errorLog, new Object[]{modifiedPropertyClass.getName(), modifiedPropertyClass.getClassName(), ex});
                }
            }
            if (newProperty != null) {
                newProperty.setId(storedProperty.getId());
                newProperty.setName(storedProperty.getName());
            } else {
                this.logger.warn(errorLog, (Object)modifiedPropertyClass.getName(), (Object)modifiedPropertyClass.getClassName());
            }
        }
        return newProperty;
    }

    private Object convertPropertyValue(Object storedValue, PropertyClass modifiedPropertyClass) {
        if (modifiedPropertyClass instanceof ListClass) {
            return this.convertPropertyValue(storedValue, (ListClass)modifiedPropertyClass);
        }
        if (modifiedPropertyClass instanceof NumberClass) {
            return this.convertPropertyValue(storedValue, (NumberClass)modifiedPropertyClass);
        }
        return storedValue;
    }

    private Object convertPropertyValue(Object storedValue, ListClass modifiedListClass) {
        if (modifiedListClass.isMultiSelect() && !(storedValue instanceof List) && storedValue != null) {
            return Arrays.asList(storedValue);
        }
        if (!modifiedListClass.isMultiSelect() && storedValue instanceof List) {
            List oldValues = (List)storedValue;
            return oldValues.isEmpty() ? null : oldValues.get(0);
        }
        return storedValue;
    }

    private Object convertPropertyValue(Object storedValue, NumberClass modifiedNumberClass) {
        Object newValue = storedValue;
        if (storedValue instanceof Number) {
            Number storedNumber = (Number)storedValue;
            String newNumberType = modifiedNumberClass.getNumberType();
            if ("integer".equals(newNumberType)) {
                newValue = storedNumber.intValue();
            } else if ("float".equals(newNumberType)) {
                newValue = Float.valueOf(storedNumber.floatValue());
            } else if ("double".equals(newNumberType)) {
                newValue = storedNumber.doubleValue();
            } else if ("long".equals(newNumberType)) {
                newValue = storedNumber.longValue();
            }
        }
        return newValue;
    }
}

