/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.skin;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.skin.AbstractWikiResource;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.net.URL;
import java.time.Instant;
import java.util.LinkedHashMap;
import javax.inject.Provider;
import org.xwiki.filter.input.StringInputSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.skin.ResourceRepository;

public class ObjectPropertyWikiResource
extends AbstractWikiResource<ObjectPropertyReference, StringInputSource> {
    private final String content;
    private final Instant instant;

    public ObjectPropertyWikiResource(String path, ResourceRepository repository, ObjectPropertyReference reference, DocumentReference authorReference, Provider<XWikiContext> xcontextProvider, String content, Instant instant) {
        super(path, path, reference.getName(), repository, reference, authorReference, xcontextProvider);
        this.content = content;
        this.instant = instant;
    }

    public StringInputSource getInputSource() throws Exception {
        return new StringInputSource(this.content);
    }

    public Instant getInstant() throws Exception {
        return this.instant;
    }

    @Override
    public String getURL(XWikiDocument document) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("cache-version", document.getVersion());
        XWikiURLFactory urlf = xcontext.getURLFactory();
        URL url = urlf.createSkinURL(((ObjectPropertyReference)this.reference).getName(), document.getSpace(), document.getName(), document.getDatabase(), xcontext, parameters);
        return urlf.getURL(url, xcontext);
    }
}

