/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.skin;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.skin.AbstractSkin;
import com.xpn.xwiki.internal.skin.ClassLoaderSkin;
import com.xpn.xwiki.internal.skin.EnvironmentSkin;
import com.xpn.xwiki.internal.skin.InternalSkinConfiguration;
import com.xpn.xwiki.internal.skin.WikiSkin;
import com.xpn.xwiki.internal.skin.WikiSkinUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.classloader.NamespaceURLClassLoader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.skin.Skin;
import org.xwiki.url.URLConfiguration;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={InternalSkinManager.class})
@Singleton
public class InternalSkinManager
implements Initializable {
    public static final String CKEY_SKIN = "skin";
    public static final String CKEY_PARENTSKIN = "baseskin";
    @Inject
    private InternalSkinConfiguration skinConfiguration;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiSkinUtils wikiSkinUtils;
    @Inject
    private Environment environment;
    @Inject
    @Named(value="all")
    private ConfigurationSource allConfiguration;
    @Inject
    private ObservationManager observation;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private Logger logger;
    @Inject
    private Provider<URLConfiguration> urlConfigurationProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private ClassLoaderManager classLoaderManager;
    private Cache<Skin> cache;

    public void initialize() throws InitializationException {
        try {
            this.cache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("skins", 100, 86400));
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to initialize cache", (Throwable)e);
        }
        this.observation.addListener((EventListener)new AbstractEventListener("skins", new Event[]{new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new DocumentCreatedEvent()}){

            public void onEvent(Event event, Object source, Object data) {
                XWikiDocument document = (XWikiDocument)source;
                if (document.getXObject((EntityReference)WikiSkinUtils.SKINCLASS_REFERENCE) != null || document.getOriginalDocument().getXObject((EntityReference)WikiSkinUtils.SKINCLASS_REFERENCE) != null) {
                    InternalSkinManager.this.cache.removeAll();
                }
            }
        }, 100);
    }

    public Skin getSkin(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Skin skin = (Skin)this.cache.get(id);
        if (skin == null) {
            skin = this.createSkin(id);
            this.cache.set(id, (Object)skin);
        }
        return skin;
    }

    private Skin createSkin(String id) {
        AbstractSkin skin;
        if (this.wikiSkinUtils.isWikiSkin(id)) {
            skin = new WikiSkin(id, this, this.skinConfiguration, this.wikiSkinUtils, this.logger);
        } else {
            EnvironmentSkin environmentSkin = new EnvironmentSkin(id, this, this.skinConfiguration, this.logger, this.environment, this.xcontextProvider, (URLConfiguration)this.urlConfigurationProvider.get());
            if (environmentSkin.exists()) {
                skin = environmentSkin;
            } else {
                WikiNamespace wikiNamespace = new WikiNamespace(this.wikiDescriptorManager.getCurrentWikiId());
                NamespaceURLClassLoader wikiClassLoader = this.classLoaderManager.getURLClassLoader(wikiNamespace.serialize(), false);
                skin = new ClassLoaderSkin(id, this, this.skinConfiguration, this.logger, this.xcontextProvider, (URLConfiguration)this.urlConfigurationProvider.get(), (ClassLoader)wikiClassLoader);
            }
        }
        return skin;
    }

    public Skin getCurrentSkin(boolean testRights) {
        return this.getSkin(this.getCurrentSkinId(testRights));
    }

    public String getCurrentSkinId(boolean testRights) {
        String skin;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null) {
            skin = (String)xcontext.get(CKEY_SKIN);
            if (StringUtils.isNotEmpty((CharSequence)skin)) {
                return skin;
            }
            skin = null;
            if (xcontext.getRequest() != null) {
                skin = xcontext.getRequest().getParameter(CKEY_SKIN);
                if (StringUtils.isNotEmpty((CharSequence)skin)) {
                    return skin;
                }
                skin = null;
            }
            if ((skin = (String)this.allConfiguration.getProperty(CKEY_SKIN)) != null) {
                return skin;
            }
        }
        skin = this.getDefaultSkinId();
        if (xcontext != null) {
            XWikiDocument document;
            if (testRights && (document = this.wikiSkinUtils.getSkinDocument(skin)) != null && !this.authorization.hasAccess(Right.VIEW, (EntityReference)document.getDocumentReference())) {
                this.logger.debug("Cannot access configured wiki skin [{}] due to access rights, using the default skin.", (Object)skin);
                skin = this.getDefaultSkinId();
            }
            xcontext.put(CKEY_SKIN, skin);
        }
        return skin;
    }

    public String getParentSkin(String skinId) {
        Skin parent;
        Skin skin = this.getSkin(skinId);
        if (skin != null && (parent = skin.getParent()) != null) {
            return parent.getId();
        }
        return null;
    }

    public Skin getCurrentParentSkin(boolean testRights) {
        return this.getSkin(this.getCurrentParentSkinId(testRights));
    }

    public String getCurrentParentSkinId(boolean testRights) {
        XWikiContext xcontext;
        Skin parent;
        Skin skin;
        String baseSkin = this.getContextParentId();
        if (baseSkin == null && (skin = this.getCurrentSkin(testRights)) != null && (parent = skin.getParent()) != null) {
            baseSkin = parent.getId();
        }
        if (baseSkin == null) {
            baseSkin = this.getDefaultParentSkinId();
        }
        if ((xcontext = (XWikiContext)this.xcontextProvider.get()) != null) {
            XWikiDocument document;
            if (testRights && (document = this.wikiSkinUtils.getSkinDocument(baseSkin)) != null && !this.authorization.hasAccess(Right.VIEW, (EntityReference)document.getDocumentReference())) {
                this.logger.debug("Cannot access configured wiki skin [{}] due to access rights, using the default skin.", (Object)baseSkin);
                baseSkin = this.getDefaultParentSkinId();
            }
            xcontext.put(CKEY_PARENTSKIN, baseSkin);
        }
        return baseSkin;
    }

    public String getContextParentId() {
        String parentId = null;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && StringUtils.isEmpty((CharSequence)(parentId = (String)xcontext.get(CKEY_PARENTSKIN)))) {
            parentId = null;
        }
        return parentId;
    }

    public Skin getDefaultSkin() {
        return this.getSkin(this.getDefaultSkinId());
    }

    public String getDefaultSkinId() {
        String skin = this.skinConfiguration.getDefaultSkinId();
        if (skin == null) {
            skin = this.getDefaultParentSkinId();
        }
        return skin;
    }

    public Skin getDefaultParentSkin() {
        return this.getSkin(this.skinConfiguration.getDefaultParentSkinId());
    }

    public String getDefaultParentSkinId() {
        String skin = this.skinConfiguration.getDefaultParentSkinId();
        if (skin == null) {
            skin = this.skinConfiguration.getDefaultSkinId();
        }
        return skin;
    }
}

