/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.skin;

import com.xpn.xwiki.internal.skin.InternalSkinConfiguration;
import com.xpn.xwiki.internal.skin.InternalSkinManager;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.skin.Resource;
import org.xwiki.skin.Skin;

public abstract class AbstractSkin
implements Skin {
    protected Skin VOID = new Skin(){

        public Resource<?> getResource(String resource) {
            return null;
        }

        public Resource<?> getLocalResource(String resource) {
            return null;
        }

        public Skin getParent() {
            return null;
        }

        public String getId() {
            return null;
        }

        public Syntax getOutputSyntax() {
            return null;
        }
    };
    protected InternalSkinManager skinManager;
    protected InternalSkinConfiguration configuration;
    protected String id;
    protected Skin parent;
    private Logger logger;

    public AbstractSkin(String id, InternalSkinManager skinManager, InternalSkinConfiguration configuration, Logger logger) {
        this.id = id;
        this.skinManager = skinManager;
        this.configuration = configuration;
        this.logger = logger;
    }

    public String getId() {
        return this.id;
    }

    public Skin getParent() {
        if (this.parent == null) {
            this.parent = this.createParent();
            if (this.parent == null) {
                this.parent = this.skinManager.getSkin(this.configuration.getDefaultParentSkinId());
            }
        }
        return this.parent;
    }

    public Resource<?> getResource(String resourceName) {
        Resource resource = this.getLocalResource(resourceName);
        if (resource == null) {
            HashSet<String> skins = new HashSet<String>();
            skins.add(this.getId());
            for (Skin parent = this.getParent(); parent != null && resource == null && !skins.contains(parent.getId()); parent = parent.getParent()) {
                resource = parent.getLocalResource(resourceName);
                skins.add(parent.getId());
            }
        }
        return resource;
    }

    protected abstract Skin createParent();

    public Syntax getOutputSyntax() {
        Syntax targetSyntax = null;
        String targetSyntaxString = this.getOutputSyntaxString();
        if (StringUtils.isNotEmpty((CharSequence)targetSyntaxString) && (targetSyntax = this.parseSyntax(this, targetSyntaxString)) != null) {
            return targetSyntax;
        }
        Skin parent = this.getParent();
        if (parent != null) {
            targetSyntax = parent.getOutputSyntax();
        }
        return targetSyntax != null ? targetSyntax : Syntax.XHTML_1_0;
    }

    protected abstract String getOutputSyntaxString();

    private Syntax parseSyntax(Skin skin, String syntax) {
        try {
            return Syntax.valueOf((String)syntax);
        }
        catch (ParseException e) {
            this.logger.warn("Failed to parse the syntax [{}] configured by the skin [{}].", (Object)syntax, (Object)skin.getId());
            return null;
        }
    }
}

