/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.sheet;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.sheet.internal.ModelBridge;

@Component
@Singleton
public class DefaultModelBridge
implements ModelBridge {
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public String getDefaultEditMode(DocumentModelBridge document) {
        try {
            return ((XWikiDocument)document).getDefaultEditMode((XWikiContext)this.xcontextProvider.get());
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get the default edit mode for [{}].", this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]));
            return null;
        }
    }

    public DocumentModelBridge getDefaultTranslation(DocumentModelBridge document) {
        if (((XWikiDocument)document).getTranslation() != 0) {
            try {
                XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
                return xcontext.getWiki().getDocument(document.getDocumentReference(), xcontext);
            }
            catch (XWikiException e) {
                String stringReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]);
                this.logger.warn("Failed to load the default translation of [{}].", (Object)stringReference, (Object)e);
            }
        }
        return document;
    }

    public String getCurrentAction() {
        return ((XWikiContext)this.xcontextProvider.get()).getAction();
    }

    public boolean isCurrentDocument(DocumentModelBridge document) {
        if (((XWikiDocument)document).getTranslation() == 0) {
            return document == ((XWikiContext)this.xcontextProvider.get()).getDoc();
        }
        return document == ((XWikiContext)this.xcontextProvider.get()).get("tdoc");
    }

    public Map<String, Object> pushDocumentInContext(DocumentModelBridge document) {
        HashMap<String, Object> backupObjects = new HashMap<String, Object>();
        XWikiDocument.backupContext(backupObjects, (XWikiContext)this.xcontextProvider.get());
        ((XWikiDocument)document).setAsContextDoc((XWikiContext)this.xcontextProvider.get());
        return backupObjects;
    }

    public Set<DocumentReference> getXObjectClassReferences(DocumentModelBridge document) {
        return ((XWikiDocument)document).getXObjects().keySet();
    }

    public DocumentModelBridge setSecurityDocument(DocumentModelBridge document) {
        return (DocumentModelBridge)((XWikiContext)this.xcontextProvider.get()).put("sdoc", document);
    }
}

