/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.sheet;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.sheet.SheetBinder;

public abstract class AbstractSheetBinder
implements SheetBinder,
Initializable {
    private static final String SHEET_PROPERTY = "sheet";
    @Inject
    private Logger logger;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    private Execution execution;
    @Inject
    private QueryManager queryManager;
    private Query sheetBindingsQuery;

    public List<DocumentReference> getSheets(DocumentModelBridge document) {
        DocumentReference sheetBindingClassReference = this.documentReferenceResolver.resolve((Object)this.getSheetBindingClass(), new Object[]{document.getDocumentReference()});
        List<BaseObject> sheetBindingObjects = ((XWikiDocument)document).getXObjects(sheetBindingClassReference);
        if (sheetBindingObjects == null) {
            return Collections.emptyList();
        }
        ArrayList<DocumentReference> sheets = new ArrayList<DocumentReference>();
        for (BaseObject sheetBindingObject : sheetBindingObjects) {
            if (sheetBindingObject == null) continue;
            String sheetStringRef = sheetBindingObject.getStringValue(SHEET_PROPERTY);
            DocumentReference sheetReference = this.documentReferenceResolver.resolve((Object)sheetStringRef, new Object[]{document.getDocumentReference()});
            sheets.add(sheetReference);
        }
        return sheets;
    }

    public List<DocumentReference> getDocuments(DocumentReference expectedSheetRef) {
        this.sheetBindingsQuery.setWiki(expectedSheetRef.getWikiReference().getName());
        try {
            List sheetBindings = this.sheetBindingsQuery.execute();
            ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
            for (Object[] sheetBinding : sheetBindings) {
                DocumentReference docRef = this.documentReferenceResolver.resolve((Object)((String)sheetBinding[0]), new Object[]{expectedSheetRef});
                DocumentReference sheetRef = this.documentReferenceResolver.resolve((Object)((String)sheetBinding[1]), new Object[]{docRef});
                if (!sheetRef.equals((Object)expectedSheetRef)) continue;
                documentReferences.add(docRef);
            }
            return documentReferences;
        }
        catch (QueryException e) {
            this.logger.warn("Failed to query sheet bindings.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean bind(DocumentModelBridge document, DocumentReference sheetReference) {
        return this.bind(document, (String)this.compactEntityReferenceSerializer.serialize((EntityReference)sheetReference, new Object[]{document.getDocumentReference()}));
    }

    public boolean bind(DocumentModelBridge document, EntityReference sheetReference) {
        return this.bind(document, (String)this.defaultEntityReferenceSerializer.serialize(sheetReference, new Object[]{document.getDocumentReference()}));
    }

    private boolean bind(DocumentModelBridge document, String sheetReferenceString) {
        EntityReference sheetBindingClassReference = this.relativeReferenceResolver.resolve((Object)this.getSheetBindingClass(), EntityType.DOCUMENT, new Object[0]);
        List<BaseObject> sheetBindingObjects = ((XWikiDocument)document).getXObjects(sheetBindingClassReference);
        if (sheetBindingObjects != null) {
            for (BaseObject sheetBindingObject : sheetBindingObjects) {
                String boundSheetStringRef;
                if (sheetBindingObject == null || !Strings.CS.equals(boundSheetStringRef = sheetBindingObject.getStringValue(SHEET_PROPERTY), sheetReferenceString)) continue;
                return false;
            }
        }
        try {
            BaseObject sheetBindingObject = ((XWikiDocument)document).newXObject(sheetBindingClassReference, this.getXWikiContext());
            sheetBindingObject.setStringValue(SHEET_PROPERTY, sheetReferenceString);
        }
        catch (XWikiException e) {
            String docStringReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]);
            this.logger.warn("Failed to bind sheet [{}] to document [{}].", (Object)sheetReferenceString, (Object)docStringReference);
            return false;
        }
        return true;
    }

    public boolean unbind(DocumentModelBridge document, DocumentReference sheetReference) {
        DocumentReference sheetBindingClassReference = this.documentReferenceResolver.resolve((Object)this.getSheetBindingClass(), new Object[]{document.getDocumentReference()});
        List<BaseObject> sheetBindingObjects = ((XWikiDocument)document).getXObjects(sheetBindingClassReference);
        if (sheetBindingObjects == null) {
            return false;
        }
        for (BaseObject sheetBindingObject : sheetBindingObjects) {
            if (sheetBindingObject == null) continue;
            String boundSheetStringRef = sheetBindingObject.getStringValue(SHEET_PROPERTY);
            DocumentReference boundSheetReference = this.documentReferenceResolver.resolve((Object)boundSheetStringRef, new Object[]{document.getDocumentReference()});
            if (!boundSheetReference.equals((Object)sheetReference)) continue;
            return ((XWikiDocument)document).removeXObject(sheetBindingObject);
        }
        return false;
    }

    @Deprecated
    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected abstract String getSheetBindingClass();

    public void initialize() throws InitializationException {
        try {
            String statement = "select doc.fullName, prop.value from XWikiDocument doc, BaseObject obj, StringProperty prop where obj.className=:sheetBindingClass and obj.name=doc.fullName and obj.id=prop.id.id and prop.id.name=:sheetProperty order by doc.fullName";
            this.sheetBindingsQuery = this.queryManager.createQuery(statement, "hql");
            this.sheetBindingsQuery.bindValue("sheetBindingClass", (Object)this.getSheetBindingClass());
            this.sheetBindingsQuery.bindValue("sheetProperty", (Object)SHEET_PROPERTY);
        }
        catch (QueryException e) {
            throw new InitializationException("Failed to create query for retrieving the list of sheet bindings.", (Throwable)e);
        }
    }
}

